/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.envelope;

import esecurity.validator.bean.ParsedTransientDocument;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCEContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCSContainer;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import it.actalis.ellips.capi.asic.utils.ASiCCommonUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public class ASiCContainerFactory {
    private ASiCFactoryOptions factoryOpts = new ASiCFactoryOptions();
    private MutableASiCOptions asicOpts = new MutableASiCOptions();

    protected void throwExceptionIfUnsupportedGetSignature(ASiCSignatureType wanted) throws OperationNotSupportedException {
        ASiCCommonUtils.throwExceptionIfUnsupportedGetSignature(this.getSignatureType(), wanted);
    }

    public ASiCContainer buildASiCContainer() throws OperationNotSupportedException {
        ASiCContainer env = null;
        switch (this.asicOpts.getFormat()) {
            case SIMPLE: {
                env = new ASiCSContainer(this.asicOpts, this.factoryOpts);
                break;
            }
            case EXTENDED: {
                env = new ASiCEContainer(this.asicOpts, this.factoryOpts);
                break;
            }
            default: {
                throw new OperationNotSupportedException("Unable to build ASiC container object since ASiC format is not specified.");
            }
        }
        return env;
    }

    public void reset() {
        this.asicOpts = new MutableASiCOptions();
        this.factoryOpts = new ASiCFactoryOptions();
    }

    public void setMimetypeContent(String content) {
        this.factoryOpts.mimetypeContent = content;
    }

    public void setMimetypeRootComment(String comment) {
        this.factoryOpts.mimetypeRootComment = comment;
    }

    public void addCadesTransientDocument(String filename, ParsedTransientDocument innerEnvelope) {
        this.factoryOpts.cadesTransientDocuments.put(filename, innerEnvelope);
    }

    public void addXadesTransientDocument(String filename, ParsedTransientDocument innerTransientDocument) {
        this.factoryOpts.xadesTransientDocuments.put(filename, innerTransientDocument);
    }

    public void addTimestampTransientDocument(String filename, ParsedTransientDocument token) {
        this.factoryOpts.timestampTransientDocuments.put(filename, token);
    }

    public void addObjectData(String filename, ASiCContentData dataStream) {
        this.factoryOpts.data.put(filename, dataStream);
    }

    public void addUnsignedFile(String filename, ASiCContentData dataStream) {
        this.factoryOpts.data.put(filename, dataStream);
        this.factoryOpts.unsignedDocs.add(filename);
    }

    public void addSignedFile(String filename, ASiCContentData dataStream) {
        this.factoryOpts.data.put(filename, dataStream);
        this.factoryOpts.signedDocs.add(filename);
    }

    public void setFormat(ASiCFormat format) {
        this.asicOpts.setFormat(format);
    }

    public void setSignatureType(ASiCSignatureType signatureType) {
        this.asicOpts.setSignatureType(signatureType);
    }

    public ASiCFormat getFormat() {
        return this.asicOpts.getFormat();
    }

    public ASiCSignatureType getSignatureType() {
        return this.asicOpts.getSignatureType();
    }

    class ASiCFactoryOptions {
        private String mimetypeContent;
        private Map<String, ParsedTransientDocument> cadesTransientDocuments = new HashMap<String, ParsedTransientDocument>();
        private Map<String, ParsedTransientDocument> xadesTransientDocuments = new HashMap<String, ParsedTransientDocument>();
        private Map<String, ParsedTransientDocument> timestampTransientDocuments = new HashMap<String, ParsedTransientDocument>();
        private List<String> unsignedDocs = new LinkedList<String>();
        private List<String> signedDocs = new LinkedList<String>();
        private String mimetypeRootComment;
        private Map<String, ASiCContentData> data = new HashMap<String, ASiCContentData>();

        ASiCFactoryOptions() {
        }

        public String getMimetypeContent() {
            return this.mimetypeContent;
        }

        public Map<String, ParsedTransientDocument> getCadesTransientDocuments() throws OperationNotSupportedException {
            ASiCContainerFactory.this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.CADES);
            return this.cadesTransientDocuments;
        }

        public Map<String, ParsedTransientDocument> getXadesTransientDocuments() throws OperationNotSupportedException {
            ASiCContainerFactory.this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.XADES);
            return this.xadesTransientDocuments;
        }

        public Map<String, ParsedTransientDocument> getTimestampTransientDocuments() throws OperationNotSupportedException {
            ASiCContainerFactory.this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.TIMESTAMP);
            return this.timestampTransientDocuments;
        }

        public Map<String, ASiCContentData> getData() {
            return this.data;
        }

        public String getMimetypeRootComment() {
            return this.mimetypeRootComment;
        }

        public List<String> getUnsignedDocs() {
            return this.unsignedDocs;
        }

        public List<String> getSignedDocs() {
            return this.signedDocs;
        }
    }
}

