/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import esecurity.dts.DTSClient;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.CompareByteRangeSignature;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pdf.AdditionalDictionaryInfo;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class SignedPDF
implements SignatureInterface {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected PDDocument document = null;
    protected long documentSize = -1L;
    protected ArrayList<RevisionInformation> revisions = new ArrayList();
    protected Vector<String> names = new Vector();
    protected Vector<PadesSignatureInformation> signatures = new Vector();
    protected Vector<java.io.File> revisionsFileVector = new Vector();
    protected Vector<InputStream> revisionsIsVector = new Vector();
    private List<PadesSignatureInformation> emptySignaturesFields = new LinkedList<PadesSignatureInformation>();
    private boolean bClosed = false;
    public static boolean bDebug = false;
    private String reason = null;
    private static String language = "IT";
    private static String lastCustomStamp = null;
    private static String defaultStamp = null;
    private String location = null;
    private Calendar signDate = null;
    protected Vector<X509Certificate> certsVector = new Vector();
    private MessageDigest msgDigest = null;
    private MessageDigest msgDigest256 = null;
    private String msgDigestToBeUsed = SHA256;
    private String TSA = null;
    private String TSAhashAlgorithm = null;
    private String TSApolicy = null;
    private boolean TSAcertReq = true;
    private HttpsClient TSAhttps = null;
    private String TSABasicAuthUser = null;
    private String TSABasicAuthPassword = null;
    private DTSClient TSAClient = null;
    private CapiException timeStampTokenExc = null;
    private java.io.File temporaryPDFenv = null;
    private int assignedCertificationLevel = 0;
    private URL temporaryPDFURL = null;
    private byte[] temporaryPDFData = null;
    private String filePDF = null;
    private InputStream inputStreamPDF;
    private boolean isSigned = false;
    private boolean isInitialized = false;
    private byte[] p7Detached = null;
    private int profile = 2;
    private String alias = null;
    private TokenSpi internal_tk = null;
    private boolean bPDFA_signature = false;
    private boolean bGray_apparance = false;
    private ScratchFile SCRATCH_FILE_TEMP = null;
    private RandomAccessRead pdfFileBuffer;
    private boolean signature_to_be_performed = false;
    private PadesSignatureInformation lastSignature = null;
    private PadesDssInfo padesDssInfo = null;
    public static final String SHA1 = CMSSignedDataGenerator.DIGEST_SHA1;
    public static final String SHA256 = CMSSignedDataGenerator.DIGEST_SHA256;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_SIGN_FORM_FILLING = 2;
    public static final int CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS = 3;
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFICATION_UNKNOWN = -1;
    public static final int PADES_BASIC = 1;
    public static final int PADES_BES = 2;

    public SignedPDF(String filename) throws CapiException {
        this(filename, null);
    }

    public SignedPDF(String filename, boolean pdfa_signature) throws CapiException {
        this(filename, null, pdfa_signature);
    }

    public SignedPDF(InputStream is, boolean pdfa_signature) throws CapiException {
        this(is, null, pdfa_signature);
    }

    public SignedPDF(String filename, byte[] ownerPassword) throws CapiException {
        this.filePDF = filename;
        this.initialize(ownerPassword);
    }

    public SignedPDF(String filename, byte[] ownerPassword, boolean pdfa_signature) throws CapiException {
        this.filePDF = filename;
        this.bPDFA_signature = pdfa_signature;
        this.initialize(ownerPassword);
    }

    public SignedPDF(byte[] pdfIn) throws CapiException {
        this(pdfIn, null);
    }

    public SignedPDF(byte[] pdfIn, byte[] ownerPassword) throws CapiException {
        this.temporaryPDFData = pdfIn;
        this.initialize(ownerPassword);
    }

    public SignedPDF(URL url) throws CapiException {
        this(url, null);
    }

    public SignedPDF(URL url, byte[] ownerPassword) throws CapiException {
        this.temporaryPDFURL = url;
        this.initialize(ownerPassword);
    }

    public SignedPDF(InputStream is, byte[] ownerPassword) throws CapiException {
        this.inputStreamPDF = is;
        this.initialize(ownerPassword);
    }

    public SignedPDF(URL url, byte[] ownerPassword, boolean pdfa_signature) throws CapiException {
        this.temporaryPDFURL = url;
        this.bPDFA_signature = pdfa_signature;
        this.initialize(ownerPassword);
    }

    public SignedPDF(InputStream is, byte[] ownerPassword, boolean pdfa_signature) throws CapiException {
        if (is instanceof ByteArrayInputStream) {
            try {
                is.reset();
                this.temporaryPDFData = Util.getBytesFromInputStream((InputStream)is);
            }
            catch (IOException ex) {
                try {
                    is.reset();
                    this.inputStreamPDF = is;
                }
                catch (IOException ex1) {
                    throw new CapiException("Internal Errore", 1003);
                }
            }
        } else {
            this.inputStreamPDF = is;
        }
        this.bPDFA_signature = pdfa_signature;
        this.initialize(ownerPassword);
    }

    public SignedPDF(InputStream is) throws CapiException {
        this(is, null);
    }

    public static void setLanguage(String lan) {
        if (lan != null && lan.equalsIgnoreCase("IT") || lan.equalsIgnoreCase("EN") || lan.equalsIgnoreCase("DE")) {
            language = lan;
        }
    }

    public static void setLastCustomStamp(String stamp) {
        if (stamp != null) {
            lastCustomStamp = stamp;
        }
    }

    public static String getLastCustomStamp() {
        return lastCustomStamp;
    }

    public static void setDefaultStamp(String stamp) {
        if (stamp != null) {
            defaultStamp = stamp;
        }
    }

    public void setPadesProfile(int profile) {
        if (profile == 1 || profile == 2) {
            this.profile = profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(byte[] ownerPassword) throws CapiException {
        try {
            this.SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
        }
        catch (IOException ex) {
            logger.error("Errore SCRATCH_FILE_TEMP", (Throwable)ex);
        }
        this.instanceDigest();
        String decryptPassword = null;
        if (ownerPassword == null) {
            logger.debug("[initialize] decrypting password is null...");
        } else {
            logger.debug("[initialize] decrypting password is not null...");
            decryptPassword = new String(ownerPassword);
        }
        this.document = null;
        try {
            long start;
            block38: {
                block39: {
                    block37: {
                        start = System.currentTimeMillis();
                        logger.debug("[initialize] loading document...");
                        if (this.temporaryPDFData == null) break block37;
                        this.load(new ByteArrayInputStream(this.temporaryPDFData), decryptPassword);
                        this.documentSize = this.temporaryPDFData.length;
                        break block38;
                    }
                    if (this.filePDF == null) break block39;
                    FileInputStream fIs = null;
                    try {
                        fIs = new FileInputStream(this.filePDF);
                        this.documentSize = fIs.available();
                        this.load(fIs, decryptPassword);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fIs);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)fIs);
                    break block38;
                }
                if (this.temporaryPDFURL != null) {
                    InputStream stream = null;
                    try {
                        stream = this.temporaryPDFURL.openStream();
                        this.documentSize = stream.available();
                        this.load(stream, decryptPassword);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)stream);
                    }
                } else if (this.inputStreamPDF != null) {
                    this.temporaryPDFenv = TmpFileUtils.createTempFile((String)"PDFenv", null);
                    logger.debug("[initialize]saving inputstream to ..." + this.temporaryPDFenv.getAbsolutePath());
                    this.saveToFile(this.inputStreamPDF, this.temporaryPDFenv, -1);
                    this.load(this.temporaryPDFenv, decryptPassword);
                    this.documentSize = this.temporaryPDFenv.length();
                }
            }
            logger.debug("[initialize] document loaded in " + (System.currentTimeMillis() - start) + " ms");
            logger.debug("canExtractForAccessibility() is " + this.document.getCurrentAccessPermission().canExtractForAccessibility());
        }
        catch (FileNotFoundException e1) {
            this.close();
            throw new CapiException("File not found", 4002);
        }
        catch (LoadWithPasswordException e1) {
            this.close();
            throw new CapiException("Error load file (" + (e1.pwd.length() > 0 ? "with" : "without") + " password)", 4000);
        }
        catch (Exception e1) {
            this.close();
            throw new CapiException("Input is not a PDF", 50023);
        }
        try {
            COSDictionary trailer;
            if (this.bPDFA_signature) {
                List outputIntent = this.document.getDocumentCatalog().getOutputIntents();
                for (PDOutputIntent oi : outputIntent) {
                    if (oi.getInfo().contains("sRGB") || oi.getInfo().contains("Dot Gain")) continue;
                    throw new CapiException("PDFA OutputIntent not supported.", 50023);
                }
                for (PDOutputIntent oi : outputIntent) {
                    if (!oi.getInfo().contains("Dot Gain")) continue;
                    logger.debug("OutputIntent{}", (Object)oi.getInfo());
                    this.bGray_apparance = true;
                    break;
                }
            }
            if ((trailer = this.document.getDocument().getTrailer()) == null) {
                logger.error("[initialize] trailer is null.");
                return;
            }
            COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            if (root == null) {
                logger.error("[initialize] root is null");
                return;
            }
            COSDictionary acroForm = (COSDictionary)root.getDictionaryObject(COSName.ACRO_FORM);
            if (acroForm == null) {
                logger.debug("[initialize] acroform is null");
                return;
            }
            this.padesDssInfo = PadesUtils.retrieveDssInfo(this.document);
            logger.debug("[initialize] findSignature");
            LinkedList<PadesSignatureInformation> lstSignatures = PadesUtils.retrieveSignatures(this.document);
            for (PadesSignatureInformation signature : lstSignatures) {
                if (signature.isEmpty()) {
                    this.emptySignaturesFields.add(signature);
                    continue;
                }
                this.signatures.add(signature);
            }
            logger.debug("[initialize] findRevision ");
            this.findRevision();
            this.checkRevisions();
            for (PadesSignatureInformation sign : this.signatures) {
                BufferedInputStream bis = this.getBufferedInputStream();
                InputHandler inputHandler = DataHandlerBuilder.get().setInputStream((InputStream)bis).buildInput();
                try {
                    sign.verify(inputHandler);
                }
                catch (Error ex) {
                    logger.error("Impossibile parsare la firma: " + sign.getName());
                }
                finally {
                    Util.closeQuietly((Closeable)bis);
                    Util.closeQuietly((Closeable)inputHandler);
                }
            }
            CompareByteRangeSignature comparator = new CompareByteRangeSignature();
            Collections.sort(this.signatures, comparator);
            for (int index = 0; index < this.signatures.size(); ++index) {
                PadesSignatureInformation element = this.signatures.get(index);
                while (this.signatures.indexOf(element) != this.signatures.lastIndexOf(element)) {
                    this.signatures.remove(this.signatures.lastIndexOf(element));
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            this.close();
            throw new CapiException("Exception parsing PDF: " + e.getMessage(), 50023);
        }
        if (this.signatures.isEmpty()) {
            logger.debug("[initialize] pdf is not signed");
            return;
        }
        if (!this.signatures.isEmpty()) {
            this.lastSignature = this.signatures.get(this.signatures.size() - 1);
        }
        if (this.lastSignature == null) {
            logger.error("[initialize] pdf is not signed");
            this.isSigned = false;
            return;
        }
        this.isSigned = true;
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Deprecated
    public boolean getOriginalPDFbyEOF(java.io.File outPDFFile) {
        return this.saveOriginalPDF(outPDFFile);
    }

    public boolean saveOriginalPDF(java.io.File outPDFFile) {
        return this.saveRevisionToFile(outPDFFile, this.revisions.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean saveRevisionToFile(java.io.File outPDFFile, RevisionInformation revision) {
        if (!this.isInitialized() || outPDFFile == null || revision == null) {
            return false;
        }
        if (this.signatures == null || this.signatures.isEmpty()) {
            return false;
        }
        if (outPDFFile.exists()) {
            outPDFFile.delete();
        }
        OutputStream outStream = null;
        try {
            if (this.filePDF != null) {
                this.saveRevisionToFile(this.filePDF, outPDFFile, revision.getByteRange()[1]);
            } else if (this.inputStreamPDF != null && this.temporaryPDFenv.exists() && this.temporaryPDFenv.isFile()) {
                this.saveRevisionToFile(this.temporaryPDFenv, outPDFFile, revision.getByteRange()[1]);
            } else if (this.temporaryPDFURL != null) {
                this.saveToFile(this.temporaryPDFURL.openStream(), outPDFFile, revision.getByteRange()[1]);
            } else if (this.temporaryPDFData != null) {
                this.saveToFile(new ByteArrayInputStream(this.temporaryPDFData), outPDFFile, revision.getByteRange()[1]);
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        catch (CapiException ex2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    BufferedInputStream getBufferedInputStream() {
        BufferedInputStream origPdf = null;
        try {
            if (this.filePDF != null) {
                origPdf = new BufferedInputStream(new FileInputStream(new java.io.File(this.filePDF)));
            } else if (this.inputStreamPDF != null && this.temporaryPDFenv.exists()) {
                origPdf = new BufferedInputStream(new FileInputStream(this.temporaryPDFenv));
            } else if (this.temporaryPDFURL != null) {
                origPdf = new BufferedInputStream(this.temporaryPDFURL.openStream());
            } else if (this.temporaryPDFData != null) {
                origPdf = new BufferedInputStream(new ByteArrayInputStream(this.temporaryPDFData));
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            return origPdf;
        }
        catch (Exception e) {
            logger.debug("Exception getting signed content: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private boolean contains(String sigName, Vector<PadesSignatureInformation> sig) {
        if (sigName == null) {
            return false;
        }
        for (int i = 0; i < sig.size(); ++i) {
            String currSigName = sig.get(i).getName();
            if (currSigName == null || !currSigName.equals(sigName)) continue;
            return true;
        }
        return false;
    }

    private boolean isSignatureField(COSDictionary field) {
        COSString sigName = (COSString)field.getDictionaryObject(COSName.T);
        if (sigName != null) {
            logger.debug("[initialize][isSignatureField] Signature: " + sigName.getString());
        } else {
            logger.debug("[initialize][isSignatureField] Signature: warning sigName is null");
        }
        COSDictionary valueField = (COSDictionary)field.getDictionaryObject(COSName.V);
        if (valueField != null) {
            COSName subFilter = (COSName)valueField.getDictionaryObject(COSName.getPDFName((String)"SubFilter"));
            if (subFilter != null) {
                if (subFilter.getName().equals("adbe.x509.rsa_sha1")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.x509.rsa_sha1");
                    return true;
                }
                if (subFilter.getName().equals("adbe.pkcs7.sha1")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.sha1");
                    return true;
                }
                if (subFilter.getName().equals("adbe.pkcs7.detached")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.detached");
                    return true;
                }
                if (subFilter.getName().equals("ETSI.CAdES.detached")) {
                    logger.debug("[initialize][isSignatureField] subfilter: ETSI.CAdES.detached");
                    return true;
                }
                if (subFilter.getName().equals("ETSI.RFC3161")) {
                    logger.debug("[initialize][isSignatureField] subfilter: ETSI.RFC3161");
                    return true;
                }
                logger.error("[initialize][isSignatureField] unknown subfilter:" + subFilter);
                return true;
            }
            logger.debug("[initialize][isSignatureField] Missing subfilter");
        } else {
            logger.debug("[initialize][isSignatureField] is empty");
        }
        return false;
    }

    private int[] getByteRange(COSDictionary field) {
        PDSignature pdSig = null;
        COSDictionary signatureDictionary = null;
        try {
            COSString sigName = (COSString)field.getDictionaryObject(COSName.T);
            logger.debug("[getByteRange] Signatue Field Name: " + sigName.getString());
            signatureDictionary = (COSDictionary)field.getDictionaryObject(COSName.V);
            pdSig = new PDSignature(signatureDictionary);
            return pdSig.getByteRange();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveToFile(InputStream in, java.io.File destFileName, int len) throws CapiException {
        block11: {
            FileOutputStream out = null;
            try {
                int ret;
                out = new FileOutputStream(destFileName);
                if (len == -1) {
                    Streams.pipeAll((InputStream)in, (OutputStream)out);
                    return;
                }
                byte[] bs = new byte[4096];
                int tot = 0;
                while (true) {
                    if ((ret = in.read(bs, 0, 4096)) == -1) {
                        break block11;
                    }
                    if (len <= (tot += ret)) break;
                    out.write(bs, 0, ret);
                }
                if (len == tot) {
                    out.write(bs, 0, ret);
                } else {
                    out.write(bs, 0, ret - (tot - len));
                }
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("File write error", 4001);
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
                IOUtils.closeQuietly((Closeable)out);
            }
        }
    }

    private void saveRevisionToFile(String srcFileName, java.io.File destFileName, int len) throws CapiException {
        Object out = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(srcFileName);
            this.saveToFile(in, destFileName, len);
        }
        catch (IOException e) {
            try {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("File write error", 4001);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
    }

    private void saveRevisionToFile(java.io.File srcFileName, java.io.File destFileName, int len) throws CapiException {
        this.saveRevisionToFile(srcFileName.getAbsolutePath(), destFileName, len);
    }

    public InputStream getGraphometricRevisionInputStream(GraphometricInfo info) throws CapiException {
        try {
            long[] revByteRangeArray = info.getByte_range();
            logger.debug("[getRevisionInputStream] revByteRangeArray:");
            for (int h = 0; h < revByteRangeArray.length; ++h) {
                logger.debug(" " + revByteRangeArray[h]);
            }
            File pdf_revision_File = TmpFileUtils.createTempFile((String)"pdf_revision", (String)".tmp");
            logger.debug("[getRevisionInputStream] saving revision to temporary file: " + pdf_revision_File.getAbsolutePath());
            this.revisionsFileVector.add((java.io.File)pdf_revision_File);
            if (this.filePDF != null) {
                this.saveRevisionToFile(this.filePDF, (java.io.File)pdf_revision_File, (int)revByteRangeArray[1]);
            } else if (this.inputStreamPDF != null && this.temporaryPDFenv.exists() && this.temporaryPDFenv.isFile()) {
                this.saveRevisionToFile(this.temporaryPDFenv, (java.io.File)pdf_revision_File, (int)revByteRangeArray[1]);
            } else if (this.temporaryPDFURL != null) {
                this.saveToFile(this.temporaryPDFURL.openStream(), (java.io.File)pdf_revision_File, (int)revByteRangeArray[1]);
            } else if (this.temporaryPDFData != null) {
                this.saveToFile(new ByteArrayInputStream(this.temporaryPDFData), (java.io.File)pdf_revision_File, (int)revByteRangeArray[1]);
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            FileInputStream fis = new FileInputStream((java.io.File)pdf_revision_File);
            this.revisionsIsVector.add(fis);
            return fis;
        }
        catch (Exception e) {
            if (bDebug) {
                logger.debug("[getRevisionInputStream] Exception getting revision input stream: " + e.getMessage());
            }
            e.printStackTrace();
            throw new CapiException("Exception getting revision input stream: " + e.getMessage(), 50050);
        }
    }

    @Deprecated
    private InputStream getRevisionInputStream(RevisionInformation revision) throws CapiException {
        try {
            File pdf_revision_File = TmpFileUtils.createTempFile((String)"pdf_revision", (String)".tmp");
            logger.debug("[getRevisionInputStream] saving revision to temporary file: " + pdf_revision_File.getAbsolutePath());
            this.revisionsFileVector.add((java.io.File)pdf_revision_File);
            if (!this.saveRevisionToFile((java.io.File)pdf_revision_File, revision)) {
                throw new CapiException("File write error", 4001);
            }
            FileInputStream fis = new FileInputStream((java.io.File)pdf_revision_File);
            this.revisionsIsVector.add(fis);
            return fis;
        }
        catch (CapiException ex) {
            if (bDebug) {
                logger.debug("[getRevisionInputStream] Exception getting revision input stream: " + ex.getMessage());
                ex.printStackTrace();
            }
            throw new CapiException("Exception getting revision input stream: " + ex.getMessage(), 50050);
        }
        catch (IOException ex) {
            if (bDebug) {
                logger.debug("[getRevisionInputStream] Exception getting revision input stream: " + ex.getMessage());
                ex.printStackTrace();
            }
            throw new CapiException("Exception getting revision input stream: " + ex.getMessage(), 50050);
        }
    }

    private int getCertificationLevel(COSBase refArr) {
        if (refArr != null && refArr instanceof COSArray) {
            if (bDebug) {
                logger.debug("[getCertificatioLevel] Found Reference");
            }
            for (int j = 0; j < ((COSArray)refArr).size(); ++j) {
                COSBase p;
                COSBase t;
                COSBase transformParams;
                COSBase ctr;
                COSBase ctype;
                COSBase item = ((COSArray)refArr).get(j);
                if (item == null || !(item instanceof COSDictionary)) continue;
                if (bDebug) {
                    logger.debug("[getCertificatioLevel] Found item");
                }
                if ((ctype = ((COSDictionary)item).getItem(COSName.getPDFName((String)"Type"))) == null || !(ctype instanceof COSName)) continue;
                if (bDebug) {
                    logger.debug("[getCertificatioLevel] Type " + ((COSName)ctype).getName());
                }
                if (((COSName)ctype).getName().compareToIgnoreCase("SigRef") != 0 || (ctr = ((COSDictionary)item).getItem(COSName.getPDFName((String)"TransformMethod"))) == null || !(ctr instanceof COSName)) continue;
                if (bDebug) {
                    logger.debug("[getCertificatioLevel] TransformMethod " + ((COSName)ctr).getName());
                }
                if (((COSName)ctr).getName().compareToIgnoreCase("DocMDP") != 0 || (transformParams = ((COSDictionary)item).getItem(COSName.getPDFName((String)"TransformParams"))) == null || !(transformParams instanceof COSDictionary) || (t = ((COSDictionary)transformParams).getItem(COSName.getPDFName((String)"Type"))) == null || !(t instanceof COSName)) continue;
                if (bDebug) {
                    logger.debug("[getCertificatioLevel] Type " + ((COSName)t).getName());
                }
                if (((COSName)t).getName().compareToIgnoreCase("TransformParams") != 0 || (p = ((COSDictionary)transformParams).getItem(COSName.getPDFName((String)"P"))) == null || !(p instanceof COSInteger)) continue;
                if (bDebug) {
                    logger.debug("[getCertificatioLevel] P " + ((COSInteger)p).intValue());
                }
                return ((COSInteger)p).intValue();
            }
        }
        return 0;
    }

    @Deprecated
    public boolean hasPreviousSignatureRevisions() throws CapiException {
        if (this.lastSignature == null) {
            return false;
        }
        RevisionInformation rev_info = this.lastSignature.getRevision();
        while (rev_info.getPreviusRevision() != null) {
            if (rev_info.getSignatures().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getCertificationLevel() throws CapiException {
        if (this.signatures.size() == 0) {
            return -1;
        }
        return this.signatures.get(this.signatures.size() - 1).getCertificationLevel();
    }

    public int getCertificationLevel(int SignatureIndex) throws CapiException {
        if (SignatureIndex < 0 || SignatureIndex >= this.signatures.size()) {
            return -1;
        }
        return this.signatures.get(SignatureIndex).getCertificationLevel();
    }

    @Deprecated
    public InputStream[] getPreviousSignatureRevisions() throws CapiException {
        InputStream is;
        this.checkClosed();
        if (!this.hasPreviousSignatureRevisions()) {
            return null;
        }
        Vector<InputStream> isVector = new Vector<InputStream>();
        if (this.lastSignature != null && this.lastSignature.getRevision().getPreviusRevision() != null && (is = this.getRevisionInputStream(this.lastSignature.getRevision().getPreviusRevision())) != null) {
            isVector.add(is);
        }
        InputStream[] arr = new InputStream[isVector.size()];
        for (int i = 0; i < isVector.size(); ++i) {
            arr[i] = (InputStream)isVector.elementAt(i);
        }
        return arr;
    }

    @Deprecated
    public InputStream getPreviousSignatureRevision(String signame) throws CapiException {
        this.checkClosed();
        if (!this.hasPreviousSignatureRevisions() || this.lastSignature.getName().equals(signame)) {
            return null;
        }
        for (int i = this.signatures.size() - 2; i >= 0; --i) {
            InputStream is;
            String name = this.signatures.get(i).getName();
            if (!name.equals(signame) || this.signatures.get(i).getRevision() == null || (is = this.getRevisionInputStream(this.signatures.get(i).getRevision())) == null) continue;
            return is;
        }
        return null;
    }

    public String[] getBlankSignatureNames() throws CapiException {
        this.checkClosed();
        String[] list = new String[this.emptySignaturesFields.size()];
        for (int i = 0; i < this.emptySignaturesFields.size(); ++i) {
            PDSignatureField sig = this.emptySignaturesFields.get(i).getSignature_field();
            COSString currSigName = (COSString)sig.getCOSObject().getDictionaryObject(COSName.T);
            String tmp = "";
            if (currSigName != null && currSigName.getString() != null) {
                tmp = currSigName.getString();
            }
            list[i] = tmp;
        }
        return list;
    }

    @Deprecated
    public String[] getPreviousSignatureRevisionNames() throws CapiException {
        this.checkClosed();
        if (!this.hasPreviousSignatureRevisions()) {
            return null;
        }
        Vector<String> names = new Vector<String>();
        for (int i = this.signatures.size() - 2; i >= 0; --i) {
            String name = this.signatures.get(i).getName();
            if (name == null || name == this.lastSignature.getName()) continue;
            names.add(name);
        }
        String[] list = new String[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            list[i] = (String)names.elementAt(i);
        }
        return list;
    }

    public void setDigestAlg(String digestAlg) throws CapiException {
        if (bDebug) {
            logger.debug("[setDigestAlg] Setting digest algorithm ...");
        }
        if (digestAlg == null) {
            throw new CapiException("Null data", 1001);
        }
        if (digestAlg.compareToIgnoreCase(SHA1) == 0) {
            if (bDebug) {
                logger.debug("[setDigestAlg] set SHA1 digest");
            }
            this.msgDigestToBeUsed = SHA1;
        } else if (digestAlg.compareToIgnoreCase(SHA256) == 0) {
            if (bDebug) {
                logger.debug("[setDigestAlg] set SHA256 digest ");
            }
            this.msgDigestToBeUsed = SHA256;
        } else {
            throw new CapiException("Invalid digest algorithm", 1002);
        }
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, HttpsClient https) throws CapiException {
        if (TSAserver == null || hashAlgorithm == null || https == null) {
            throw new CapiException("Null data", 1001);
        }
        if (hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAhttps = https;
        if (bDebug) {
            logger.debug("[setSignatureTimeStampParams] done.");
        }
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, String basicAuthUser, String basicAuthPassword) throws CapiException {
        if (TSAserver == null || hashAlgorithm == null) {
            throw new CapiException("Null data", 1001);
        }
        if (hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSABasicAuthUser = basicAuthUser;
        this.TSABasicAuthPassword = basicAuthPassword;
        if (bDebug) {
            logger.debug("[setSignatureTimeStampParams] done.");
        }
    }

    public void setSignatureTimeStampParams(String hashAlgorithm, String policy, boolean certReq, DTSClient client) throws CapiException {
        if (client == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAClient = client;
        this.TSA = "TSCLIENT";
        if (bDebug) {
            logger.debug("[setSignatureTimeStampParams DTSClient] done.");
        }
    }

    public void addVisualRenderedCertificationSignature(String alias, String visibleLabel, int fontSize, OutputStream pdfout, int permissions) throws CapiException {
        this.verifyAndSetCertificationPermission(permissions);
        this.addVisualRenderedSignatureRevision(alias, visibleLabel, fontSize, pdfout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addVisualRenderedSignatureRevision(String alias, String visibleLabel, int fontSize, OutputStream pdfout) throws CapiException {
        String in = null;
        URL inURL = null;
        Object objAppearance = null;
        try {
            if (this.filePDF != null) {
                in = this.filePDF;
            } else if (this.temporaryPDFenv != null && this.temporaryPDFenv.exists()) {
                in = this.temporaryPDFenv.getAbsolutePath();
            } else if (this.temporaryPDFURL != null) {
                inURL = this.temporaryPDFURL;
            } else {
                if (this.temporaryPDFData == null) throw new CapiException("Cannot get PDF Input File or URL", 1003);
                File tmpFile = TmpFileUtils.createTempFile((String)"PDFenv", null);
                this.temporaryPDFenv = tmpFile;
                FileOutputStream out = new FileOutputStream((java.io.File)tmpFile);
                out.write(this.temporaryPDFData, 0, this.temporaryPDFData.length);
                if (bDebug) {
                    logger.debug("bytearray saved in: " + tmpFile.getAbsolutePath());
                }
                in = this.temporaryPDFenv.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CapiException("Exception " + e.getMessage(), 1003);
        }
        try {
            Method myMethod;
            ClassLoader classLoader = SignedPDF.class.getClassLoader();
            Class<?> pdfClass = classLoader.loadClass("arubasign.pdf.PDFViewer");
            Object objInstance = pdfClass.newInstance();
            Class<?> pdfApparClass = classLoader.loadClass("arubasign.pdf.PDFSignApparence");
            if (bDebug) {
                logger.debug("arubasign.pdf.PDFSignApparence loaded");
            }
            if (in != null) {
                if (bDebug) {
                    logger.debug("call setLan...");
                }
                myMethod = pdfClass.getMethod("setLan", String.class);
                objAppearance = myMethod.invoke(objInstance, language);
                if (defaultStamp != null) {
                    if (bDebug) {
                        logger.debug("call defaultStamp...");
                    }
                    myMethod = pdfClass.getMethod("setDefaultStamp", String.class);
                    objAppearance = myMethod.invoke(objInstance, defaultStamp);
                }
                if (lastCustomStamp != null) {
                    if (bDebug) {
                        logger.debug("call lastCustomStamp...");
                    }
                    myMethod = pdfClass.getMethod("setLastCustomStamp", String.class);
                    objAppearance = myMethod.invoke(objInstance, lastCustomStamp);
                }
                if (bDebug) {
                    logger.debug("call checkApparence...");
                }
                myMethod = pdfClass.getMethod("checkApparence", String.class, String.class, String.class);
                objAppearance = myMethod.invoke(objInstance, in, this.reason, this.location);
            } else {
                if (inURL == null) throw new CapiException("No PDF Input File or URL", 1003);
                myMethod = pdfClass.getMethod("checkApparence", URL.class, String.class, String.class);
                objAppearance = myMethod.invoke(objInstance, inURL, this.reason, this.location);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CapiException("ClassNotFoundException: arubasign.pdf.PDFViewer", 1003);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CapiException("Exception: " + e.getMessage(), 1003);
        }
        if (objAppearance != null) {
            try {
                if (bDebug) {
                    logger.debug("objAppearance is not null");
                }
                Method pageField = objAppearance.getClass().getMethod("getPage", new Class[0]);
                Integer pageValue = (Integer)pageField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("page= " + pageValue);
                }
                Method reasonField = objAppearance.getClass().getMethod("getReason", new Class[0]);
                String reasonValue = (String)reasonField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("reason= " + reasonValue);
                }
                Method locationField = objAppearance.getClass().getMethod("getLocation", new Class[0]);
                String locationValue = (String)locationField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("location= " + locationValue);
                }
                this.setSignatureReason(reasonValue);
                this.setSignatureLocation(locationValue);
                Method imageField = objAppearance.getClass().getMethod("getImage", new Class[0]);
                BufferedImage imageValue = (BufferedImage)imageField.invoke(objAppearance, new Object[0]);
                Method customImagePathFiels = objAppearance.getClass().getMethod("getCustomImagePath", new Class[0]);
                String customImagePath = (String)customImagePathFiels.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("customImagePath= " + customImagePath);
                }
                if (customImagePath != null) {
                    lastCustomStamp = customImagePath;
                }
                Method leftxField = objAppearance.getClass().getMethod("getLeftx", new Class[0]);
                Integer leftxValue = (Integer)leftxField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("leftx= " + leftxValue);
                }
                Method leftyField = objAppearance.getClass().getMethod("getLefty", new Class[0]);
                Integer leftyValue = (Integer)leftyField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("lefty= " + leftyValue);
                }
                Method rightxField = objAppearance.getClass().getMethod("getRightx", new Class[0]);
                Integer rightxValue = (Integer)rightxField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("rightx= " + rightxValue);
                }
                Method rightyField = objAppearance.getClass().getMethod("getRighty", new Class[0]);
                Integer rightyValue = (Integer)rightyField.invoke(objAppearance, new Object[0]);
                if (bDebug) {
                    logger.debug("righty= " + rightyValue);
                }
                String id = "Signature_" + new Long(System.currentTimeMillis()).intValue();
                this.addSignatureRevision(alias, pdfout, id, pageValue, leftxValue.intValue(), rightyValue.intValue(), rightxValue - leftxValue, rightyValue - leftyValue, imageValue, visibleLabel, fontSize);
                if (!bDebug) return;
                logger.debug("visible signature added.");
                return;
            }
            catch (CapiException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CapiException("Exception: " + e.getMessage(), 1003);
            }
        } else {
            if (bDebug) {
                logger.debug("objAppearance is null");
            }
            this.addSignatureRevision(alias, pdfout, null);
            if (!bDebug) return;
            logger.debug("invisible signature added.");
        }
    }

    public void addSignatureRevision(String alias, OutputStream pdfout) throws CapiException {
        this.addSignatureRevision(alias, pdfout, null);
    }

    public void addSignatureRevision(String alias, OutputStream pdfout, String fieldName) throws CapiException {
        this.addSignatureRevision(false, alias, pdfout, fieldName, 0, 0.0f, 0.0f, 0.0f, 0.0f, null, null, 0);
    }

    public void addSignatureRevision(String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height) throws CapiException {
        this.addSignatureRevision(true, alias, pdfout, fieldName, page, posX, posY, width, height, null, null, 0);
    }

    public void addSignatureRevision(String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height, BufferedImage image, String visibleLabel, int fontSize) throws CapiException {
        this.addSignatureRevision(true, alias, pdfout, fieldName, page, posX, posY, width, height, image, visibleLabel, fontSize);
    }

    public void addSignatureRevision(TokenSpi tk, boolean newVisible, String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height, BufferedImage imageValue, String visibleLabel, int fontSize) throws CapiException {
        CapiPDFApparence app = null;
        if (newVisible) {
            app = new CapiPDFApparence();
            app.setPage(page);
            app.setImage(imageValue);
            app.setPosX(posX);
            app.setPosY(posY);
            app.setWidth(width);
            app.setHeight(height);
            app.setFontSize(fontSize);
            app.setVisibleLabel(visibleLabel);
        }
        this.addSignatureRevision(tk, alias, pdfout, fieldName, app, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSignatureRevision(TokenSpi tk, String alias, OutputStream pdfout, String fieldName, CapiPDFApparence apparence, AdditionalDictionaryInfo info) throws CapiException {
        this.signature_to_be_performed = true;
        if ((this.signatures != null && this.signatures.size() == 0 || apparence != null) && this.document.getDocumentCatalog().getAcroForm() != null && this.document.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
            this.document.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        PrivateKey privKey = null;
        Certificate x509 = null;
        String name = null;
        String organization = null;
        String title = null;
        try {
            String[] titles;
            String[] organizations;
            this.setInternalTokenSpi(tk);
            if (bDebug) {
                logger.debug("[addSigner] getting credential from token...");
            }
            x509 = new Certificate(tk.getCert(alias).getBytes());
            this.addSignatureCertificate(Util.getBytes((String)tk.getCert(alias)));
            if (bDebug) {
                logger.debug("...cert ok");
            }
            privKey = tk.getPrivateKey(alias);
            if (bDebug) {
                logger.debug("[addSigner] getting credential from token ok");
            }
            if ((name = x509.getName()) != null) {
                name = name.toUpperCase();
            }
            if ((organizations = x509.getSubjectDNAttribute("organization")) != null && organizations.length > 0) {
                organization = organizations[0].toUpperCase();
            }
            if ((titles = x509.getSubjectDNAttribute("title")) != null && titles.length > 0) {
                title = titles[0];
            }
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        this.setAlias(alias);
        logger.debug("Adding signer...");
        BufferedOutputStream fos = null;
        File pdf_signed = null;
        try {
            pdf_signed = TmpFileUtils.createTempFile((String)"pdf_signed", (String)".tmp");
            fos = new BufferedOutputStream(new FileOutputStream((java.io.File)pdf_signed));
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        signature.setName(x509.getName());
        if (this.reason != null) {
            signature.setReason(this.reason);
        }
        if (this.location != null) {
            signature.setLocation(this.location);
        }
        if (this.profile == 2) {
            signature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        }
        if (this.signDate != null) {
            signature.setSignDate(this.signDate);
        } else {
            signature.setSignDate(Calendar.getInstance());
        }
        if (info != null) {
            long[] byte_range;
            if (info instanceof GraphometricInfo) {
                byte_range = new long[]{0L, this.documentSize};
                COSDictionary graph = info.getDictionary(byte_range);
                signature.getCOSObject().setItem("biometric_data", (COSBase)graph);
            } else if (info instanceof AutenticaBinding) {
                signature.getCOSObject().setItem("binding_dictionary", (COSBase)info.getDictionary());
            } else if (info instanceof FeaInfo) {
                byte_range = new long[]{0L, this.documentSize};
                COSDictionary feaInfo = info.getDictionary(byte_range);
                signature.getCOSObject().setItem("fea_dictionary", (COSBase)feaInfo);
            } else {
                for (COSName cname : info.getDictionary().keySet()) {
                    COSBase item = info.getDictionary().getItem(cname);
                    signature.getCOSObject().setItem(cname, item);
                }
            }
        }
        if (this.assignedCertificationLevel != 0) {
            COSDictionary sigRefDic = new COSDictionary();
            sigRefDic.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"SigRef"));
            sigRefDic.setItem(COSName.getPDFName((String)"TransformMethod"), (COSBase)COSName.getPDFName((String)"DocMDP"));
            COSDictionary transformParams = new COSDictionary();
            transformParams.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"TransformParams"));
            transformParams.setItem(COSName.getPDFName((String)"V"), (COSBase)COSName.getPDFName((String)"1.2"));
            transformParams.setInt("P", this.assignedCertificationLevel);
            transformParams.setDirect(true);
            sigRefDic.setItem(COSName.getPDFName((String)"TransformParams"), (COSBase)transformParams);
            sigRefDic.setDirect(true);
            COSArray refArr = new COSArray();
            refArr.add((COSBase)sigRefDic);
            refArr.setDirect(true);
            signature.getCOSObject().setItem(COSName.getPDFName((String)"Reference"), (COSBase)refArr);
        }
        if (apparence != null) {
            apparence.setName(name);
            apparence.setOrganization(organization);
            apparence.setTitle(title);
            apparence.setFieldName(fieldName);
            apparence.setPDFASignature(this.bPDFA_signature);
            apparence.setGray(this.bGray_apparance);
            apparence.setSigningTimeCal(this.signDate);
            apparence.setLocation(this.location);
            apparence.setReason(this.reason);
            apparence.setPdDocument(this.document);
        } else if (fieldName != null) {
            PDSignatureField emptyPDsig = null;
            for (int i = 0; i < this.emptySignaturesFields.size(); ++i) {
                emptyPDsig = this.emptySignaturesFields.get(i).getSignature_field();
                COSString currSigName = (COSString)emptyPDsig.getCOSObject().getDictionaryObject(COSName.T);
                String tmp = "";
                if (currSigName != null && currSigName.getString() != null) {
                    tmp = currSigName.getString();
                }
                if (!fieldName.equalsIgnoreCase(tmp)) continue;
                if (bDebug) {
                    logger.debug("[addSigner] found emptySignatureFields to fill ");
                }
                try {
                    emptyPDsig.getCOSObject().setNeedToBeUpdated(true);
                    if (emptyPDsig.getWidgets().size() > 0) {
                        if (((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle() != null) {
                            if (((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getWidth() != 0.0f || ((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getHeight() != 0.0f) {
                                emptyPDsig.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
                                apparence = new CapiPDFApparence();
                                apparence.setPosX(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getLowerLeftX());
                                apparence.setPosY(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getUpperRightY());
                                apparence.setWidth(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getWidth());
                                apparence.setHeight(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getRectangle().getHeight());
                                apparence.setPage(this.document.getPages().indexOf(((PDAnnotationWidget)emptyPDsig.getWidgets().get(0)).getPage()) + 1);
                                apparence.setVisibleLabel(String.format("Signed by %s", name));
                                apparence.setScaleFont(true);
                                apparence.setPDFASignature(this.bPDFA_signature);
                                apparence.setGray(this.bGray_apparance);
                                apparence.setSigningTimeCal(this.signDate);
                                apparence.setLocation(this.location);
                                apparence.setReason(this.reason);
                                apparence.setPdDocument(this.document);
                                break;
                            }
                            emptyPDsig.setValue(signature);
                            break;
                        }
                        emptyPDsig.setValue(signature);
                        break;
                    }
                    emptyPDsig.setValue(signature);
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
        PDVisibleSigProperties signatureProperties = PadesUtils.getPDVisibleSigProperties(apparence);
        SignatureOptions options = null;
        try {
            if (signatureProperties != null && signatureProperties.isVisualSignEnabled()) {
                logger.debug("Adding visible Signature ....");
                options = new SignatureOptions();
                options.setVisualSignature(signatureProperties);
                options.setPage(apparence.getPage() - 1);
                this.document.addSignature(signature, (SignatureInterface)this, options);
            } else {
                logger.debug("Adding invisible Signature ....");
                this.document.addSignature(signature, (SignatureInterface)this);
            }
            long start = System.currentTimeMillis();
            logger.debug("[saveIncremental] saving document...");
            COSArray fieldArray = (COSArray)this.document.getDocumentCatalog().getAcroForm().getCOSObject().getDictionaryObject(COSName.FIELDS);
            fieldArray.setNeedToBeUpdated(true);
            this.document.saveIncremental((OutputStream)fos);
            logger.debug("[saveIncremental] document saved in " + (System.currentTimeMillis() - start) + " ms");
            if (this.signature_to_be_performed) {
                IOUtils.closeQuietly((Closeable)fos);
                fos = null;
                if (pdf_signed.exists()) {
                    pdf_signed.delete();
                }
                throw new CapiException("Firma PDF non Eseguita", 50001);
            }
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof CapiException) {
                if (pdf_signed != null && pdf_signed.exists()) {
                    pdf_signed.delete();
                }
                throw (CapiException)e.getCause();
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new CapiException("Internal error", 50050);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fos);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream((java.io.File)pdf_signed);
            Streams.pipeAll((InputStream)fis, (OutputStream)pdfout);
        }
        catch (FileNotFoundException e) {
            try {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
                catch (Exception e2) {
                    logger.debug(e2.getMessage(), (Throwable)e2);
                    throw new CapiException("Internal error", 50050);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                try {
                    if (pdf_signed != null && pdf_signed.exists()) {
                        pdf_signed.delete();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                try {
                    this.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
                Util.closeQuietly((Closeable)options);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fis);
        try {
            if (pdf_signed != null && pdf_signed.exists()) {
                pdf_signed.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.closeQuietly((Closeable)options);
        logger.debug("PDF Signature done");
    }

    public void addSignatureRevision(boolean newVisible, String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height, BufferedImage imageValue, String visibleLabel, int fontSize) throws CapiException {
        if (newVisible && fieldName == null) {
            throw new CapiException("Null fieldName", 1001);
        }
        this.checkClosed();
        if (this.lastSignature != null && this.lastSignature.getCertificationLevel() == 1) {
            if (bDebug) {
                logger.debug("Document certified and no changes allowed");
            }
            throw new CapiException("Document is certified and no changes are allowed.", 50026);
        }
        TokenSpi tk = ProvUtils.retrieveTokenByAlias((String)alias);
        this.addSignatureRevision(tk, newVisible, alias, pdfout, fieldName, page, posX, posY, width, height, imageValue, visibleLabel, fontSize);
    }

    private PDSignatureField findSignatureField(List<PDField> fields, PDSignature sigObject) {
        PDSignatureField signatureField = null;
        for (PDField pdField : fields) {
            PDSignature signature;
            if (!(pdField instanceof PDSignatureField) || (signature = ((PDSignatureField)pdField).getSignature()) == null || !signature.getCOSObject().equals(sigObject.getCOSObject())) continue;
            signatureField = (PDSignatureField)pdField;
        }
        return signatureField;
    }

    @Deprecated
    public GraphometricInfo getGraphometricInfo() {
        if (this.lastSignature != null) {
            return this.lastSignature.getGraphometricInfo();
        }
        return null;
    }

    public GraphometricInfo getGraphometricInfo(int signatureIndex) {
        return this.signatures.get(signatureIndex).getGraphometricInfo();
    }

    private Attribute getTSUnsignedAttribute(byte[] tstByteArray) throws CapiException {
        try {
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(tstByteArray));
            ContentInfo ci = ContentInfo.getInstance((Object)extIn.readObject());
            Attribute attr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)ci));
            return attr;
        }
        catch (Exception x) {
            logger.debug(x.getMessage(), (Throwable)x);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }

    private void setTimeStampTokenExc(CapiException e) {
        this.timeStampTokenExc = e;
    }

    public byte[] sign(InputStream content) throws IOException {
        StreamSignedEnvelope sse = null;
        try (ByteArrayOutputStream baos = null;){
            Date s_time;
            sse = new StreamSignedEnvelope(2);
            baos = new ByteArrayOutputStream();
            if (this.TSA != null) {
                if (this.TSA.toLowerCase().startsWith("http")) {
                    if (this.TSAhttps != null) {
                        sse.setSignatureTimeStampParams(this.TSA, this.TSAhashAlgorithm, this.TSApolicy, this.TSAcertReq, this.TSAhttps);
                    } else {
                        sse.setSignatureTimeStampParams(this.TSA, this.TSAhashAlgorithm, this.TSApolicy, this.TSAcertReq, this.TSABasicAuthUser, this.TSABasicAuthPassword);
                    }
                } else if (this.TSAClient != null) {
                    sse.setSignatureTimeStampParams(this.TSAhashAlgorithm, this.TSApolicy, this.TSAcertReq, this.TSAClient);
                }
            }
            Date date = s_time = this.signDate != null ? this.signDate.getTime() : null;
            if (this.profile == 2) {
                sse.includeSigningTime(false);
            }
            sse.addSigner(this.internal_tk, this.getAlias(), s_time, content);
            sse.getEncoded(null, (OutputStream)baos);
            this.signature_to_be_performed = false;
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private void setInternalTokenSpi(TokenSpi tk) {
        this.internal_tk = tk;
    }

    private void setAlias(String a) {
        this.alias = a;
    }

    private String getAlias() {
        return this.alias;
    }

    public void addCertificationSignature(String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height, int permissions) throws CapiException {
        this.verifyAndSetCertificationPermission(permissions);
        this.addSignatureRevision(true, alias, pdfout, fieldName, page, posX, posY, width, height, null, null, 0);
    }

    public void addCertificationSignature(String alias, OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height, int permissions, BufferedImage image, String visibleLabel, int fontSize) throws CapiException {
        this.verifyAndSetCertificationPermission(permissions);
        this.addSignatureRevision(true, alias, pdfout, fieldName, page, posX, posY, width, height, image, visibleLabel, fontSize);
    }

    public void addCertificationSignature(String alias, OutputStream pdfout, String fieldName, int permissions) throws CapiException {
        this.verifyAndSetCertificationPermission(permissions);
        this.addSignatureRevision(alias, pdfout, fieldName);
    }

    private void verifyAndSetCertificationPermission(int permissions) throws CapiException {
        this.checkClosed();
        if (!this.signatures.isEmpty()) {
            throw new CapiException("PDF is already signed. Certification Signature cannot be added.", 50050);
        }
        if (this.getCertificationLevel() != 0) {
            if (bDebug) {
                logger.debug("Document already certified");
            }
            throw new CapiException("Document already certified. Certification signature cannot be added.", 50026);
        }
        switch (permissions) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.assignedCertificationLevel = permissions;
                break;
            }
            default: {
                if (bDebug) {
                    logger.debug("Certification level value is not valid.");
                }
                throw new CapiException("Certification level value not valid.", 1002);
            }
        }
    }

    public boolean isSigned() throws CapiException {
        return this.isSigned;
    }

    public void addEmptySignatureField(OutputStream pdfout, String fieldName, int page, float posX, float posY, float width, float height) throws CapiException {
        if (fieldName == null) {
            throw new CapiException("Null fieldName", 1001);
        }
        this.checkClosed();
    }

    public void close() {
        this.deletePreviousRevisionsResources();
        this.bClosed = true;
        IOUtils.closeQuietly((Closeable)this.document);
        IOUtils.closeQuietly((Closeable)this.pdfFileBuffer);
        IOUtils.closeQuietly((Closeable)this.SCRATCH_FILE_TEMP);
        try {
            if (this.temporaryPDFenv.exists()) {
                this.temporaryPDFenv.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSignatureCertificate(byte[] certificate) throws CapiException {
        this.checkClosed();
        X509Certificate cert = new Certificate(certificate).getInternalCert();
        if (!this.certsVector.contains(cert)) {
            this.certsVector.addElement(cert);
        }
    }

    private void checkClosed() throws CapiException {
        if (this.bClosed) {
            throw new CapiException("PDF has been closed, reread it from the outputstream used to add the signature revision", 50003);
        }
    }

    public void addSignatureCertificates(Certificate[] certs) throws CapiException {
        this.checkClosed();
        for (int k = 0; k < certs.length; ++k) {
            if (this.certsVector.contains(certs[k].getInternalCert())) continue;
            this.certsVector.addElement(certs[k].getInternalCert());
        }
    }

    public void addSignatureCertificates(String[] certs) throws CapiException {
        this.checkClosed();
        for (int k = 0; k < certs.length; ++k) {
            Certificate crt = new Certificate(Util.getBytes((String)certs[k]));
            if (this.certsVector.contains(crt.getInternalCert())) continue;
            this.certsVector.addElement(crt.getInternalCert());
        }
    }

    @Deprecated
    public List<Certificate> listCertificates() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.lastSignature.getCertificatesArray();
    }

    public List<Certificate> listCertificates(int signatureIndex) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.signatures.get(signatureIndex).getCertificatesArray();
    }

    @Deprecated
    public Certificate getSignerCertificate() throws CapiException {
        return this.lastSignature.getSignerCertificate();
    }

    public Certificate getSignerCertificate(int signatureIndex) throws CapiException {
        return this.signatures.get(signatureIndex).getSignerCertificate();
    }

    @Deprecated
    public String getReason() {
        return this.lastSignature.getReason();
    }

    public String getReason(int signatureIndex) {
        return this.signatures.get(signatureIndex).getReason();
    }

    public void setSignatureReason(String reason) {
        this.reason = reason;
    }

    @Deprecated
    public String getSubFilter() {
        return this.lastSignature.getSubFilter();
    }

    @Deprecated
    public String getSubFilter(int signatureIndex) {
        return this.signatures.get(signatureIndex).getSubFilter();
    }

    @Deprecated
    public String getCertificateInSigDictionary() {
        return this.lastSignature.getCertificateInSigDictionary();
    }

    public String getCertificateInSigDictionary(int signatureIndex) {
        return this.signatures.get(signatureIndex).getCertificateInSigDictionary();
    }

    @Deprecated
    public byte[] getP7Detached() {
        return this.lastSignature.getP7Detached();
    }

    public byte[] getP7Detached(int signatureIndex) {
        return this.signatures.get(signatureIndex).getP7Detached();
    }

    @Deprecated
    public String getLocation() {
        return this.lastSignature.getLocation();
    }

    public String getLocation(int signatureIndex) {
        return this.signatures.get(signatureIndex).getLocation();
    }

    @Deprecated
    public void setSignatureLocation(String location) {
        this.location = location;
    }

    @Deprecated
    public Calendar getSignDate() {
        return this.lastSignature.getSignDate();
    }

    public Calendar getSignDate(int signatureIndex) {
        return this.signatures.get(signatureIndex).getSignDate();
    }

    @Deprecated
    public String getName() {
        return this.lastSignature.getName();
    }

    public String getName(int signatureIndex) {
        return this.signatures.get(signatureIndex).getName();
    }

    public void setSignatureSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    @Deprecated
    public String verify() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        if (!this.lastSignature.isValidSignature()) {
            throw new CapiException("Invalid signature", 3010);
        }
        return this.getSignerCertificate().getEncoded();
    }

    public String verify(int signatureIndex) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        if (!this.signatures.get(signatureIndex).isValidSignature()) {
            throw new CapiException("Invalid signature", 3010);
        }
        return this.getSignerCertificate(signatureIndex).getEncoded();
    }

    private void instanceDigest() throws CapiException {
        try {
            this.msgDigest = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            this.msgDigest256 = MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
    }

    private void deletePreviousRevisionsResources() {
        int i;
        if (this.revisionsIsVector != null && !this.revisionsIsVector.isEmpty()) {
            for (i = 0; i < this.revisionsIsVector.size(); ++i) {
                IOUtils.closeQuietly((Closeable)this.revisionsIsVector.get(i));
            }
        }
        if (this.revisionsFileVector != null && !this.revisionsFileVector.isEmpty()) {
            for (i = 0; i < this.revisionsFileVector.size(); ++i) {
                try {
                    this.revisionsFileVector.get(i).delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Deprecated
    public byte[] getSignature() throws CapiException {
        return this.lastSignature.getSignature();
    }

    @Deprecated
    public String getSignerEncryptionAlg(int signerInfoIndex) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.signatures.get(signerInfoIndex).getSignerEncryptionAlg();
    }

    @Deprecated
    public String getSignerDigestAlg() throws CapiException {
        return this.lastSignature.getSignerDigestAlg();
    }

    @Deprecated
    public String getSignerDigestAlgOid() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.lastSignature.getSignerDigestAlg();
    }

    @Deprecated
    public byte[] getMessageDigest() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.lastSignature.getMessageDigest();
    }

    @Deprecated
    public boolean hasSigningCertificateV2() throws CapiException {
        return this.lastSignature.hasSigningCertificateV2();
    }

    @Deprecated
    public String getSigningCertificateV2HashAlg() throws CapiException {
        return this.lastSignature.getSigningCertificateV2HashAlg();
    }

    @Deprecated
    public boolean hasSigningCertificate() throws CapiException {
        return this.lastSignature.hasSigningCertificate();
    }

    @Deprecated
    public byte[] getSignatureTimeStampToken() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.lastSignature.getSignatureTimeStampToken();
    }

    @Deprecated
    private void checkSigningCertificateESSCertID() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        this.lastSignature.hasSigningCertificateV2();
    }

    public static void setDebug(boolean value) {
        bDebug = value;
    }

    @Deprecated
    public AutenticaBinding getAutentica_info() {
        return this.lastSignature.getAutentica_info();
    }

    public FeaInfo getFeaInfo(int signatureIndex) {
        return this.signatures.get(signatureIndex).getFeaInfo();
    }

    public AutenticaBinding getAutentica_info(int signatureIndex) {
        return this.signatures.get(signatureIndex).getAutentica_info();
    }

    private void load(InputStream is, String decryptPassword) throws LoadWithPasswordException {
        PDFParser parser = null;
        try {
            this.pdfFileBuffer = this.SCRATCH_FILE_TEMP.createBuffer(is);
            if (!this.checkPdf(this.pdfFileBuffer)) {
                throw new IOException("Input is not a PDF");
            }
            parser = decryptPassword != null ? new PDFParser(this.pdfFileBuffer, decryptPassword, null, null, this.SCRATCH_FILE_TEMP) : new PDFParser(this.pdfFileBuffer, this.SCRATCH_FILE_TEMP);
            this.document = parser.parse();
        }
        catch (IOException ioe) {
            throw new LoadWithPasswordException(decryptPassword, ioe);
        }
    }

    private void load(java.io.File f, String decryptPassword) throws IOException {
        this.pdfFileBuffer = new RandomAccessBufferedFileInputStream(f);
        if (this.checkPdf(this.pdfFileBuffer)) {
            PDFParser parser = null;
            parser = decryptPassword != null ? new PDFParser(this.pdfFileBuffer, decryptPassword, null, null, this.SCRATCH_FILE_TEMP) : new PDFParser(this.pdfFileBuffer, this.SCRATCH_FILE_TEMP);
            try {
                this.document = parser.parse();
            }
            catch (IOException ioe) {
                IOUtils.closeQuietly((Closeable)this.pdfFileBuffer);
                throw new LoadWithPasswordException(decryptPassword, ioe);
            }
        } else {
            throw new IOException("Input is not a PDF");
        }
    }

    private void findRevision() throws IOException {
        int[] currentRange = new int[2];
        currentRange[0] = 0;
        int revisionIndex = 0;
        int currentByteLen = 0;
        RevisionInformation previous = null;
        this.pdfFileBuffer.seek(0L);
        boolean first_signed_revision_find = false;
        while (!this.pdfFileBuffer.isEOF()) {
            int readChar = this.pdfFileBuffer.read();
            if ((char)readChar == '%') {
                this.pdfFileBuffer.seek((long)currentByteLen);
                byte[] eof = this.pdfFileBuffer.readFully(5);
                String test = new String(eof, 0, 5, "US-ASCII");
                if (test.trim().equals("%%EOF")) {
                    readChar = this.pdfFileBuffer.read();
                    if ((char)readChar == '\n') {
                        ++currentByteLen;
                        logger.debug("EOF 6 carattere \\n codifica unix");
                    }
                    if ((char)readChar == '\r') {
                        ++currentByteLen;
                        readChar = this.pdfFileBuffer.read();
                        if ((char)readChar == '\n') {
                            logger.debug("EOF 6 carattere \\r settimo \\n codifica windows");
                            ++currentByteLen;
                        }
                    }
                    RevisionInformation newRev = new RevisionInformation();
                    currentRange[1] = currentByteLen += 5;
                    newRev.setRevisionId(revisionIndex);
                    newRev.setByteRange(currentRange);
                    for (PadesSignatureInformation signature : this.signatures) {
                        int[] br = signature.getByteRangeArray();
                        if (br == null || br[1] <= newRev.getByteRange()[0] || br[2] >= newRev.getByteRange()[1]) continue;
                        newRev.getSignatures().add(signature);
                        signature.setRevision(newRev);
                        newRev.setSignedRevision(true);
                        COSString contents = (COSString)signature.getSignatureDictionary().getDictionaryObject(COSName.CONTENTS);
                        int contentDimension = contents.toHexString().length();
                        int evaluatedContentDimension = br[2] - 1 - (br[1] + 1);
                        int revisionDimension = newRev.getByteRange()[1];
                        signature.setSignature_cover_all_revision(false);
                        if (br[0] != 0 || evaluatedContentDimension != contentDimension || br[2] + br[3] - contentDimension != revisionDimension - contentDimension || br[2] + br[3] != revisionDimension) continue;
                        signature.setSignature_cover_all_revision(true);
                    }
                    this.pdfFileBuffer.seek((long)currentByteLen);
                    if (first_signed_revision_find) {
                        newRev.setPreviousRevision(previous);
                        previous.setNextRevision(newRev);
                        this.revisions.add(newRev);
                        previous = newRev;
                        logger.debug("Aggiunta revisione " + revisionIndex + " Range " + currentRange[0] + " " + currentRange[1]);
                        ++revisionIndex;
                    } else if (newRev.getSignatures().size() != 0) {
                        if (previous != null) {
                            previous.getByteRange()[0] = 0;
                            previous.setRevisionId(0);
                            this.revisions.add(previous);
                            newRev.setPreviousRevision(previous);
                            previous.setNextRevision(newRev);
                            revisionIndex = 1;
                        } else {
                            revisionIndex = 0;
                        }
                        first_signed_revision_find = true;
                        newRev.setRevisionId(revisionIndex);
                        this.revisions.add(newRev);
                        previous = newRev;
                        logger.debug("Aggiunta revisione " + revisionIndex + " Range " + currentRange[0] + " " + currentRange[1]);
                        ++revisionIndex;
                    } else if (this.isParsableRevision(newRev)) {
                        previous = newRev;
                    }
                    currentRange = new int[2];
                    currentRange[0] = currentByteLen + 1;
                    continue;
                }
                this.pdfFileBuffer.seek((long)(currentByteLen + 1));
                ++currentByteLen;
                continue;
            }
            ++currentByteLen;
        }
        if (!first_signed_revision_find) {
            previous.getByteRange()[0] = 0;
            previous.setRevisionId(0);
            this.revisions.add(previous);
        } else {
            previous.getByteRange()[1] = (int)this.pdfFileBuffer.length();
        }
        for (PadesSignatureInformation signature : this.signatures) {
            if (signature.getRevision() != null) continue;
            this.revisions.get(this.revisions.size() - 1).getSignatures().add(signature);
            signature.setRevision(this.revisions.get(this.revisions.size() - 1));
            signature.setSignature_cover_all_revision(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isParsableRevision(RevisionInformation rev) {
        boolean bl;
        BufferedInputStream bis;
        PDDocument doc;
        RandomAccess randomAccess;
        ScratchFile scrachFile;
        block5: {
            scrachFile = null;
            randomAccess = null;
            doc = null;
            bis = null;
            if (rev.getByteRange()[1] >= 1000000) break block5;
            bis = this.getBufferedInputStream();
            scrachFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            randomAccess = scrachFile.createBuffer((InputStream)bis);
            doc = rev.getDocument(randomAccess, scrachFile);
            boolean bl2 = true;
            Util.closeQuietly((Closeable)doc);
            Util.closeQuietly((Closeable)bis);
            Util.closeQuietly((Closeable)randomAccess);
            Util.closeQuietly((Closeable)scrachFile);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (IOException ex) {
            try {
                logger.debug("Ipossibile parsare la revisioner");
            }
            catch (Throwable throwable) {
                Util.closeQuietly(doc);
                Util.closeQuietly(bis);
                Util.closeQuietly(randomAccess);
                Util.closeQuietly(scrachFile);
                throw throwable;
            }
            Util.closeQuietly(doc);
            Util.closeQuietly((Closeable)bis);
            Util.closeQuietly(randomAccess);
            Util.closeQuietly(scrachFile);
            return false;
        }
        Util.closeQuietly(doc);
        Util.closeQuietly((Closeable)bis);
        Util.closeQuietly(randomAccess);
        Util.closeQuietly((Closeable)scrachFile);
        return bl;
    }

    public void checkRevisions() throws FileNotFoundException, IOException, InterruptedException {
        for (int i = 0; i < this.document.getPages().getCount(); ++i) {
            Iterator streams = this.document.getPages().get(i).getContentStreams();
            while (streams.hasNext()) {
                PDStream stream = (PDStream)streams.next();
                RevisionInformation objectRevision = this.getRevisionByObjectOffset(stream.getCOSObject().getOffsetPosition());
                if (objectRevision == null || objectRevision.getPreviusRevision() == null) continue;
                objectRevision.setUpdatePreviousObject(true);
            }
            List annotations = this.document.getPages().get(i).getAnnotations();
            for (int z = 0; z < annotations.size(); ++z) {
                RevisionInformation objectRevision;
                PDAnnotation anno = (PDAnnotation)annotations.get(z);
                if (anno.getCOSObject().getItem(COSName.FT) != null || (objectRevision = this.getRevisionByObjectOffset(anno.getCOSObject().getOffsetPosition())) == null || objectRevision.getPreviusRevision() == null) continue;
                objectRevision.setUpdatePreviousAnnotation(true);
            }
        }
        List fields = this.document.getDocumentCatalog().getAcroForm().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            RevisionInformation objectRevision;
            PDField field = (PDField)fields.get(i);
            if (field.getFieldType() != null && field.getFieldType().equals("Sig") || (objectRevision = this.getRevisionByObjectOffset(field.getCOSObject().getOffsetPosition())) == null || objectRevision.getPreviusRevision() == null) continue;
            objectRevision.setUpdatePreviousField(true);
        }
    }

    private RevisionInformation getRevisionByObjectOffset(long offset) {
        RevisionInformation objReturn = null;
        for (int i = 0; i < this.revisions.size(); ++i) {
            long minOffset = 0L;
            long maxOffset = 0L;
            RevisionInformation rev = this.revisions.get(i);
            minOffset = rev.getPreviusRevision() != null ? (long)rev.getPreviusRevision().getByteRange()[1] : (long)rev.getByteRange()[0];
            maxOffset = rev.getByteRange()[1];
            if (offset >= maxOffset || offset < minOffset) continue;
            objReturn = rev;
            break;
        }
        return objReturn;
    }

    public ArrayList<RevisionInformation> getRevisions() {
        return this.revisions;
    }

    protected void finalize() throws IOException {
        if (!this.bClosed) {
            logger.debug("Documento PDF non chiuso");
            this.close();
        }
    }

    public LinkedList<X509Certificate> getCerts() {
        return this.padesDssInfo != null ? this.padesDssInfo.getCerts() : new LinkedList<X509Certificate>();
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        return this.padesDssInfo != null ? this.padesDssInfo.getOcsps() : new LinkedList<BasicOCSPResp>();
    }

    public LinkedList<CRL> getCrls() {
        return this.padesDssInfo != null ? this.padesDssInfo.getCrls() : new LinkedList<CRL>();
    }

    private boolean checkPdf(RandomAccessRead rar) throws IOException {
        boolean bRet = false;
        byte[] data = new byte[5];
        int nRead = rar.read(data, 0, data.length);
        if (nRead != -1) {
            String str = new String(data);
            bRet = str.startsWith("%FDF-") || str.startsWith("%PDF-");
        }
        rar.seek(0L);
        return bRet;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    private class LoadWithPasswordException
    extends IOException {
        String pwd;

        public LoadWithPasswordException(String pwd, Throwable cause) {
            super(cause);
            this.pwd = "";
            this.pwd = pwd;
        }
    }
}

