/*
 * Decompiled with CFR 0.152.
 */
package demo.cms.ecc;

import demo.DemoUtil;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.cms.CMSCertList;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedData;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.security.ecc.provider.ECCProvider;
import iaik.utils.ASN1InputStream;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class ECDSASignedData {
    private static String b;
    private static String a;
    X509Certificate[] certificates;
    PrivateKey signerKey;

    public void start() throws Exception {
        ECCProvider.addAsProvider();
        this.a();
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        byte[] byArray2 = null;
        System.out.println("Stream implementation demos");
        System.out.println("===========================");
        System.out.println("\nImplicit SignedDataStream demo [create]:\n");
        byte[] byArray3 = this.createSignedDataStream(byArray, 1);
        System.out.println();
        System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
        byArray2 = this.getSignedDataStream(byArray3, null);
        System.out.print("\nSigned content: ");
        System.out.println(new String(byArray2));
        System.out.println("\nExplicit SignedDataStream demo [create]:\n");
        byArray3 = this.createSignedDataStream(byArray, 2);
        System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
        byArray2 = this.getSignedDataStream(byArray3, byArray);
        System.out.print("\nSigned content: ");
        System.out.println(new String(byArray2));
        System.out.println("\nNon-stream implementation demos");
        System.out.println("===============================");
        System.out.println("\nImplicit CMS SignedData demo [create]:\n");
        byArray3 = this.createSignedData(byArray, 1);
        System.out.println("\nImplicit CMS SignedData demo [parse]:\n");
        byArray2 = this.getSignedData(byArray3, null);
        System.out.print("\nSigned content: ");
        System.out.println(new String(byArray2));
        System.out.println("\nExplicit CMS SignedData demo [create]:\n");
        byArray3 = this.createSignedData(byArray, 2);
        System.out.println("\nExplicit CMS SignedData demo [parse]:\n");
        byArray2 = this.getSignedData(byArray3, byArray);
        System.out.print("\nSigned content: ");
        System.out.println(new String(byArray2));
    }

    private void a() throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        Object object;
        try {
            object = new ASN1(a.getBytes()).toByteArray();
            pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "IAIK_ECC");
            this.signerKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            System.out.println(this.signerKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception("Error parsing private key: " + invalidKeySpecException.toString());
        }
        catch (CodingException codingException) {
            throw new Exception("Error parsing private key: " + codingException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("Error parsing private key: " + noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Exception("Error parsing private key: " + noSuchProviderException.toString());
        }
        try {
            object = new ASN1InputStream((InputStream)new ByteArrayInputStream(b.getBytes()));
            pKCS8EncodedKeySpec = new CMSCertList((InputStream)object);
            this.certificates = pKCS8EncodedKeySpec.getX509Certificates();
            return;
        }
        catch (CMSParsingException cMSParsingException) {
            throw new Exception("Error parsing signer certs: " + cMSParsingException.toString());
        }
        catch (IOException iOException) {
            throw new Exception("Error parsing signer certs: " + iOException.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new ECDSASignedData().start();
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        if (signedDataStream.getMode() == 2) {
            signedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        InputStream inputStream = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedDataStream.verify(this.certificates[0]);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.certificates[0].getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedData signedData = new SignedData((InputStream)byteArrayInputStream);
        if (signedData.getMode() == 2) {
            signedData.setContent(byArray2);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedData.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.certificates[0]);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.certificates[0].getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Object object;
        InputStream inputStream;
        System.out.print("Create a new message signed with ECDSA:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.certificates[0]);
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.ecdsa_With_SHA1.clone();
        algorithmID.encodeAbsentParametersAsNull(true);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, algorithmID, this.signerKey);
        Attribute[] attributeArray = new Attribute[]{new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.cms_data}), new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()})};
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        if (n == 2) {
            int n2;
            inputStream = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object)) > 0) {
            }
        }
        signedDataStream.setBlockSize(2048);
        inputStream = new ContentInfoStream((ContentStream)signedDataStream);
        object = new ByteArrayOutputStream();
        inputStream.writeTo((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public byte[] createSignedData(byte[] byArray, int n) throws IOException, CMSException {
        System.out.println("Create a new message signed with ECDSA:");
        SignedData signedData = new SignedData(byArray, n);
        signedData.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.certificates[0]);
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.ecdsa_With_SHA1.clone();
        algorithmID.encodeAbsentParametersAsNull(true);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, algorithmID, this.signerKey);
        Attribute[] attributeArray = new Attribute[]{new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data}), new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()})};
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        ContentInfo contentInfo = new ContentInfo((Content)signedData);
        return contentInfo.getEncoded();
    }

    public ECDSASignedData() throws Exception {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           ECDSASignedData demo                                 *");
        System.out.println("*      (shows how to use the SignedData(Stream) implementation with ECDSA)       *");
        System.out.println("**********************************************************************************");
        System.out.println();
    }

    static {
        a = "-----BEGIN ECDSA PRIVATE KEY-----\nMIIBGgIBADCBvAYHKoZIzj0CATCBsAIBATAkBgcqhkjOPQEBAhkA////////////\n/////////v//////////MDQEGP////////////////////7//////////AQYZCEF\nGeWcgOcPp+mrciQwSf643uzBRrmxBDEEGI2oDrAwkPZ8vyDrQ6GIAPT/Cv2C/xAS\nBxkrlf/I2nhjEBHtayTN1XP5d6EeeUgRAhkA////////////////md74NhRrybG0\n0igxAgEBBFYwVAIBAQQZAIIWXgv61AxyZxE0T8iWVBL/oMLKXHS5HaE0AzIABETJ\n4i9RX5LaoJlGaAlBC6N53f4oBAj073bnwWW2npxYU/klOFbBD74pdD++V2EwTQ==\n-----END ECDSA PPRIVATE KEY-----\n";
        b = "-----BEGIN PKCS7-----\nMIIHRAYJKoZIhvcNAQcCoIIHNTCCBzECAQExADALBgkqhkiG9w0BBwGgggcZMIID\nwjCCAyugAwIBAgIBCzANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMCQVQxJjAk\nBgNVBAoTHUdSQVogVU5JVkVSU0lUWSBPRiBURUNITk9MT0dZMUcwRQYDVQQLEz5J\nbnNpdHV0ZSBmb3IgQXBwbGllZCBJbmZvcm1hdGlvbiBQcm9jZXNzaW5nIGFuZCBD\nb21tdW5pY2F0aW9uczEVMBMGA1UEAxMMSUFJSyBUZXN0IENBMB4XDTA1MDExOTEw\nMTEzNVoXDTI1MDEwNjIyMzExN1owgZYxCzAJBgNVBAYTAkFUMSYwJAYDVQQKEx1H\nUkFaIFVOSVZFUlNJVFkgT0YgVEVDSE5PTE9HWTFHMEUGA1UECxM+SW5zaXR1dGUg\nZm9yIEFwcGxpZWQgSW5mb3JtYXRpb24gUHJvY2Vzc2luZyBhbmQgQ29tbXVuaWNh\ndGlvbnMxFjAUBgNVBAMTDUlBSUsgVGVzdFVzZXIwgfMwgbwGByqGSM49AgEwgbAC\nAQEwJAYHKoZIzj0BAQIZAP////////////////////7//////////zA0BBj/////\n///////////////+//////////wEGGQhBRnlnIDnD6fpq3IkMEn+uN7swUa5sQQx\nBBiNqA6wMJD2fL8g60OhiAD0/wr9gv8QEgcZK5X/yNp4YxAR7WskzdVz+XehHnlI\nEQIZAP///////////////5ne+DYUa8mxtNIoMQIBAQMyAAREyeIvUV+S2qCZRmgJ\nQQujed3+KAQI9O9258Fltp6cWFP5JThWwQ++KXQ/vldhME2jgcowgccwDAYDVR0T\nAQH/BAIwADAOBgNVHQ8BAf8EBAMCBsAwZwYDVR0gBGAwXjBcBgwrBgEEAZUSAQID\nAQEwTDBKBggrBgEFBQcCAjA+GjxUaGlzIGNlcnRpZmljYXRlIG1heSBiZSB1c2Vk\nIGZvciBkZW1vbnN0cmF0aW9uIHB1cnBvc2VzIG9ubHkwHQYDVR0OBBYEFO7FlM9O\nzhLRtLb15ZVukHnjzazpMB8GA1UdIwQYMBaAFOtWHOnph3q+vzHzdX8q/qzlQNOO\nMA0GCSqGSIb3DQEBBQUAA4GBACO1IvVkEXEszw/jzzTh4JVxMOcCkFaE3CjWfFqt\nMNvyrOiHhM4moRHc2TEeTLI3X+eXmcg8wnoRozm3zQ20sfl4QiT+w4Pr8cWaX0Jb\npXO+O9C/trOVYRLv8f2IWlTR1FR3Ysn/kQq9vxJ7rFZP6odFQ0jrgH1IT3ZLI+Ea\neGyWMIIDTzCCArigAwIBAgIBADANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMC\nQVQxJjAkBgNVBAoTHUdSQVogVU5JVkVSU0lUWSBPRiBURUNITk9MT0dZMUcwRQYD\nVQQLEz5JbnNpdHV0ZSBmb3IgQXBwbGllZCBJbmZvcm1hdGlvbiBQcm9jZXNzaW5n\nIGFuZCBDb21tdW5pY2F0aW9uczEVMBMGA1UEAxMMSUFJSyBUZXN0IENBMB4XDTA1\nMDEwNjIyMzExN1oXDTI1MDEwNjIyMzExN1owgZUxCzAJBgNVBAYTAkFUMSYwJAYD\nVQQKEx1HUkFaIFVOSVZFUlNJVFkgT0YgVEVDSE5PTE9HWTFHMEUGA1UECxM+SW5z\naXR1dGUgZm9yIEFwcGxpZWQgSW5mb3JtYXRpb24gUHJvY2Vzc2luZyBhbmQgQ29t\nbXVuaWNhdGlvbnMxFTATBgNVBAMTDElBSUsgVGVzdCBDQTCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAzI4qWbKahUJCdZk7qRApCkSHR/luZuX8PpueX4Y4TdB6\n4AQbv4nu2Uu7+dt6gVqPorwH9ETBVnW4lBl2OfempZtAguMltZfQYwi/R6nm3Idp\nMtDLGq/ex9lBit7VXXsdCAsWXvzf3OpuAf4dUMd5ut7hzK68Oj45CPQ2DdF6ohcC\nAwEAAaOBrDCBqTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjBnBgNV\nHSAEYDBeMFwGDCsGAQQBlRIBAgMBATBMMEoGCCsGAQUFBwICMD4aPFRoaXMgY2Vy\ndGlmaWNhdGUgbWF5IGJlIHVzZWQgZm9yIGRlbW9uc3RyYXRpb24gcHVycG9zZXMg\nb25seTAdBgNVHQ4EFgQU61Yc6emHer6/MfN1fyr+rOVA044wDQYJKoZIhvcNAQEF\nBQADgYEAtvTsj41rzptNAYSoEcMo7uUH6rRFssKZsr6x9hv8LQZE3atqvJSfpQV8\nHV3X0G9HXHAxGg1IUAgTOmJsffQiFH/8V7BTyK6XgzuWKTKJGkZ93PJlrYjblnoO\nSHJwoDB6B3Z2QFilWE/ew3DXkImWNUuvCGQjyaDtjuV7tB8ZXAgxAA==\n-----END PKCS7-----\n";
    }
}

