/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.AuthenticatedData;
import iaik.cms.AuthenticatedDataStream;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyAgreeRecipientInfo;
import iaik.cms.KeyIdentifier;
import iaik.cms.OriginatorInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.RecipientKeyIdentifier;
import iaik.cms.attributes.CMSContentType;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;

public class CMSAuthenticatedData {
    SecureRandom random;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate[] originatorCerts;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            AlgorithmID algorithmID = AlgorithmID.hMAC_SHA1;
            int n = 64;
            AlgorithmID algorithmID2 = AlgorithmID.sha1;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nCMS AuthenticatedDataStream demo with authenticated attributes [create, implicit mode]:\n");
            byte[] byArray2 = this.createAuthenticatedDataStream(byArray, algorithmID, n, algorithmID2, 1);
            System.out.println("\nCMS AuthenticatedDataStream demo [parse, implicit mode]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(true, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(true, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(true, byArray2, null);
            System.out.println("\nCMS AuthenticatedDataStream demo without authenticated attributes [create, implicit mode]:\n");
            byArray2 = this.createAuthenticatedDataStream(byArray, algorithmID, n, null, 1);
            System.out.println("\nCMS AuthenticatedDataStream demo [parse, implicit mode]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(true, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(true, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(true, byArray2, null);
            System.out.println("\nCMS AuthenticatedDataStream demo with authenticated attributes [create, explicit mode]:\n");
            byArray2 = this.createAuthenticatedDataStream(byArray, algorithmID, n, algorithmID2, 2);
            System.out.println("\nCMS AuthenticatedDataStream demo [parse, explicit mode]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(true, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(true, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(true, byArray2, byArray);
            System.out.println("\nCMS AuthenticatedDataStream demo without authenticated attributes [create, explicit mode]:\n");
            byArray2 = this.createAuthenticatedDataStream(byArray, algorithmID, n, null, 2);
            System.out.println("\nCMS AuthenticatedDataStream demo [parse, explicit mode]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(true, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(true, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(true, byArray2, byArray);
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nCMS AuthenticatedData demo with authenticated attributes [create, implicit mode]:\n");
            byArray2 = this.createAuthenticatedData(byArray, algorithmID, n, algorithmID2, 1);
            System.out.println("\nCMS AuthenticatedData demo [parse]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(false, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(false, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(false, byArray2, null);
            System.out.println("\nCMS AuthenticatedData demo without authenticated attributes [create, implicit mode]:\n");
            byArray2 = this.createAuthenticatedData(byArray, algorithmID, n, null, 1);
            System.out.println("\nCMS AuthenticatedData demo [parse]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(false, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(false, byArray2, null);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(false, byArray2, null);
            System.out.println("\nCMS AuthenticatedData demo with authenticated attributes [create, explicit mode]:\n");
            byArray2 = this.createAuthenticatedData(byArray, algorithmID, n, algorithmID2, 2);
            System.out.println("\nCMS AuthenticatedData demo [parse]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(false, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(false, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(false, byArray2, byArray);
            System.out.println("\nCMS AuthenticatedData demo without authenticated attributes [create, explicit mode]:\n");
            byArray2 = this.createAuthenticatedData(byArray, algorithmID, n, null, 2);
            System.out.println("\nCMS AuthenticatedData demo [parse]:\n");
            System.out.println("Decrypt and verify for the several recipients using their index into the recipientInfos field.");
            this.parseAuthenticatedDataWithRecipientInfoIndex(false, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their RecipientIdentifier.");
            this.parseAuthenticatedDataWithRecipientIdentifier(false, byArray2, byArray);
            System.out.println("Decrypt and verify for the several recipients using their certificate.");
            this.parseAuthenticatedDataWithRecipientCert(false, byArray2, byArray);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void parseAuthenticatedDataWithRecipientInfoIndex(boolean bl, byte[] byArray, byte[] byArray2) throws Exception {
        if (bl) {
            System.out.println("\nVerify MAC for user1:");
            byte[] byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user1_pk, 0);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            System.out.println("\nVerify MAC for user2:");
            byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user2_pk, 0);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            return;
        }
        System.out.println("\nVerify MAC for user1:");
        byte[] byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user1_pk, 0);
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
        System.out.println("\nVerify MAC for user2:");
        byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user2_pk, 0);
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
    }

    public void parseAuthenticatedDataWithRecipientIdentifier(boolean bl, byte[] byArray, byte[] byArray2) throws Exception {
        if (bl) {
            System.out.println("\nVerify MAC for user1:");
            byte[] byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.user1));
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            System.out.println("\nVerify MAC for user2:");
            byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user2_pk, (KeyIdentifier)new RecipientKeyIdentifier(this.user2));
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            return;
        }
        System.out.println("\nVerify MAC for user1:");
        byte[] byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user1_pk, (KeyIdentifier)new IssuerAndSerialNumber(this.user1));
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
        System.out.println("\nVerify MAC for user2:");
        byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user2_pk, (KeyIdentifier)new RecipientKeyIdentifier(this.user2));
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
    }

    public void parseAuthenticatedDataWithRecipientCert(boolean bl, byte[] byArray, byte[] byArray2) throws Exception {
        if (bl) {
            System.out.println("\nVerify MAC for user1:");
            byte[] byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user1_pk, this.user1);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            System.out.println("\nVerify MAC for user2:");
            byArray3 = this.getAuthenticatedDataStream(byArray, byArray2, (Key)this.user2_pk, this.user2);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray3));
            return;
        }
        System.out.println("\nVerify MAC for user1:");
        byte[] byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user1_pk, this.user1);
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
        System.out.println("\nVerify MAC for user2:");
        byArray4 = this.getAuthenticatedData(byArray, byArray2, (Key)this.user2_pk, this.user2);
        System.out.print("\nContent: ");
        System.out.println(new String(byArray4));
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSAuthenticatedData().start();
        System.in.read();
    }

    public byte[] getAuthenticatedDataStream(byte[] byArray, byte[] byArray2, Key key, X509Certificate x509Certificate) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedDataStream authenticatedDataStream = new AuthenticatedDataStream((InputStream)byteArrayInputStream);
        if (authenticatedDataStream.getMode() == 2) {
            authenticatedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        try {
            System.out.println("Verify mac...");
            authenticatedDataStream.setupMac(key, x509Certificate);
            InputStream inputStream = authenticatedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            if (!authenticatedDataStream.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getAuthenticatedDataStream(byte[] byArray, byte[] byArray2, Key key, KeyIdentifier keyIdentifier) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedDataStream authenticatedDataStream = new AuthenticatedDataStream((InputStream)byteArrayInputStream);
        if (authenticatedDataStream.getMode() == 2) {
            authenticatedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        System.out.println("\nSearch for RecipientInfo:");
        RecipientInfo recipientInfo = authenticatedDataStream.getRecipientInfo(keyIdentifier);
        if (recipientInfo != null) {
            System.out.println("RecipientInfo: " + recipientInfo);
        }
        try {
            System.out.println("Decrypt encrypted mac key...");
            SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier);
            System.out.println("Verify content mac with decrypted mac key...");
            authenticatedDataStream.setupMac(secretKey);
            InputStream inputStream = authenticatedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            if (!authenticatedDataStream.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getAuthenticatedDataStream(byte[] byArray, byte[] byArray2, Key key, int n) throws IOException, CMSException {
        StreamCopier streamCopier;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedDataStream authenticatedDataStream = new AuthenticatedDataStream((InputStream)byteArrayInputStream);
        if (authenticatedDataStream.getMode() == 2) {
            authenticatedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        System.out.println("\nThis message can be verified by the following recipients:");
        RecipientInfo[] recipientInfoArray = authenticatedDataStream.getRecipientInfos();
        if (n == 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < recipientInfoArray.length) {
                streamCopier = recipientInfoArray[n3].getRecipientIdentifiers();
                int n4 = 0;
                while (n4 < ((StreamCopier)streamCopier).length) {
                    System.out.println("Recipient " + ++n2 + ":");
                    System.out.println(streamCopier[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
        try {
            authenticatedDataStream.setupMac(key, n);
            InputStream inputStream = authenticatedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            if (!authenticatedDataStream.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getAuthenticatedData(byte[] byArray, byte[] byArray2, Key key, X509Certificate x509Certificate) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedData authenticatedData = new AuthenticatedData((InputStream)byteArrayInputStream);
        if (authenticatedData.getMode() == 2) {
            authenticatedData.setContent(byArray2);
        }
        try {
            System.out.println("Verify mac...");
            authenticatedData.setupMac(key, x509Certificate);
            if (!authenticatedData.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return authenticatedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getAuthenticatedData(byte[] byArray, byte[] byArray2, Key key, KeyIdentifier keyIdentifier) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedData authenticatedData = new AuthenticatedData((InputStream)byteArrayInputStream);
        if (authenticatedData.getMode() == 2) {
            authenticatedData.setContent(byArray2);
        }
        System.out.println("\nSearch for RecipientInfo:");
        RecipientInfo recipientInfo = authenticatedData.getRecipientInfo(keyIdentifier);
        if (recipientInfo != null) {
            System.out.println("RecipientInfo: " + recipientInfo);
        }
        try {
            System.out.println("Decrypt encrypted mac key...");
            SecretKey secretKey = recipientInfo.decryptKey(key, keyIdentifier);
            System.out.println("Verify content mac with decrypted mac key...");
            authenticatedData.setupMac(secretKey);
            if (!authenticatedData.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return authenticatedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
    }

    public byte[] getAuthenticatedData(byte[] byArray, byte[] byArray2, Key key, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AuthenticatedData authenticatedData = new AuthenticatedData((InputStream)byteArrayInputStream);
        if (authenticatedData.getMode() == 2) {
            authenticatedData.setContent(byArray2);
        }
        System.out.println("\nThis message can be verified by the owners of the following recipients:");
        RecipientInfo[] recipientInfoArray = authenticatedData.getRecipientInfos();
        if (n == 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < recipientInfoArray.length) {
                KeyIdentifier[] keyIdentifierArray = recipientInfoArray[n3].getRecipientIdentifiers();
                int n4 = 0;
                while (n4 < keyIdentifierArray.length) {
                    System.out.println("Recipient " + ++n2 + ":");
                    System.out.println(keyIdentifierArray[n4]);
                    ++n4;
                }
                ++n3;
            }
        }
        try {
            authenticatedData.setupMac(key, n);
            if (!authenticatedData.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return authenticatedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public RecipientInfo[] createRecipients() throws CMSException {
        KeyAgreeRecipientInfo[] keyAgreeRecipientInfoArray = new KeyAgreeRecipientInfo[1];
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.ssdhKeyAgreement.clone();
            AlgorithmID algorithmID2 = (AlgorithmID)CMSAlgorithmID.cms_HMACwith3DES_wrap.clone();
            int n = 192;
            byte[] byArray = new byte[64];
            this.random.nextBytes(byArray);
            keyAgreeRecipientInfoArray[0] = new KeyAgreeRecipientInfo(this.user1, this.user1_pk, 0, algorithmID, algorithmID2, n, byArray);
            keyAgreeRecipientInfoArray[0].addRecipient(this.user1, 0);
            keyAgreeRecipientInfoArray[0].addRecipient(this.user2, 2);
        }
        catch (Exception exception) {
            throw new CMSException("Error adding recipients: " + exception.getMessage());
        }
        return keyAgreeRecipientInfoArray;
    }

    public byte[] createAuthenticatedDataStream(byte[] byArray, AlgorithmID algorithmID, int n, AlgorithmID algorithmID2, int n2) throws IOException, CMSException {
        Closeable closeable;
        AuthenticatedDataStream authenticatedDataStream;
        AlgorithmID algorithmID3 = (AlgorithmID)algorithmID.clone();
        AlgorithmID algorithmID4 = null;
        if (algorithmID2 != null) {
            algorithmID4 = (AlgorithmID)algorithmID2.clone();
        }
        ObjectID objectID = ObjectID.cms_data;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            authenticatedDataStream = new AuthenticatedDataStream(objectID, (InputStream)byteArrayInputStream, algorithmID3, n, null, algorithmID4, n2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
        OriginatorInfo originatorInfo = new OriginatorInfo();
        originatorInfo.setCertificates((Certificate[])this.originatorCerts);
        authenticatedDataStream.setOriginatorInfo(originatorInfo);
        RecipientInfo[] recipientInfoArray = this.createRecipients();
        authenticatedDataStream.setRecipientInfos(recipientInfoArray);
        if (algorithmID2 != null) {
            try {
                closeable = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(objectID))};
                authenticatedDataStream.setAuthenticatedAttributes((Attribute[])closeable);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating attribute: " + exception.toString());
            }
        }
        if (n2 == 2) {
            int n3;
            closeable = authenticatedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n3 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        authenticatedDataStream.writeTo((OutputStream)closeable, 2048);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public byte[] createAuthenticatedData(byte[] byArray, AlgorithmID algorithmID, int n, AlgorithmID algorithmID2, int n2) throws CMSException {
        AuthenticatedData authenticatedData;
        AlgorithmID algorithmID3 = (AlgorithmID)algorithmID.clone();
        AlgorithmID algorithmID4 = null;
        if (algorithmID2 != null) {
            algorithmID4 = (AlgorithmID)algorithmID2.clone();
        }
        ObjectID objectID = ObjectID.cms_data;
        try {
            authenticatedData = new AuthenticatedData(objectID, byArray, algorithmID3, n, null, algorithmID4, n2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
        OriginatorInfo originatorInfo = new OriginatorInfo();
        originatorInfo.setCertificates((Certificate[])this.originatorCerts);
        authenticatedData.setOriginatorInfo(originatorInfo);
        RecipientInfo[] recipientInfoArray = this.createRecipients();
        authenticatedData.setRecipientInfos(recipientInfoArray);
        if (algorithmID2 != null) {
            try {
                Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(objectID))};
                authenticatedData.setAuthenticatedAttributes(attributeArray);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating attribute: " + exception.toString());
            }
        }
        return authenticatedData.getEncoded();
    }

    public CMSAuthenticatedData() throws IOException {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           CMSAuthenticatedData demo                                *");
        System.out.println("*        (shows the usage of the CMS AuthenticatedData type implementation)          *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.originatorCerts = CMSKeyStore.getCertificateChain(2, 4);
        this.user1 = this.originatorCerts[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(2, 4);
        this.user2 = CMSKeyStore.getCertificateChain(2, 5)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(2, 5);
        this.random = SecRandom.getDefault();
    }
}

