/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.parser;

import java.lang.reflect.GenericSignatureFormatError;
import java.util.ArrayList;
import java.util.List;
import sun.reflect.generics.tree.ArrayTypeSignature;
import sun.reflect.generics.tree.BaseType;
import sun.reflect.generics.tree.BooleanSignature;
import sun.reflect.generics.tree.BottomSignature;
import sun.reflect.generics.tree.ByteSignature;
import sun.reflect.generics.tree.CharSignature;
import sun.reflect.generics.tree.ClassSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.tree.DoubleSignature;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.tree.FloatSignature;
import sun.reflect.generics.tree.FormalTypeParameter;
import sun.reflect.generics.tree.IntSignature;
import sun.reflect.generics.tree.LongSignature;
import sun.reflect.generics.tree.MethodTypeSignature;
import sun.reflect.generics.tree.ReturnType;
import sun.reflect.generics.tree.ShortSignature;
import sun.reflect.generics.tree.SimpleClassTypeSignature;
import sun.reflect.generics.tree.TypeArgument;
import sun.reflect.generics.tree.TypeSignature;
import sun.reflect.generics.tree.TypeVariableSignature;
import sun.reflect.generics.tree.VoidDescriptor;
import sun.reflect.generics.tree.Wildcard;

public class SignatureParser {
    private char[] input;
    private int index = 0;
    private static final char EOI = ':';
    private static final boolean DEBUG = false;

    private SignatureParser() {
    }

    private char getNext() {
        assert (this.index <= this.input.length);
        try {
            return this.input[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return ':';
        }
    }

    private char current() {
        assert (this.index <= this.input.length);
        try {
            return this.input[this.index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return ':';
        }
    }

    private void advance() {
        assert (this.index <= this.input.length);
        ++this.index;
    }

    private boolean matches(char c, char ... cArray) {
        for (char c2 : cArray) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    private Error error(String string) {
        return new GenericSignatureFormatError();
    }

    public static SignatureParser make() {
        return new SignatureParser();
    }

    public ClassSignature parseClassSig(String string) {
        this.input = string.toCharArray();
        return this.parseClassSignature();
    }

    public MethodTypeSignature parseMethodSig(String string) {
        this.input = string.toCharArray();
        return this.parseMethodTypeSignature();
    }

    public TypeSignature parseTypeSig(String string) {
        this.input = string.toCharArray();
        return this.parseTypeSignature();
    }

    private ClassSignature parseClassSignature() {
        assert (this.index == 0);
        return ClassSignature.make(this.parseZeroOrMoreFormalTypeParameters(), this.parseClassTypeSignature(), this.parseSuperInterfaces());
    }

    private FormalTypeParameter[] parseZeroOrMoreFormalTypeParameters() {
        if (this.current() == '<') {
            return this.parseFormalTypeParameters();
        }
        return new FormalTypeParameter[0];
    }

    private FormalTypeParameter[] parseFormalTypeParameters() {
        ArrayList<FormalTypeParameter> arrayList = new ArrayList<FormalTypeParameter>(3);
        assert (this.current() == '<');
        if (this.current() != '<') {
            throw this.error("expected <");
        }
        this.advance();
        arrayList.add(this.parseFormalTypeParameter());
        while (this.current() != '>') {
            arrayList.add(this.parseFormalTypeParameter());
        }
        this.advance();
        FormalTypeParameter[] formalTypeParameterArray = new FormalTypeParameter[arrayList.size()];
        return arrayList.toArray(formalTypeParameterArray);
    }

    private FormalTypeParameter parseFormalTypeParameter() {
        String string = this.parseIdentifier();
        FieldTypeSignature[] fieldTypeSignatureArray = this.parseZeroOrMoreBounds();
        return FormalTypeParameter.make(string, fieldTypeSignatureArray);
    }

    private String parseIdentifier() {
        StringBuilder stringBuilder = new StringBuilder();
        while (!Character.isWhitespace(this.current())) {
            char c = this.current();
            switch (c) {
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '[': {
                    return stringBuilder.toString();
                }
            }
            stringBuilder.append(c);
            this.advance();
        }
        return stringBuilder.toString();
    }

    private FieldTypeSignature parseFieldTypeSignature() {
        switch (this.current()) {
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
            case '[': {
                return this.parseArrayTypeSignature();
            }
        }
        throw this.error("Expected Field Type Signature");
    }

    private ClassTypeSignature parseClassTypeSignature() {
        assert (this.current() == 'L');
        if (this.current() != 'L') {
            throw this.error("expected a class type");
        }
        this.advance();
        ArrayList<SimpleClassTypeSignature> arrayList = new ArrayList<SimpleClassTypeSignature>(5);
        arrayList.add(this.parseSimpleClassTypeSignature(false));
        this.parseClassTypeSignatureSuffix(arrayList);
        if (this.current() != ';') {
            throw this.error("expected ';' got '" + this.current() + "'");
        }
        this.advance();
        return ClassTypeSignature.make(arrayList);
    }

    private SimpleClassTypeSignature parseSimpleClassTypeSignature(boolean bl) {
        String string = this.parseIdentifier();
        char c = this.current();
        switch (c) {
            case '/': 
            case ';': {
                return SimpleClassTypeSignature.make(string, bl, new TypeArgument[0]);
            }
            case '<': {
                return SimpleClassTypeSignature.make(string, bl, this.parseTypeArguments());
            }
        }
        throw this.error("expected < or ; or /");
    }

    private void parseClassTypeSignatureSuffix(List<SimpleClassTypeSignature> list) {
        while (this.current() == '/' || this.current() == '.') {
            boolean bl = this.current() == '.';
            this.advance();
            list.add(this.parseSimpleClassTypeSignature(bl));
        }
    }

    private TypeArgument[] parseTypeArgumentsOpt() {
        if (this.current() == '<') {
            return this.parseTypeArguments();
        }
        return new TypeArgument[0];
    }

    private TypeArgument[] parseTypeArguments() {
        ArrayList<TypeArgument> arrayList = new ArrayList<TypeArgument>(3);
        assert (this.current() == '<');
        if (this.current() != '<') {
            throw this.error("expected <");
        }
        this.advance();
        arrayList.add(this.parseTypeArgument());
        while (this.current() != '>') {
            arrayList.add(this.parseTypeArgument());
        }
        this.advance();
        TypeArgument[] typeArgumentArray = new TypeArgument[arrayList.size()];
        return arrayList.toArray(typeArgumentArray);
    }

    private TypeArgument parseTypeArgument() {
        FieldTypeSignature[] fieldTypeSignatureArray = new FieldTypeSignature[1];
        FieldTypeSignature[] fieldTypeSignatureArray2 = new FieldTypeSignature[1];
        TypeArgument[] typeArgumentArray = new TypeArgument[]{};
        char c = this.current();
        switch (c) {
            case '+': {
                this.advance();
                fieldTypeSignatureArray[0] = this.parseFieldTypeSignature();
                fieldTypeSignatureArray2[0] = BottomSignature.make();
                return Wildcard.make(fieldTypeSignatureArray, fieldTypeSignatureArray2);
            }
            case '*': {
                this.advance();
                fieldTypeSignatureArray[0] = SimpleClassTypeSignature.make("java.lang.Object", false, typeArgumentArray);
                fieldTypeSignatureArray2[0] = BottomSignature.make();
                return Wildcard.make(fieldTypeSignatureArray, fieldTypeSignatureArray2);
            }
            case '-': {
                this.advance();
                fieldTypeSignatureArray2[0] = this.parseFieldTypeSignature();
                fieldTypeSignatureArray[0] = SimpleClassTypeSignature.make("java.lang.Object", false, typeArgumentArray);
                return Wildcard.make(fieldTypeSignatureArray, fieldTypeSignatureArray2);
            }
        }
        return this.parseFieldTypeSignature();
    }

    private TypeVariableSignature parseTypeVariableSignature() {
        assert (this.current() == 'T');
        if (this.current() != 'T') {
            throw this.error("expected a type variable usage");
        }
        this.advance();
        TypeVariableSignature typeVariableSignature = TypeVariableSignature.make(this.parseIdentifier());
        if (this.current() != ';') {
            throw this.error("; expected in signature of type variable named" + typeVariableSignature.getIdentifier());
        }
        this.advance();
        return typeVariableSignature;
    }

    private ArrayTypeSignature parseArrayTypeSignature() {
        if (this.current() != '[') {
            throw this.error("expected array type signature");
        }
        this.advance();
        return ArrayTypeSignature.make(this.parseTypeSignature());
    }

    private TypeSignature parseTypeSignature() {
        switch (this.current()) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return this.parseBaseType();
            }
        }
        return this.parseFieldTypeSignature();
    }

    private BaseType parseBaseType() {
        switch (this.current()) {
            case 'B': {
                this.advance();
                return ByteSignature.make();
            }
            case 'C': {
                this.advance();
                return CharSignature.make();
            }
            case 'D': {
                this.advance();
                return DoubleSignature.make();
            }
            case 'F': {
                this.advance();
                return FloatSignature.make();
            }
            case 'I': {
                this.advance();
                return IntSignature.make();
            }
            case 'J': {
                this.advance();
                return LongSignature.make();
            }
            case 'S': {
                this.advance();
                return ShortSignature.make();
            }
            case 'Z': {
                this.advance();
                return BooleanSignature.make();
            }
        }
        assert (false);
        throw this.error("expected primitive type");
    }

    private FieldTypeSignature[] parseZeroOrMoreBounds() {
        ArrayList<FieldTypeSignature> arrayList = new ArrayList<FieldTypeSignature>(3);
        if (this.current() == ':') {
            this.advance();
            switch (this.current()) {
                case ':': {
                    break;
                }
                default: {
                    arrayList.add(this.parseFieldTypeSignature());
                }
            }
            while (this.current() == ':') {
                this.advance();
                arrayList.add(this.parseFieldTypeSignature());
            }
        }
        FieldTypeSignature[] fieldTypeSignatureArray = new FieldTypeSignature[arrayList.size()];
        return arrayList.toArray(fieldTypeSignatureArray);
    }

    private ClassTypeSignature[] parseSuperInterfaces() {
        ArrayList<ClassTypeSignature> arrayList = new ArrayList<ClassTypeSignature>(5);
        while (this.current() == 'L') {
            arrayList.add(this.parseClassTypeSignature());
        }
        ClassTypeSignature[] classTypeSignatureArray = new ClassTypeSignature[arrayList.size()];
        return arrayList.toArray(classTypeSignatureArray);
    }

    private MethodTypeSignature parseMethodTypeSignature() {
        assert (this.index == 0);
        return MethodTypeSignature.make(this.parseZeroOrMoreFormalTypeParameters(), this.parseFormalParameters(), this.parseReturnType(), this.parseZeroOrMoreThrowsSignatures());
    }

    private TypeSignature[] parseFormalParameters() {
        if (this.current() != '(') {
            throw this.error("expected (");
        }
        this.advance();
        TypeSignature[] typeSignatureArray = this.parseZeroOrMoreTypeSignatures();
        if (this.current() != ')') {
            throw this.error("expected )");
        }
        this.advance();
        return typeSignatureArray;
    }

    private TypeSignature[] parseZeroOrMoreTypeSignatures() {
        ArrayList<TypeSignature> arrayList = new ArrayList<TypeSignature>();
        boolean bl = false;
        block3: while (!bl) {
            switch (this.current()) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'T': 
                case 'Z': 
                case '[': {
                    arrayList.add(this.parseTypeSignature());
                    continue block3;
                }
            }
            bl = true;
        }
        TypeSignature[] typeSignatureArray = new TypeSignature[arrayList.size()];
        return arrayList.toArray(typeSignatureArray);
    }

    private ReturnType parseReturnType() {
        if (this.current() == 'V') {
            this.advance();
            return VoidDescriptor.make();
        }
        return this.parseTypeSignature();
    }

    private FieldTypeSignature[] parseZeroOrMoreThrowsSignatures() {
        ArrayList<FieldTypeSignature> arrayList = new ArrayList<FieldTypeSignature>(3);
        while (this.current() == '^') {
            arrayList.add(this.parseThrowsSignature());
        }
        FieldTypeSignature[] fieldTypeSignatureArray = new FieldTypeSignature[arrayList.size()];
        return arrayList.toArray(fieldTypeSignatureArray);
    }

    private FieldTypeSignature parseThrowsSignature() {
        assert (this.current() == '^');
        if (this.current() != '^') {
            throw this.error("expected throws signature");
        }
        this.advance();
        return this.parseFieldTypeSignature();
    }
}

