/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;

public class BeanValueProperty
extends SimpleValueProperty {
    private final PropertyDescriptor propertyDescriptor;
    private final Class valueType;

    public BeanValueProperty(PropertyDescriptor propertyDescriptor, Class valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.valueType = valueType == null ? propertyDescriptor.getPropertyType() : valueType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected Object doGetValue(Object source) {
        return BeanPropertyHelper.readProperty(source, this.propertyDescriptor);
    }

    protected void doSetValue(Object source, Object value) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, value);
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new BeanPropertyListener((IProperty)this, this.propertyDescriptor, listener){

            protected IDiff computeDiff(Object oldValue, Object newValue) {
                return Diffs.createValueDiff((Object)oldValue, (Object)newValue);
            }
        };
    }

    public String toString() {
        String s = BeanPropertyHelper.propertyName(this.propertyDescriptor);
        if (this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

