/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.risorse;

import finanze.IDTE.studi2002.posizione.SezioneTabella;
import finanze.IDTE.studi2002.posizione.SezioneTabellaPannelli;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class InterpreteTabellaSet {
    private String nomeFile = null;
    private SezioneTabella[] sezioni = null;
    private SezioneTabellaPannelli sezionePannelli = null;

    public InterpreteTabellaSet(String nomeFile) {
        this.nomeFile = nomeFile;
        this.leggi();
    }

    public SezioneTabellaPannelli getSezioneTabellaPannelli() {
        return this.sezionePannelli;
    }

    public SezioneTabella[] getSezioni() {
        return this.sezioni;
    }

    public SezioneTabella[] getSezioniPerTipo(String tipo) {
        Vector<SezioneTabella> sezioniTipo = new Vector<SezioneTabella>();
        int i = 0;
        while (i < this.sezioni.length) {
            if (this.sezioni[i].getRecord().equalsIgnoreCase(tipo)) {
                sezioniTipo.addElement(this.sezioni[i]);
            }
            ++i;
        }
        Object[] sezioniPerTipo = new SezioneTabella[sezioniTipo.size()];
        sezioniTipo.copyInto(sezioniPerTipo);
        return sezioniPerTipo;
    }

    private void interpreta(String[] righe) {
        int start = -1;
        int end = -1;
        Vector<SezioneTabella> temp = new Vector<SezioneTabella>();
        int i = 0;
        while (i < righe.length) {
            String riga = righe[i].trim();
            if (riga.equalsIgnoreCase("[pannelli]")) {
                if (this.sezionePannelli != null) break;
                this.sezionePannelli = new SezioneTabellaPannelli(righe, i, righe.length);
            }
            if (this.isSezione(riga) || i == righe.length - 1) {
                if (start == -1) {
                    start = i;
                } else {
                    end = i == righe.length - 1 ? i + 1 : i;
                }
            }
            if (start > -1 && end > -1) {
                temp.addElement(new SezioneTabella(righe, start, end));
                start = -1;
                end = -1;
                --i;
            }
            ++i;
        }
        this.sezioni = new SezioneTabella[temp.size()];
        temp.copyInto(this.sezioni);
    }

    private boolean isSezione(String riga) {
        return riga.startsWith("[") && riga.endsWith("]");
    }

    private void leggi() {
        Vector<String> v = new Vector<String>();
        try {
            BufferedReader raf = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.nomeFile)));
            String riga = raf.readLine();
            if (riga != null && !this.isSezione(riga)) {
                v.addElement("[S*Testa]");
            }
            while (riga != null) {
                v.addElement(riga);
                riga = raf.readLine();
            }
            raf.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Object[] righeTabella = new String[v.size()];
        v.copyInto(righeTabella);
        this.interpreta((String[])righeTabella);
    }
}

