/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.zip.handlers;

import it.sogei.rcp.filesystemutil.FileSystemUtil;
import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.util.RelativePath;
import it.sogei.rcp.zip.exceptions.ZipException;
import it.sogei.rcp.zip.interfaces.IZipUtil;
import it.sogei.rcp.zip.priv.entities.ZippedFileTO;
import it.sogei.utilities.log4j.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zip
implements IZipUtil {
    FileSystemUtil fsu = new FileSystemUtil();
    static final int BUFFER = 2048;
    private static final String tmpRelativeDir = "_tmpExtract";

    @Override
    public void compress(IRelativePath relativeZipFilePath, IRelativePath relativeInputFilePath) throws IOException, ZipException {
        try {
            int count;
            String zipPath = relativeZipFilePath.getAbsoluteFolderPath();
            String zipFilename = relativeZipFilePath.getFileName();
            String inputFilename = relativeInputFilePath.getFileName();
            String inputFilePath = relativeInputFilePath.getAbsoluteFolderPath();
            FileInputStream fis = this.getFileInputStream(inputFilePath, inputFilename);
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(String.valueOf(zipPath) + zipFilename);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            origin = new BufferedInputStream(fis, 2048);
            ZipEntry entry = new ZipEntry(inputFilename);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            out.close();
            fis.close();
            fis = null;
        }
        catch (Exception exception) {
            throw new ZipException("Errore durante la compressione del file");
        }
    }

    @Override
    public void compressMultiFiles(IRelativePath relativeZipFilePath, ArrayList<IRelativePath> relativeInputFilePaths) throws IOException, ZipException {
        try {
            String zipPath = relativeZipFilePath.getAbsoluteFolderPath();
            String zipFilename = relativeZipFilePath.getFileName();
            ArrayList<ZippedFileTO> listaFileDaZippare = new ArrayList<ZippedFileTO>();
            for (IRelativePath filePath : relativeInputFilePaths) {
                String filename = filePath.getFileName();
                FileInputStream fis = this.getFileInputStream(filePath.getAbsoluteFolderPath(), filename);
                listaFileDaZippare.add(new ZippedFileTO(filename, fis));
            }
            Iterator iterZippedFiles = listaFileDaZippare.iterator();
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(String.valueOf(zipPath) + zipFilename);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            while (iterZippedFiles.hasNext()) {
                int count;
                ZippedFileTO zippedFile = (ZippedFileTO)iterZippedFiles.next();
                origin = new BufferedInputStream(zippedFile.fis, 2048);
                ZipEntry entry = new ZipEntry(zippedFile.fileName);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                LogUtil.log((String)"Zip", (int)2, (String)("aggiunto file " + zippedFile.fileName + " a " + zipPath + zipFilename));
            }
            out.close();
        }
        catch (Exception exception) {
            throw new ZipException("Errore durante la compressione dei files");
        }
    }

    @Override
    public void uncompress(IRelativePath relativeZipFilePath, IRelativePath relativeOutputPath) throws IOException, ZipException {
        BufferedOutputStream dest = null;
        try {
            ZipEntry entry;
            FileInputStream fis = this.getFileInputStream(relativeZipFilePath.getAbsoluteFolderPath(), relativeZipFilePath.getFileName());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(String.valueOf(relativeOutputPath.getAbsoluteFolderPath()) + entry.getName());
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception exception) {
            throw new ZipException("Errore durante la decompressione del file");
        }
    }

    @Override
    public void unZipArchivio(IAbsolutePath absoluteZipFilePath, IAbsolutePath absoluteOutputPath) throws IOException, ZipException {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipInputStream zis = null;
        File folder = null;
        try {
            try {
                ZipEntry entry;
                folder = new File(absoluteOutputPath.getAbsolutePath());
                if (!folder.exists()) {
                    folder.mkdir();
                }
                zis = new ZipInputStream(new FileInputStream(absoluteZipFilePath.getAbsolutePath()));
                while ((entry = zis.getNextEntry()) != null) {
                    String fileName = entry.getName();
                    File newFile = new File(String.valueOf(absoluteOutputPath.getAbsolutePath()) + "/" + fileName);
                    if (entry.isDirectory()) {
                        newFile.mkdirs();
                        continue;
                    }
                    newFile.getParentFile().mkdirs();
                    newFile.createNewFile();
                    try {
                        try {
                            int len;
                            fos = new FileOutputStream(newFile);
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                            fos.flush();
                            fos.close();
                            newFile.setExecutable(true, true);
                            newFile.setReadable(true);
                            newFile.setWritable(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new ZipException("Errore durante la decompressione del file");
                        }
                    }
                    catch (Throwable throwable) {
                        if (fos != null) {
                            try {
                                fos.flush();
                                fos.close();
                            }
                            catch (IOException iOException) {
                                throw new ZipException("Errore durante la decompressione del file");
                            }
                        }
                        throw throwable;
                    }
                    if (fos == null) continue;
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (IOException iOException) {
                        throw new ZipException("Errore durante la decompressione del file");
                    }
                }
                zis.closeEntry();
                zis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZipException("Errore durante la decompressione del file");
            }
        }
        catch (Throwable throwable) {
            if (zis != null) {
                try {
                    zis.closeEntry();
                    zis.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zis != null) {
            try {
                zis.closeEntry();
                zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void add(IRelativePath relativeZipFilePath, IRelativePath relativeInputFilePath) throws IOException, ZipException {
        try {
            RelativePath relativeExtractFolderPath = new RelativePath(tmpRelativeDir);
            this.fsu.createFolder((IRelativePath)relativeExtractFolderPath);
            ArrayList<String> filenameList = this.getEntriesNames(relativeZipFilePath);
            RelativePath relativeOutputFilePath = new RelativePath(String.valueOf(relativeExtractFolderPath.getFolderPath()) + relativeInputFilePath.getFileName());
            this.uncompress(relativeZipFilePath, (IRelativePath)relativeExtractFolderPath);
            this.fsu.deleteFile(relativeZipFilePath);
            this.fsu.copyFile(relativeInputFilePath, (IRelativePath)relativeOutputFilePath);
            filenameList.add(relativeInputFilePath.getFileName());
            ArrayList<IRelativePath> fileList = new ArrayList<IRelativePath>();
            int i = 0;
            while (i < filenameList.size()) {
                fileList.add((IRelativePath)new RelativePath(String.valueOf(relativeExtractFolderPath.getFolderPath()) + filenameList.get(i)));
                ++i;
            }
            this.compressMultiFiles(relativeZipFilePath, fileList);
            this.fsu.deleteFolder((IRelativePath)relativeExtractFolderPath, true);
        }
        catch (Exception e) {
            throw new ZipException("errore durante l'aggiunta del file ", e);
        }
    }

    @Override
    public int getEntriesNumber(IRelativePath relativeZipFilePath) throws IOException, ZipException {
        int n = 0;
        String zipName = relativeZipFilePath.getFileName();
        String zipPath = relativeZipFilePath.getAbsoluteFolderPath();
        try {
            ZipEntry entry;
            FileInputStream fis = this.getFileInputStream(zipPath, zipName);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ++n;
            }
            zis.close();
            return n;
        }
        catch (Exception exception) {
            throw new ZipException("Errore durante l'elaborazione del file compresso");
        }
    }

    @Override
    public ArrayList<String> getEntriesNames(IRelativePath relativeZipFilePath) throws IOException, ZipException {
        ArrayList<String> filenamesList = new ArrayList<String>();
        String zipName = relativeZipFilePath.getFileName();
        String zipPath = relativeZipFilePath.getAbsoluteFolderPath();
        try {
            ZipEntry entry;
            FileInputStream fis = this.getFileInputStream(zipPath, zipName);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                filenamesList.add(entry.getName());
            }
            zis.close();
            if (filenamesList.size() == 0) {
                filenamesList = null;
            }
            return filenamesList;
        }
        catch (Exception exception) {
            filenamesList = null;
            throw new ZipException("Errore durante l'elaborazione del file compresso");
        }
    }

    private FileInputStream getFileInputStream(String filePath, String fileName) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(new File(String.valueOf(filePath) + fileName));
        return fis;
    }
}

