/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IInPlaceEditor;
import org.eclipse.ui.IInPlaceEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FileInPlaceEditorInput
extends FileEditorInput
implements IInPlaceEditorInput {
    IInPlaceEditor embeddedEditor;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta affectedElement;
            IResourceDelta mainDelta = event.getDelta();
            if (mainDelta != null && FileInPlaceEditorInput.this.embeddedEditor != null && (affectedElement = mainDelta.findMember(FileInPlaceEditorInput.this.getFile().getFullPath())) != null) {
                this.processDelta(affectedElement);
            }
        }

        private boolean processDelta(IResourceDelta delta) {
            Runnable changeRunnable = null;
            switch (delta.getKind()) {
                case 2: {
                    changeRunnable = (0x2000 & delta.getFlags()) != 0 ? new Runnable(this, delta){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IResourceDelta val$delta;
                        {
                            this.this$1 = var1_1;
                            this.val$delta = iResourceDelta;
                        }

                        public void run() {
                            IPath path = this.val$delta.getMovedToPath();
                            IFile newFile = this.val$delta.getResource().getWorkspace().getRoot().getFile(path);
                            if (newFile != null && 1.access$0(this.this$1).embeddedEditor != null) {
                                1.access$0(this.this$1).embeddedEditor.sourceChanged((IInPlaceEditorInput)new FileInPlaceEditorInput(newFile));
                            }
                        }
                    } : new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (1.access$0(this.this$1).embeddedEditor != null) {
                                1.access$0(this.this$1).embeddedEditor.sourceDeleted();
                                1.access$0(this.this$1).embeddedEditor.getSite().getPage().closeEditor((IEditorPart)1.access$0(this.this$1).embeddedEditor, true);
                            }
                        }
                    };
                }
            }
            if (changeRunnable != null && FileInPlaceEditorInput.this.embeddedEditor != null) {
                FileInPlaceEditorInput.this.embeddedEditor.getSite().getShell().getDisplay().asyncExec(changeRunnable);
            }
            return true;
        }

        static /* synthetic */ FileInPlaceEditorInput access$0(1 var0) {
            return var0.FileInPlaceEditorInput.this;
        }
    };

    public FileInPlaceEditorInput(IFile file) {
        super(file);
    }

    public void setInPlaceEditor(IInPlaceEditor editor) {
        if (this.embeddedEditor != editor) {
            if (this.embeddedEditor != null) {
                this.getFile().getWorkspace().removeResourceChangeListener(this.resourceListener);
            }
            this.embeddedEditor = editor;
            if (this.embeddedEditor != null) {
                this.getFile().getWorkspace().addResourceChangeListener(this.resourceListener);
            }
        }
    }
}

