/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.campi.AlfaNumericModel;
import finanze.IDTE.studi2002.campi.CodAttModel;
import finanze.IDTE.studi2002.campi.CodFiscModel;
import finanze.IDTE.studi2002.campi.CodiceCatastaleModel;
import finanze.IDTE.studi2002.campi.ComboBoxCustomModel;
import finanze.IDTE.studi2002.campi.ComboBoxModel;
import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.DefaultNumericModel;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.NatGiurModel;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.campi.NumericModel;
import finanze.IDTE.studi2002.campi.ProgressivoStudioModel;
import finanze.IDTE.studi2002.campi.ProvinciaModel;
import finanze.IDTE.studi2002.campi.RangeNumericModel;
import finanze.IDTE.studi2002.campi.SettMercModel;
import finanze.IDTE.studi2002.campi.ToggleButtonModel;
import finanze.IDTE.studi2002.campi.ValutaNumericModel;
import finanze.IDTE.studi2002.controlli.GericoControllo;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import finanze.IDTE.studi2002.main.Anomalia;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveStudio;
import finanze.IDTE.studi2002.posizione.GestioneQuadroMultiploModel;
import finanze.IDTE.studi2002.risorse.ModelloSet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Posizione
implements GestioneQuadroMultiploModel {
    private String tipoRecord;
    private ChiaveStudio chiave;
    private boolean batchComune;
    private String codiceStudio;
    private int tipoReddito;
    private Vector controlli;
    private Vector controlliComuneProvincia;
    private Vector campiErrati;
    private Vector specificheControlliQM;
    private Vector controlliQM;
    private Vector vecTesta;
    private Vector chiaviCampiPosizionali;
    private Vector chiaviCampiNonPosizionali;
    private Vector quadroMultiplo;
    private Vector vecMsgErrori;
    private Vector vecMsgWarning;
    private Vector warning;
    private Hashtable campi;
    private boolean flagCalcolabile;
    private boolean flagCoerente;
    private boolean flagRichiestaMarginali;
    private boolean flagRichMargBD = false;
    private String ricavoDichiarato;
    private int inizioAreaCalcolo;
    private final String CODE_PROB1 = "Prob1";
    private Hashtable campiOld;
    private int numeroMaxQuadri;
    private String codiceNumeroQM;
    private Hashtable codiciErratiQM = null;
    private Vector messaggioErrore;
    private Vector messaggioErroreQM = null;
    private final int CODA_RECORD = 15;
    private final String RETURN = "\n";
    private final int LUNGHEZZA_TESTA = 100;
    private final int MODEL_CODE = 0;
    private final int MODEL_ERRORDESCRIPTION = 1;
    private final int MODEL_LENGTH = 2;
    public static final String CODE_STUDIO = "CodiceStudio";
    public static final String CODE_FISCALE = "CodiceFiscale";
    public static final String CODE_ATTIVITA = "CodiceAttivita";
    public static final String CODE_PROGRESSIVO = "Progressivo";
    public static final String CODE_MODELLO_DICHIARAZIONE = "ModelloDichiarazione";
    public static final String CODE_ANNO = "Anno";
    public static final String CODE_EURO = "Euro";
    public static final String CODE_OMOCODICE = "Omocodice";
    public static final String CODE_COGNOME = "Cognome";
    public static final String CODE_NOME = "Nome";
    public static final String CODE_DENOMINAZIONE = "Denominazione";
    public static final String CODE_DESCRIZIONE = "DescrCodAtt";
    public static final String CODE_TIPO_REDDITO = "TipRedd";
    public static final String CODE_CALCOLABILE = "FlagCalcolabilita";
    public static final String CODE_ANOMALIE = "FlagAnomalie";
    public static final String CODE_RICAVO_STIMATO = "RicavoStimato";
    public static final String CODE_RICAVO_MINIMO = "RicavoMinimo";
    public static final String CODE_ALIQUOTA_MEDIA = "AliquotaMedia";
    public static final String CODE_IVA_DOVUTA_STIMATO = "IvaDovutaStimato";
    public static final String CODE_IVA_DOVUTA_MINIMO = "IvaDovutaMinimo";
    public static final String CODE_NON_CONGRUITA = "Congruo";
    public static final String CODE_RICHIESTA_MARGINALI = "FlagRichiestaMarginalita";
    public static final String CODE_MARGINALITA = "FlagMarginali";
    public static final String CODE_RIDUZIONE_TERR = "FlagRiduzioneTerritoriale";
    public static final String CODE_RIDUZIONE_SOGG = "FlagRiduzioneSoggettiva";
    private final String E_MODELLO_TIPO_REDD = "Il modello dichiarazione non e' coerente con il tipo reddito";
    private final String E_MOD_DICH_COD_STU = "Il modello dichiarazione non e' congruente con lo studio";
    private String nomeFile;
    public static final String RECORD_S = "S";
    public static final String RECORD_U = "U";
    public static final int LUNGHEZZA_TESTA_PARAMETRI = 657;
    private int impresa;
    private int autonomo;
    private static final String ANOMALIA = "anomalia";
    private static final String SCARTO = "scarto";
    private static final String ERR_INCONGRUENZA_QM = "ErroreMultiQuadro";
    private String progN = "";

    public Posizione(ChiaveStudio chiaveStudio, String tipoRecord) {
        this.chiave = chiaveStudio;
        this.codiceStudio = this.chiave.getCodiceStudio();
        this.tipoReddito = this.chiave.getTipoReddito();
        this.tipoRecord = tipoRecord;
        this.initialize();
    }

    private void aggiornaSpecificheControlliQM() {
        new Vector();
        Vector descrizioniQM = new Vector();
        descrizioniQM = this.getQuadroMultiplo(0, 4);
        int inc = MetodiUtili.verificaIncremento(descrizioniQM)[0];
        int decr = MetodiUtili.verificaIncremento(descrizioniQM)[1];
        Vector specPrimoQM = (Vector)this.specificheControlliQM.firstElement();
        int i = 1;
        while (i <= this.getNumeroMaxQuadri() - 1) {
            Vector<String> specificheCtrlQ = new Vector<String>();
            int incremento = i * (this.getNumeroCampiMultiplo() + inc - decr);
            int k = 0;
            while (k < specPrimoQM.size()) {
                StringBuffer appo = new StringBuffer();
                StringTokenizer strTok = new StringTokenizer((String)specPrimoQM.elementAt(k), "%");
                String primaParte = strTok.nextToken();
                StringTokenizer strTok2 = new StringTokenizer(primaParte, "*");
                String tipoControllo = strTok2.nextToken();
                appo.append(tipoControllo);
                if (tipoControllo.equalsIgnoreCase("CE") || tipoControllo.equalsIgnoreCase("CEB") || tipoControllo.equalsIgnoreCase("CP")) {
                    appo.append(this.creaSpecificaCE(strTok2, incremento));
                }
                if (tipoControllo.equalsIgnoreCase("CR")) {
                    appo.append(this.creaSpecificaCR(strTok2, incremento));
                }
                if (tipoControllo.equalsIgnoreCase("CT")) {
                    appo.append(this.creaSpecificaCT(primaParte, incremento));
                }
                if (tipoControllo.equalsIgnoreCase("C2")) {
                    appo.append(this.creaSpecificaC2(primaParte, incremento));
                }
                appo.append("%");
                StringTokenizer strTok3 = new StringTokenizer(strTok.nextToken(), "&");
                appo.append(strTok3.nextToken());
                Vector<String[]> descrizioni = new Vector<String[]>();
                boolean chek = false;
                while (strTok3.hasMoreTokens()) {
                    String[] campiMsg;
                    StringTokenizer strTok4 = new StringTokenizer(strTok3.nextToken(), "*");
                    int numTok = strTok4.countTokens();
                    String str = "";
                    if (numTok == 1 && tipoControllo.equalsIgnoreCase("CT") && !chek) {
                        str = strTok4.nextToken();
                    }
                    if (numTok == 1 && str.indexOf("+") != -1 && str.indexOf("*") == -1 && !chek) {
                        StringTokenizer tok = new StringTokenizer(str, "+");
                        String cod_descr = tok.nextToken();
                        appo.append("&").append(this.creaCodCampoMsg(cod_descr, incremento)).append("+");
                        while (tok.hasMoreTokens()) {
                            String cod_desc = tok.nextToken();
                            appo.append(this.creaCodCampoMsg(cod_desc, incremento));
                        }
                        chek = true;
                        continue;
                    }
                    if (tipoControllo.equalsIgnoreCase("CT") && !chek) {
                        campiMsg = new String[numTok];
                        campiMsg[0] = str;
                        descrizioni.addElement(campiMsg);
                        continue;
                    }
                    campiMsg = new String[numTok];
                    int j = 0;
                    int size = campiMsg.length;
                    while (j < size) {
                        campiMsg[j] = strTok4.nextToken();
                        ++j;
                    }
                    descrizioni.addElement(campiMsg);
                }
                if (!descrizioni.isEmpty()) {
                    int y = 0;
                    while (y < descrizioni.size()) {
                        appo.append("&");
                        String[] campi = (String[])descrizioni.elementAt(y);
                        int z = 0;
                        while (z < campi.length) {
                            String descAggiornata = this.creaCodCampoMsg(campi[z], incremento);
                            appo.append(descAggiornata);
                            if (campi.length > 1 && z < campi.length - 1) {
                                appo.append("*");
                            }
                            ++z;
                        }
                        ++y;
                    }
                } else {
                    appo.append("&");
                }
                specificheCtrlQ.addElement(appo.toString());
                ++k;
            }
            this.specificheControlliQM.addElement(specificheCtrlQ);
            ++i;
        }
    }

    private boolean coerenzaModDichCodiceStudio() {
        boolean coerente = true;
        boolean nonCoerrente = false;
        String codStudio = this.chiave.getCodiceStudio();
        if (codStudio.equalsIgnoreCase("SG56U") || codStudio.equalsIgnoreCase("SG73B") || codStudio.equalsIgnoreCase("SG74U") || codStudio.equalsIgnoreCase("SK08U") || codStudio.equalsIgnoreCase("SK16U") || codStudio.equalsIgnoreCase("SK19U") || codStudio.equalsIgnoreCase("SK21U")) {
            return coerente;
        }
        int modello = Integer.parseInt(this.getCampo(CODE_MODELLO_DICHIARAZIONE).getValue());
        switch (modello) {
            case 1: 
            case 4: 
            case 8: {
                if (codStudio.equalsIgnoreCase("sk01u") || codStudio.equalsIgnoreCase("sk02u") || codStudio.equalsIgnoreCase("sk03u") || codStudio.equalsIgnoreCase("sk04u") || codStudio.equalsIgnoreCase("sk05u") || codStudio.equalsIgnoreCase("sk06u") || codStudio.equalsIgnoreCase("sk10u") || codStudio.equalsIgnoreCase("sk17u") || codStudio.equalsIgnoreCase("sk18u") || codStudio.equalsIgnoreCase("sk20u") || codStudio.equalsIgnoreCase("sk22u")) {
                    return coerente;
                }
                return nonCoerrente;
            }
        }
        if (codStudio.equalsIgnoreCase("sk01u") || codStudio.equalsIgnoreCase("sk02u") || codStudio.equalsIgnoreCase("sk03u") || codStudio.equalsIgnoreCase("sk04u") || codStudio.equalsIgnoreCase("sk05u") || codStudio.equalsIgnoreCase("sk06u") || codStudio.equalsIgnoreCase("sk10u") || codStudio.equalsIgnoreCase("sk17u") || codStudio.equalsIgnoreCase("sk18u") || codStudio.equalsIgnoreCase("sk20u") || codStudio.equalsIgnoreCase("sk22u")) {
            return nonCoerrente;
        }
        return coerente;
    }

    private boolean coerenzaModDichTipoReddito() {
        if (this.chiave.getCodiceStudio().equals("SG56U") || this.chiave.getCodiceStudio().equals("SG73B") || this.chiave.getCodiceStudio().equals("SG74U") || this.chiave.getCodiceStudio().equals("SK08U") || this.chiave.getCodiceStudio().equals("SK16U") || this.chiave.getCodiceStudio().equals("SK19U") || this.chiave.getCodiceStudio().equals("SK21U")) {
            int modello = Integer.parseInt(this.getCampo(CODE_MODELLO_DICHIARAZIONE).getValue());
            int tipoRedd = Integer.parseInt(this.getCampo(CODE_TIPO_REDDITO).getValue());
            switch (modello) {
                case 1: 
                case 4: 
                case 8: {
                    return tipoRedd == 2;
                }
            }
            return tipoRedd == 1;
        }
        return true;
    }

    private void completaChiave() {
        this.chiave = new ChiaveStudio(this.getCampo(CODE_FISCALE).getValue(), Integer.parseInt(this.getCampo(CODE_ANNO).getValue()), this.getCampo(CODE_ATTIVITA).getValue(), this.getCampo(CODE_PROGRESSIVO).getValue(), this.codiceStudio);
        String modDic = this.getCampo(CODE_MODELLO_DICHIARAZIONE).getValue();
        boolean eu = false;
        boolean omo = false;
        if (this.getCampo(CODE_EURO).getValue().equalsIgnoreCase("1")) {
            eu = true;
        }
        if (this.getCampo(CODE_OMOCODICE).getValue().equalsIgnoreCase("1")) {
            omo = true;
        }
        this.chiave.setEuro(eu);
        this.chiave.setModelloDic(modDic);
        this.chiave.setOmocodice(omo);
        this.chiave.setTipoReddito(this.tipoReddito);
    }

    private boolean[] controllaValiditaCodice(String codice) {
        int i = 0;
        while (i < this.numeroMaxQuadri) {
            Vector vecCodici = this.getQuadroMultiplo(i, 2);
            int j = 0;
            while (j < vecCodici.size()) {
                if (vecCodici.elementAt(j).equals(codice)) {
                    if (i < this.getNumeroQuadriMultipli()) {
                        return new boolean[]{true, true};
                    }
                    return new boolean[]{false, true};
                }
                ++j;
            }
            ++i;
        }
        return new boolean[]{false, false};
    }

    private void controlliCoerenza(Hashtable componentiErrati) {
        if (!componentiErrati.containsKey(CODE_MODELLO_DICHIARAZIONE)) {
            int modelloDichiarazione = (int)((NumericModel)this.getCampo(CODE_MODELLO_DICHIARAZIONE)).getNumericValue();
            if (!componentiErrati.containsKey(CODE_FISCALE)) {
                CodFiscModel cfm = (CodFiscModel)this.getCampo(CODE_FISCALE);
                try {
                    cfm.setModelloDichiarazione(modelloDichiarazione);
                }
                catch (NonCoerenzaException nonCoerenzaException) {
                    Anomalia anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, cfm);
                    this.messaggioErrore.addElement(anomalia);
                }
            }
            if (!componentiErrati.containsKey(CODE_TIPO_REDDITO) && !this.coerenzaModDichTipoReddito()) {
                Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "806");
                this.messaggioErrore.addElement(anomalia);
            }
        }
        if (!componentiErrati.containsKey(CODE_MODELLO_DICHIARAZIONE) && this.tipoRecord.equalsIgnoreCase(RECORD_S) && !this.coerenzaModDichCodiceStudio()) {
            Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "807");
            this.messaggioErrore.addElement(anomalia);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void costruisciCampo(String[] specificaCampo) {
        block19: {
            try {
                gm = null;
                type = specificaCampo[0];
                spec_line = specificaCampo[1];
                specif_lineVet = new Vector<String>();
                strTok = new StringTokenizer(spec_line, "#");
                spec_block1 = strTok.nextToken();
                spec_block2 = strTok.hasMoreTokens() != false ? strTok.nextToken() : null;
                strTok = new StringTokenizer(spec_block1, "*");
                while (strTok.hasMoreTokens()) {
                    specif_lineVet.addElement(strTok.nextToken());
                }
                gm = this.creaBeanModel(type, specif_lineVet);
                if (spec_block2 != null) {
                    if (spec_block2.equalsIgnoreCase("O")) {
                        gm.setOnlyWrite(true);
                    } else {
                        MetodiUtili.logEccezioni(new Exception("Errore in tabella: blocco 2 della riga " + spec_line));
                    }
                }
                this.campi.put(gm.getCode(), gm);
                if (specificaCampo.length == 2) {
                    this.vecTesta.addElement(gm.getCode());
                } else if (specificaCampo.length == 3) {
                    if (specificaCampo[2].equalsIgnoreCase("S")) {
                        this.chiaviCampiPosizionali.addElement(gm.getCode());
                    }
                    if (specificaCampo[2].equalsIgnoreCase("Q")) {
                        this.chiaviCampiPosizionali.addElement(gm.getCode());
                    } else if (specificaCampo[2].equalsIgnoreCase("T")) {
                        this.chiaviCampiNonPosizionali.addElement(gm.getCode());
                    } else if (!specificaCampo[2].equalsIgnoreCase("M")) {
                        if (specificaCampo[2].equalsIgnoreCase("NQ")) {
                            this.codiceNumeroQM = gm.getCode();
                            this.chiaviCampiNonPosizionali.addElement(this.codiceNumeroQM);
                            this.numeroMaxQuadri = Integer.parseInt(this.estraiNumMaxQuadri(spec_line));
                        } else if (specificaCampo[2].equalsIgnoreCase("F")) {
                            this.chiaviCampiNonPosizionali.addElement(gm.getCode());
                        }
                    }
                }
                break block19;
            }
            catch (Exception ex) {
                System.out.print("Riga errata: ");
                i = 0;
                ** while (i < specificaCampo.length)
            }
lbl-1000:
            // 1 sources

            {
                System.out.print(String.valueOf(specificaCampo[i]) + "*");
                ++i;
                continue;
            }
lbl49:
            // 1 sources

            System.out.println(" ");
            MetodiUtili.logEccezioni(ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void costruisciControllo(String[] specificaControllo) {
        block12: {
            try {
                specificaContr = new String[2];
                spec_line = specificaControllo[0];
                nomeQuadroControllo = specificaControllo[1];
                specificaControllo[2];
                gc = null;
                specificaContr[0] = spec_line;
                specificaContr[1] = nomeQuadroControllo;
                try {
                    gc = GericoControllo.getIstanza(specificaContr, this.campi);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (gc == null) {
                    throw new Exception();
                }
                if (specificaControllo[2].equalsIgnoreCase("M") && this.controlliQM.isEmpty()) {
                    primoMultiplo = new Vector<E>();
                    this.controlliQM.addElement(primoMultiplo);
                    gc.setNomeQuadro(String.valueOf(nomeQuadroControllo) + " " + 1);
                    ((Vector)this.controlliQM.firstElement()).addElement(gc);
                    this.controlli.addElement(nomeQuadroControllo);
                    this.specificheControlliQM.addElement(new Vector<E>());
                    ((Vector)this.specificheControlliQM.firstElement()).addElement(spec_line);
                } else if (specificaControllo[2].equalsIgnoreCase("M")) {
                    gc.setNomeQuadro(String.valueOf(nomeQuadroControllo) + " " + 1);
                    ((Vector)this.controlliQM.firstElement()).addElement(gc);
                    ((Vector)this.specificheControlliQM.firstElement()).addElement(spec_line);
                } else {
                    try {
                        this.controlli.addElement(gc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block12;
            }
            catch (Exception ex) {
                System.out.print("Riga errata: ");
                i = 0;
                ** while (i < specificaControllo.length)
            }
lbl-1000:
            // 1 sources

            {
                System.out.print(String.valueOf(specificaControllo[i]) + " ");
                ++i;
                continue;
            }
lbl44:
            // 1 sources

            System.out.println(" ");
            MetodiUtili.logEccezioni(ex);
        }
    }

    public void costruisciControlloQM(int indiceQuadro) {
        block6: {
            try {
                Vector specificheSingoloQ = new Vector();
                GericoControllo gc = null;
                Vector<GericoControllo> appoggio = new Vector<GericoControllo>();
                if (this.controlliQM.isEmpty()) break block6;
                String nomePrimoQuadro = ((GericoControllo)((Vector)this.controlliQM.firstElement()).firstElement()).getNomeQuadro();
                String nomeQuadro = nomePrimoQuadro.substring(0, nomePrimoQuadro.length() - 2);
                specificheSingoloQ = (Vector)this.specificheControlliQM.elementAt(indiceQuadro);
                int i = 0;
                while (i < specificheSingoloQ.size()) {
                    String[] specificaContr = new String[]{(String)specificheSingoloQ.elementAt(i), String.valueOf(nomeQuadro) + " " + (indiceQuadro + 1)};
                    try {
                        gc = GericoControllo.getIstanza(specificaContr, this.campi);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (gc == null) {
                        throw new Exception();
                    }
                    appoggio.addElement(gc);
                    ++i;
                }
                this.controlliQM.addElement(appoggio);
            }
            catch (Exception ex) {
                System.out.println("GericoControllo su QM non e' stato istanziato ");
                MetodiUtili.logEccezioni(ex);
            }
        }
    }

    private GericoModel creaAlfaNumericModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new AlfaNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    private GericoModel creaBeanModel(String type, Vector specif_lineVet) {
        GericoModel gm = null;
        if (type.equalsIgnoreCase("DNM")) {
            gm = this.creaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("RNM")) {
            gm = this.creaRangeModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("PSM")) {
            gm = this.creaProgressivoModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("VNM")) {
            gm = this.creaValutaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("UCLM")) {
            gm = this.creaAlfaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("AM")) {
            gm = this.creaAlfaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CBM")) {
            gm = this.creaComboModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CBCM")) {
            gm = this.creaComboCustomModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("PBM")) {
            gm = this.creaProvinciaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("TBM")) {
            gm = this.creaToggleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CCM")) {
            gm = this.creaCodiceCatastaleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("SCM")) {
            gm = this.creaAlfaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("SMM")) {
            gm = this.creaSettMercModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CFM")) {
            gm = this.creaCodiceFiscaleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CAFM")) {
            gm = this.creaCodiceFiscaleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CAM")) {
            gm = this.creaCodiceAttivitaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CASM")) {
            gm = this.creaCodiceAttivitaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("NGM")) {
            gm = this.creaNaturaGiuridicaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("DEM")) {
            gm = this.creaNumericModel(specif_lineVet);
        }
        return gm;
    }

    private String creaCodCampoMsg(String string, int incremento) {
        int num1 = Integer.parseInt(string.substring(1, string.length()));
        String codice = String.valueOf(string.substring(0, 1)) + (num1 += incremento);
        return codice;
    }

    private GericoModel creaCodiceAttivitaModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        return new CodAttModel(codiceCampo, descrErrore, RECORD_S);
    }

    private GericoModel creaCodiceCatastaleModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        String fileTerritorialita = (String)v.elementAt(2);
        return new CodiceCatastaleModel(codiceCampo, descrErrore, fileTerritorialita, this.batchComune);
    }

    private GericoModel creaCodiceFiscaleModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        String flagobb = (String)v.elementAt(2);
        if (flagobb.equals("0")) {
            return new CodFiscModel(codiceCampo, descrErrore, false);
        }
        if (flagobb.equals("1")) {
            return new CodFiscModel(codiceCampo, descrErrore, true);
        }
        return null;
    }

    private GericoModel creaComboCustomModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        int numValori = (v.size() - 3) / 2;
        Vector listaElementi = new Vector();
        int j = 3;
        while (j < v.size() - numValori) {
            listaElementi.addElement(v.elementAt(j));
            ++j;
        }
        Vector listaValori = new Vector();
        int j2 = 3 + numValori;
        while (j2 < v.size()) {
            listaValori.addElement(v.elementAt(j2));
            ++j2;
        }
        return new ComboBoxCustomModel(codiceCampo, descrErrore, lunghezza, listaElementi, listaValori);
    }

    private GericoModel creaComboModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        Vector lista = new Vector();
        int j = 3;
        while (j < v.size()) {
            lista.addElement(v.elementAt(j));
            ++j;
        }
        return new ComboBoxModel(codiceCampo, descrErrore, lunghezza, lista);
    }

    private void creaModelQM(int numeroQuadri) {
        this.setNumeroQuadriMultipli(1);
        int i = 1;
        while (i < numeroQuadri) {
            this.getModelNuovoQuadroMultiplo();
            ++i;
        }
    }

    private GericoModel creaNaturaGiuridicaModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        return new NatGiurModel(codiceCampo, descrErrore);
    }

    private GericoModel creaNumericModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new DefaultNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    private GericoModel creaProgressivoModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        long valoreMinimo = Long.parseLong((String)v.elementAt(3));
        long valoreMassimo = Long.parseLong((String)v.elementAt(4));
        return new ProgressivoStudioModel(codiceCampo, descrErrore, lunghezza, valoreMinimo, valoreMassimo);
    }

    private GericoModel creaProvinciaModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new ProvinciaModel(codiceCampo, descrErrore, lunghezza);
    }

    private GericoModel creaRangeModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        long valoreMinimo = Long.parseLong((String)v.elementAt(3));
        long valoreMassimo = Long.parseLong((String)v.elementAt(4));
        return new RangeNumericModel(codiceCampo, descrErrore, lunghezza, valoreMinimo, valoreMassimo);
    }

    private GericoModel creaSettMercModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        return new SettMercModel(codiceCampo, descrErrore);
    }

    private String creaSpecificaC2(String primaParte, int incremento) {
        StringBuffer appo = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(primaParte, "^");
        while (strTok.hasMoreElements()) {
            String controllo = strTok.nextToken();
            StringTokenizer strTok2 = new StringTokenizer(controllo, "*");
            String tipoControllo = strTok2.nextToken();
            if (tipoControllo.equalsIgnoreCase("C2")) {
                appo.append(this.creaSpecificaCE(strTok2, incremento));
            }
            if (tipoControllo.equalsIgnoreCase("CE") || tipoControllo.equalsIgnoreCase("CEB") || tipoControllo.equalsIgnoreCase("CP")) {
                appo.append(tipoControllo).append(this.creaSpecificaCE(strTok2, incremento));
            }
            if (tipoControllo.equalsIgnoreCase("CR")) {
                appo.append(tipoControllo).append(this.creaSpecificaCR(strTok2, incremento));
            }
            if (tipoControllo.equalsIgnoreCase("CT")) {
                appo.append(tipoControllo).append(this.creaSpecificaCT(controllo, incremento));
            }
            if (tipoControllo.equalsIgnoreCase("CU")) {
                appo.append(controllo);
            }
            appo.append("^");
        }
        return appo.toString();
    }

    private String creaSpecificaCE(StringTokenizer strTok, int incremento) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici = new Vector<String>();
        while (strTok.hasMoreTokens()) {
            codici.addElement(strTok.nextToken());
        }
        int x = 0;
        while (x < codici.size()) {
            if (((String)codici.elementAt(x)).length() == 6) {
                String codAggiornato = MetodiUtili.creaCodice((String)codici.elementAt(x), incremento);
                appo.append("*").append(codAggiornato);
            } else if (((String)codici.elementAt(x)).length() > 6) {
                appo.append("*").append((String)codici.elementAt(x));
            } else {
                System.out.println("Valore non corrispondente a codice di bean: lunghezza minore di 6!");
            }
            ++x;
        }
        return appo.toString();
    }

    private String creaSpecificaCR(StringTokenizer strTok, int incremento) {
        StringBuffer appo = new StringBuffer();
        String codAggiornato = MetodiUtili.creaCodice(strTok.nextToken(), incremento);
        appo.append("*").append(codAggiornato);
        while (strTok.hasMoreTokens()) {
            appo.append("*").append(strTok.nextToken());
        }
        return appo.toString();
    }

    private String creaSpecificaCT(String primaParte, int incremento) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici1 = new Vector<String>();
        Vector<String> codici2 = new Vector<String>();
        StringTokenizer strTok = new StringTokenizer(primaParte, "_");
        StringTokenizer strTok2 = new StringTokenizer(strTok.nextToken(), "*");
        strTok2.nextToken();
        while (strTok2.hasMoreTokens()) {
            codici1.addElement(strTok2.nextToken());
        }
        int x = 0;
        while (x < codici1.size()) {
            if (((String)codici1.elementAt(x)).length() == 7) {
                String codAggiornato = MetodiUtili.creaCodice(((String)codici1.elementAt(x)).substring(1, 7), incremento);
                appo.append("*").append(((String)codici1.elementAt(x)).substring(0, 1)).append(codAggiornato);
            } else if (((String)codici1.elementAt(x)).length() < 7) {
                appo.append("*").append((String)codici1.elementAt(x));
            } else {
                System.out.println("Valore non corrispondente a un codice di bean: lunghezza diversa da 7 !");
            }
            ++x;
        }
        appo.append("_").append(strTok.nextToken()).append("_");
        StringTokenizer strTok3 = new StringTokenizer(strTok.nextToken(), "*");
        while (strTok3.hasMoreTokens()) {
            codici2.addElement(strTok3.nextToken());
        }
        int x2 = 0;
        while (x2 < codici2.size()) {
            if (((String)codici2.elementAt(x2)).length() == 7) {
                appo.append(((String)codici2.elementAt(x2)).substring(0, 1));
                String codAggiornato = MetodiUtili.creaCodice(((String)codici2.elementAt(x2)).substring(1, 7), incremento);
                appo.append(codAggiornato);
                if (codici1.size() > 1) {
                    appo.append("*");
                }
            } else if (((String)codici2.elementAt(x2)).length() < 7) {
                appo.append((String)codici2.elementAt(x2));
            } else {
                System.out.println("Valore non corrispondente a un codice di bean: lunghezza diversa da 7 !");
            }
            ++x2;
        }
        return appo.toString();
    }

    private GericoModel creaToggleModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        return new ToggleButtonModel(codiceCampo, descrErrore);
    }

    private GericoModel creaValutaModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new ValutaNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    public boolean eseguiControlliDocumento() {
        this.campiErrati.removeAllElements();
        this.vecMsgErrori.removeAllElements();
        boolean ritorno = true;
        if (this.getCampo(CODE_ATTIVITA).getValue().length() != 5 || this.getCampo(CODE_ATTIVITA).getValue().equals("00000")) {
            Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "012", CODE_ATTIVITA);
            this.messaggioErrore.addElement(anomalia);
            ritorno = false;
        }
        int cont = 0;
        while (cont < this.controlli.size()) {
            boolean risultato;
            GericoControllo gc;
            if (this.controlli.elementAt(cont) instanceof String) {
                int contQM = 0;
                while (contQM < this.controlliQM.size()) {
                    Vector vecSingoloQ = new Vector();
                    vecSingoloQ = (Vector)this.controlliQM.elementAt(contQM);
                    int contSingoloQ = 0;
                    while (contSingoloQ < vecSingoloQ.size()) {
                        gc = (GericoControllo)vecSingoloQ.elementAt(contSingoloQ);
                        risultato = gc.verifica();
                        if (!risultato) {
                            Anomalia anomalia = null;
                            anomalia = this.tipoRecord.equals("T") && gc.getNomeQuadro().equals("Dati Anagrafici") ? new Anomalia((Chiave)this.chiave, RECORD_S, gc) : new Anomalia((Chiave)this.chiave, this.tipoRecord, gc);
                            this.messaggioErrore.addElement(anomalia);
                            ritorno = false;
                        }
                        ++contSingoloQ;
                    }
                    ++contQM;
                }
            } else {
                gc = (GericoControllo)this.controlli.elementAt(cont);
                risultato = gc.verifica();
                if (!risultato) {
                    Anomalia anomalia = null;
                    anomalia = this.tipoRecord.equals("T") && gc.getNomeQuadro().equals("Dati Anagrafici") ? new Anomalia((Chiave)this.chiave, RECORD_S, gc) : new Anomalia((Chiave)this.chiave, this.tipoRecord, gc);
                    this.messaggioErrore.addElement(anomalia);
                    ritorno = false;
                }
            }
            ++cont;
        }
        return ritorno;
    }

    private String estraiNumMaxQuadri(String specLine) {
        StringTokenizer st = new StringTokenizer(specLine, "*");
        int countTokens = st.countTokens();
        int i = 0;
        while (i < countTokens - 1) {
            st.nextToken();
            ++i;
        }
        return st.nextToken();
    }

    private void gestisciEuro() {
        boolean euro = this.toBoolean(this.getCampo(CODE_EURO).getValue());
        Enumeration valore = this.campi.elements();
        while (valore.hasMoreElements()) {
            Object valoreInCampo = valore.nextElement();
            if (!(valoreInCampo instanceof ValutaNumericModel)) continue;
            ValutaNumericModel cfr_ignored_0 = (ValutaNumericModel)valoreInCampo;
            ValutaNumericModel.flagEuro = euro;
        }
    }

    public Hashtable getCampi() {
        return this.campi;
    }

    public Vector getCampiErrati() {
        return this.campiErrati;
    }

    public GericoModel getCampo(String chiave) {
        GericoModel gm = (GericoModel)this.campi.get(chiave);
        return gm;
    }

    private String getCampoMultiplo(int indiceCampo, int tipoCampo) {
        switch (tipoCampo) {
            case 0: {
                return this.getCampo(this.getCampoMultiplo(indiceCampo, 2)).getValue();
            }
            case 1: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[0];
            }
            case 2: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[1].substring(0, 6);
            }
            case 3: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[1].substring(7, 10);
            }
        }
        return null;
    }

    private Object getCampoMultiplo(int indiceCampo, int indiceQuadroMultiplo, int tipoCampo) {
        if (indiceCampo > this.getNumeroCampiMultiplo()) {
            throw new ArrayIndexOutOfBoundsException(indiceCampo);
        }
        if (indiceQuadroMultiplo > this.numeroMaxQuadri) {
            throw new ArrayIndexOutOfBoundsException(indiceQuadroMultiplo);
        }
        int indice = indiceQuadroMultiplo * this.getNumeroCampiMultiplo() + indiceCampo;
        switch (tipoCampo) {
            case 4: {
                return this.quadroMultiplo.elementAt(indice);
            }
            case 5: {
                return this.getCampo(this.getCampoMultiplo(indice, 2));
            }
        }
        return this.getCampoMultiplo(indice, tipoCampo);
    }

    public ChiaveStudio getChiave() {
        return this.chiave;
    }

    public Vector getControlliQM() {
        return this.controlliQM;
    }

    public Vector getControlliQM(int indice) {
        Vector vec = (Vector)this.controlliQM.elementAt(indice);
        return vec;
    }

    public Vector getControlliQuadro(String nomeQuadro) {
        GericoControllo gm = null;
        Vector<GericoControllo> controlliQuadroVet = new Vector<GericoControllo>();
        int cont = 0;
        int contQM = 0;
        if (this.controlli.size() == 0) {
            return controlliQuadroVet;
        }
        cont = 0;
        while (cont < this.controlli.size()) {
            if (this.controlli.elementAt(cont) instanceof String) {
                contQM = 0;
                while (contQM < this.controlliQM.size()) {
                    Vector vecSingoloQ = new Vector();
                    vecSingoloQ = (Vector)this.controlliQM.elementAt(contQM);
                    int contSingoloQ = 0;
                    while (contSingoloQ < vecSingoloQ.size()) {
                        gm = (GericoControllo)vecSingoloQ.elementAt(contSingoloQ);
                        if (gm.getNomeQuadro().equalsIgnoreCase(String.valueOf(nomeQuadro) + " " + (contQM + 1))) {
                            controlliQuadroVet.addElement(gm);
                        }
                        ++contSingoloQ;
                    }
                    ++contQM;
                }
            } else {
                gm = (GericoControllo)this.controlli.elementAt(cont);
                if (gm.getNomeQuadro().equalsIgnoreCase(nomeQuadro)) {
                    controlliQuadroVet.addElement(gm);
                }
            }
            ++cont;
        }
        return controlliQuadroVet;
    }

    public int getIndiceAssenzaQM() {
        int i = 0;
        while (i < Math.max(this.getNumeroQuadriMultipli(), 1)) {
            if (this.isQuadroMultiploAssente(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getMessaggioErrore() {
        return this.messaggioErrore;
    }

    public Vector getModelNuovoQuadroMultiplo() {
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        int i = 0;
        while (i < this.getNumeroCampiMultiplo()) {
            String[] specifiche = (String[])this.getCampoMultiplo(i, numeroQuadriMultipli, 4);
            this.costruisciCampo(specifiche);
            ++i;
        }
        Vector codici = this.getQuadroMultiplo(numeroQuadriMultipli, 2);
        Vector models = new Vector();
        int i2 = 0;
        while (i2 < codici.size()) {
            String codice = (String)codici.elementAt(i2);
            models.addElement(this.campi.get(codice));
            ++i2;
        }
        this.setNumeroQuadriMultipli(++numeroQuadriMultipli);
        return models;
    }

    private int getNumeroCampiMultiplo() {
        try {
            return this.quadroMultiplo.size() / this.numeroMaxQuadri;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumeroMaxQuadri() {
        return this.numeroMaxQuadri;
    }

    public int getNumeroQuadriMultipli() {
        try {
            return Integer.parseInt(this.getCampo(this.codiceNumeroQM).getValue());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean[] getQuadriMultipliAssenti() {
        boolean[] quadriAssenti = new boolean[this.getNumeroQuadriMultipli()];
        int i = 0;
        while (i < this.getNumeroQuadriMultipli()) {
            quadriAssenti[i] = this.isQuadroMultiploAssente(i);
            ++i;
        }
        return quadriAssenti;
    }

    public Vector getQuadroMultiplo(int indiceQuadro, int tipoCampo) {
        Vector<Object> riga = new Vector<Object>();
        int i = 0;
        while (i < this.getNumeroCampiMultiplo()) {
            riga.addElement(this.getCampoMultiplo(i, indiceQuadro, tipoCampo));
            ++i;
        }
        return riga;
    }

    public StringBuffer getRecordPosizionale() {
        GericoModel gm;
        String chiave;
        StringBuffer recordS = new StringBuffer();
        int i = 0;
        while (i < this.vecTesta.size()) {
            chiave = (String)this.vecTesta.elementAt(i);
            gm = (GericoModel)this.campi.get(chiave);
            recordS.append(gm.getValue());
            ++i;
        }
        i = 0;
        while (i < this.chiaviCampiPosizionali.size()) {
            chiave = (String)this.chiaviCampiPosizionali.elementAt(i);
            gm = (GericoModel)this.campi.get(chiave);
            recordS.append(gm.getValue());
            ++i;
        }
        recordS.insert(0, RECORD_S);
        return recordS;
    }

    public Vector getVecMsgErrori() {
        if (!this.vecMsgErrori.isEmpty()) {
            Vector vec = new Vector();
            int i = 0;
            while (i < this.vecMsgErrori.size()) {
                vec.addElement(this.vecMsgErrori.elementAt(i));
                ++i;
            }
            this.vecMsgErrori.removeAllElements();
            this.vecMsgErrori = vec;
        }
        return this.vecMsgErrori;
    }

    private void initialize() {
        String[] strSpecifiche;
        Vector vecSpecifiche;
        ModelloSet specifiche;
        block16: {
            block15: {
                specifiche = new ModelloSet(this.tipoRecord);
                vecSpecifiche = null;
                strSpecifiche = new String[2];
                this.codiceNumeroQM = "";
                this.ricavoDichiarato = "0";
                this.campi = new Hashtable();
                this.chiaviCampiNonPosizionali = new Vector();
                this.chiaviCampiPosizionali = new Vector();
                this.vecTesta = new Vector();
                this.controlli = new Vector();
                this.controlliComuneProvincia = new Vector();
                this.warning = new Vector();
                this.campiErrati = new Vector();
                this.specificheControlliQM = new Vector();
                this.controlliQM = new Vector();
                this.messaggioErrore = new Vector();
                this.vecMsgErrori = new Vector();
                this.vecMsgWarning = new Vector();
                try {
                    vecSpecifiche = specifiche.getTesta();
                }
                catch (IOException iOException) {
                    if (this.tipoRecord.equalsIgnoreCase(RECORD_S)) {
                        throw new IllegalArgumentException("testa.ger");
                    }
                    if (!this.tipoRecord.equalsIgnoreCase(RECORD_U)) break block15;
                    throw new IllegalArgumentException("testa_parametri.ger");
                }
            }
            int i = 0;
            while (i < vecSpecifiche.size()) {
                strSpecifiche = (String[])vecSpecifiche.elementAt(i);
                this.costruisciCampo(strSpecifiche);
                ++i;
            }
            strSpecifiche = new String[3];
            String tipoRedditoStringa = String.valueOf(this.tipoReddito);
            try {
                if (this.tipoRecord.equalsIgnoreCase(RECORD_S)) {
                    vecSpecifiche = specifiche.getModel(this.codiceStudio, true, tipoRedditoStringa);
                } else if (this.tipoRecord.equalsIgnoreCase(RECORD_U)) {
                    vecSpecifiche = specifiche.getModel("parametri", String.valueOf(this.tipoReddito));
                }
            }
            catch (IOException iOException) {
                if (this.tipoRecord.equalsIgnoreCase(RECORD_S)) {
                    throw new IllegalArgumentException("testa.ger");
                }
                if (!this.tipoRecord.equalsIgnoreCase(RECORD_U)) break block16;
                throw new IllegalArgumentException("testa_parametri.ger");
            }
        }
        this.quadroMultiplo = specifiche.getVectorMultipli();
        int i = 0;
        while (i < vecSpecifiche.size()) {
            strSpecifiche = (String[])vecSpecifiche.elementAt(i);
            this.costruisciCampo(strSpecifiche);
            ++i;
        }
        i = 0;
        while (i < this.quadroMultiplo.size()) {
            this.chiaviCampiNonPosizionali.addElement(this.getCampoMultiplo(i, 2));
            ++i;
        }
        strSpecifiche = new String[3];
        vecSpecifiche = specifiche.getControlli();
        i = 0;
        while (i < vecSpecifiche.size()) {
            strSpecifiche = (String[])vecSpecifiche.elementAt(i);
            if (strSpecifiche[0].charAt(0) != 'W') {
                this.costruisciControllo(strSpecifiche);
            }
            ++i;
        }
        if (!this.specificheControlliQM.isEmpty()) {
            this.aggiornaSpecificheControlliQM();
        }
    }

    public boolean isQuadroMultiploAssente(int indice) {
        Vector models = this.getQuadroMultiplo(indice, 5);
        int i = 0;
        while (i < models.size()) {
            GericoModel gm = (GericoModel)models.elementAt(i);
            if (gm != null && !gm.isValorePredefinito()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean leggi(Hashtable hash) {
        boolean esitoLettura = this.leggiDatiPosizione(hash);
        this.completaChiave();
        this.gestisciEuro();
        this.setControlliQM();
        return esitoLettura;
    }

    private boolean leggiDatiPosizione(Hashtable hash) {
        String value = (String)hash.get(this.codiceNumeroQM);
        if (value != null) {
            try {
                int n = Integer.parseInt(value);
                this.creaModelQM(n);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        String chiaveCampo = null;
        String valoreCampo = null;
        Enumeration chiavi = hash.keys();
        boolean esito = true;
        while (chiavi.hasMoreElements()) {
            chiaveCampo = (String)chiavi.nextElement();
            valoreCampo = (String)hash.get(chiaveCampo);
            this.tipoRecord = "T";
            int i = 0;
            while (i < this.chiaviCampiPosizionali.size()) {
                if (chiaveCampo.equalsIgnoreCase((String)this.chiaviCampiPosizionali.elementAt(i))) {
                    this.tipoRecord = RECORD_S;
                    break;
                }
                ++i;
            }
            if (this.setValoreCampo(chiaveCampo, valoreCampo)) continue;
            esito = false;
        }
        return esito;
    }

    public boolean leggiRecords(Vector records) {
        Hashtable componentiErrati;
        String recT = new String();
        boolean esito = true;
        this.messaggioErrore = new Vector();
        String recS = (String)records.elementAt(0);
        if (this.tipoRecord.equalsIgnoreCase(RECORD_S)) {
            componentiErrati = new Hashtable();
            componentiErrati = this.sezionaRecordPosizionale(recS, this.chiaviCampiPosizionali);
            this.impresa = 1;
            this.autonomo = 2;
            this.controlliCoerenza(componentiErrati);
        } else if (this.tipoRecord.equalsIgnoreCase(RECORD_U)) {
            componentiErrati = new Hashtable();
            componentiErrati = this.sezionaRecordPosizionale(String.valueOf(recS.substring(0, 657)) + recS.substring(1881, 1898), this.chiaviCampiPosizionali);
            this.impresa = 2;
            this.autonomo = 1;
            this.controlliCoerenza(componentiErrati);
        }
        int i = 0;
        while (i < records.size()) {
            recT = (String)records.elementAt(i);
            this.tipoRecord = recT.substring(0, 1);
            if (this.tipoRecord.equalsIgnoreCase("T")) {
                this.sezionaRecordT(recT, 100);
            } else if (this.tipoRecord.equalsIgnoreCase(RECORD_U)) {
                this.sezionaRecordT(recT, 657);
            }
            ++i;
        }
        int numeroQm = this.getNumeroQuadriMultipli();
        int i2 = 1;
        while (i2 < numeroQm) {
            this.costruisciControlloQM(i2);
            ++i2;
        }
        if (this.messaggioErrore.isEmpty()) {
            esito = false;
            this.eseguiControlliDocumento();
        }
        return esito;
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        v.addElement("S00000000018     00000000                                                                930122002010600                                                                                                                                                                                000000100 0000000000000000000000000000                                                                                              00000000000000000000000000000000000000000000000001 0000000000000000000000000000000000000000           000000000000                                                                                                                                                                                                                                     000000000000000000000000000000000000000000000000000000                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             000                                                                                                                                                A");
        v.addElement("T00000000018     00000000                                                                93012200201A00101                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               A");
        ChiaveStudio chiave = new ChiaveStudio("00000000018", 2002, "93012", "01", "SG67U");
        try {
            chiave.setModelloDic("06");
            CodFiscModel cf = new CodFiscModel("", "", true);
            cf.setOmo(false);
        }
        catch (Exception exception) {}
        chiave.setTipoReddito(2);
        Posizione p = new Posizione(chiave, RECORD_S);
        p.leggiRecords(v);
    }

    private void rimuoviModelQuadroMultiplo(int indice) {
        Vector codici = this.getQuadroMultiplo(indice, 2);
        int i = 0;
        while (i < codici.size()) {
            this.campi.remove(codici.elementAt(i));
            ++i;
        }
    }

    private void setControlliQM() {
        int numQ = this.getNumeroQuadriMultipli();
        int i = 1;
        while (i < numQ) {
            this.costruisciControlloQM(i);
            ++i;
        }
    }

    public void setNumeroQuadriMultipli(int numero) {
        try {
            this.getCampo(this.codiceNumeroQM).setValore(String.valueOf(numero));
        }
        catch (ControlloFormaleException controlloFormaleException) {}
    }

    private boolean setValoreCampo(String chiave, String valore) {
        GericoModel gm = (GericoModel)this.campi.get(chiave);
        if (gm != null) {
            try {
                gm.setValore(valore.trim());
                return true;
            }
            catch (ControlloFormaleException controlloFormaleException) {
                Anomalia anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, gm);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
        }
        return false;
    }

    private void setValoreCampoFornitura(String codice, String valore) {
        this.setValoreCampoFornitura(codice, valore, this.messaggioErrore, "Il campo " + codice + " \u00e8 inesistente" + "\n");
    }

    private void setValoreCampoFornitura(String codice, String valore, Vector messaggio, String msg) {
        block15: {
            GericoModel gm = null;
            gm = (GericoModel)this.campi.get(codice);
            if (gm != null) {
                if (!gm.isOnlyWrite()) {
                    try {
                        if (!gm.isValorePredefinito()) {
                            if (gm.getCode().length() == 6) {
                                Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, SCARTO, "808", gm.getCode());
                                this.messaggioErrore.addElement(anomalia);
                            } else {
                                Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, SCARTO, "808", gm.getCode().substring(gm.getCode().length() - 6, gm.getCode().length()));
                                this.messaggioErrore.addElement(anomalia);
                            }
                            break block15;
                        }
                        if (codice.equals(this.codiceNumeroQM)) {
                            this.messaggioErroreQM = new Vector();
                            this.codiciErratiQM = new Hashtable();
                            try {
                                gm.setValore(valore.trim());
                                if (Integer.parseInt(valore.trim()) == 0) {
                                    this.rimuoviModelQuadroMultiplo(0);
                                    break block15;
                                }
                                this.creaModelQM(Integer.parseInt(valore.trim()));
                            }
                            catch (ControlloFormaleException controlloFormaleException) {
                                this.rimuoviModelQuadroMultiplo(0);
                                Anomalia anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, gm);
                                this.messaggioErrore.addElement(anomalia);
                            }
                            break block15;
                        }
                        gm.setValore(valore.trim());
                    }
                    catch (ControlloFormaleException controlloFormaleException) {
                        if (this.messaggioErroreQM != null) {
                            this.codiciErratiQM.put(codice, "");
                        }
                        Anomalia anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, gm);
                        codice.length();
                        this.messaggioErrore.addElement(anomalia);
                    }
                }
            } else if (codice.length() == 6) {
                Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, SCARTO, "809", codice);
                this.messaggioErrore.addElement(anomalia);
            } else {
                Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, SCARTO, "809", codice.substring(codice.length() - 6, codice.length()));
                this.messaggioErrore.addElement(anomalia);
            }
        }
    }

    private Hashtable sezionaRecordPosizionale(String recordS, Vector campiPosizionali) {
        Anomalia anomalia;
        String codice = new String();
        String risSub = new String();
        GericoModel gm = null;
        int inizio = 1;
        int lunghezza = 0;
        Hashtable<String, GericoModel> componentiErrati = new Hashtable<String, GericoModel>();
        int i = 0;
        while (i < this.vecTesta.size()) {
            codice = (String)this.vecTesta.elementAt(i);
            gm = (GericoModel)this.campi.get(codice);
            lunghezza = gm.length();
            risSub = recordS.substring(inizio, inizio + lunghezza);
            inizio += lunghezza;
            if (!gm.isOnlyWrite()) {
                try {
                    gm.setValore(risSub.trim());
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, gm);
                    this.messaggioErrore.addElement(anomalia);
                }
            }
            ++i;
        }
        i = 0;
        while (i < campiPosizionali.size()) {
            codice = (String)campiPosizionali.elementAt(i);
            gm = (GericoModel)this.campi.get(codice);
            lunghezza = gm.length();
            risSub = recordS.substring(inizio, inizio + lunghezza);
            inizio += lunghezza;
            if (!gm.isOnlyWrite()) {
                try {
                    if (gm.getCode().equals(CODE_RICHIESTA_MARGINALI) && risSub.equals("1") && !Character.isLetter(this.getChiave().getCodiceFiscale().charAt(0))) {
                        anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "159");
                        this.messaggioErrore.addElement(anomalia);
                    }
                    gm.setValore(risSub.trim());
                }
                catch (ControlloFormaleException controlloFormaleException) {
                    componentiErrati.put(gm.getCode(), gm);
                    anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, gm);
                    this.messaggioErrore.addElement(anomalia);
                }
            }
            ++i;
        }
        if (!componentiErrati.containsKey(CODE_FISCALE) && !componentiErrati.containsKey(CODE_OMOCODICE)) {
            CodFiscModel cfm = (CodFiscModel)this.getCampo(CODE_FISCALE);
            try {
                cfm.setOmoCodice(this.getCampo(CODE_OMOCODICE).getValue().equals("1"));
            }
            catch (NonCoerenzaException nonCoerenzaException) {
                anomalia = new Anomalia((Chiave)this.chiave, this.tipoRecord, cfm);
                this.messaggioErrore.addElement(anomalia);
            }
        }
        return componentiErrati;
    }

    private void sezionaRecordT(String record, int inizio) {
        String codice = new String();
        String valore = new String();
        while (record.length() - 15 > inizio) {
            codice = record.substring(inizio, inizio + 6);
            valore = record.substring(inizio += 6, inizio + 11);
            inizio += 11;
            if (this.messaggioErroreQM != null) {
                boolean[] flag = this.controllaValiditaCodice(codice);
                if (flag[0]) {
                    this.setValoreCampoFornitura(codice, valore, this.messaggioErroreQM, "");
                } else if (!flag[0] && flag[1]) {
                    Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "800");
                    this.messaggioErrore.addElement(anomalia);
                    this.setValoreCampoFornitura(codice, valore);
                    this.messaggioErroreQM = null;
                } else {
                    if (this.getIndiceAssenzaQM() == -1) {
                        int i = 0;
                        while (i < this.messaggioErroreQM.size()) {
                            this.messaggioErrore.addElement(this.messaggioErroreQM.elementAt(i));
                            ++i;
                        }
                        this.messaggioErroreQM = null;
                    } else {
                        boolean trovatoErrato = false;
                        boolean[] quadriAssenti = this.getQuadriMultipliAssenti();
                        int i = 0;
                        while (i < quadriAssenti.length) {
                            if (quadriAssenti[i]) {
                                trovatoErrato = false;
                                Vector codici = this.getQuadroMultiplo(i, 2);
                                int j = 0;
                                while (j < codici.size()) {
                                    if (this.codiciErratiQM.get(codici.elementAt(j)) != null) {
                                        trovatoErrato = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!trovatoErrato) {
                                    this.messaggioErroreQM = null;
                                    Anomalia anomalia = new Anomalia(this.chiave, this.tipoRecord, "scarto_confermabile", "800");
                                    this.messaggioErrore.addElement(anomalia);
                                    break;
                                }
                            }
                            ++i;
                        }
                        if (trovatoErrato) {
                            i = 0;
                            while (i < this.messaggioErroreQM.size()) {
                                this.messaggioErrore.addElement(this.messaggioErroreQM.elementAt(i));
                                ++i;
                            }
                            this.messaggioErroreQM = null;
                        }
                    }
                    if (codice.trim().length() != 0) {
                        this.setValoreCampoFornitura(codice, valore);
                    }
                }
                if (codice.trim().length() != 0) continue;
                break;
            }
            if (codice.trim().length() == 0) break;
            this.messaggioErroreQM = null;
            this.setValoreCampoFornitura(codice, valore);
        }
    }

    private boolean toBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    private void valorizzaBean(ChiaveStudio chiave) {
        GericoModel gm = null;
        try {
            gm = (GericoModel)this.campi.get(CODE_FISCALE);
            gm.setValore(chiave.getCodiceFiscale());
            gm = (GericoModel)this.campi.get(CODE_ATTIVITA);
            gm = (GericoModel)this.campi.get(CODE_PROGRESSIVO);
            gm.setValore(String.valueOf(chiave.getProgressivo()));
            gm = (GericoModel)this.campi.get(CODE_MODELLO_DICHIARAZIONE);
            gm.setValore(chiave.getModelloDic());
            gm = (GericoModel)this.campi.get(CODE_ANNO);
            gm.setValore(String.valueOf(chiave.getAnno()));
            gm = (GericoModel)this.campi.get(CODE_EURO);
            String euro = chiave.getEuro() ? "1" : "0";
            ((ToggleButtonModel)gm).setValore(euro);
            gm = (GericoModel)this.campi.get(CODE_OMOCODICE);
            String omocodice = chiave.getEuro() ? "1" : "0";
            ((ToggleButtonModel)gm).setValore(omocodice);
            gm = (GericoModel)this.campi.get(CODE_TIPO_REDDITO);
            if (gm != null) {
                gm.setValore(String.valueOf(chiave.getTipoReddito()));
            }
            this.gestisciEuro();
        }
        catch (ControlloFormaleException e) {
            e.printStackTrace();
        }
    }
}

