/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimphelp_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

/**
 * gimp_help:
 * @prog_name: The plug-in's executable name or an empty string.
 * @help_page: The location of the help page.
 *
 * Load a help page.
 *
 * This procedure loads the specified help page into the helpbrowser or
 * what ever is configured as help viewer. The location of the help
 * page is given relative to the help rootdir. The help rootdir is
 * determined from the prog_name: if prog_name is NULL, we use the help
 * rootdir of the main GIMP installation, if the plug-in's full
 * executable name is passed as prog_name, the GIMP will use this
 * information to look up the help path the plug-in has registered
 * before with gimp-plugin-help-register.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_help (gchar *prog_name,
	   gchar *help_page)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_help",
				    &nreturn_vals,
				    GIMP_PDB_STRING, prog_name,
				    GIMP_PDB_STRING, help_page,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
