/****************************************************************************
**
** Copyright (C) 2018 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <vector>

namespace CppTools {
namespace Constants {

struct TidyNode
{
    const std::vector<TidyNode> children;
    const char *name = nullptr;
    TidyNode(const char *name, std::vector<TidyNode> &&children)
        : children(std::move(children))
        , name(name)
    {}
    TidyNode(const char *name) : name(name) {}
};

// CLANG-UPGRADE-CHECK: Run 'scripts/generateClangTidyChecks.py' after Clang upgrade to
// update this header.
static const TidyNode CLANG_TIDY_CHECKS_ROOT
{
    "",
    {
        {
            "android-",
            {
                {
                    "cloexec-",
                    {
                        "accept",
                        "accept4",
                        "creat",
                        "dup",
                        {
                            "epoll-",
                            {
                                "create",
                                "create1"
                            }
                        },
                        "fopen",
                        {
                            "inotify-",
                            {
                                "init",
                                "init1"
                            }
                        },
                        "memfd-create",
                        "open",
                        "socket"
                    }
                }
            }
        },
        {
            "boost-",
            {
                "use-to-string"
            }
        },
        {
            "bugprone-",
            {
                "argument-comment",
                "assert-side-effect",
                "bool-pointer-implicit-conversion",
                "copy-constructor-init",
                "dangling-handle",
                "fold-init-type",
                "forward-declaration-namespace",
                "inaccurate-erase",
                "integer-division",
                "misplaced-operator-in-strlen-in-alloc",
                "move-forwarding-reference",
                "multiple-statement-macro",
                "string-constructor",
                "suspicious-memset-usage",
                "undefined-memory-manipulation",
                "use-after-move",
                "virtual-near-miss"
            }
        },
        {
            "cert-",
            {
                "dcl03-c",
                "dcl21-cpp",
                "dcl50-cpp",
                "dcl54-cpp",
                "dcl58-cpp",
                "dcl59-cpp",
                "env33-c",
                "err09-cpp",
                "err34-c",
                "err52-cpp",
                "err58-cpp",
                "err60-cpp",
                "err61-cpp",
                "fio38-c",
                "flp30-c",
                "msc30-c",
                "msc50-cpp",
                "oop11-cpp"
            }
        },
        {
            "clang-analyzer-",
            {
                "apiModeling.google.GTest",
                {
                    "core.",
                    {
                        "CallAndMessage",
                        "DivideZero",
                        "DynamicTypePropagation",
                        "NonNullParamChecker",
                        "NonnilStringConstants",
                        "NullDereference",
                        "StackAddressEscape",
                        "UndefinedBinaryOperatorResult",
                        "VLASize",
                        {
                            "builtin.",
                            {
                                "BuiltinFunctions",
                                "NoReturnFunctions"
                            }
                        },
                        {
                            "uninitialized.",
                            {
                                "ArraySubscript",
                                "Assign",
                                "Branch",
                                "CapturedBlockVariable",
                                "UndefReturn"
                            }
                        }
                    }
                },
                {
                    "cplusplus.",
                    {
                        "NewDelete",
                        "NewDeleteLeaks",
                        "SelfAssignment"
                    }
                },
                "deadcode.DeadStores",
                "llvm.Conventions",
                {
                    "nullability.",
                    {
                        "NullPassedToNonnull",
                        "NullReturnedFromNonnull",
                        "NullableDereferenced",
                        "NullablePassedToNonnull",
                        "NullableReturnedFromNonnull"
                    }
                },
                {
                    "optin.",
                    {
                        "cplusplus.VirtualCall",
                        "mpi.MPI-Checker",
                        {
                            "osx.",
                            {
                                {
                                    "cocoa.",
                                    {
                                        {
                                            "localizability.",
                                            {
                                                "EmptyLocalizationContextChecker",
                                                "NonLocalizedStringChecker"
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        "performance.Padding",
                        "portability.UnixAPI"
                    }
                },
                {
                    "osx.",
                    {
                        "API",
                        "NumberObjectConversion",
                        "ObjCProperty",
                        "SecKeychainAPI",
                        {
                            "cocoa.",
                            {
                                "AtSync",
                                "ClassRelease",
                                "Dealloc",
                                "IncompatibleMethodTypes",
                                "Loops",
                                "MissingSuperCall",
                                "NSAutoreleasePool",
                                "NSError",
                                "NilArg",
                                "NonNilReturnValue",
                                "ObjCGenerics",
                                "RetainCount",
                                "SelfInit",
                                "SuperDealloc",
                                "UnusedIvars",
                                "VariadicMethodTypes"
                            }
                        },
                        {
                            "coreFoundation.",
                            {
                                "CFError",
                                "CFNumber",
                                "CFRetainRelease",
                                {
                                    "containers.",
                                    {
                                        "OutOfBounds",
                                        "PointerSizedValues"
                                    }
                                }
                            }
                        }
                    }
                },
                {
                    "security.",
                    {
                        "FloatLoopCounter",
                        {
                            "insecureAPI.",
                            {
                                "UncheckedReturn",
                                "getpw",
                                "gets",
                                "mkstemp",
                                "mktemp",
                                "rand",
                                "strcpy",
                                "vfork"
                            }
                        }
                    }
                },
                {
                    "unix.",
                    {
                        "API",
                        "Malloc",
                        "MallocSizeof",
                        "MismatchedDeallocator",
                        "StdCLibraryFunctions",
                        "Vfork",
                        {
                            "cstring.",
                            {
                                "BadSizeArg",
                                "NullArg"
                            }
                        }
                    }
                },
                {
                    "valist.",
                    {
                        "CopyToSelf",
                        "Uninitialized",
                        "Unterminated"
                    }
                }
            }
        },
        {
            "cppcoreguidelines-",
            {
                "c-copy-assignment-signature",
                "interfaces-global-init",
                "no-malloc",
                "owning-memory",
                {
                    "pro-",
                    {
                        {
                            "bounds-",
                            {
                                "array-to-pointer-decay",
                                "constant-array-index",
                                "pointer-arithmetic"
                            }
                        },
                        {
                            "type-",
                            {
                                "const-cast",
                                "cstyle-cast",
                                "member-init",
                                "reinterpret-cast",
                                "static-cast-downcast",
                                "union-access",
                                "vararg"
                            }
                        }
                    }
                },
                "slicing",
                "special-member-functions"
            }
        },
        {
            "fuchsia-",
            {
                "default-arguments",
                "overloaded-operator",
                "virtual-inheritance"
            }
        },
        {
            "google-",
            {
                {
                    "build-",
                    {
                        "explicit-make-pair",
                        "namespaces",
                        "using-namespace"
                    }
                },
                "default-arguments",
                "explicit-constructor",
                "global-names-in-headers",
                {
                    "objc-",
                    {
                        "avoid-throwing-exception",
                        "global-variable-declaration"
                    }
                },
                {
                    "readability-",
                    {
                        "braces-around-statements",
                        "casting",
                        "function-size",
                        "namespace-comments",
                        "redundant-smartptr-get",
                        "todo"
                    }
                },
                {
                    "runtime-",
                    {
                        "int",
                        "member-string-references",
                        "operator",
                        "references"
                    }
                }
            }
        },
        {
            "hicpp-",
            {
                "braces-around-statements",
                "deprecated-headers",
                "exception-baseclass",
                "explicit-conversions",
                "function-size",
                "invalid-access-moved",
                "member-init",
                "move-const-arg",
                "named-parameter",
                "new-delete-operators",
                {
                    "no-",
                    {
                        "array-decay",
                        "assembler",
                        "malloc"
                    }
                },
                "noexcept-move",
                "signed-bitwise",
                "special-member-functions",
                "static-assert",
                "undelegated-constructor",
                {
                    "use-",
                    {
                        "auto",
                        "emplace",
                        {
                            "equals-",
                            {
                                "default",
                                "delete"
                            }
                        },
                        "noexcept",
                        "nullptr",
                        "override"
                    }
                },
                "vararg"
            }
        },
        {
            "llvm-",
            {
                "header-guard",
                "include-order",
                "namespace-comment",
                "twine-local"
            }
        },
        {
            "misc-",
            {
                "definitions-in-headers",
                "forwarding-reference-overload",
                "incorrect-roundings",
                "lambda-function-name",
                {
                    "macro-",
                    {
                        "parentheses",
                        "repeated-side-effects"
                    }
                },
                {
                    "misplaced-",
                    {
                        "const",
                        "widening-cast"
                    }
                },
                "new-delete-overloads",
                "non-copyable-objects",
                "redundant-expression",
                {
                    "sizeof-",
                    {
                        "container",
                        "expression"
                    }
                },
                "static-assert",
                {
                    "string-",
                    {
                        "compare",
                        "integer-assignment",
                        "literal-with-embedded-nul"
                    }
                },
                {
                    "suspicious-",
                    {
                        "enum-usage",
                        "missing-comma",
                        "semicolon",
                        "string-compare"
                    }
                },
                "swapped-arguments",
                "throw-by-value-catch-by-reference",
                "unconventional-assign-operator",
                "undelegated-constructor",
                "uniqueptr-reset-release",
                {
                    "unused-",
                    {
                        "alias-decls",
                        "parameters",
                        "raii",
                        "using-decls"
                    }
                }
            }
        },
        {
            "modernize-",
            {
                "avoid-bind",
                "deprecated-headers",
                "loop-convert",
                {
                    "make-",
                    {
                        "shared",
                        "unique"
                    }
                },
                "pass-by-value",
                "raw-string-literal",
                "redundant-void-arg",
                {
                    "replace-",
                    {
                        "auto-ptr",
                        "random-shuffle"
                    }
                },
                "return-braced-init-list",
                "shrink-to-fit",
                "unary-static-assert",
                {
                    "use-",
                    {
                        "auto",
                        "bool-literals",
                        "default-member-init",
                        "emplace",
                        {
                            "equals-",
                            {
                                "default",
                                "delete"
                            }
                        },
                        "noexcept",
                        "nullptr",
                        "override",
                        "transparent-functors",
                        "using"
                    }
                }
            }
        },
        {
            "mpi-",
            {
                "buffer-deref",
                "type-mismatch"
            }
        },
        {
            "objc-",
            {
                {
                    "avoid-",
                    {
                        "nserror-init",
                        "spinlock"
                    }
                },
                "forbidden-subclassing",
                "property-declaration"
            }
        },
        {
            "performance-",
            {
                "faster-string-find",
                "for-range-copy",
                "implicit-conversion-in-loop",
                {
                    "inefficient-",
                    {
                        "algorithm",
                        "string-concatenation",
                        "vector-operation"
                    }
                },
                {
                    "move-",
                    {
                        "const-arg",
                        "constructor-init"
                    }
                },
                "noexcept-move-constructor",
                "type-promotion-in-math-fn",
                {
                    "unnecessary-",
                    {
                        "copy-initialization",
                        "value-param"
                    }
                }
            }
        },
        {
            "readability-",
            {
                "avoid-const-params-in-decls",
                "braces-around-statements",
                "container-size-empty",
                "delete-null-pointer",
                "deleted-default",
                "else-after-return",
                "function-size",
                "identifier-naming",
                "implicit-bool-conversion",
                "inconsistent-declaration-parameter-name",
                "misleading-indentation",
                "misplaced-array-index",
                "named-parameter",
                "non-const-parameter",
                {
                    "redundant-",
                    {
                        "control-flow",
                        "declaration",
                        "function-ptr-dereference",
                        "member-init",
                        "smartptr-get",
                        {
                            "string-",
                            {
                                "cstr",
                                "init"
                            }
                        }
                    }
                },
                "simplify-boolean-expr",
                {
                    "static-",
                    {
                        "accessed-through-instance",
                        "definition-in-anonymous-namespace"
                    }
                },
                "uniqueptr-delete-release"
            }
        }
    }
};

} // namespace Constants
} // namespace CppTools
