/*
* Diffusion Tables for Whirlpool
* (C) 1999-2007 Jack Lloyd
*
* Distributed under the terms of the Botan license
*/

#include <botan/whrlpool.h>

namespace Botan {

const u64bit Whirlpool::C0[256] = {
(u64bit) 0x18186018C07830D8ULL, (u64bit) 0x23238C2305AF4626ULL, (u64bit) 0xC6C63FC67EF991B8ULL, (u64bit) 0xE8E887E8136FCDFBULL,
(u64bit) 0x878726874CA113CBULL, (u64bit) 0xB8B8DAB8A9626D11ULL, (u64bit) 0x0101040108050209ULL, (u64bit) 0x4F4F214F426E9E0DULL,
(u64bit) 0x3636D836ADEE6C9BULL, (u64bit) 0xA6A6A2A6590451FFULL, (u64bit) 0xD2D26FD2DEBDB90CULL, (u64bit) 0xF5F5F3F5FB06F70EULL,
(u64bit) 0x7979F979EF80F296ULL, (u64bit) 0x6F6FA16F5FCEDE30ULL, (u64bit) 0x91917E91FCEF3F6DULL, (u64bit) 0x52525552AA07A4F8ULL,
(u64bit) 0x60609D6027FDC047ULL, (u64bit) 0xBCBCCABC89766535ULL, (u64bit) 0x9B9B569BACCD2B37ULL, (u64bit) 0x8E8E028E048C018AULL,
(u64bit) 0xA3A3B6A371155BD2ULL, (u64bit) 0x0C0C300C603C186CULL, (u64bit) 0x7B7BF17BFF8AF684ULL, (u64bit) 0x3535D435B5E16A80ULL,
(u64bit) 0x1D1D741DE8693AF5ULL, (u64bit) 0xE0E0A7E05347DDB3ULL, (u64bit) 0xD7D77BD7F6ACB321ULL, (u64bit) 0xC2C22FC25EED999CULL,
(u64bit) 0x2E2EB82E6D965C43ULL, (u64bit) 0x4B4B314B627A9629ULL, (u64bit) 0xFEFEDFFEA321E15DULL, (u64bit) 0x575741578216AED5ULL,
(u64bit) 0x15155415A8412ABDULL, (u64bit) 0x7777C1779FB6EEE8ULL, (u64bit) 0x3737DC37A5EB6E92ULL, (u64bit) 0xE5E5B3E57B56D79EULL,
(u64bit) 0x9F9F469F8CD92313ULL, (u64bit) 0xF0F0E7F0D317FD23ULL, (u64bit) 0x4A4A354A6A7F9420ULL, (u64bit) 0xDADA4FDA9E95A944ULL,
(u64bit) 0x58587D58FA25B0A2ULL, (u64bit) 0xC9C903C906CA8FCFULL, (u64bit) 0x2929A429558D527CULL, (u64bit) 0x0A0A280A5022145AULL,
(u64bit) 0xB1B1FEB1E14F7F50ULL, (u64bit) 0xA0A0BAA0691A5DC9ULL, (u64bit) 0x6B6BB16B7FDAD614ULL, (u64bit) 0x85852E855CAB17D9ULL,
(u64bit) 0xBDBDCEBD8173673CULL, (u64bit) 0x5D5D695DD234BA8FULL, (u64bit) 0x1010401080502090ULL, (u64bit) 0xF4F4F7F4F303F507ULL,
(u64bit) 0xCBCB0BCB16C08BDDULL, (u64bit) 0x3E3EF83EEDC67CD3ULL, (u64bit) 0x0505140528110A2DULL, (u64bit) 0x676781671FE6CE78ULL,
(u64bit) 0xE4E4B7E47353D597ULL, (u64bit) 0x27279C2725BB4E02ULL, (u64bit) 0x4141194132588273ULL, (u64bit) 0x8B8B168B2C9D0BA7ULL,
(u64bit) 0xA7A7A6A7510153F6ULL, (u64bit) 0x7D7DE97DCF94FAB2ULL, (u64bit) 0x95956E95DCFB3749ULL, (u64bit) 0xD8D847D88E9FAD56ULL,
(u64bit) 0xFBFBCBFB8B30EB70ULL, (u64bit) 0xEEEE9FEE2371C1CDULL, (u64bit) 0x7C7CED7CC791F8BBULL, (u64bit) 0x6666856617E3CC71ULL,
(u64bit) 0xDDDD53DDA68EA77BULL, (u64bit) 0x17175C17B84B2EAFULL, (u64bit) 0x4747014702468E45ULL, (u64bit) 0x9E9E429E84DC211AULL,
(u64bit) 0xCACA0FCA1EC589D4ULL, (u64bit) 0x2D2DB42D75995A58ULL, (u64bit) 0xBFBFC6BF9179632EULL, (u64bit) 0x07071C07381B0E3FULL,
(u64bit) 0xADAD8EAD012347ACULL, (u64bit) 0x5A5A755AEA2FB4B0ULL, (u64bit) 0x838336836CB51BEFULL, (u64bit) 0x3333CC3385FF66B6ULL,
(u64bit) 0x636391633FF2C65CULL, (u64bit) 0x02020802100A0412ULL, (u64bit) 0xAAAA92AA39384993ULL, (u64bit) 0x7171D971AFA8E2DEULL,
(u64bit) 0xC8C807C80ECF8DC6ULL, (u64bit) 0x19196419C87D32D1ULL, (u64bit) 0x494939497270923BULL, (u64bit) 0xD9D943D9869AAF5FULL,
(u64bit) 0xF2F2EFF2C31DF931ULL, (u64bit) 0xE3E3ABE34B48DBA8ULL, (u64bit) 0x5B5B715BE22AB6B9ULL, (u64bit) 0x88881A8834920DBCULL,
(u64bit) 0x9A9A529AA4C8293EULL, (u64bit) 0x262698262DBE4C0BULL, (u64bit) 0x3232C8328DFA64BFULL, (u64bit) 0xB0B0FAB0E94A7D59ULL,
(u64bit) 0xE9E983E91B6ACFF2ULL, (u64bit) 0x0F0F3C0F78331E77ULL, (u64bit) 0xD5D573D5E6A6B733ULL, (u64bit) 0x80803A8074BA1DF4ULL,
(u64bit) 0xBEBEC2BE997C6127ULL, (u64bit) 0xCDCD13CD26DE87EBULL, (u64bit) 0x3434D034BDE46889ULL, (u64bit) 0x48483D487A759032ULL,
(u64bit) 0xFFFFDBFFAB24E354ULL, (u64bit) 0x7A7AF57AF78FF48DULL, (u64bit) 0x90907A90F4EA3D64ULL, (u64bit) 0x5F5F615FC23EBE9DULL,
(u64bit) 0x202080201DA0403DULL, (u64bit) 0x6868BD6867D5D00FULL, (u64bit) 0x1A1A681AD07234CAULL, (u64bit) 0xAEAE82AE192C41B7ULL,
(u64bit) 0xB4B4EAB4C95E757DULL, (u64bit) 0x54544D549A19A8CEULL, (u64bit) 0x93937693ECE53B7FULL, (u64bit) 0x222288220DAA442FULL,
(u64bit) 0x64648D6407E9C863ULL, (u64bit) 0xF1F1E3F1DB12FF2AULL, (u64bit) 0x7373D173BFA2E6CCULL, (u64bit) 0x12124812905A2482ULL,
(u64bit) 0x40401D403A5D807AULL, (u64bit) 0x0808200840281048ULL, (u64bit) 0xC3C32BC356E89B95ULL, (u64bit) 0xECEC97EC337BC5DFULL,
(u64bit) 0xDBDB4BDB9690AB4DULL, (u64bit) 0xA1A1BEA1611F5FC0ULL, (u64bit) 0x8D8D0E8D1C830791ULL, (u64bit) 0x3D3DF43DF5C97AC8ULL,
(u64bit) 0x97976697CCF1335BULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0xCFCF1BCF36D483F9ULL, (u64bit) 0x2B2BAC2B4587566EULL,
(u64bit) 0x7676C57697B3ECE1ULL, (u64bit) 0x8282328264B019E6ULL, (u64bit) 0xD6D67FD6FEA9B128ULL, (u64bit) 0x1B1B6C1BD87736C3ULL,
(u64bit) 0xB5B5EEB5C15B7774ULL, (u64bit) 0xAFAF86AF112943BEULL, (u64bit) 0x6A6AB56A77DFD41DULL, (u64bit) 0x50505D50BA0DA0EAULL,
(u64bit) 0x45450945124C8A57ULL, (u64bit) 0xF3F3EBF3CB18FB38ULL, (u64bit) 0x3030C0309DF060ADULL, (u64bit) 0xEFEF9BEF2B74C3C4ULL,
(u64bit) 0x3F3FFC3FE5C37EDAULL, (u64bit) 0x55554955921CAAC7ULL, (u64bit) 0xA2A2B2A2791059DBULL, (u64bit) 0xEAEA8FEA0365C9E9ULL,
(u64bit) 0x656589650FECCA6AULL, (u64bit) 0xBABAD2BAB9686903ULL, (u64bit) 0x2F2FBC2F65935E4AULL, (u64bit) 0xC0C027C04EE79D8EULL,
(u64bit) 0xDEDE5FDEBE81A160ULL, (u64bit) 0x1C1C701CE06C38FCULL, (u64bit) 0xFDFDD3FDBB2EE746ULL, (u64bit) 0x4D4D294D52649A1FULL,
(u64bit) 0x92927292E4E03976ULL, (u64bit) 0x7575C9758FBCEAFAULL, (u64bit) 0x06061806301E0C36ULL, (u64bit) 0x8A8A128A249809AEULL,
(u64bit) 0xB2B2F2B2F940794BULL, (u64bit) 0xE6E6BFE66359D185ULL, (u64bit) 0x0E0E380E70361C7EULL, (u64bit) 0x1F1F7C1FF8633EE7ULL,
(u64bit) 0x6262956237F7C455ULL, (u64bit) 0xD4D477D4EEA3B53AULL, (u64bit) 0xA8A89AA829324D81ULL, (u64bit) 0x96966296C4F43152ULL,
(u64bit) 0xF9F9C3F99B3AEF62ULL, (u64bit) 0xC5C533C566F697A3ULL, (u64bit) 0x2525942535B14A10ULL, (u64bit) 0x59597959F220B2ABULL,
(u64bit) 0x84842A8454AE15D0ULL, (u64bit) 0x7272D572B7A7E4C5ULL, (u64bit) 0x3939E439D5DD72ECULL, (u64bit) 0x4C4C2D4C5A619816ULL,
(u64bit) 0x5E5E655ECA3BBC94ULL, (u64bit) 0x7878FD78E785F09FULL, (u64bit) 0x3838E038DDD870E5ULL, (u64bit) 0x8C8C0A8C14860598ULL,
(u64bit) 0xD1D163D1C6B2BF17ULL, (u64bit) 0xA5A5AEA5410B57E4ULL, (u64bit) 0xE2E2AFE2434DD9A1ULL, (u64bit) 0x616199612FF8C24EULL,
(u64bit) 0xB3B3F6B3F1457B42ULL, (u64bit) 0x2121842115A54234ULL, (u64bit) 0x9C9C4A9C94D62508ULL, (u64bit) 0x1E1E781EF0663CEEULL,
(u64bit) 0x4343114322528661ULL, (u64bit) 0xC7C73BC776FC93B1ULL, (u64bit) 0xFCFCD7FCB32BE54FULL, (u64bit) 0x0404100420140824ULL,
(u64bit) 0x51515951B208A2E3ULL, (u64bit) 0x99995E99BCC72F25ULL, (u64bit) 0x6D6DA96D4FC4DA22ULL, (u64bit) 0x0D0D340D68391A65ULL,
(u64bit) 0xFAFACFFA8335E979ULL, (u64bit) 0xDFDF5BDFB684A369ULL, (u64bit) 0x7E7EE57ED79BFCA9ULL, (u64bit) 0x242490243DB44819ULL,
(u64bit) 0x3B3BEC3BC5D776FEULL, (u64bit) 0xABAB96AB313D4B9AULL, (u64bit) 0xCECE1FCE3ED181F0ULL, (u64bit) 0x1111441188552299ULL,
(u64bit) 0x8F8F068F0C890383ULL, (u64bit) 0x4E4E254E4A6B9C04ULL, (u64bit) 0xB7B7E6B7D1517366ULL, (u64bit) 0xEBEB8BEB0B60CBE0ULL,
(u64bit) 0x3C3CF03CFDCC78C1ULL, (u64bit) 0x81813E817CBF1FFDULL, (u64bit) 0x94946A94D4FE3540ULL, (u64bit) 0xF7F7FBF7EB0CF31CULL,
(u64bit) 0xB9B9DEB9A1676F18ULL, (u64bit) 0x13134C13985F268BULL, (u64bit) 0x2C2CB02C7D9C5851ULL, (u64bit) 0xD3D36BD3D6B8BB05ULL,
(u64bit) 0xE7E7BBE76B5CD38CULL, (u64bit) 0x6E6EA56E57CBDC39ULL, (u64bit) 0xC4C437C46EF395AAULL, (u64bit) 0x03030C03180F061BULL,
(u64bit) 0x565645568A13ACDCULL, (u64bit) 0x44440D441A49885EULL, (u64bit) 0x7F7FE17FDF9EFEA0ULL, (u64bit) 0xA9A99EA921374F88ULL,
(u64bit) 0x2A2AA82A4D825467ULL, (u64bit) 0xBBBBD6BBB16D6B0AULL, (u64bit) 0xC1C123C146E29F87ULL, (u64bit) 0x53535153A202A6F1ULL,
(u64bit) 0xDCDC57DCAE8BA572ULL, (u64bit) 0x0B0B2C0B58271653ULL, (u64bit) 0x9D9D4E9D9CD32701ULL, (u64bit) 0x6C6CAD6C47C1D82BULL,
(u64bit) 0x3131C43195F562A4ULL, (u64bit) 0x7474CD7487B9E8F3ULL, (u64bit) 0xF6F6FFF6E309F115ULL, (u64bit) 0x464605460A438C4CULL,
(u64bit) 0xACAC8AAC092645A5ULL, (u64bit) 0x89891E893C970FB5ULL, (u64bit) 0x14145014A04428B4ULL, (u64bit) 0xE1E1A3E15B42DFBAULL,
(u64bit) 0x16165816B04E2CA6ULL, (u64bit) 0x3A3AE83ACDD274F7ULL, (u64bit) 0x6969B9696FD0D206ULL, (u64bit) 0x09092409482D1241ULL,
(u64bit) 0x7070DD70A7ADE0D7ULL, (u64bit) 0xB6B6E2B6D954716FULL, (u64bit) 0xD0D067D0CEB7BD1EULL, (u64bit) 0xEDED93ED3B7EC7D6ULL,
(u64bit) 0xCCCC17CC2EDB85E2ULL, (u64bit) 0x424215422A578468ULL, (u64bit) 0x98985A98B4C22D2CULL, (u64bit) 0xA4A4AAA4490E55EDULL,
(u64bit) 0x2828A0285D885075ULL, (u64bit) 0x5C5C6D5CDA31B886ULL, (u64bit) 0xF8F8C7F8933FED6BULL, (u64bit) 0x8686228644A411C2ULL };

const u64bit Whirlpool::C1[256] = {
(u64bit) 0xD818186018C07830ULL, (u64bit) 0x2623238C2305AF46ULL, (u64bit) 0xB8C6C63FC67EF991ULL, (u64bit) 0xFBE8E887E8136FCDULL,
(u64bit) 0xCB878726874CA113ULL, (u64bit) 0x11B8B8DAB8A9626DULL, (u64bit) 0x0901010401080502ULL, (u64bit) 0x0D4F4F214F426E9EULL,
(u64bit) 0x9B3636D836ADEE6CULL, (u64bit) 0xFFA6A6A2A6590451ULL, (u64bit) 0x0CD2D26FD2DEBDB9ULL, (u64bit) 0x0EF5F5F3F5FB06F7ULL,
(u64bit) 0x967979F979EF80F2ULL, (u64bit) 0x306F6FA16F5FCEDEULL, (u64bit) 0x6D91917E91FCEF3FULL, (u64bit) 0xF852525552AA07A4ULL,
(u64bit) 0x4760609D6027FDC0ULL, (u64bit) 0x35BCBCCABC897665ULL, (u64bit) 0x379B9B569BACCD2BULL, (u64bit) 0x8A8E8E028E048C01ULL,
(u64bit) 0xD2A3A3B6A371155BULL, (u64bit) 0x6C0C0C300C603C18ULL, (u64bit) 0x847B7BF17BFF8AF6ULL, (u64bit) 0x803535D435B5E16AULL,
(u64bit) 0xF51D1D741DE8693AULL, (u64bit) 0xB3E0E0A7E05347DDULL, (u64bit) 0x21D7D77BD7F6ACB3ULL, (u64bit) 0x9CC2C22FC25EED99ULL,
(u64bit) 0x432E2EB82E6D965CULL, (u64bit) 0x294B4B314B627A96ULL, (u64bit) 0x5DFEFEDFFEA321E1ULL, (u64bit) 0xD5575741578216AEULL,
(u64bit) 0xBD15155415A8412AULL, (u64bit) 0xE87777C1779FB6EEULL, (u64bit) 0x923737DC37A5EB6EULL, (u64bit) 0x9EE5E5B3E57B56D7ULL,
(u64bit) 0x139F9F469F8CD923ULL, (u64bit) 0x23F0F0E7F0D317FDULL, (u64bit) 0x204A4A354A6A7F94ULL, (u64bit) 0x44DADA4FDA9E95A9ULL,
(u64bit) 0xA258587D58FA25B0ULL, (u64bit) 0xCFC9C903C906CA8FULL, (u64bit) 0x7C2929A429558D52ULL, (u64bit) 0x5A0A0A280A502214ULL,
(u64bit) 0x50B1B1FEB1E14F7FULL, (u64bit) 0xC9A0A0BAA0691A5DULL, (u64bit) 0x146B6BB16B7FDAD6ULL, (u64bit) 0xD985852E855CAB17ULL,
(u64bit) 0x3CBDBDCEBD817367ULL, (u64bit) 0x8F5D5D695DD234BAULL, (u64bit) 0x9010104010805020ULL, (u64bit) 0x07F4F4F7F4F303F5ULL,
(u64bit) 0xDDCBCB0BCB16C08BULL, (u64bit) 0xD33E3EF83EEDC67CULL, (u64bit) 0x2D0505140528110AULL, (u64bit) 0x78676781671FE6CEULL,
(u64bit) 0x97E4E4B7E47353D5ULL, (u64bit) 0x0227279C2725BB4EULL, (u64bit) 0x7341411941325882ULL, (u64bit) 0xA78B8B168B2C9D0BULL,
(u64bit) 0xF6A7A7A6A7510153ULL, (u64bit) 0xB27D7DE97DCF94FAULL, (u64bit) 0x4995956E95DCFB37ULL, (u64bit) 0x56D8D847D88E9FADULL,
(u64bit) 0x70FBFBCBFB8B30EBULL, (u64bit) 0xCDEEEE9FEE2371C1ULL, (u64bit) 0xBB7C7CED7CC791F8ULL, (u64bit) 0x716666856617E3CCULL,
(u64bit) 0x7BDDDD53DDA68EA7ULL, (u64bit) 0xAF17175C17B84B2EULL, (u64bit) 0x454747014702468EULL, (u64bit) 0x1A9E9E429E84DC21ULL,
(u64bit) 0xD4CACA0FCA1EC589ULL, (u64bit) 0x582D2DB42D75995AULL, (u64bit) 0x2EBFBFC6BF917963ULL, (u64bit) 0x3F07071C07381B0EULL,
(u64bit) 0xACADAD8EAD012347ULL, (u64bit) 0xB05A5A755AEA2FB4ULL, (u64bit) 0xEF838336836CB51BULL, (u64bit) 0xB63333CC3385FF66ULL,
(u64bit) 0x5C636391633FF2C6ULL, (u64bit) 0x1202020802100A04ULL, (u64bit) 0x93AAAA92AA393849ULL, (u64bit) 0xDE7171D971AFA8E2ULL,
(u64bit) 0xC6C8C807C80ECF8DULL, (u64bit) 0xD119196419C87D32ULL, (u64bit) 0x3B49493949727092ULL, (u64bit) 0x5FD9D943D9869AAFULL,
(u64bit) 0x31F2F2EFF2C31DF9ULL, (u64bit) 0xA8E3E3ABE34B48DBULL, (u64bit) 0xB95B5B715BE22AB6ULL, (u64bit) 0xBC88881A8834920DULL,
(u64bit) 0x3E9A9A529AA4C829ULL, (u64bit) 0x0B262698262DBE4CULL, (u64bit) 0xBF3232C8328DFA64ULL, (u64bit) 0x59B0B0FAB0E94A7DULL,
(u64bit) 0xF2E9E983E91B6ACFULL, (u64bit) 0x770F0F3C0F78331EULL, (u64bit) 0x33D5D573D5E6A6B7ULL, (u64bit) 0xF480803A8074BA1DULL,
(u64bit) 0x27BEBEC2BE997C61ULL, (u64bit) 0xEBCDCD13CD26DE87ULL, (u64bit) 0x893434D034BDE468ULL, (u64bit) 0x3248483D487A7590ULL,
(u64bit) 0x54FFFFDBFFAB24E3ULL, (u64bit) 0x8D7A7AF57AF78FF4ULL, (u64bit) 0x6490907A90F4EA3DULL, (u64bit) 0x9D5F5F615FC23EBEULL,
(u64bit) 0x3D202080201DA040ULL, (u64bit) 0x0F6868BD6867D5D0ULL, (u64bit) 0xCA1A1A681AD07234ULL, (u64bit) 0xB7AEAE82AE192C41ULL,
(u64bit) 0x7DB4B4EAB4C95E75ULL, (u64bit) 0xCE54544D549A19A8ULL, (u64bit) 0x7F93937693ECE53BULL, (u64bit) 0x2F222288220DAA44ULL,
(u64bit) 0x6364648D6407E9C8ULL, (u64bit) 0x2AF1F1E3F1DB12FFULL, (u64bit) 0xCC7373D173BFA2E6ULL, (u64bit) 0x8212124812905A24ULL,
(u64bit) 0x7A40401D403A5D80ULL, (u64bit) 0x4808082008402810ULL, (u64bit) 0x95C3C32BC356E89BULL, (u64bit) 0xDFECEC97EC337BC5ULL,
(u64bit) 0x4DDBDB4BDB9690ABULL, (u64bit) 0xC0A1A1BEA1611F5FULL, (u64bit) 0x918D8D0E8D1C8307ULL, (u64bit) 0xC83D3DF43DF5C97AULL,
(u64bit) 0x5B97976697CCF133ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0xF9CFCF1BCF36D483ULL, (u64bit) 0x6E2B2BAC2B458756ULL,
(u64bit) 0xE17676C57697B3ECULL, (u64bit) 0xE68282328264B019ULL, (u64bit) 0x28D6D67FD6FEA9B1ULL, (u64bit) 0xC31B1B6C1BD87736ULL,
(u64bit) 0x74B5B5EEB5C15B77ULL, (u64bit) 0xBEAFAF86AF112943ULL, (u64bit) 0x1D6A6AB56A77DFD4ULL, (u64bit) 0xEA50505D50BA0DA0ULL,
(u64bit) 0x5745450945124C8AULL, (u64bit) 0x38F3F3EBF3CB18FBULL, (u64bit) 0xAD3030C0309DF060ULL, (u64bit) 0xC4EFEF9BEF2B74C3ULL,
(u64bit) 0xDA3F3FFC3FE5C37EULL, (u64bit) 0xC755554955921CAAULL, (u64bit) 0xDBA2A2B2A2791059ULL, (u64bit) 0xE9EAEA8FEA0365C9ULL,
(u64bit) 0x6A656589650FECCAULL, (u64bit) 0x03BABAD2BAB96869ULL, (u64bit) 0x4A2F2FBC2F65935EULL, (u64bit) 0x8EC0C027C04EE79DULL,
(u64bit) 0x60DEDE5FDEBE81A1ULL, (u64bit) 0xFC1C1C701CE06C38ULL, (u64bit) 0x46FDFDD3FDBB2EE7ULL, (u64bit) 0x1F4D4D294D52649AULL,
(u64bit) 0x7692927292E4E039ULL, (u64bit) 0xFA7575C9758FBCEAULL, (u64bit) 0x3606061806301E0CULL, (u64bit) 0xAE8A8A128A249809ULL,
(u64bit) 0x4BB2B2F2B2F94079ULL, (u64bit) 0x85E6E6BFE66359D1ULL, (u64bit) 0x7E0E0E380E70361CULL, (u64bit) 0xE71F1F7C1FF8633EULL,
(u64bit) 0x556262956237F7C4ULL, (u64bit) 0x3AD4D477D4EEA3B5ULL, (u64bit) 0x81A8A89AA829324DULL, (u64bit) 0x5296966296C4F431ULL,
(u64bit) 0x62F9F9C3F99B3AEFULL, (u64bit) 0xA3C5C533C566F697ULL, (u64bit) 0x102525942535B14AULL, (u64bit) 0xAB59597959F220B2ULL,
(u64bit) 0xD084842A8454AE15ULL, (u64bit) 0xC57272D572B7A7E4ULL, (u64bit) 0xEC3939E439D5DD72ULL, (u64bit) 0x164C4C2D4C5A6198ULL,
(u64bit) 0x945E5E655ECA3BBCULL, (u64bit) 0x9F7878FD78E785F0ULL, (u64bit) 0xE53838E038DDD870ULL, (u64bit) 0x988C8C0A8C148605ULL,
(u64bit) 0x17D1D163D1C6B2BFULL, (u64bit) 0xE4A5A5AEA5410B57ULL, (u64bit) 0xA1E2E2AFE2434DD9ULL, (u64bit) 0x4E616199612FF8C2ULL,
(u64bit) 0x42B3B3F6B3F1457BULL, (u64bit) 0x342121842115A542ULL, (u64bit) 0x089C9C4A9C94D625ULL, (u64bit) 0xEE1E1E781EF0663CULL,
(u64bit) 0x6143431143225286ULL, (u64bit) 0xB1C7C73BC776FC93ULL, (u64bit) 0x4FFCFCD7FCB32BE5ULL, (u64bit) 0x2404041004201408ULL,
(u64bit) 0xE351515951B208A2ULL, (u64bit) 0x2599995E99BCC72FULL, (u64bit) 0x226D6DA96D4FC4DAULL, (u64bit) 0x650D0D340D68391AULL,
(u64bit) 0x79FAFACFFA8335E9ULL, (u64bit) 0x69DFDF5BDFB684A3ULL, (u64bit) 0xA97E7EE57ED79BFCULL, (u64bit) 0x19242490243DB448ULL,
(u64bit) 0xFE3B3BEC3BC5D776ULL, (u64bit) 0x9AABAB96AB313D4BULL, (u64bit) 0xF0CECE1FCE3ED181ULL, (u64bit) 0x9911114411885522ULL,
(u64bit) 0x838F8F068F0C8903ULL, (u64bit) 0x044E4E254E4A6B9CULL, (u64bit) 0x66B7B7E6B7D15173ULL, (u64bit) 0xE0EBEB8BEB0B60CBULL,
(u64bit) 0xC13C3CF03CFDCC78ULL, (u64bit) 0xFD81813E817CBF1FULL, (u64bit) 0x4094946A94D4FE35ULL, (u64bit) 0x1CF7F7FBF7EB0CF3ULL,
(u64bit) 0x18B9B9DEB9A1676FULL, (u64bit) 0x8B13134C13985F26ULL, (u64bit) 0x512C2CB02C7D9C58ULL, (u64bit) 0x05D3D36BD3D6B8BBULL,
(u64bit) 0x8CE7E7BBE76B5CD3ULL, (u64bit) 0x396E6EA56E57CBDCULL, (u64bit) 0xAAC4C437C46EF395ULL, (u64bit) 0x1B03030C03180F06ULL,
(u64bit) 0xDC565645568A13ACULL, (u64bit) 0x5E44440D441A4988ULL, (u64bit) 0xA07F7FE17FDF9EFEULL, (u64bit) 0x88A9A99EA921374FULL,
(u64bit) 0x672A2AA82A4D8254ULL, (u64bit) 0x0ABBBBD6BBB16D6BULL, (u64bit) 0x87C1C123C146E29FULL, (u64bit) 0xF153535153A202A6ULL,
(u64bit) 0x72DCDC57DCAE8BA5ULL, (u64bit) 0x530B0B2C0B582716ULL, (u64bit) 0x019D9D4E9D9CD327ULL, (u64bit) 0x2B6C6CAD6C47C1D8ULL,
(u64bit) 0xA43131C43195F562ULL, (u64bit) 0xF37474CD7487B9E8ULL, (u64bit) 0x15F6F6FFF6E309F1ULL, (u64bit) 0x4C464605460A438CULL,
(u64bit) 0xA5ACAC8AAC092645ULL, (u64bit) 0xB589891E893C970FULL, (u64bit) 0xB414145014A04428ULL, (u64bit) 0xBAE1E1A3E15B42DFULL,
(u64bit) 0xA616165816B04E2CULL, (u64bit) 0xF73A3AE83ACDD274ULL, (u64bit) 0x066969B9696FD0D2ULL, (u64bit) 0x4109092409482D12ULL,
(u64bit) 0xD77070DD70A7ADE0ULL, (u64bit) 0x6FB6B6E2B6D95471ULL, (u64bit) 0x1ED0D067D0CEB7BDULL, (u64bit) 0xD6EDED93ED3B7EC7ULL,
(u64bit) 0xE2CCCC17CC2EDB85ULL, (u64bit) 0x68424215422A5784ULL, (u64bit) 0x2C98985A98B4C22DULL, (u64bit) 0xEDA4A4AAA4490E55ULL,
(u64bit) 0x752828A0285D8850ULL, (u64bit) 0x865C5C6D5CDA31B8ULL, (u64bit) 0x6BF8F8C7F8933FEDULL, (u64bit) 0xC28686228644A411ULL };

const u64bit Whirlpool::C2[256] = {
(u64bit) 0x30D818186018C078ULL, (u64bit) 0x462623238C2305AFULL, (u64bit) 0x91B8C6C63FC67EF9ULL, (u64bit) 0xCDFBE8E887E8136FULL,
(u64bit) 0x13CB878726874CA1ULL, (u64bit) 0x6D11B8B8DAB8A962ULL, (u64bit) 0x0209010104010805ULL, (u64bit) 0x9E0D4F4F214F426EULL,
(u64bit) 0x6C9B3636D836ADEEULL, (u64bit) 0x51FFA6A6A2A65904ULL, (u64bit) 0xB90CD2D26FD2DEBDULL, (u64bit) 0xF70EF5F5F3F5FB06ULL,
(u64bit) 0xF2967979F979EF80ULL, (u64bit) 0xDE306F6FA16F5FCEULL, (u64bit) 0x3F6D91917E91FCEFULL, (u64bit) 0xA4F852525552AA07ULL,
(u64bit) 0xC04760609D6027FDULL, (u64bit) 0x6535BCBCCABC8976ULL, (u64bit) 0x2B379B9B569BACCDULL, (u64bit) 0x018A8E8E028E048CULL,
(u64bit) 0x5BD2A3A3B6A37115ULL, (u64bit) 0x186C0C0C300C603CULL, (u64bit) 0xF6847B7BF17BFF8AULL, (u64bit) 0x6A803535D435B5E1ULL,
(u64bit) 0x3AF51D1D741DE869ULL, (u64bit) 0xDDB3E0E0A7E05347ULL, (u64bit) 0xB321D7D77BD7F6ACULL, (u64bit) 0x999CC2C22FC25EEDULL,
(u64bit) 0x5C432E2EB82E6D96ULL, (u64bit) 0x96294B4B314B627AULL, (u64bit) 0xE15DFEFEDFFEA321ULL, (u64bit) 0xAED5575741578216ULL,
(u64bit) 0x2ABD15155415A841ULL, (u64bit) 0xEEE87777C1779FB6ULL, (u64bit) 0x6E923737DC37A5EBULL, (u64bit) 0xD79EE5E5B3E57B56ULL,
(u64bit) 0x23139F9F469F8CD9ULL, (u64bit) 0xFD23F0F0E7F0D317ULL, (u64bit) 0x94204A4A354A6A7FULL, (u64bit) 0xA944DADA4FDA9E95ULL,
(u64bit) 0xB0A258587D58FA25ULL, (u64bit) 0x8FCFC9C903C906CAULL, (u64bit) 0x527C2929A429558DULL, (u64bit) 0x145A0A0A280A5022ULL,
(u64bit) 0x7F50B1B1FEB1E14FULL, (u64bit) 0x5DC9A0A0BAA0691AULL, (u64bit) 0xD6146B6BB16B7FDAULL, (u64bit) 0x17D985852E855CABULL,
(u64bit) 0x673CBDBDCEBD8173ULL, (u64bit) 0xBA8F5D5D695DD234ULL, (u64bit) 0x2090101040108050ULL, (u64bit) 0xF507F4F4F7F4F303ULL,
(u64bit) 0x8BDDCBCB0BCB16C0ULL, (u64bit) 0x7CD33E3EF83EEDC6ULL, (u64bit) 0x0A2D050514052811ULL, (u64bit) 0xCE78676781671FE6ULL,
(u64bit) 0xD597E4E4B7E47353ULL, (u64bit) 0x4E0227279C2725BBULL, (u64bit) 0x8273414119413258ULL, (u64bit) 0x0BA78B8B168B2C9DULL,
(u64bit) 0x53F6A7A7A6A75101ULL, (u64bit) 0xFAB27D7DE97DCF94ULL, (u64bit) 0x374995956E95DCFBULL, (u64bit) 0xAD56D8D847D88E9FULL,
(u64bit) 0xEB70FBFBCBFB8B30ULL, (u64bit) 0xC1CDEEEE9FEE2371ULL, (u64bit) 0xF8BB7C7CED7CC791ULL, (u64bit) 0xCC716666856617E3ULL,
(u64bit) 0xA77BDDDD53DDA68EULL, (u64bit) 0x2EAF17175C17B84BULL, (u64bit) 0x8E45474701470246ULL, (u64bit) 0x211A9E9E429E84DCULL,
(u64bit) 0x89D4CACA0FCA1EC5ULL, (u64bit) 0x5A582D2DB42D7599ULL, (u64bit) 0x632EBFBFC6BF9179ULL, (u64bit) 0x0E3F07071C07381BULL,
(u64bit) 0x47ACADAD8EAD0123ULL, (u64bit) 0xB4B05A5A755AEA2FULL, (u64bit) 0x1BEF838336836CB5ULL, (u64bit) 0x66B63333CC3385FFULL,
(u64bit) 0xC65C636391633FF2ULL, (u64bit) 0x041202020802100AULL, (u64bit) 0x4993AAAA92AA3938ULL, (u64bit) 0xE2DE7171D971AFA8ULL,
(u64bit) 0x8DC6C8C807C80ECFULL, (u64bit) 0x32D119196419C87DULL, (u64bit) 0x923B494939497270ULL, (u64bit) 0xAF5FD9D943D9869AULL,
(u64bit) 0xF931F2F2EFF2C31DULL, (u64bit) 0xDBA8E3E3ABE34B48ULL, (u64bit) 0xB6B95B5B715BE22AULL, (u64bit) 0x0DBC88881A883492ULL,
(u64bit) 0x293E9A9A529AA4C8ULL, (u64bit) 0x4C0B262698262DBEULL, (u64bit) 0x64BF3232C8328DFAULL, (u64bit) 0x7D59B0B0FAB0E94AULL,
(u64bit) 0xCFF2E9E983E91B6AULL, (u64bit) 0x1E770F0F3C0F7833ULL, (u64bit) 0xB733D5D573D5E6A6ULL, (u64bit) 0x1DF480803A8074BAULL,
(u64bit) 0x6127BEBEC2BE997CULL, (u64bit) 0x87EBCDCD13CD26DEULL, (u64bit) 0x68893434D034BDE4ULL, (u64bit) 0x903248483D487A75ULL,
(u64bit) 0xE354FFFFDBFFAB24ULL, (u64bit) 0xF48D7A7AF57AF78FULL, (u64bit) 0x3D6490907A90F4EAULL, (u64bit) 0xBE9D5F5F615FC23EULL,
(u64bit) 0x403D202080201DA0ULL, (u64bit) 0xD00F6868BD6867D5ULL, (u64bit) 0x34CA1A1A681AD072ULL, (u64bit) 0x41B7AEAE82AE192CULL,
(u64bit) 0x757DB4B4EAB4C95EULL, (u64bit) 0xA8CE54544D549A19ULL, (u64bit) 0x3B7F93937693ECE5ULL, (u64bit) 0x442F222288220DAAULL,
(u64bit) 0xC86364648D6407E9ULL, (u64bit) 0xFF2AF1F1E3F1DB12ULL, (u64bit) 0xE6CC7373D173BFA2ULL, (u64bit) 0x248212124812905AULL,
(u64bit) 0x807A40401D403A5DULL, (u64bit) 0x1048080820084028ULL, (u64bit) 0x9B95C3C32BC356E8ULL, (u64bit) 0xC5DFECEC97EC337BULL,
(u64bit) 0xAB4DDBDB4BDB9690ULL, (u64bit) 0x5FC0A1A1BEA1611FULL, (u64bit) 0x07918D8D0E8D1C83ULL, (u64bit) 0x7AC83D3DF43DF5C9ULL,
(u64bit) 0x335B97976697CCF1ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0x83F9CFCF1BCF36D4ULL, (u64bit) 0x566E2B2BAC2B4587ULL,
(u64bit) 0xECE17676C57697B3ULL, (u64bit) 0x19E68282328264B0ULL, (u64bit) 0xB128D6D67FD6FEA9ULL, (u64bit) 0x36C31B1B6C1BD877ULL,
(u64bit) 0x7774B5B5EEB5C15BULL, (u64bit) 0x43BEAFAF86AF1129ULL, (u64bit) 0xD41D6A6AB56A77DFULL, (u64bit) 0xA0EA50505D50BA0DULL,
(u64bit) 0x8A5745450945124CULL, (u64bit) 0xFB38F3F3EBF3CB18ULL, (u64bit) 0x60AD3030C0309DF0ULL, (u64bit) 0xC3C4EFEF9BEF2B74ULL,
(u64bit) 0x7EDA3F3FFC3FE5C3ULL, (u64bit) 0xAAC755554955921CULL, (u64bit) 0x59DBA2A2B2A27910ULL, (u64bit) 0xC9E9EAEA8FEA0365ULL,
(u64bit) 0xCA6A656589650FECULL, (u64bit) 0x6903BABAD2BAB968ULL, (u64bit) 0x5E4A2F2FBC2F6593ULL, (u64bit) 0x9D8EC0C027C04EE7ULL,
(u64bit) 0xA160DEDE5FDEBE81ULL, (u64bit) 0x38FC1C1C701CE06CULL, (u64bit) 0xE746FDFDD3FDBB2EULL, (u64bit) 0x9A1F4D4D294D5264ULL,
(u64bit) 0x397692927292E4E0ULL, (u64bit) 0xEAFA7575C9758FBCULL, (u64bit) 0x0C3606061806301EULL, (u64bit) 0x09AE8A8A128A2498ULL,
(u64bit) 0x794BB2B2F2B2F940ULL, (u64bit) 0xD185E6E6BFE66359ULL, (u64bit) 0x1C7E0E0E380E7036ULL, (u64bit) 0x3EE71F1F7C1FF863ULL,
(u64bit) 0xC4556262956237F7ULL, (u64bit) 0xB53AD4D477D4EEA3ULL, (u64bit) 0x4D81A8A89AA82932ULL, (u64bit) 0x315296966296C4F4ULL,
(u64bit) 0xEF62F9F9C3F99B3AULL, (u64bit) 0x97A3C5C533C566F6ULL, (u64bit) 0x4A102525942535B1ULL, (u64bit) 0xB2AB59597959F220ULL,
(u64bit) 0x15D084842A8454AEULL, (u64bit) 0xE4C57272D572B7A7ULL, (u64bit) 0x72EC3939E439D5DDULL, (u64bit) 0x98164C4C2D4C5A61ULL,
(u64bit) 0xBC945E5E655ECA3BULL, (u64bit) 0xF09F7878FD78E785ULL, (u64bit) 0x70E53838E038DDD8ULL, (u64bit) 0x05988C8C0A8C1486ULL,
(u64bit) 0xBF17D1D163D1C6B2ULL, (u64bit) 0x57E4A5A5AEA5410BULL, (u64bit) 0xD9A1E2E2AFE2434DULL, (u64bit) 0xC24E616199612FF8ULL,
(u64bit) 0x7B42B3B3F6B3F145ULL, (u64bit) 0x42342121842115A5ULL, (u64bit) 0x25089C9C4A9C94D6ULL, (u64bit) 0x3CEE1E1E781EF066ULL,
(u64bit) 0x8661434311432252ULL, (u64bit) 0x93B1C7C73BC776FCULL, (u64bit) 0xE54FFCFCD7FCB32BULL, (u64bit) 0x0824040410042014ULL,
(u64bit) 0xA2E351515951B208ULL, (u64bit) 0x2F2599995E99BCC7ULL, (u64bit) 0xDA226D6DA96D4FC4ULL, (u64bit) 0x1A650D0D340D6839ULL,
(u64bit) 0xE979FAFACFFA8335ULL, (u64bit) 0xA369DFDF5BDFB684ULL, (u64bit) 0xFCA97E7EE57ED79BULL, (u64bit) 0x4819242490243DB4ULL,
(u64bit) 0x76FE3B3BEC3BC5D7ULL, (u64bit) 0x4B9AABAB96AB313DULL, (u64bit) 0x81F0CECE1FCE3ED1ULL, (u64bit) 0x2299111144118855ULL,
(u64bit) 0x03838F8F068F0C89ULL, (u64bit) 0x9C044E4E254E4A6BULL, (u64bit) 0x7366B7B7E6B7D151ULL, (u64bit) 0xCBE0EBEB8BEB0B60ULL,
(u64bit) 0x78C13C3CF03CFDCCULL, (u64bit) 0x1FFD81813E817CBFULL, (u64bit) 0x354094946A94D4FEULL, (u64bit) 0xF31CF7F7FBF7EB0CULL,
(u64bit) 0x6F18B9B9DEB9A167ULL, (u64bit) 0x268B13134C13985FULL, (u64bit) 0x58512C2CB02C7D9CULL, (u64bit) 0xBB05D3D36BD3D6B8ULL,
(u64bit) 0xD38CE7E7BBE76B5CULL, (u64bit) 0xDC396E6EA56E57CBULL, (u64bit) 0x95AAC4C437C46EF3ULL, (u64bit) 0x061B03030C03180FULL,
(u64bit) 0xACDC565645568A13ULL, (u64bit) 0x885E44440D441A49ULL, (u64bit) 0xFEA07F7FE17FDF9EULL, (u64bit) 0x4F88A9A99EA92137ULL,
(u64bit) 0x54672A2AA82A4D82ULL, (u64bit) 0x6B0ABBBBD6BBB16DULL, (u64bit) 0x9F87C1C123C146E2ULL, (u64bit) 0xA6F153535153A202ULL,
(u64bit) 0xA572DCDC57DCAE8BULL, (u64bit) 0x16530B0B2C0B5827ULL, (u64bit) 0x27019D9D4E9D9CD3ULL, (u64bit) 0xD82B6C6CAD6C47C1ULL,
(u64bit) 0x62A43131C43195F5ULL, (u64bit) 0xE8F37474CD7487B9ULL, (u64bit) 0xF115F6F6FFF6E309ULL, (u64bit) 0x8C4C464605460A43ULL,
(u64bit) 0x45A5ACAC8AAC0926ULL, (u64bit) 0x0FB589891E893C97ULL, (u64bit) 0x28B414145014A044ULL, (u64bit) 0xDFBAE1E1A3E15B42ULL,
(u64bit) 0x2CA616165816B04EULL, (u64bit) 0x74F73A3AE83ACDD2ULL, (u64bit) 0xD2066969B9696FD0ULL, (u64bit) 0x124109092409482DULL,
(u64bit) 0xE0D77070DD70A7ADULL, (u64bit) 0x716FB6B6E2B6D954ULL, (u64bit) 0xBD1ED0D067D0CEB7ULL, (u64bit) 0xC7D6EDED93ED3B7EULL,
(u64bit) 0x85E2CCCC17CC2EDBULL, (u64bit) 0x8468424215422A57ULL, (u64bit) 0x2D2C98985A98B4C2ULL, (u64bit) 0x55EDA4A4AAA4490EULL,
(u64bit) 0x50752828A0285D88ULL, (u64bit) 0xB8865C5C6D5CDA31ULL, (u64bit) 0xED6BF8F8C7F8933FULL, (u64bit) 0x11C28686228644A4ULL };

const u64bit Whirlpool::C3[256] = {
(u64bit) 0x7830D818186018C0ULL, (u64bit) 0xAF462623238C2305ULL, (u64bit) 0xF991B8C6C63FC67EULL, (u64bit) 0x6FCDFBE8E887E813ULL,
(u64bit) 0xA113CB878726874CULL, (u64bit) 0x626D11B8B8DAB8A9ULL, (u64bit) 0x0502090101040108ULL, (u64bit) 0x6E9E0D4F4F214F42ULL,
(u64bit) 0xEE6C9B3636D836ADULL, (u64bit) 0x0451FFA6A6A2A659ULL, (u64bit) 0xBDB90CD2D26FD2DEULL, (u64bit) 0x06F70EF5F5F3F5FBULL,
(u64bit) 0x80F2967979F979EFULL, (u64bit) 0xCEDE306F6FA16F5FULL, (u64bit) 0xEF3F6D91917E91FCULL, (u64bit) 0x07A4F852525552AAULL,
(u64bit) 0xFDC04760609D6027ULL, (u64bit) 0x766535BCBCCABC89ULL, (u64bit) 0xCD2B379B9B569BACULL, (u64bit) 0x8C018A8E8E028E04ULL,
(u64bit) 0x155BD2A3A3B6A371ULL, (u64bit) 0x3C186C0C0C300C60ULL, (u64bit) 0x8AF6847B7BF17BFFULL, (u64bit) 0xE16A803535D435B5ULL,
(u64bit) 0x693AF51D1D741DE8ULL, (u64bit) 0x47DDB3E0E0A7E053ULL, (u64bit) 0xACB321D7D77BD7F6ULL, (u64bit) 0xED999CC2C22FC25EULL,
(u64bit) 0x965C432E2EB82E6DULL, (u64bit) 0x7A96294B4B314B62ULL, (u64bit) 0x21E15DFEFEDFFEA3ULL, (u64bit) 0x16AED55757415782ULL,
(u64bit) 0x412ABD15155415A8ULL, (u64bit) 0xB6EEE87777C1779FULL, (u64bit) 0xEB6E923737DC37A5ULL, (u64bit) 0x56D79EE5E5B3E57BULL,
(u64bit) 0xD923139F9F469F8CULL, (u64bit) 0x17FD23F0F0E7F0D3ULL, (u64bit) 0x7F94204A4A354A6AULL, (u64bit) 0x95A944DADA4FDA9EULL,
(u64bit) 0x25B0A258587D58FAULL, (u64bit) 0xCA8FCFC9C903C906ULL, (u64bit) 0x8D527C2929A42955ULL, (u64bit) 0x22145A0A0A280A50ULL,
(u64bit) 0x4F7F50B1B1FEB1E1ULL, (u64bit) 0x1A5DC9A0A0BAA069ULL, (u64bit) 0xDAD6146B6BB16B7FULL, (u64bit) 0xAB17D985852E855CULL,
(u64bit) 0x73673CBDBDCEBD81ULL, (u64bit) 0x34BA8F5D5D695DD2ULL, (u64bit) 0x5020901010401080ULL, (u64bit) 0x03F507F4F4F7F4F3ULL,
(u64bit) 0xC08BDDCBCB0BCB16ULL, (u64bit) 0xC67CD33E3EF83EEDULL, (u64bit) 0x110A2D0505140528ULL, (u64bit) 0xE6CE78676781671FULL,
(u64bit) 0x53D597E4E4B7E473ULL, (u64bit) 0xBB4E0227279C2725ULL, (u64bit) 0x5882734141194132ULL, (u64bit) 0x9D0BA78B8B168B2CULL,
(u64bit) 0x0153F6A7A7A6A751ULL, (u64bit) 0x94FAB27D7DE97DCFULL, (u64bit) 0xFB374995956E95DCULL, (u64bit) 0x9FAD56D8D847D88EULL,
(u64bit) 0x30EB70FBFBCBFB8BULL, (u64bit) 0x71C1CDEEEE9FEE23ULL, (u64bit) 0x91F8BB7C7CED7CC7ULL, (u64bit) 0xE3CC716666856617ULL,
(u64bit) 0x8EA77BDDDD53DDA6ULL, (u64bit) 0x4B2EAF17175C17B8ULL, (u64bit) 0x468E454747014702ULL, (u64bit) 0xDC211A9E9E429E84ULL,
(u64bit) 0xC589D4CACA0FCA1EULL, (u64bit) 0x995A582D2DB42D75ULL, (u64bit) 0x79632EBFBFC6BF91ULL, (u64bit) 0x1B0E3F07071C0738ULL,
(u64bit) 0x2347ACADAD8EAD01ULL, (u64bit) 0x2FB4B05A5A755AEAULL, (u64bit) 0xB51BEF838336836CULL, (u64bit) 0xFF66B63333CC3385ULL,
(u64bit) 0xF2C65C636391633FULL, (u64bit) 0x0A04120202080210ULL, (u64bit) 0x384993AAAA92AA39ULL, (u64bit) 0xA8E2DE7171D971AFULL,
(u64bit) 0xCF8DC6C8C807C80EULL, (u64bit) 0x7D32D119196419C8ULL, (u64bit) 0x70923B4949394972ULL, (u64bit) 0x9AAF5FD9D943D986ULL,
(u64bit) 0x1DF931F2F2EFF2C3ULL, (u64bit) 0x48DBA8E3E3ABE34BULL, (u64bit) 0x2AB6B95B5B715BE2ULL, (u64bit) 0x920DBC88881A8834ULL,
(u64bit) 0xC8293E9A9A529AA4ULL, (u64bit) 0xBE4C0B262698262DULL, (u64bit) 0xFA64BF3232C8328DULL, (u64bit) 0x4A7D59B0B0FAB0E9ULL,
(u64bit) 0x6ACFF2E9E983E91BULL, (u64bit) 0x331E770F0F3C0F78ULL, (u64bit) 0xA6B733D5D573D5E6ULL, (u64bit) 0xBA1DF480803A8074ULL,
(u64bit) 0x7C6127BEBEC2BE99ULL, (u64bit) 0xDE87EBCDCD13CD26ULL, (u64bit) 0xE468893434D034BDULL, (u64bit) 0x75903248483D487AULL,
(u64bit) 0x24E354FFFFDBFFABULL, (u64bit) 0x8FF48D7A7AF57AF7ULL, (u64bit) 0xEA3D6490907A90F4ULL, (u64bit) 0x3EBE9D5F5F615FC2ULL,
(u64bit) 0xA0403D202080201DULL, (u64bit) 0xD5D00F6868BD6867ULL, (u64bit) 0x7234CA1A1A681AD0ULL, (u64bit) 0x2C41B7AEAE82AE19ULL,
(u64bit) 0x5E757DB4B4EAB4C9ULL, (u64bit) 0x19A8CE54544D549AULL, (u64bit) 0xE53B7F93937693ECULL, (u64bit) 0xAA442F222288220DULL,
(u64bit) 0xE9C86364648D6407ULL, (u64bit) 0x12FF2AF1F1E3F1DBULL, (u64bit) 0xA2E6CC7373D173BFULL, (u64bit) 0x5A24821212481290ULL,
(u64bit) 0x5D807A40401D403AULL, (u64bit) 0x2810480808200840ULL, (u64bit) 0xE89B95C3C32BC356ULL, (u64bit) 0x7BC5DFECEC97EC33ULL,
(u64bit) 0x90AB4DDBDB4BDB96ULL, (u64bit) 0x1F5FC0A1A1BEA161ULL, (u64bit) 0x8307918D8D0E8D1CULL, (u64bit) 0xC97AC83D3DF43DF5ULL,
(u64bit) 0xF1335B97976697CCULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0xD483F9CFCF1BCF36ULL, (u64bit) 0x87566E2B2BAC2B45ULL,
(u64bit) 0xB3ECE17676C57697ULL, (u64bit) 0xB019E68282328264ULL, (u64bit) 0xA9B128D6D67FD6FEULL, (u64bit) 0x7736C31B1B6C1BD8ULL,
(u64bit) 0x5B7774B5B5EEB5C1ULL, (u64bit) 0x2943BEAFAF86AF11ULL, (u64bit) 0xDFD41D6A6AB56A77ULL, (u64bit) 0x0DA0EA50505D50BAULL,
(u64bit) 0x4C8A574545094512ULL, (u64bit) 0x18FB38F3F3EBF3CBULL, (u64bit) 0xF060AD3030C0309DULL, (u64bit) 0x74C3C4EFEF9BEF2BULL,
(u64bit) 0xC37EDA3F3FFC3FE5ULL, (u64bit) 0x1CAAC75555495592ULL, (u64bit) 0x1059DBA2A2B2A279ULL, (u64bit) 0x65C9E9EAEA8FEA03ULL,
(u64bit) 0xECCA6A656589650FULL, (u64bit) 0x686903BABAD2BAB9ULL, (u64bit) 0x935E4A2F2FBC2F65ULL, (u64bit) 0xE79D8EC0C027C04EULL,
(u64bit) 0x81A160DEDE5FDEBEULL, (u64bit) 0x6C38FC1C1C701CE0ULL, (u64bit) 0x2EE746FDFDD3FDBBULL, (u64bit) 0x649A1F4D4D294D52ULL,
(u64bit) 0xE0397692927292E4ULL, (u64bit) 0xBCEAFA7575C9758FULL, (u64bit) 0x1E0C360606180630ULL, (u64bit) 0x9809AE8A8A128A24ULL,
(u64bit) 0x40794BB2B2F2B2F9ULL, (u64bit) 0x59D185E6E6BFE663ULL, (u64bit) 0x361C7E0E0E380E70ULL, (u64bit) 0x633EE71F1F7C1FF8ULL,
(u64bit) 0xF7C4556262956237ULL, (u64bit) 0xA3B53AD4D477D4EEULL, (u64bit) 0x324D81A8A89AA829ULL, (u64bit) 0xF4315296966296C4ULL,
(u64bit) 0x3AEF62F9F9C3F99BULL, (u64bit) 0xF697A3C5C533C566ULL, (u64bit) 0xB14A102525942535ULL, (u64bit) 0x20B2AB59597959F2ULL,
(u64bit) 0xAE15D084842A8454ULL, (u64bit) 0xA7E4C57272D572B7ULL, (u64bit) 0xDD72EC3939E439D5ULL, (u64bit) 0x6198164C4C2D4C5AULL,
(u64bit) 0x3BBC945E5E655ECAULL, (u64bit) 0x85F09F7878FD78E7ULL, (u64bit) 0xD870E53838E038DDULL, (u64bit) 0x8605988C8C0A8C14ULL,
(u64bit) 0xB2BF17D1D163D1C6ULL, (u64bit) 0x0B57E4A5A5AEA541ULL, (u64bit) 0x4DD9A1E2E2AFE243ULL, (u64bit) 0xF8C24E616199612FULL,
(u64bit) 0x457B42B3B3F6B3F1ULL, (u64bit) 0xA542342121842115ULL, (u64bit) 0xD625089C9C4A9C94ULL, (u64bit) 0x663CEE1E1E781EF0ULL,
(u64bit) 0x5286614343114322ULL, (u64bit) 0xFC93B1C7C73BC776ULL, (u64bit) 0x2BE54FFCFCD7FCB3ULL, (u64bit) 0x1408240404100420ULL,
(u64bit) 0x08A2E351515951B2ULL, (u64bit) 0xC72F2599995E99BCULL, (u64bit) 0xC4DA226D6DA96D4FULL, (u64bit) 0x391A650D0D340D68ULL,
(u64bit) 0x35E979FAFACFFA83ULL, (u64bit) 0x84A369DFDF5BDFB6ULL, (u64bit) 0x9BFCA97E7EE57ED7ULL, (u64bit) 0xB44819242490243DULL,
(u64bit) 0xD776FE3B3BEC3BC5ULL, (u64bit) 0x3D4B9AABAB96AB31ULL, (u64bit) 0xD181F0CECE1FCE3EULL, (u64bit) 0x5522991111441188ULL,
(u64bit) 0x8903838F8F068F0CULL, (u64bit) 0x6B9C044E4E254E4AULL, (u64bit) 0x517366B7B7E6B7D1ULL, (u64bit) 0x60CBE0EBEB8BEB0BULL,
(u64bit) 0xCC78C13C3CF03CFDULL, (u64bit) 0xBF1FFD81813E817CULL, (u64bit) 0xFE354094946A94D4ULL, (u64bit) 0x0CF31CF7F7FBF7EBULL,
(u64bit) 0x676F18B9B9DEB9A1ULL, (u64bit) 0x5F268B13134C1398ULL, (u64bit) 0x9C58512C2CB02C7DULL, (u64bit) 0xB8BB05D3D36BD3D6ULL,
(u64bit) 0x5CD38CE7E7BBE76BULL, (u64bit) 0xCBDC396E6EA56E57ULL, (u64bit) 0xF395AAC4C437C46EULL, (u64bit) 0x0F061B03030C0318ULL,
(u64bit) 0x13ACDC565645568AULL, (u64bit) 0x49885E44440D441AULL, (u64bit) 0x9EFEA07F7FE17FDFULL, (u64bit) 0x374F88A9A99EA921ULL,
(u64bit) 0x8254672A2AA82A4DULL, (u64bit) 0x6D6B0ABBBBD6BBB1ULL, (u64bit) 0xE29F87C1C123C146ULL, (u64bit) 0x02A6F153535153A2ULL,
(u64bit) 0x8BA572DCDC57DCAEULL, (u64bit) 0x2716530B0B2C0B58ULL, (u64bit) 0xD327019D9D4E9D9CULL, (u64bit) 0xC1D82B6C6CAD6C47ULL,
(u64bit) 0xF562A43131C43195ULL, (u64bit) 0xB9E8F37474CD7487ULL, (u64bit) 0x09F115F6F6FFF6E3ULL, (u64bit) 0x438C4C464605460AULL,
(u64bit) 0x2645A5ACAC8AAC09ULL, (u64bit) 0x970FB589891E893CULL, (u64bit) 0x4428B414145014A0ULL, (u64bit) 0x42DFBAE1E1A3E15BULL,
(u64bit) 0x4E2CA616165816B0ULL, (u64bit) 0xD274F73A3AE83ACDULL, (u64bit) 0xD0D2066969B9696FULL, (u64bit) 0x2D12410909240948ULL,
(u64bit) 0xADE0D77070DD70A7ULL, (u64bit) 0x54716FB6B6E2B6D9ULL, (u64bit) 0xB7BD1ED0D067D0CEULL, (u64bit) 0x7EC7D6EDED93ED3BULL,
(u64bit) 0xDB85E2CCCC17CC2EULL, (u64bit) 0x578468424215422AULL, (u64bit) 0xC22D2C98985A98B4ULL, (u64bit) 0x0E55EDA4A4AAA449ULL,
(u64bit) 0x8850752828A0285DULL, (u64bit) 0x31B8865C5C6D5CDAULL, (u64bit) 0x3FED6BF8F8C7F893ULL, (u64bit) 0xA411C28686228644ULL };

const u64bit Whirlpool::C4[256] = {
(u64bit) 0xC07830D818186018ULL, (u64bit) 0x05AF462623238C23ULL, (u64bit) 0x7EF991B8C6C63FC6ULL, (u64bit) 0x136FCDFBE8E887E8ULL,
(u64bit) 0x4CA113CB87872687ULL, (u64bit) 0xA9626D11B8B8DAB8ULL, (u64bit) 0x0805020901010401ULL, (u64bit) 0x426E9E0D4F4F214FULL,
(u64bit) 0xADEE6C9B3636D836ULL, (u64bit) 0x590451FFA6A6A2A6ULL, (u64bit) 0xDEBDB90CD2D26FD2ULL, (u64bit) 0xFB06F70EF5F5F3F5ULL,
(u64bit) 0xEF80F2967979F979ULL, (u64bit) 0x5FCEDE306F6FA16FULL, (u64bit) 0xFCEF3F6D91917E91ULL, (u64bit) 0xAA07A4F852525552ULL,
(u64bit) 0x27FDC04760609D60ULL, (u64bit) 0x89766535BCBCCABCULL, (u64bit) 0xACCD2B379B9B569BULL, (u64bit) 0x048C018A8E8E028EULL,
(u64bit) 0x71155BD2A3A3B6A3ULL, (u64bit) 0x603C186C0C0C300CULL, (u64bit) 0xFF8AF6847B7BF17BULL, (u64bit) 0xB5E16A803535D435ULL,
(u64bit) 0xE8693AF51D1D741DULL, (u64bit) 0x5347DDB3E0E0A7E0ULL, (u64bit) 0xF6ACB321D7D77BD7ULL, (u64bit) 0x5EED999CC2C22FC2ULL,
(u64bit) 0x6D965C432E2EB82EULL, (u64bit) 0x627A96294B4B314BULL, (u64bit) 0xA321E15DFEFEDFFEULL, (u64bit) 0x8216AED557574157ULL,
(u64bit) 0xA8412ABD15155415ULL, (u64bit) 0x9FB6EEE87777C177ULL, (u64bit) 0xA5EB6E923737DC37ULL, (u64bit) 0x7B56D79EE5E5B3E5ULL,
(u64bit) 0x8CD923139F9F469FULL, (u64bit) 0xD317FD23F0F0E7F0ULL, (u64bit) 0x6A7F94204A4A354AULL, (u64bit) 0x9E95A944DADA4FDAULL,
(u64bit) 0xFA25B0A258587D58ULL, (u64bit) 0x06CA8FCFC9C903C9ULL, (u64bit) 0x558D527C2929A429ULL, (u64bit) 0x5022145A0A0A280AULL,
(u64bit) 0xE14F7F50B1B1FEB1ULL, (u64bit) 0x691A5DC9A0A0BAA0ULL, (u64bit) 0x7FDAD6146B6BB16BULL, (u64bit) 0x5CAB17D985852E85ULL,
(u64bit) 0x8173673CBDBDCEBDULL, (u64bit) 0xD234BA8F5D5D695DULL, (u64bit) 0x8050209010104010ULL, (u64bit) 0xF303F507F4F4F7F4ULL,
(u64bit) 0x16C08BDDCBCB0BCBULL, (u64bit) 0xEDC67CD33E3EF83EULL, (u64bit) 0x28110A2D05051405ULL, (u64bit) 0x1FE6CE7867678167ULL,
(u64bit) 0x7353D597E4E4B7E4ULL, (u64bit) 0x25BB4E0227279C27ULL, (u64bit) 0x3258827341411941ULL, (u64bit) 0x2C9D0BA78B8B168BULL,
(u64bit) 0x510153F6A7A7A6A7ULL, (u64bit) 0xCF94FAB27D7DE97DULL, (u64bit) 0xDCFB374995956E95ULL, (u64bit) 0x8E9FAD56D8D847D8ULL,
(u64bit) 0x8B30EB70FBFBCBFBULL, (u64bit) 0x2371C1CDEEEE9FEEULL, (u64bit) 0xC791F8BB7C7CED7CULL, (u64bit) 0x17E3CC7166668566ULL,
(u64bit) 0xA68EA77BDDDD53DDULL, (u64bit) 0xB84B2EAF17175C17ULL, (u64bit) 0x02468E4547470147ULL, (u64bit) 0x84DC211A9E9E429EULL,
(u64bit) 0x1EC589D4CACA0FCAULL, (u64bit) 0x75995A582D2DB42DULL, (u64bit) 0x9179632EBFBFC6BFULL, (u64bit) 0x381B0E3F07071C07ULL,
(u64bit) 0x012347ACADAD8EADULL, (u64bit) 0xEA2FB4B05A5A755AULL, (u64bit) 0x6CB51BEF83833683ULL, (u64bit) 0x85FF66B63333CC33ULL,
(u64bit) 0x3FF2C65C63639163ULL, (u64bit) 0x100A041202020802ULL, (u64bit) 0x39384993AAAA92AAULL, (u64bit) 0xAFA8E2DE7171D971ULL,
(u64bit) 0x0ECF8DC6C8C807C8ULL, (u64bit) 0xC87D32D119196419ULL, (u64bit) 0x7270923B49493949ULL, (u64bit) 0x869AAF5FD9D943D9ULL,
(u64bit) 0xC31DF931F2F2EFF2ULL, (u64bit) 0x4B48DBA8E3E3ABE3ULL, (u64bit) 0xE22AB6B95B5B715BULL, (u64bit) 0x34920DBC88881A88ULL,
(u64bit) 0xA4C8293E9A9A529AULL, (u64bit) 0x2DBE4C0B26269826ULL, (u64bit) 0x8DFA64BF3232C832ULL, (u64bit) 0xE94A7D59B0B0FAB0ULL,
(u64bit) 0x1B6ACFF2E9E983E9ULL, (u64bit) 0x78331E770F0F3C0FULL, (u64bit) 0xE6A6B733D5D573D5ULL, (u64bit) 0x74BA1DF480803A80ULL,
(u64bit) 0x997C6127BEBEC2BEULL, (u64bit) 0x26DE87EBCDCD13CDULL, (u64bit) 0xBDE468893434D034ULL, (u64bit) 0x7A75903248483D48ULL,
(u64bit) 0xAB24E354FFFFDBFFULL, (u64bit) 0xF78FF48D7A7AF57AULL, (u64bit) 0xF4EA3D6490907A90ULL, (u64bit) 0xC23EBE9D5F5F615FULL,
(u64bit) 0x1DA0403D20208020ULL, (u64bit) 0x67D5D00F6868BD68ULL, (u64bit) 0xD07234CA1A1A681AULL, (u64bit) 0x192C41B7AEAE82AEULL,
(u64bit) 0xC95E757DB4B4EAB4ULL, (u64bit) 0x9A19A8CE54544D54ULL, (u64bit) 0xECE53B7F93937693ULL, (u64bit) 0x0DAA442F22228822ULL,
(u64bit) 0x07E9C86364648D64ULL, (u64bit) 0xDB12FF2AF1F1E3F1ULL, (u64bit) 0xBFA2E6CC7373D173ULL, (u64bit) 0x905A248212124812ULL,
(u64bit) 0x3A5D807A40401D40ULL, (u64bit) 0x4028104808082008ULL, (u64bit) 0x56E89B95C3C32BC3ULL, (u64bit) 0x337BC5DFECEC97ECULL,
(u64bit) 0x9690AB4DDBDB4BDBULL, (u64bit) 0x611F5FC0A1A1BEA1ULL, (u64bit) 0x1C8307918D8D0E8DULL, (u64bit) 0xF5C97AC83D3DF43DULL,
(u64bit) 0xCCF1335B97976697ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0x36D483F9CFCF1BCFULL, (u64bit) 0x4587566E2B2BAC2BULL,
(u64bit) 0x97B3ECE17676C576ULL, (u64bit) 0x64B019E682823282ULL, (u64bit) 0xFEA9B128D6D67FD6ULL, (u64bit) 0xD87736C31B1B6C1BULL,
(u64bit) 0xC15B7774B5B5EEB5ULL, (u64bit) 0x112943BEAFAF86AFULL, (u64bit) 0x77DFD41D6A6AB56AULL, (u64bit) 0xBA0DA0EA50505D50ULL,
(u64bit) 0x124C8A5745450945ULL, (u64bit) 0xCB18FB38F3F3EBF3ULL, (u64bit) 0x9DF060AD3030C030ULL, (u64bit) 0x2B74C3C4EFEF9BEFULL,
(u64bit) 0xE5C37EDA3F3FFC3FULL, (u64bit) 0x921CAAC755554955ULL, (u64bit) 0x791059DBA2A2B2A2ULL, (u64bit) 0x0365C9E9EAEA8FEAULL,
(u64bit) 0x0FECCA6A65658965ULL, (u64bit) 0xB9686903BABAD2BAULL, (u64bit) 0x65935E4A2F2FBC2FULL, (u64bit) 0x4EE79D8EC0C027C0ULL,
(u64bit) 0xBE81A160DEDE5FDEULL, (u64bit) 0xE06C38FC1C1C701CULL, (u64bit) 0xBB2EE746FDFDD3FDULL, (u64bit) 0x52649A1F4D4D294DULL,
(u64bit) 0xE4E0397692927292ULL, (u64bit) 0x8FBCEAFA7575C975ULL, (u64bit) 0x301E0C3606061806ULL, (u64bit) 0x249809AE8A8A128AULL,
(u64bit) 0xF940794BB2B2F2B2ULL, (u64bit) 0x6359D185E6E6BFE6ULL, (u64bit) 0x70361C7E0E0E380EULL, (u64bit) 0xF8633EE71F1F7C1FULL,
(u64bit) 0x37F7C45562629562ULL, (u64bit) 0xEEA3B53AD4D477D4ULL, (u64bit) 0x29324D81A8A89AA8ULL, (u64bit) 0xC4F4315296966296ULL,
(u64bit) 0x9B3AEF62F9F9C3F9ULL, (u64bit) 0x66F697A3C5C533C5ULL, (u64bit) 0x35B14A1025259425ULL, (u64bit) 0xF220B2AB59597959ULL,
(u64bit) 0x54AE15D084842A84ULL, (u64bit) 0xB7A7E4C57272D572ULL, (u64bit) 0xD5DD72EC3939E439ULL, (u64bit) 0x5A6198164C4C2D4CULL,
(u64bit) 0xCA3BBC945E5E655EULL, (u64bit) 0xE785F09F7878FD78ULL, (u64bit) 0xDDD870E53838E038ULL, (u64bit) 0x148605988C8C0A8CULL,
(u64bit) 0xC6B2BF17D1D163D1ULL, (u64bit) 0x410B57E4A5A5AEA5ULL, (u64bit) 0x434DD9A1E2E2AFE2ULL, (u64bit) 0x2FF8C24E61619961ULL,
(u64bit) 0xF1457B42B3B3F6B3ULL, (u64bit) 0x15A5423421218421ULL, (u64bit) 0x94D625089C9C4A9CULL, (u64bit) 0xF0663CEE1E1E781EULL,
(u64bit) 0x2252866143431143ULL, (u64bit) 0x76FC93B1C7C73BC7ULL, (u64bit) 0xB32BE54FFCFCD7FCULL, (u64bit) 0x2014082404041004ULL,
(u64bit) 0xB208A2E351515951ULL, (u64bit) 0xBCC72F2599995E99ULL, (u64bit) 0x4FC4DA226D6DA96DULL, (u64bit) 0x68391A650D0D340DULL,
(u64bit) 0x8335E979FAFACFFAULL, (u64bit) 0xB684A369DFDF5BDFULL, (u64bit) 0xD79BFCA97E7EE57EULL, (u64bit) 0x3DB4481924249024ULL,
(u64bit) 0xC5D776FE3B3BEC3BULL, (u64bit) 0x313D4B9AABAB96ABULL, (u64bit) 0x3ED181F0CECE1FCEULL, (u64bit) 0x8855229911114411ULL,
(u64bit) 0x0C8903838F8F068FULL, (u64bit) 0x4A6B9C044E4E254EULL, (u64bit) 0xD1517366B7B7E6B7ULL, (u64bit) 0x0B60CBE0EBEB8BEBULL,
(u64bit) 0xFDCC78C13C3CF03CULL, (u64bit) 0x7CBF1FFD81813E81ULL, (u64bit) 0xD4FE354094946A94ULL, (u64bit) 0xEB0CF31CF7F7FBF7ULL,
(u64bit) 0xA1676F18B9B9DEB9ULL, (u64bit) 0x985F268B13134C13ULL, (u64bit) 0x7D9C58512C2CB02CULL, (u64bit) 0xD6B8BB05D3D36BD3ULL,
(u64bit) 0x6B5CD38CE7E7BBE7ULL, (u64bit) 0x57CBDC396E6EA56EULL, (u64bit) 0x6EF395AAC4C437C4ULL, (u64bit) 0x180F061B03030C03ULL,
(u64bit) 0x8A13ACDC56564556ULL, (u64bit) 0x1A49885E44440D44ULL, (u64bit) 0xDF9EFEA07F7FE17FULL, (u64bit) 0x21374F88A9A99EA9ULL,
(u64bit) 0x4D8254672A2AA82AULL, (u64bit) 0xB16D6B0ABBBBD6BBULL, (u64bit) 0x46E29F87C1C123C1ULL, (u64bit) 0xA202A6F153535153ULL,
(u64bit) 0xAE8BA572DCDC57DCULL, (u64bit) 0x582716530B0B2C0BULL, (u64bit) 0x9CD327019D9D4E9DULL, (u64bit) 0x47C1D82B6C6CAD6CULL,
(u64bit) 0x95F562A43131C431ULL, (u64bit) 0x87B9E8F37474CD74ULL, (u64bit) 0xE309F115F6F6FFF6ULL, (u64bit) 0x0A438C4C46460546ULL,
(u64bit) 0x092645A5ACAC8AACULL, (u64bit) 0x3C970FB589891E89ULL, (u64bit) 0xA04428B414145014ULL, (u64bit) 0x5B42DFBAE1E1A3E1ULL,
(u64bit) 0xB04E2CA616165816ULL, (u64bit) 0xCDD274F73A3AE83AULL, (u64bit) 0x6FD0D2066969B969ULL, (u64bit) 0x482D124109092409ULL,
(u64bit) 0xA7ADE0D77070DD70ULL, (u64bit) 0xD954716FB6B6E2B6ULL, (u64bit) 0xCEB7BD1ED0D067D0ULL, (u64bit) 0x3B7EC7D6EDED93EDULL,
(u64bit) 0x2EDB85E2CCCC17CCULL, (u64bit) 0x2A57846842421542ULL, (u64bit) 0xB4C22D2C98985A98ULL, (u64bit) 0x490E55EDA4A4AAA4ULL,
(u64bit) 0x5D8850752828A028ULL, (u64bit) 0xDA31B8865C5C6D5CULL, (u64bit) 0x933FED6BF8F8C7F8ULL, (u64bit) 0x44A411C286862286ULL };

const u64bit Whirlpool::C5[256] = {
(u64bit) 0x18C07830D8181860ULL, (u64bit) 0x2305AF462623238CULL, (u64bit) 0xC67EF991B8C6C63FULL, (u64bit) 0xE8136FCDFBE8E887ULL,
(u64bit) 0x874CA113CB878726ULL, (u64bit) 0xB8A9626D11B8B8DAULL, (u64bit) 0x0108050209010104ULL, (u64bit) 0x4F426E9E0D4F4F21ULL,
(u64bit) 0x36ADEE6C9B3636D8ULL, (u64bit) 0xA6590451FFA6A6A2ULL, (u64bit) 0xD2DEBDB90CD2D26FULL, (u64bit) 0xF5FB06F70EF5F5F3ULL,
(u64bit) 0x79EF80F2967979F9ULL, (u64bit) 0x6F5FCEDE306F6FA1ULL, (u64bit) 0x91FCEF3F6D91917EULL, (u64bit) 0x52AA07A4F8525255ULL,
(u64bit) 0x6027FDC04760609DULL, (u64bit) 0xBC89766535BCBCCAULL, (u64bit) 0x9BACCD2B379B9B56ULL, (u64bit) 0x8E048C018A8E8E02ULL,
(u64bit) 0xA371155BD2A3A3B6ULL, (u64bit) 0x0C603C186C0C0C30ULL, (u64bit) 0x7BFF8AF6847B7BF1ULL, (u64bit) 0x35B5E16A803535D4ULL,
(u64bit) 0x1DE8693AF51D1D74ULL, (u64bit) 0xE05347DDB3E0E0A7ULL, (u64bit) 0xD7F6ACB321D7D77BULL, (u64bit) 0xC25EED999CC2C22FULL,
(u64bit) 0x2E6D965C432E2EB8ULL, (u64bit) 0x4B627A96294B4B31ULL, (u64bit) 0xFEA321E15DFEFEDFULL, (u64bit) 0x578216AED5575741ULL,
(u64bit) 0x15A8412ABD151554ULL, (u64bit) 0x779FB6EEE87777C1ULL, (u64bit) 0x37A5EB6E923737DCULL, (u64bit) 0xE57B56D79EE5E5B3ULL,
(u64bit) 0x9F8CD923139F9F46ULL, (u64bit) 0xF0D317FD23F0F0E7ULL, (u64bit) 0x4A6A7F94204A4A35ULL, (u64bit) 0xDA9E95A944DADA4FULL,
(u64bit) 0x58FA25B0A258587DULL, (u64bit) 0xC906CA8FCFC9C903ULL, (u64bit) 0x29558D527C2929A4ULL, (u64bit) 0x0A5022145A0A0A28ULL,
(u64bit) 0xB1E14F7F50B1B1FEULL, (u64bit) 0xA0691A5DC9A0A0BAULL, (u64bit) 0x6B7FDAD6146B6BB1ULL, (u64bit) 0x855CAB17D985852EULL,
(u64bit) 0xBD8173673CBDBDCEULL, (u64bit) 0x5DD234BA8F5D5D69ULL, (u64bit) 0x1080502090101040ULL, (u64bit) 0xF4F303F507F4F4F7ULL,
(u64bit) 0xCB16C08BDDCBCB0BULL, (u64bit) 0x3EEDC67CD33E3EF8ULL, (u64bit) 0x0528110A2D050514ULL, (u64bit) 0x671FE6CE78676781ULL,
(u64bit) 0xE47353D597E4E4B7ULL, (u64bit) 0x2725BB4E0227279CULL, (u64bit) 0x4132588273414119ULL, (u64bit) 0x8B2C9D0BA78B8B16ULL,
(u64bit) 0xA7510153F6A7A7A6ULL, (u64bit) 0x7DCF94FAB27D7DE9ULL, (u64bit) 0x95DCFB374995956EULL, (u64bit) 0xD88E9FAD56D8D847ULL,
(u64bit) 0xFB8B30EB70FBFBCBULL, (u64bit) 0xEE2371C1CDEEEE9FULL, (u64bit) 0x7CC791F8BB7C7CEDULL, (u64bit) 0x6617E3CC71666685ULL,
(u64bit) 0xDDA68EA77BDDDD53ULL, (u64bit) 0x17B84B2EAF17175CULL, (u64bit) 0x4702468E45474701ULL, (u64bit) 0x9E84DC211A9E9E42ULL,
(u64bit) 0xCA1EC589D4CACA0FULL, (u64bit) 0x2D75995A582D2DB4ULL, (u64bit) 0xBF9179632EBFBFC6ULL, (u64bit) 0x07381B0E3F07071CULL,
(u64bit) 0xAD012347ACADAD8EULL, (u64bit) 0x5AEA2FB4B05A5A75ULL, (u64bit) 0x836CB51BEF838336ULL, (u64bit) 0x3385FF66B63333CCULL,
(u64bit) 0x633FF2C65C636391ULL, (u64bit) 0x02100A0412020208ULL, (u64bit) 0xAA39384993AAAA92ULL, (u64bit) 0x71AFA8E2DE7171D9ULL,
(u64bit) 0xC80ECF8DC6C8C807ULL, (u64bit) 0x19C87D32D1191964ULL, (u64bit) 0x497270923B494939ULL, (u64bit) 0xD9869AAF5FD9D943ULL,
(u64bit) 0xF2C31DF931F2F2EFULL, (u64bit) 0xE34B48DBA8E3E3ABULL, (u64bit) 0x5BE22AB6B95B5B71ULL, (u64bit) 0x8834920DBC88881AULL,
(u64bit) 0x9AA4C8293E9A9A52ULL, (u64bit) 0x262DBE4C0B262698ULL, (u64bit) 0x328DFA64BF3232C8ULL, (u64bit) 0xB0E94A7D59B0B0FAULL,
(u64bit) 0xE91B6ACFF2E9E983ULL, (u64bit) 0x0F78331E770F0F3CULL, (u64bit) 0xD5E6A6B733D5D573ULL, (u64bit) 0x8074BA1DF480803AULL,
(u64bit) 0xBE997C6127BEBEC2ULL, (u64bit) 0xCD26DE87EBCDCD13ULL, (u64bit) 0x34BDE468893434D0ULL, (u64bit) 0x487A75903248483DULL,
(u64bit) 0xFFAB24E354FFFFDBULL, (u64bit) 0x7AF78FF48D7A7AF5ULL, (u64bit) 0x90F4EA3D6490907AULL, (u64bit) 0x5FC23EBE9D5F5F61ULL,
(u64bit) 0x201DA0403D202080ULL, (u64bit) 0x6867D5D00F6868BDULL, (u64bit) 0x1AD07234CA1A1A68ULL, (u64bit) 0xAE192C41B7AEAE82ULL,
(u64bit) 0xB4C95E757DB4B4EAULL, (u64bit) 0x549A19A8CE54544DULL, (u64bit) 0x93ECE53B7F939376ULL, (u64bit) 0x220DAA442F222288ULL,
(u64bit) 0x6407E9C86364648DULL, (u64bit) 0xF1DB12FF2AF1F1E3ULL, (u64bit) 0x73BFA2E6CC7373D1ULL, (u64bit) 0x12905A2482121248ULL,
(u64bit) 0x403A5D807A40401DULL, (u64bit) 0x0840281048080820ULL, (u64bit) 0xC356E89B95C3C32BULL, (u64bit) 0xEC337BC5DFECEC97ULL,
(u64bit) 0xDB9690AB4DDBDB4BULL, (u64bit) 0xA1611F5FC0A1A1BEULL, (u64bit) 0x8D1C8307918D8D0EULL, (u64bit) 0x3DF5C97AC83D3DF4ULL,
(u64bit) 0x97CCF1335B979766ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0xCF36D483F9CFCF1BULL, (u64bit) 0x2B4587566E2B2BACULL,
(u64bit) 0x7697B3ECE17676C5ULL, (u64bit) 0x8264B019E6828232ULL, (u64bit) 0xD6FEA9B128D6D67FULL, (u64bit) 0x1BD87736C31B1B6CULL,
(u64bit) 0xB5C15B7774B5B5EEULL, (u64bit) 0xAF112943BEAFAF86ULL, (u64bit) 0x6A77DFD41D6A6AB5ULL, (u64bit) 0x50BA0DA0EA50505DULL,
(u64bit) 0x45124C8A57454509ULL, (u64bit) 0xF3CB18FB38F3F3EBULL, (u64bit) 0x309DF060AD3030C0ULL, (u64bit) 0xEF2B74C3C4EFEF9BULL,
(u64bit) 0x3FE5C37EDA3F3FFCULL, (u64bit) 0x55921CAAC7555549ULL, (u64bit) 0xA2791059DBA2A2B2ULL, (u64bit) 0xEA0365C9E9EAEA8FULL,
(u64bit) 0x650FECCA6A656589ULL, (u64bit) 0xBAB9686903BABAD2ULL, (u64bit) 0x2F65935E4A2F2FBCULL, (u64bit) 0xC04EE79D8EC0C027ULL,
(u64bit) 0xDEBE81A160DEDE5FULL, (u64bit) 0x1CE06C38FC1C1C70ULL, (u64bit) 0xFDBB2EE746FDFDD3ULL, (u64bit) 0x4D52649A1F4D4D29ULL,
(u64bit) 0x92E4E03976929272ULL, (u64bit) 0x758FBCEAFA7575C9ULL, (u64bit) 0x06301E0C36060618ULL, (u64bit) 0x8A249809AE8A8A12ULL,
(u64bit) 0xB2F940794BB2B2F2ULL, (u64bit) 0xE66359D185E6E6BFULL, (u64bit) 0x0E70361C7E0E0E38ULL, (u64bit) 0x1FF8633EE71F1F7CULL,
(u64bit) 0x6237F7C455626295ULL, (u64bit) 0xD4EEA3B53AD4D477ULL, (u64bit) 0xA829324D81A8A89AULL, (u64bit) 0x96C4F43152969662ULL,
(u64bit) 0xF99B3AEF62F9F9C3ULL, (u64bit) 0xC566F697A3C5C533ULL, (u64bit) 0x2535B14A10252594ULL, (u64bit) 0x59F220B2AB595979ULL,
(u64bit) 0x8454AE15D084842AULL, (u64bit) 0x72B7A7E4C57272D5ULL, (u64bit) 0x39D5DD72EC3939E4ULL, (u64bit) 0x4C5A6198164C4C2DULL,
(u64bit) 0x5ECA3BBC945E5E65ULL, (u64bit) 0x78E785F09F7878FDULL, (u64bit) 0x38DDD870E53838E0ULL, (u64bit) 0x8C148605988C8C0AULL,
(u64bit) 0xD1C6B2BF17D1D163ULL, (u64bit) 0xA5410B57E4A5A5AEULL, (u64bit) 0xE2434DD9A1E2E2AFULL, (u64bit) 0x612FF8C24E616199ULL,
(u64bit) 0xB3F1457B42B3B3F6ULL, (u64bit) 0x2115A54234212184ULL, (u64bit) 0x9C94D625089C9C4AULL, (u64bit) 0x1EF0663CEE1E1E78ULL,
(u64bit) 0x4322528661434311ULL, (u64bit) 0xC776FC93B1C7C73BULL, (u64bit) 0xFCB32BE54FFCFCD7ULL, (u64bit) 0x0420140824040410ULL,
(u64bit) 0x51B208A2E3515159ULL, (u64bit) 0x99BCC72F2599995EULL, (u64bit) 0x6D4FC4DA226D6DA9ULL, (u64bit) 0x0D68391A650D0D34ULL,
(u64bit) 0xFA8335E979FAFACFULL, (u64bit) 0xDFB684A369DFDF5BULL, (u64bit) 0x7ED79BFCA97E7EE5ULL, (u64bit) 0x243DB44819242490ULL,
(u64bit) 0x3BC5D776FE3B3BECULL, (u64bit) 0xAB313D4B9AABAB96ULL, (u64bit) 0xCE3ED181F0CECE1FULL, (u64bit) 0x1188552299111144ULL,
(u64bit) 0x8F0C8903838F8F06ULL, (u64bit) 0x4E4A6B9C044E4E25ULL, (u64bit) 0xB7D1517366B7B7E6ULL, (u64bit) 0xEB0B60CBE0EBEB8BULL,
(u64bit) 0x3CFDCC78C13C3CF0ULL, (u64bit) 0x817CBF1FFD81813EULL, (u64bit) 0x94D4FE354094946AULL, (u64bit) 0xF7EB0CF31CF7F7FBULL,
(u64bit) 0xB9A1676F18B9B9DEULL, (u64bit) 0x13985F268B13134CULL, (u64bit) 0x2C7D9C58512C2CB0ULL, (u64bit) 0xD3D6B8BB05D3D36BULL,
(u64bit) 0xE76B5CD38CE7E7BBULL, (u64bit) 0x6E57CBDC396E6EA5ULL, (u64bit) 0xC46EF395AAC4C437ULL, (u64bit) 0x03180F061B03030CULL,
(u64bit) 0x568A13ACDC565645ULL, (u64bit) 0x441A49885E44440DULL, (u64bit) 0x7FDF9EFEA07F7FE1ULL, (u64bit) 0xA921374F88A9A99EULL,
(u64bit) 0x2A4D8254672A2AA8ULL, (u64bit) 0xBBB16D6B0ABBBBD6ULL, (u64bit) 0xC146E29F87C1C123ULL, (u64bit) 0x53A202A6F1535351ULL,
(u64bit) 0xDCAE8BA572DCDC57ULL, (u64bit) 0x0B582716530B0B2CULL, (u64bit) 0x9D9CD327019D9D4EULL, (u64bit) 0x6C47C1D82B6C6CADULL,
(u64bit) 0x3195F562A43131C4ULL, (u64bit) 0x7487B9E8F37474CDULL, (u64bit) 0xF6E309F115F6F6FFULL, (u64bit) 0x460A438C4C464605ULL,
(u64bit) 0xAC092645A5ACAC8AULL, (u64bit) 0x893C970FB589891EULL, (u64bit) 0x14A04428B4141450ULL, (u64bit) 0xE15B42DFBAE1E1A3ULL,
(u64bit) 0x16B04E2CA6161658ULL, (u64bit) 0x3ACDD274F73A3AE8ULL, (u64bit) 0x696FD0D2066969B9ULL, (u64bit) 0x09482D1241090924ULL,
(u64bit) 0x70A7ADE0D77070DDULL, (u64bit) 0xB6D954716FB6B6E2ULL, (u64bit) 0xD0CEB7BD1ED0D067ULL, (u64bit) 0xED3B7EC7D6EDED93ULL,
(u64bit) 0xCC2EDB85E2CCCC17ULL, (u64bit) 0x422A578468424215ULL, (u64bit) 0x98B4C22D2C98985AULL, (u64bit) 0xA4490E55EDA4A4AAULL,
(u64bit) 0x285D8850752828A0ULL, (u64bit) 0x5CDA31B8865C5C6DULL, (u64bit) 0xF8933FED6BF8F8C7ULL, (u64bit) 0x8644A411C2868622ULL };

const u64bit Whirlpool::C6[256] = {
(u64bit) 0x6018C07830D81818ULL, (u64bit) 0x8C2305AF46262323ULL, (u64bit) 0x3FC67EF991B8C6C6ULL, (u64bit) 0x87E8136FCDFBE8E8ULL,
(u64bit) 0x26874CA113CB8787ULL, (u64bit) 0xDAB8A9626D11B8B8ULL, (u64bit) 0x0401080502090101ULL, (u64bit) 0x214F426E9E0D4F4FULL,
(u64bit) 0xD836ADEE6C9B3636ULL, (u64bit) 0xA2A6590451FFA6A6ULL, (u64bit) 0x6FD2DEBDB90CD2D2ULL, (u64bit) 0xF3F5FB06F70EF5F5ULL,
(u64bit) 0xF979EF80F2967979ULL, (u64bit) 0xA16F5FCEDE306F6FULL, (u64bit) 0x7E91FCEF3F6D9191ULL, (u64bit) 0x5552AA07A4F85252ULL,
(u64bit) 0x9D6027FDC0476060ULL, (u64bit) 0xCABC89766535BCBCULL, (u64bit) 0x569BACCD2B379B9BULL, (u64bit) 0x028E048C018A8E8EULL,
(u64bit) 0xB6A371155BD2A3A3ULL, (u64bit) 0x300C603C186C0C0CULL, (u64bit) 0xF17BFF8AF6847B7BULL, (u64bit) 0xD435B5E16A803535ULL,
(u64bit) 0x741DE8693AF51D1DULL, (u64bit) 0xA7E05347DDB3E0E0ULL, (u64bit) 0x7BD7F6ACB321D7D7ULL, (u64bit) 0x2FC25EED999CC2C2ULL,
(u64bit) 0xB82E6D965C432E2EULL, (u64bit) 0x314B627A96294B4BULL, (u64bit) 0xDFFEA321E15DFEFEULL, (u64bit) 0x41578216AED55757ULL,
(u64bit) 0x5415A8412ABD1515ULL, (u64bit) 0xC1779FB6EEE87777ULL, (u64bit) 0xDC37A5EB6E923737ULL, (u64bit) 0xB3E57B56D79EE5E5ULL,
(u64bit) 0x469F8CD923139F9FULL, (u64bit) 0xE7F0D317FD23F0F0ULL, (u64bit) 0x354A6A7F94204A4AULL, (u64bit) 0x4FDA9E95A944DADAULL,
(u64bit) 0x7D58FA25B0A25858ULL, (u64bit) 0x03C906CA8FCFC9C9ULL, (u64bit) 0xA429558D527C2929ULL, (u64bit) 0x280A5022145A0A0AULL,
(u64bit) 0xFEB1E14F7F50B1B1ULL, (u64bit) 0xBAA0691A5DC9A0A0ULL, (u64bit) 0xB16B7FDAD6146B6BULL, (u64bit) 0x2E855CAB17D98585ULL,
(u64bit) 0xCEBD8173673CBDBDULL, (u64bit) 0x695DD234BA8F5D5DULL, (u64bit) 0x4010805020901010ULL, (u64bit) 0xF7F4F303F507F4F4ULL,
(u64bit) 0x0BCB16C08BDDCBCBULL, (u64bit) 0xF83EEDC67CD33E3EULL, (u64bit) 0x140528110A2D0505ULL, (u64bit) 0x81671FE6CE786767ULL,
(u64bit) 0xB7E47353D597E4E4ULL, (u64bit) 0x9C2725BB4E022727ULL, (u64bit) 0x1941325882734141ULL, (u64bit) 0x168B2C9D0BA78B8BULL,
(u64bit) 0xA6A7510153F6A7A7ULL, (u64bit) 0xE97DCF94FAB27D7DULL, (u64bit) 0x6E95DCFB37499595ULL, (u64bit) 0x47D88E9FAD56D8D8ULL,
(u64bit) 0xCBFB8B30EB70FBFBULL, (u64bit) 0x9FEE2371C1CDEEEEULL, (u64bit) 0xED7CC791F8BB7C7CULL, (u64bit) 0x856617E3CC716666ULL,
(u64bit) 0x53DDA68EA77BDDDDULL, (u64bit) 0x5C17B84B2EAF1717ULL, (u64bit) 0x014702468E454747ULL, (u64bit) 0x429E84DC211A9E9EULL,
(u64bit) 0x0FCA1EC589D4CACAULL, (u64bit) 0xB42D75995A582D2DULL, (u64bit) 0xC6BF9179632EBFBFULL, (u64bit) 0x1C07381B0E3F0707ULL,
(u64bit) 0x8EAD012347ACADADULL, (u64bit) 0x755AEA2FB4B05A5AULL, (u64bit) 0x36836CB51BEF8383ULL, (u64bit) 0xCC3385FF66B63333ULL,
(u64bit) 0x91633FF2C65C6363ULL, (u64bit) 0x0802100A04120202ULL, (u64bit) 0x92AA39384993AAAAULL, (u64bit) 0xD971AFA8E2DE7171ULL,
(u64bit) 0x07C80ECF8DC6C8C8ULL, (u64bit) 0x6419C87D32D11919ULL, (u64bit) 0x39497270923B4949ULL, (u64bit) 0x43D9869AAF5FD9D9ULL,
(u64bit) 0xEFF2C31DF931F2F2ULL, (u64bit) 0xABE34B48DBA8E3E3ULL, (u64bit) 0x715BE22AB6B95B5BULL, (u64bit) 0x1A8834920DBC8888ULL,
(u64bit) 0x529AA4C8293E9A9AULL, (u64bit) 0x98262DBE4C0B2626ULL, (u64bit) 0xC8328DFA64BF3232ULL, (u64bit) 0xFAB0E94A7D59B0B0ULL,
(u64bit) 0x83E91B6ACFF2E9E9ULL, (u64bit) 0x3C0F78331E770F0FULL, (u64bit) 0x73D5E6A6B733D5D5ULL, (u64bit) 0x3A8074BA1DF48080ULL,
(u64bit) 0xC2BE997C6127BEBEULL, (u64bit) 0x13CD26DE87EBCDCDULL, (u64bit) 0xD034BDE468893434ULL, (u64bit) 0x3D487A7590324848ULL,
(u64bit) 0xDBFFAB24E354FFFFULL, (u64bit) 0xF57AF78FF48D7A7AULL, (u64bit) 0x7A90F4EA3D649090ULL, (u64bit) 0x615FC23EBE9D5F5FULL,
(u64bit) 0x80201DA0403D2020ULL, (u64bit) 0xBD6867D5D00F6868ULL, (u64bit) 0x681AD07234CA1A1AULL, (u64bit) 0x82AE192C41B7AEAEULL,
(u64bit) 0xEAB4C95E757DB4B4ULL, (u64bit) 0x4D549A19A8CE5454ULL, (u64bit) 0x7693ECE53B7F9393ULL, (u64bit) 0x88220DAA442F2222ULL,
(u64bit) 0x8D6407E9C8636464ULL, (u64bit) 0xE3F1DB12FF2AF1F1ULL, (u64bit) 0xD173BFA2E6CC7373ULL, (u64bit) 0x4812905A24821212ULL,
(u64bit) 0x1D403A5D807A4040ULL, (u64bit) 0x2008402810480808ULL, (u64bit) 0x2BC356E89B95C3C3ULL, (u64bit) 0x97EC337BC5DFECECULL,
(u64bit) 0x4BDB9690AB4DDBDBULL, (u64bit) 0xBEA1611F5FC0A1A1ULL, (u64bit) 0x0E8D1C8307918D8DULL, (u64bit) 0xF43DF5C97AC83D3DULL,
(u64bit) 0x6697CCF1335B9797ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0x1BCF36D483F9CFCFULL, (u64bit) 0xAC2B4587566E2B2BULL,
(u64bit) 0xC57697B3ECE17676ULL, (u64bit) 0x328264B019E68282ULL, (u64bit) 0x7FD6FEA9B128D6D6ULL, (u64bit) 0x6C1BD87736C31B1BULL,
(u64bit) 0xEEB5C15B7774B5B5ULL, (u64bit) 0x86AF112943BEAFAFULL, (u64bit) 0xB56A77DFD41D6A6AULL, (u64bit) 0x5D50BA0DA0EA5050ULL,
(u64bit) 0x0945124C8A574545ULL, (u64bit) 0xEBF3CB18FB38F3F3ULL, (u64bit) 0xC0309DF060AD3030ULL, (u64bit) 0x9BEF2B74C3C4EFEFULL,
(u64bit) 0xFC3FE5C37EDA3F3FULL, (u64bit) 0x4955921CAAC75555ULL, (u64bit) 0xB2A2791059DBA2A2ULL, (u64bit) 0x8FEA0365C9E9EAEAULL,
(u64bit) 0x89650FECCA6A6565ULL, (u64bit) 0xD2BAB9686903BABAULL, (u64bit) 0xBC2F65935E4A2F2FULL, (u64bit) 0x27C04EE79D8EC0C0ULL,
(u64bit) 0x5FDEBE81A160DEDEULL, (u64bit) 0x701CE06C38FC1C1CULL, (u64bit) 0xD3FDBB2EE746FDFDULL, (u64bit) 0x294D52649A1F4D4DULL,
(u64bit) 0x7292E4E039769292ULL, (u64bit) 0xC9758FBCEAFA7575ULL, (u64bit) 0x1806301E0C360606ULL, (u64bit) 0x128A249809AE8A8AULL,
(u64bit) 0xF2B2F940794BB2B2ULL, (u64bit) 0xBFE66359D185E6E6ULL, (u64bit) 0x380E70361C7E0E0EULL, (u64bit) 0x7C1FF8633EE71F1FULL,
(u64bit) 0x956237F7C4556262ULL, (u64bit) 0x77D4EEA3B53AD4D4ULL, (u64bit) 0x9AA829324D81A8A8ULL, (u64bit) 0x6296C4F431529696ULL,
(u64bit) 0xC3F99B3AEF62F9F9ULL, (u64bit) 0x33C566F697A3C5C5ULL, (u64bit) 0x942535B14A102525ULL, (u64bit) 0x7959F220B2AB5959ULL,
(u64bit) 0x2A8454AE15D08484ULL, (u64bit) 0xD572B7A7E4C57272ULL, (u64bit) 0xE439D5DD72EC3939ULL, (u64bit) 0x2D4C5A6198164C4CULL,
(u64bit) 0x655ECA3BBC945E5EULL, (u64bit) 0xFD78E785F09F7878ULL, (u64bit) 0xE038DDD870E53838ULL, (u64bit) 0x0A8C148605988C8CULL,
(u64bit) 0x63D1C6B2BF17D1D1ULL, (u64bit) 0xAEA5410B57E4A5A5ULL, (u64bit) 0xAFE2434DD9A1E2E2ULL, (u64bit) 0x99612FF8C24E6161ULL,
(u64bit) 0xF6B3F1457B42B3B3ULL, (u64bit) 0x842115A542342121ULL, (u64bit) 0x4A9C94D625089C9CULL, (u64bit) 0x781EF0663CEE1E1EULL,
(u64bit) 0x1143225286614343ULL, (u64bit) 0x3BC776FC93B1C7C7ULL, (u64bit) 0xD7FCB32BE54FFCFCULL, (u64bit) 0x1004201408240404ULL,
(u64bit) 0x5951B208A2E35151ULL, (u64bit) 0x5E99BCC72F259999ULL, (u64bit) 0xA96D4FC4DA226D6DULL, (u64bit) 0x340D68391A650D0DULL,
(u64bit) 0xCFFA8335E979FAFAULL, (u64bit) 0x5BDFB684A369DFDFULL, (u64bit) 0xE57ED79BFCA97E7EULL, (u64bit) 0x90243DB448192424ULL,
(u64bit) 0xEC3BC5D776FE3B3BULL, (u64bit) 0x96AB313D4B9AABABULL, (u64bit) 0x1FCE3ED181F0CECEULL, (u64bit) 0x4411885522991111ULL,
(u64bit) 0x068F0C8903838F8FULL, (u64bit) 0x254E4A6B9C044E4EULL, (u64bit) 0xE6B7D1517366B7B7ULL, (u64bit) 0x8BEB0B60CBE0EBEBULL,
(u64bit) 0xF03CFDCC78C13C3CULL, (u64bit) 0x3E817CBF1FFD8181ULL, (u64bit) 0x6A94D4FE35409494ULL, (u64bit) 0xFBF7EB0CF31CF7F7ULL,
(u64bit) 0xDEB9A1676F18B9B9ULL, (u64bit) 0x4C13985F268B1313ULL, (u64bit) 0xB02C7D9C58512C2CULL, (u64bit) 0x6BD3D6B8BB05D3D3ULL,
(u64bit) 0xBBE76B5CD38CE7E7ULL, (u64bit) 0xA56E57CBDC396E6EULL, (u64bit) 0x37C46EF395AAC4C4ULL, (u64bit) 0x0C03180F061B0303ULL,
(u64bit) 0x45568A13ACDC5656ULL, (u64bit) 0x0D441A49885E4444ULL, (u64bit) 0xE17FDF9EFEA07F7FULL, (u64bit) 0x9EA921374F88A9A9ULL,
(u64bit) 0xA82A4D8254672A2AULL, (u64bit) 0xD6BBB16D6B0ABBBBULL, (u64bit) 0x23C146E29F87C1C1ULL, (u64bit) 0x5153A202A6F15353ULL,
(u64bit) 0x57DCAE8BA572DCDCULL, (u64bit) 0x2C0B582716530B0BULL, (u64bit) 0x4E9D9CD327019D9DULL, (u64bit) 0xAD6C47C1D82B6C6CULL,
(u64bit) 0xC43195F562A43131ULL, (u64bit) 0xCD7487B9E8F37474ULL, (u64bit) 0xFFF6E309F115F6F6ULL, (u64bit) 0x05460A438C4C4646ULL,
(u64bit) 0x8AAC092645A5ACACULL, (u64bit) 0x1E893C970FB58989ULL, (u64bit) 0x5014A04428B41414ULL, (u64bit) 0xA3E15B42DFBAE1E1ULL,
(u64bit) 0x5816B04E2CA61616ULL, (u64bit) 0xE83ACDD274F73A3AULL, (u64bit) 0xB9696FD0D2066969ULL, (u64bit) 0x2409482D12410909ULL,
(u64bit) 0xDD70A7ADE0D77070ULL, (u64bit) 0xE2B6D954716FB6B6ULL, (u64bit) 0x67D0CEB7BD1ED0D0ULL, (u64bit) 0x93ED3B7EC7D6EDEDULL,
(u64bit) 0x17CC2EDB85E2CCCCULL, (u64bit) 0x15422A5784684242ULL, (u64bit) 0x5A98B4C22D2C9898ULL, (u64bit) 0xAAA4490E55EDA4A4ULL,
(u64bit) 0xA0285D8850752828ULL, (u64bit) 0x6D5CDA31B8865C5CULL, (u64bit) 0xC7F8933FED6BF8F8ULL, (u64bit) 0x228644A411C28686ULL };

const u64bit Whirlpool::C7[256] = {
(u64bit) 0x186018C07830D818ULL, (u64bit) 0x238C2305AF462623ULL, (u64bit) 0xC63FC67EF991B8C6ULL, (u64bit) 0xE887E8136FCDFBE8ULL,
(u64bit) 0x8726874CA113CB87ULL, (u64bit) 0xB8DAB8A9626D11B8ULL, (u64bit) 0x0104010805020901ULL, (u64bit) 0x4F214F426E9E0D4FULL,
(u64bit) 0x36D836ADEE6C9B36ULL, (u64bit) 0xA6A2A6590451FFA6ULL, (u64bit) 0xD26FD2DEBDB90CD2ULL, (u64bit) 0xF5F3F5FB06F70EF5ULL,
(u64bit) 0x79F979EF80F29679ULL, (u64bit) 0x6FA16F5FCEDE306FULL, (u64bit) 0x917E91FCEF3F6D91ULL, (u64bit) 0x525552AA07A4F852ULL,
(u64bit) 0x609D6027FDC04760ULL, (u64bit) 0xBCCABC89766535BCULL, (u64bit) 0x9B569BACCD2B379BULL, (u64bit) 0x8E028E048C018A8EULL,
(u64bit) 0xA3B6A371155BD2A3ULL, (u64bit) 0x0C300C603C186C0CULL, (u64bit) 0x7BF17BFF8AF6847BULL, (u64bit) 0x35D435B5E16A8035ULL,
(u64bit) 0x1D741DE8693AF51DULL, (u64bit) 0xE0A7E05347DDB3E0ULL, (u64bit) 0xD77BD7F6ACB321D7ULL, (u64bit) 0xC22FC25EED999CC2ULL,
(u64bit) 0x2EB82E6D965C432EULL, (u64bit) 0x4B314B627A96294BULL, (u64bit) 0xFEDFFEA321E15DFEULL, (u64bit) 0x5741578216AED557ULL,
(u64bit) 0x155415A8412ABD15ULL, (u64bit) 0x77C1779FB6EEE877ULL, (u64bit) 0x37DC37A5EB6E9237ULL, (u64bit) 0xE5B3E57B56D79EE5ULL,
(u64bit) 0x9F469F8CD923139FULL, (u64bit) 0xF0E7F0D317FD23F0ULL, (u64bit) 0x4A354A6A7F94204AULL, (u64bit) 0xDA4FDA9E95A944DAULL,
(u64bit) 0x587D58FA25B0A258ULL, (u64bit) 0xC903C906CA8FCFC9ULL, (u64bit) 0x29A429558D527C29ULL, (u64bit) 0x0A280A5022145A0AULL,
(u64bit) 0xB1FEB1E14F7F50B1ULL, (u64bit) 0xA0BAA0691A5DC9A0ULL, (u64bit) 0x6BB16B7FDAD6146BULL, (u64bit) 0x852E855CAB17D985ULL,
(u64bit) 0xBDCEBD8173673CBDULL, (u64bit) 0x5D695DD234BA8F5DULL, (u64bit) 0x1040108050209010ULL, (u64bit) 0xF4F7F4F303F507F4ULL,
(u64bit) 0xCB0BCB16C08BDDCBULL, (u64bit) 0x3EF83EEDC67CD33EULL, (u64bit) 0x05140528110A2D05ULL, (u64bit) 0x6781671FE6CE7867ULL,
(u64bit) 0xE4B7E47353D597E4ULL, (u64bit) 0x279C2725BB4E0227ULL, (u64bit) 0x4119413258827341ULL, (u64bit) 0x8B168B2C9D0BA78BULL,
(u64bit) 0xA7A6A7510153F6A7ULL, (u64bit) 0x7DE97DCF94FAB27DULL, (u64bit) 0x956E95DCFB374995ULL, (u64bit) 0xD847D88E9FAD56D8ULL,
(u64bit) 0xFBCBFB8B30EB70FBULL, (u64bit) 0xEE9FEE2371C1CDEEULL, (u64bit) 0x7CED7CC791F8BB7CULL, (u64bit) 0x66856617E3CC7166ULL,
(u64bit) 0xDD53DDA68EA77BDDULL, (u64bit) 0x175C17B84B2EAF17ULL, (u64bit) 0x47014702468E4547ULL, (u64bit) 0x9E429E84DC211A9EULL,
(u64bit) 0xCA0FCA1EC589D4CAULL, (u64bit) 0x2DB42D75995A582DULL, (u64bit) 0xBFC6BF9179632EBFULL, (u64bit) 0x071C07381B0E3F07ULL,
(u64bit) 0xAD8EAD012347ACADULL, (u64bit) 0x5A755AEA2FB4B05AULL, (u64bit) 0x8336836CB51BEF83ULL, (u64bit) 0x33CC3385FF66B633ULL,
(u64bit) 0x6391633FF2C65C63ULL, (u64bit) 0x020802100A041202ULL, (u64bit) 0xAA92AA39384993AAULL, (u64bit) 0x71D971AFA8E2DE71ULL,
(u64bit) 0xC807C80ECF8DC6C8ULL, (u64bit) 0x196419C87D32D119ULL, (u64bit) 0x4939497270923B49ULL, (u64bit) 0xD943D9869AAF5FD9ULL,
(u64bit) 0xF2EFF2C31DF931F2ULL, (u64bit) 0xE3ABE34B48DBA8E3ULL, (u64bit) 0x5B715BE22AB6B95BULL, (u64bit) 0x881A8834920DBC88ULL,
(u64bit) 0x9A529AA4C8293E9AULL, (u64bit) 0x2698262DBE4C0B26ULL, (u64bit) 0x32C8328DFA64BF32ULL, (u64bit) 0xB0FAB0E94A7D59B0ULL,
(u64bit) 0xE983E91B6ACFF2E9ULL, (u64bit) 0x0F3C0F78331E770FULL, (u64bit) 0xD573D5E6A6B733D5ULL, (u64bit) 0x803A8074BA1DF480ULL,
(u64bit) 0xBEC2BE997C6127BEULL, (u64bit) 0xCD13CD26DE87EBCDULL, (u64bit) 0x34D034BDE4688934ULL, (u64bit) 0x483D487A75903248ULL,
(u64bit) 0xFFDBFFAB24E354FFULL, (u64bit) 0x7AF57AF78FF48D7AULL, (u64bit) 0x907A90F4EA3D6490ULL, (u64bit) 0x5F615FC23EBE9D5FULL,
(u64bit) 0x2080201DA0403D20ULL, (u64bit) 0x68BD6867D5D00F68ULL, (u64bit) 0x1A681AD07234CA1AULL, (u64bit) 0xAE82AE192C41B7AEULL,
(u64bit) 0xB4EAB4C95E757DB4ULL, (u64bit) 0x544D549A19A8CE54ULL, (u64bit) 0x937693ECE53B7F93ULL, (u64bit) 0x2288220DAA442F22ULL,
(u64bit) 0x648D6407E9C86364ULL, (u64bit) 0xF1E3F1DB12FF2AF1ULL, (u64bit) 0x73D173BFA2E6CC73ULL, (u64bit) 0x124812905A248212ULL,
(u64bit) 0x401D403A5D807A40ULL, (u64bit) 0x0820084028104808ULL, (u64bit) 0xC32BC356E89B95C3ULL, (u64bit) 0xEC97EC337BC5DFECULL,
(u64bit) 0xDB4BDB9690AB4DDBULL, (u64bit) 0xA1BEA1611F5FC0A1ULL, (u64bit) 0x8D0E8D1C8307918DULL, (u64bit) 0x3DF43DF5C97AC83DULL,
(u64bit) 0x976697CCF1335B97ULL, (u64bit) 0x0000000000000000ULL, (u64bit) 0xCF1BCF36D483F9CFULL, (u64bit) 0x2BAC2B4587566E2BULL,
(u64bit) 0x76C57697B3ECE176ULL, (u64bit) 0x82328264B019E682ULL, (u64bit) 0xD67FD6FEA9B128D6ULL, (u64bit) 0x1B6C1BD87736C31BULL,
(u64bit) 0xB5EEB5C15B7774B5ULL, (u64bit) 0xAF86AF112943BEAFULL, (u64bit) 0x6AB56A77DFD41D6AULL, (u64bit) 0x505D50BA0DA0EA50ULL,
(u64bit) 0x450945124C8A5745ULL, (u64bit) 0xF3EBF3CB18FB38F3ULL, (u64bit) 0x30C0309DF060AD30ULL, (u64bit) 0xEF9BEF2B74C3C4EFULL,
(u64bit) 0x3FFC3FE5C37EDA3FULL, (u64bit) 0x554955921CAAC755ULL, (u64bit) 0xA2B2A2791059DBA2ULL, (u64bit) 0xEA8FEA0365C9E9EAULL,
(u64bit) 0x6589650FECCA6A65ULL, (u64bit) 0xBAD2BAB9686903BAULL, (u64bit) 0x2FBC2F65935E4A2FULL, (u64bit) 0xC027C04EE79D8EC0ULL,
(u64bit) 0xDE5FDEBE81A160DEULL, (u64bit) 0x1C701CE06C38FC1CULL, (u64bit) 0xFDD3FDBB2EE746FDULL, (u64bit) 0x4D294D52649A1F4DULL,
(u64bit) 0x927292E4E0397692ULL, (u64bit) 0x75C9758FBCEAFA75ULL, (u64bit) 0x061806301E0C3606ULL, (u64bit) 0x8A128A249809AE8AULL,
(u64bit) 0xB2F2B2F940794BB2ULL, (u64bit) 0xE6BFE66359D185E6ULL, (u64bit) 0x0E380E70361C7E0EULL, (u64bit) 0x1F7C1FF8633EE71FULL,
(u64bit) 0x62956237F7C45562ULL, (u64bit) 0xD477D4EEA3B53AD4ULL, (u64bit) 0xA89AA829324D81A8ULL, (u64bit) 0x966296C4F4315296ULL,
(u64bit) 0xF9C3F99B3AEF62F9ULL, (u64bit) 0xC533C566F697A3C5ULL, (u64bit) 0x25942535B14A1025ULL, (u64bit) 0x597959F220B2AB59ULL,
(u64bit) 0x842A8454AE15D084ULL, (u64bit) 0x72D572B7A7E4C572ULL, (u64bit) 0x39E439D5DD72EC39ULL, (u64bit) 0x4C2D4C5A6198164CULL,
(u64bit) 0x5E655ECA3BBC945EULL, (u64bit) 0x78FD78E785F09F78ULL, (u64bit) 0x38E038DDD870E538ULL, (u64bit) 0x8C0A8C148605988CULL,
(u64bit) 0xD163D1C6B2BF17D1ULL, (u64bit) 0xA5AEA5410B57E4A5ULL, (u64bit) 0xE2AFE2434DD9A1E2ULL, (u64bit) 0x6199612FF8C24E61ULL,
(u64bit) 0xB3F6B3F1457B42B3ULL, (u64bit) 0x21842115A5423421ULL, (u64bit) 0x9C4A9C94D625089CULL, (u64bit) 0x1E781EF0663CEE1EULL,
(u64bit) 0x4311432252866143ULL, (u64bit) 0xC73BC776FC93B1C7ULL, (u64bit) 0xFCD7FCB32BE54FFCULL, (u64bit) 0x0410042014082404ULL,
(u64bit) 0x515951B208A2E351ULL, (u64bit) 0x995E99BCC72F2599ULL, (u64bit) 0x6DA96D4FC4DA226DULL, (u64bit) 0x0D340D68391A650DULL,
(u64bit) 0xFACFFA8335E979FAULL, (u64bit) 0xDF5BDFB684A369DFULL, (u64bit) 0x7EE57ED79BFCA97EULL, (u64bit) 0x2490243DB4481924ULL,
(u64bit) 0x3BEC3BC5D776FE3BULL, (u64bit) 0xAB96AB313D4B9AABULL, (u64bit) 0xCE1FCE3ED181F0CEULL, (u64bit) 0x1144118855229911ULL,
(u64bit) 0x8F068F0C8903838FULL, (u64bit) 0x4E254E4A6B9C044EULL, (u64bit) 0xB7E6B7D1517366B7ULL, (u64bit) 0xEB8BEB0B60CBE0EBULL,
(u64bit) 0x3CF03CFDCC78C13CULL, (u64bit) 0x813E817CBF1FFD81ULL, (u64bit) 0x946A94D4FE354094ULL, (u64bit) 0xF7FBF7EB0CF31CF7ULL,
(u64bit) 0xB9DEB9A1676F18B9ULL, (u64bit) 0x134C13985F268B13ULL, (u64bit) 0x2CB02C7D9C58512CULL, (u64bit) 0xD36BD3D6B8BB05D3ULL,
(u64bit) 0xE7BBE76B5CD38CE7ULL, (u64bit) 0x6EA56E57CBDC396EULL, (u64bit) 0xC437C46EF395AAC4ULL, (u64bit) 0x030C03180F061B03ULL,
(u64bit) 0x5645568A13ACDC56ULL, (u64bit) 0x440D441A49885E44ULL, (u64bit) 0x7FE17FDF9EFEA07FULL, (u64bit) 0xA99EA921374F88A9ULL,
(u64bit) 0x2AA82A4D8254672AULL, (u64bit) 0xBBD6BBB16D6B0ABBULL, (u64bit) 0xC123C146E29F87C1ULL, (u64bit) 0x535153A202A6F153ULL,
(u64bit) 0xDC57DCAE8BA572DCULL, (u64bit) 0x0B2C0B582716530BULL, (u64bit) 0x9D4E9D9CD327019DULL, (u64bit) 0x6CAD6C47C1D82B6CULL,
(u64bit) 0x31C43195F562A431ULL, (u64bit) 0x74CD7487B9E8F374ULL, (u64bit) 0xF6FFF6E309F115F6ULL, (u64bit) 0x4605460A438C4C46ULL,
(u64bit) 0xAC8AAC092645A5ACULL, (u64bit) 0x891E893C970FB589ULL, (u64bit) 0x145014A04428B414ULL, (u64bit) 0xE1A3E15B42DFBAE1ULL,
(u64bit) 0x165816B04E2CA616ULL, (u64bit) 0x3AE83ACDD274F73AULL, (u64bit) 0x69B9696FD0D20669ULL, (u64bit) 0x092409482D124109ULL,
(u64bit) 0x70DD70A7ADE0D770ULL, (u64bit) 0xB6E2B6D954716FB6ULL, (u64bit) 0xD067D0CEB7BD1ED0ULL, (u64bit) 0xED93ED3B7EC7D6EDULL,
(u64bit) 0xCC17CC2EDB85E2CCULL, (u64bit) 0x4215422A57846842ULL, (u64bit) 0x985A98B4C22D2C98ULL, (u64bit) 0xA4AAA4490E55EDA4ULL,
(u64bit) 0x28A0285D88507528ULL, (u64bit) 0x5C6D5CDA31B8865CULL, (u64bit) 0xF8C7F8933FED6BF8ULL, (u64bit) 0x86228644A411C286ULL };

}
