/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import org.videolan.BDJXletContext;
import org.videolan.Logger;
import org.videolan.PortingHelper;

public class BDJThreadGroup
extends ThreadGroup {
    private BDJXletContext context;
    private static final Logger logger = Logger.getLogger(BDJThreadGroup.class.getName());

    public BDJThreadGroup(String name, BDJXletContext context) {
        super(name);
        this.context = context;
    }

    public void uncaughtException(Thread t, Throwable e) {
        StackTraceElement[] elems;
        String stack = "";
        if (e != null && (elems = e.getStackTrace()) != null) {
            for (int i = 0; i < elems.length; ++i) {
                stack = stack + "\n\t" + elems[i].toString();
            }
        }
        if (e instanceof ThreadDeath) {
            logger.error("Thread " + t + " killed" + stack);
        } else {
            logger.error("Unhandled exception in thread " + t + ": " + e + stack);
        }
    }

    public BDJXletContext getContext() {
        return this.context;
    }

    public void setContext(BDJXletContext context) {
        this.context = context;
    }

    public boolean waitForShutdown(int timeout, int maxThreads) {
        boolean result;
        if (this.parentOf(Thread.currentThread().getThreadGroup()) && maxThreads < 1) {
            logger.error("Current Thread is contained within ThreadGroup to be disposed.");
            throw new IllegalThreadStateException("Current Thread is contained within ThreadGroup to be disposed.");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (this.activeCount() > maxThreads && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        boolean bl = result = this.activeCount() <= maxThreads;
        if (!result) {
            logger.error("waitForShutdown timeout (have " + this.activeCount() + " threads, expected " + maxThreads + ")");
        }
        return result;
    }

    protected void stopAll(int timeout) {
        this.interrupt();
        this.waitForShutdown(timeout, 0);
        if (this.activeCount() > 0) {
            logger.error("stopAll(): killing threads");
            this.dumpThreads();
            PortingHelper.stopThreadGroup(this);
            this.waitForShutdown(500, 0);
        }
        try {
            this.destroy();
        }
        catch (IllegalThreadStateException e) {
            logger.error("ThreadGroup destroy failed: " + e);
        }
        this.context = null;
    }

    public void dumpThreads() {
        logger.info("Active threads in " + this + ":");
        Thread[] threads = new Thread[this.activeCount() + 1];
        while (this.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            logger.info("    " + threads[i]);
            logger.info("    at " + PortingHelper.dumpStack(threads[i]));
        }
    }
}

