/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.core.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class UpdateReportFileWriter {
    private final Logger a;
    private File b;

    public UpdateReportFileWriter(Logger logger) {
        this.a = logger;
    }

    public void setFile(File file) {
        this.b = file;
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            return;
        }
        catch (IOException iOException) {
            this.a.error("unable to create the report file! " + iOException.getMessage(), (Throwable)iOException);
            return;
        }
    }

    public boolean write(String string) {
        return this.writeLines(Collections.singletonList(string));
    }

    public boolean writeLines(String ... stringArray) {
        return this.writeLines(Arrays.asList(stringArray));
    }

    public boolean writeLines(List<String> object) {
        if (this.b == null) {
            return false;
        }
        if (!this.b.exists()) {
            return false;
        }
        if (!this.b.canWrite()) {
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.b.getAbsoluteFile(), true);
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                fileWriter.write(string + '\n');
                this.a.debug(string);
            }
        }
        catch (IOException iOException) {
            try {
                this.a.error("error writing report", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(fileWriter);
                throw throwable;
            }
            Util.closeQuietly(fileWriter);
            return false;
        }
        Util.closeQuietly(fileWriter);
        return true;
    }
}

