/**
 * 
 * Start Gestione Scroll
 * 
 */

/**
 * Dimensioni, a schermo, delle pagine visualizzate
 * 
 * @type {width: Number, height: Number}
 */
var pdf_mainPageDimension = {width: 0, height: 0};
/**
 * Dimensioni, a schermo, delle preview visualizzate
 * 
 * @type {width: Number, height: Number}
 */
var pdf_previewPageDimension = {width: 0, height: 0};

var pdf_delay = 100; // in "ms" (higher means lower fidelity )

function pdf_setMainPageDimension(width, height) {
    pdf_mainPageDimension = {width: width, height: height};
}

function pdf_setPreviewPageDimension(width, height) {
    pdf_previewPageDimension = {width: width, height: height};
}

var pdf_checkMainPageScrollSpeed = (function () {
    var lastPos = null, newPos, timer, delta = 0;

    return function () {
        try {
            newPos = document.getElementById("pdfView_formContentContainer_viewerArea_pagesArea").scrollTop;
            if (lastPos != null) {
                delta = Math.abs(newPos - lastPos);
            }
            lastPos = newPos;
            clearTimeout(timer);
            var pageInfo = {delta: delta, pos: newPos};
            timer = setTimeout(function () {
                pdf_scrollMainPage(pageInfo);
                lastPos = null;
                delta = 0;
            }, pdf_delay);
            return pageInfo;
        } catch (exception) {
            error(exception.stack);
        }
    };
})();

var pdf_checkPreviewPageScrollSpeed = (function () {
    var lastPos = null, newPos, timer, delta = 0;

    return function () {
        newPos = document.getElementById("pdfView_formContentContainer_viewerArea_pagePreviewPages").scrollTop;
        if (lastPos != null) {
            delta = Math.abs(newPos - lastPos);
        }
        lastPos = newPos;
        clearTimeout(timer);
        var pageInfo = {delta: delta, pos: newPos};
        timer = setTimeout(function () {
            pdf_scrollPreviewPage(pageInfo);
            lastPos = null;
            delta = 0;
        }, pdf_delay);
        return pageInfo;
    };
})();

/**
 * Avvia il controllo dello scrolling delle pagine
 * 
 * @returns {undefined}
 */
function pdf_checkMainPageScroll() {
    try {
        var pageInfo = pdf_checkMainPageScrollSpeed();
        pdf_sincronizeScrolling(pageInfo);
        if (pageInfo.delta != null && pageInfo.delta < 50) {
            pdf_scrollMainPage(pageInfo);
        }
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Sincronizza lo scroll delle pagine con la preview
 * 
 * @param {type} pageInfo
 * @returns {undefined}
 */
function pdf_sincronizeScrolling(pageInfo) {
    var previewArea = document.getElementById("pdfView_formContentContainer_viewerArea_pagePreviewPages");
    var visiblePreviewPage = previewArea.offsetHeight / pdf_previewPageDimension.height;
    var pageMult = Math.ceil(visiblePreviewPage / 2);
    var previewAreaHeight = document.getElementById("pdfView_formContentContainer_viewerArea_pagePreviewPages_Container").offsetHeight;
    var mainAreaOffsetHeight = document.getElementById("pdfView_formContentContainer_viewerArea_pagesArea_Container").offsetHeight;
    var newPreviewScroll = previewAreaHeight * Math.max(0, (pageInfo.pos - (pdf_mainPageDimension.height * pageMult)) / mainAreaOffsetHeight);
    previewArea.scrollTop = newPreviewScroll;
}

/**
 * Informa il controller che è avvenuto un evento scroll 
 * passandogli il numero di pagina corrente
 * 
 * @param {delta: Number, pos: Number} info delta: differenza tra vecchia posizione e nuova, pos: nuova posizione
 * @returns {undefined}
 */
function pdf_scrollMainPage(pageInfo) {
    try {
        var floatPage = pageInfo.pos / (pdf_mainPageDimension.height + 20);
        var page = Math.floor(floatPage);
        var dec = floatPage - page;
        if (dec > 0.8) {
            page = Math.ceil(floatPage);
        }
        if (page < 0) {
            page = 0;
        }
        $controller$.scrollMainPage(Number(page));
    } catch (exception) {
        error(exception.stack);
    }
}


/**
 * Avvia il controllo dello scrolling delle preview
 * 
 * @returns {undefined}
 */
function pdf_checkPreviewPageScroll() {
    try {
        var pageInfo = pdf_checkPreviewPageScrollSpeed();
        if (pageInfo.delta != null && pageInfo.delta < 50) {
            pdf_scrollPreviewPage(pageInfo);
        }
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Informa il controller che è avvenuto un evento scroll 
 * passandogli il numero della preview corrente
 * 
 * @param {delta: Number, pos: Number} info delta: differenza tra vecchia posizione e nuova, pos: nuova posizione
 * @returns {undefined}
 */
function pdf_scrollPreviewPage(info) {
    page = Math.floor(info.pos / (pdf_previewPageDimension.height + 8));
    if (page < 0) {
        page = 0;
    }
    $controller$.scrollPreviewPage(Number(page));
}

/**
 * Visualizza la pagina richiesta
 * 
 * @param {type} elementId
 * @returns {undefined}
 */
function pdf_scrollTo(elementId) {
    try {
        var topPos = document.getElementById(elementId).offsetTop;
        document.getElementById("pdfView_formContentContainer_viewerArea_pagesArea").scrollTop = topPos;
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * 
 * End Gestione Scroll
 * 
 */

/**
 * 
 * Start Gestione firma-------------------------------------------------------------------------------------------------------------
 * 
 */

var pdf_signCount = 0;
var pdf_startX;
var pdf_startY;
var pdf_currentSignature;
var pdf_signing = false;
var pdf_signatureArea = {top: 0, left: 0, width: 0, height: 0};

var pdf_signLayerList = [];

var pdf_signParent;

function pdf_addSignLayer(layerId) {
    pdf_signLayerList.push(layerId);
}

/**
 * Funzione eseguita a seguito di un evento mousedown sul SignLayer
 * 
 * @param {type} evt l'evento mousedown
 * @param {type} imageId id della pagina su cui ci troviamo
 * @returns {undefined}
 */
function pdf_startSigning(evt, imageId) {
    try {
        if (pdf_signLayerList.indexOf(evt.target.id) < 0) {
            return;
        }
        var image = document.getElementById(imageId);
        var rect = image.getBoundingClientRect();
        pdf_signatureArea = {top: 0, left: 0, width: 0, height: 0};
        pdf_currentSignature = document.createElement("div");
        pdf_currentSignature.id = imageId + "_signature_" + pdf_signCount++;
        pdf_currentSignature.classList.add("page_signature");
        pdf_currentSignature.classList.add("page_signature_selected");
        pdf_startX = evt.clientX - rect.left;
        pdf_startY = evt.clientY - rect.top;
        pdf_currentSignature.style.left = pdf_startX;
        pdf_currentSignature.style.top = pdf_startY;
        pdf_signatureArea.top = pdf_startY;
        pdf_signatureArea.left = pdf_startX;
        pdf_signParent = document.getElementById(imageId + "_signLayer");
        pdf_signParent.appendChild(pdf_currentSignature);
        pdf_signing = true;
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Funzione eseguita a seguito di un evento mousemove sul SignLayer
 * @param {type} evt l'evento mousemove
 * @param {type} imageId id della pagina su cui ci troviamo
 * @returns {undefined}
 */
function pdf_updateSignature(evt, imageId) {
    try {
        if (pdf_signing) {
            var rect = document.getElementById(imageId).getBoundingClientRect();
            var endX = evt.clientX - rect.left;
            var endY = evt.clientY - rect.top;

            pdf_signatureArea.width = Math.abs(endX - pdf_startX);
            pdf_signatureArea.height = Math.abs(endY - pdf_startY);
            pdf_signatureArea.top = (endY - pdf_startY < 0) ? endY : pdf_startY;
            pdf_signatureArea.left = (endX - pdf_startX < 0) ? endX : pdf_startX;

            pdf_currentSignature.style.width = pdf_signatureArea.width + 'px';
            pdf_currentSignature.style.height = pdf_signatureArea.height + 'px';
            pdf_currentSignature.style.left = pdf_signatureArea.left + 'px';
            pdf_currentSignature.style.top = pdf_signatureArea.top + 'px';
        }
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Funzione eseguita a seguito di un evento mouseup sul SignLayer
 * 
 * @param {type} evt l'evento mouseup
 * @param {type} imageId id della pagina su cui ci troviamo
 * @returns {undefined}
 */
function pdf_finishSigning(evt, imageId) {
    try {
        if (pdf_signing) {
            pdf_signing = false;
            pdf_selectedAppearance = pdf_currentSignature.id;
            if (pdf_signatureArea.width > 20 && pdf_signatureArea.height > 20) {
                $controller$.appendSignature(pdf_currentSignature.id, imageId, pdf_signatureArea.left, pdf_signatureArea.top, pdf_signatureArea.width, pdf_signatureArea.height, true, true, null);
            } else {
                $controller$.appendDefaultSignature(pdf_currentSignature.id, imageId, pdf_signatureArea.left, pdf_signatureArea.top, true, true, null);
            }
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function toggleCGAppearanceTooltip(targetId, tooltipId, signLayerId) {
    if (hasClass(tooltipId, 'cg-appearance-topTooltip-hover')) {
        hideCGAppearanceTooltip(tooltipId);
        return;
    }
    showCGAppearanceTooltip(targetId, tooltipId, signLayerId);
}

function showCGAppearanceTooltip(targetId, tooltipId, signLayerId) {
    try {
        removeClass(tooltipId, 'cg-appearance-topTooltip-hide');
        addClass(tooltipId, 'cg-appearance-topTooltip-hover');
        redrawCGAppearanceTooltip(targetId, tooltipId, signLayerId);
    } catch (exception) {
        error(exception.stack);
    }
}

function redrawCGAppearanceTooltip(targetId, tooltipId, signLayerId) {
    var tagert = document.getElementById(targetId);
    var tooltip = document.getElementById(tooltipId);
    var signLayer = document.getElementById(signLayerId);
    var signLayerRect = signLayer.getBoundingClientRect();
    var targetRect = tagert.getBoundingClientRect();
    var targetHeight = targetRect.bottom - targetRect.top;
    var targetWidth = targetRect.right - targetRect.left;
    var tooltipRect = tooltip.getBoundingClientRect();
    var tooltipHeight = tooltipRect.bottom - tooltipRect.top;
    if (tooltipRect.top < 0) {
        tooltipHeight = 0;
    }
    var tooltipWidth = 300;
    var tooltipCalculatedTop = ((targetHeight / 2)) - (tooltipHeight / 2);
    if (tooltipCalculatedTop < -5) {
        tooltipCalculatedTop = -5;
    }
    tooltip.style.top = tooltipCalculatedTop;
    tooltip.style.width = tooltipWidth;
    if (signLayerRect.left < targetRect.left - tooltipWidth) {
        // il tooltip ha abbastanza spazio a sinistra
        tooltip.style.left = -(tooltipWidth + 15);
        removeClass(tooltipId + "_i", "cg-appearance-topTooltip_anchor_right");
        addClass(tooltipId + "_i", "cg-appearance-topTooltip_anchor_left");
    } else {
        // il tooltip non ha abbastanza spazio a sinistra
        tooltip.style.left = targetWidth + 15;
        removeClass(tooltipId + "_i", "cg-appearance-topTooltip_anchor_left");
        addClass(tooltipId + "_i", "cg-appearance-topTooltip_anchor_right");
    }
}

function hideCGAppearanceTooltip(tooltipId) {
    removeClass(tooltipId, 'cg-appearance-topTooltip-hover');
    addClass(tooltipId, 'cg-appearance-topTooltip-hide');
}

/**
 * 
 * End Gestione Firma-------------------------------------------------------------------------------------------------------------
 * 
 */

/**
 * 
 * Start Gestione Resize-------------------------------------------------------------------------------------------------------------
 * 
 */

var pdf_dragPointId;
var pdf_pageId;
var pdf_signatureId;
var pdf_signArea;

var pdf_originalHeight;
var pdf_originalWidth;

var pdf_originalMouseX;
var pdf_originalMouseY;

var pdf_minimumSize = 20;

var pdf_original_x;
var pdf_original_y;

var pdf_dragPointNord;
var pdf_dragPointSud;
var pdf_dragPointOvest;
var pdf_dragPointEst;

var pdf_initialRect;

/**
 * Funzione eseguita a seguito di un evento mousedown su uno dei DragPoint.
 * 
 * Si occupa di reperire la posizione iniziale e gli id di tutti gli elementi 
 * interessati dal resize.
 * 
 * Aggiunge gli eventi mousemove e mouseup alla window. Questi eventi vengono 
 * aggiunti adesso per evitare strani comportamenti sull'interfaccia.
 * 
 * @param {type} evt l'evento mousedown
 * @param {type} dragPointId id del DragPoint su cui è stato invocato l'evento
 * @param {type} signatureId id dell'appearance che stiamo ridimensionando
 * @param {type} pageId id della pagina contenente l'appearance
 * @param {type} imageId id dell'immagine dell'appearance
 * @param {type} deleteButtonId id del button di cancellazione dell'appearance
 * @returns {undefined}
 */
function pdf_onDragPointStartDrag(evt, dragPointId, signatureId, pageId, imageId, deleteButtonId) {
    var dragPointGeneralId = dragPointId.substring(0, dragPointId.lastIndexOf("_"));
    pdf_dragPointNord = document.getElementById(dragPointGeneralId + "_Nord");
    pdf_dragPointSud = document.getElementById(dragPointGeneralId + "_Sud");
    pdf_dragPointOvest = document.getElementById(dragPointGeneralId + "_Ovest");
    pdf_dragPointEst = document.getElementById(dragPointGeneralId + "_Est");
    pdf_signArea = document.getElementById(signatureId);
    pdf_initialRect = pdf_signArea.getBoundingClientRect();
    document.getElementById(imageId).style.display = "none";
    document.getElementById(deleteButtonId).style.display = "none";
    pdf_originalWidth = parseFloat(pdf_signArea.style.width.replace('px', ''));
    pdf_originalHeight = parseFloat(pdf_signArea.style.height.replace('px', ''));
    pdf_original_x = pdf_signArea.getBoundingClientRect().left;
    pdf_original_y = pdf_signArea.getBoundingClientRect().top;
    pdf_originalMouseX = evt.pageX;
    pdf_originalMouseY = evt.pageY;
    pdf_dragPointId = dragPointId;
    pdf_pageId = pageId;
    pdf_signatureId = signatureId;
    window.addEventListener('mousemove', pdf_resize);
    window.addEventListener('mouseup', pdf_stopResize);
}

/**
 * Funzione eseguita a seguito di un evento mousemove.
 * 
 * Effettua il resize dell'appearance in base al DragPoint selezionato.
 * L'appearance non può superare i limiti della pagina.
 * 
 * @param {type} e l'evento mousemove
 * @returns {undefined}
 */
function pdf_resize(e) {
    var dragPoint = document.getElementById(pdf_dragPointId);
    var page = document.getElementById(pdf_pageId);
    var pageRect = page.getBoundingClientRect();
    var signAreaRect = pdf_signArea.getBoundingClientRect();
    if (dragPoint.classList.contains('dragPoint-nord')) {
        var height = pdf_originalHeight - (e.pageY - pdf_originalMouseY);
        var newTop = pdf_original_y + (e.pageY - pdf_originalMouseY);
        if (height > pdf_minimumSize) {
            if (newTop > pageRect.top) {
                pdf_signArea.style.height = height + 'px';
                pdf_signArea.style.top = newTop - pageRect.top + 'px';
                pdf_dragPointEst.style.top = (height / 2) + 'px';
                pdf_dragPointOvest.style.top = (height / 2) + 'px';
            } else {
                pdf_signArea.style.bottom = (pdf_initialRect.bottom - pageRect.top) + 'px';
                pdf_signArea.style.top = '0px';
            }
        }
    } else if (dragPoint.classList.contains('dragPoint-sud')) {
        var height = pdf_originalHeight + (e.pageY - pdf_originalMouseY);
        var newBottom = signAreaRect.top + height;
        if (height > pdf_minimumSize) {
            if (newBottom < pageRect.bottom) {
                pdf_signArea.style.height = height + 'px';
                pdf_dragPointEst.style.top = (height / 2) + 'px';
                pdf_dragPointOvest.style.top = (height / 2) + 'px';
            } else {
                pdf_signArea.style.bottom = pageRect.height + 'px';
            }
        }
    } else if (dragPoint.classList.contains('dragPoint-ovest')) {
        var width = pdf_originalWidth - (e.pageX - pdf_originalMouseX);
        var newLeft = pdf_original_x + (e.pageX - pdf_originalMouseX);
        if (width > pdf_minimumSize) {
            if (newLeft > pageRect.left) {
                pdf_signArea.style.width = width + 'px';
                pdf_signArea.style.left = newLeft - pageRect.left + 'px';
                pdf_dragPointNord.style.left = (width / 2) + 'px';
                pdf_dragPointSud.style.left = (width / 2) + 'px';
            } else {
                pdf_signArea.style.left = '0px';
            }
        }
    } else if (dragPoint.classList.contains('dragPoint-est')) {
        var width = pdf_originalWidth + (e.pageX - pdf_originalMouseX);
        var newRight = signAreaRect.left + width;
        if (width > pdf_minimumSize) {
            if (newRight < pageRect.right) {
                pdf_signArea.style.width = width + 'px';
                pdf_dragPointNord.style.left = (width / 2) + 'px';
                pdf_dragPointSud.style.left = (width / 2) + 'px';
            } else {
                pdf_signArea.style.right = pageRect.width + 'px';
            }
        }
    }
}

/**
 * Funzione eseguita a seguito di un evento mouseup.
 * 
 * Si occupa di rimuovere gli eventi mousemove e mouseup dalla window e di 
 * invocare il metodo Java appearanceResized che aggiorna l'appearance.
 * 
 * @param {type} e l'evento mouseup
 * @returns {undefined}
 */
function pdf_stopResize(e) {
    window.removeEventListener('mousemove', pdf_resize);
    window.removeEventListener('mouseup', pdf_stopResize);
    var rect = pdf_signArea.getBoundingClientRect();
    var pageRect = document.getElementById(pdf_pageId).getBoundingClientRect();
    var top = rect.top - pageRect.top;
    var left = rect.left - pageRect.left;
    if (top + rect.height > pageRect.bottom) {
        rect.height = pageRect.bottom - rect.top;
    }
    if (left + rect.width > pageRect.rigth) {
        rect.width = pageRect.rigth - rect.left;
    }
    $controller$.appearanceResized(pdf_signatureId, top, left, rect.width - 4, rect.height - 4);
}

/**
 * 
 * End Gestione Resize-------------------------------------------------------------------------------------------------------------
 * 
 */

/**
 * 
 * Start Gestione Move-------------------------------------------------------------------------------------------------------------
 * 
 */

var pdf_originalImageX;
var pdf_originalImageY;

var pdf_dragOriginalMouseX;
var pdf_dragOriginalMouseY;

var pdf_appearance;
var pdf_dragPage;

/**
 * Funzione eseguita a seguito di un evento mousedown sull'appearance selezionata.
 * 
 * Si occupa di reperire la posizione iniziale e gli id di tutti gli elementi 
 * interessati dal drag.
 * 
 * Aggiunge gli eventi mousemove e mouseup alla window. Questi eventi vengono 
 * aggiunti adesso per evitare strani comportamenti sull'interfaccia.
 * 
 * @param {type} evt l'evento mousedown
 * @param {type} appearanceId id dell'appearance
 * @param {type} pageId id della pagina su cui è presente l'appearance
 * @returns {undefined}
 */
function pdf_onDragImage(evt, appearanceId, pageId) {
    evt.stopPropagation();
    pdf_signArea = document.getElementById(appearanceId);
    pdf_originalImageX = pdf_signArea.getBoundingClientRect().left;
    pdf_originalImageY = pdf_signArea.getBoundingClientRect().top;
    pdf_dragOriginalMouseX = evt.pageX;
    pdf_dragOriginalMouseY = evt.pageY;

    pdf_appearance = document.getElementById(appearanceId);
    pdf_dragPage = document.getElementById(pageId);

    window.addEventListener('mousemove', pdf_moveImage);
    window.addEventListener('mouseup', pdf_stopMoveImage);
}

/**
 * Funzione eseguita a seguito di un evento mousemove.
 * 
 * Si occupa di spostare l'appearance sulla pagina.
 * L'appearance non può superare i limiti della pagina.
 * 
 * @param {type} evt evento mousemove
 * @returns {undefined}
 */
function pdf_moveImage(evt) {
    var pageRect = pdf_dragPage.getBoundingClientRect();

    var newLeft = pdf_originalImageX + (evt.pageX - pdf_dragOriginalMouseX);
    var newTop = pdf_originalImageY + (evt.pageY - pdf_dragOriginalMouseY);

    var signRect = pdf_signArea.getBoundingClientRect();

    if (newLeft < pageRect.left) {
        pdf_appearance.style.left = "0px";
    } else if (newLeft + signRect.width > pageRect.right) {
        pdf_appearance.style.left = ((pageRect.right - signRect.width) - pageRect.left) + "px";
    } else {
        pdf_appearance.style.left = (newLeft - pageRect.left) + "px";
    }
    if (newTop < pageRect.top) {
        pdf_appearance.style.top = "0px";
    } else if (newTop + signRect.height > pageRect.bottom) {
        pdf_appearance.style.top = ((pageRect.bottom - signRect.height) - pageRect.top) + "px";
    } else {
        pdf_appearance.style.top = (newTop - pageRect.top) + "px";
    }
}

/**
 * Funzione eseguita a seguito di un evento mouseup.
 * 
 * Si occupa di rimuovere gli eventi mousemove e mouseup dalla window e di 
 * invocare il metodo Java appearanceMoved che aggiorna l'appearance.
 * 
 * @returns {undefined}
 */
function pdf_stopMoveImage() {
    window.removeEventListener('mousemove', pdf_moveImage);
    window.removeEventListener('mouseup', pdf_stopMoveImage);
    var rect = pdf_appearance.getBoundingClientRect();
    var pageRect = pdf_dragPage.getBoundingClientRect();
    $controller$.appearanceMoved(pdf_appearance.id, rect.top - pageRect.top, rect.left - pageRect.left);
}

/**
 * 
 * End Gestione Move-------------------------------------------------------------------------------------------------------------
 * 
 */

var pdf_selectedAppearance;

/**
 * Funzione eseguita a seguito di un evento mousedown sull'appearance.
 * 
 * Se l'appearance su cui è avvenuto l'evento è diversa dalla precedente 
 * selezionata, invoca il metodo Java appearanceSelected passandogli l'id.
 * 
 * @param {type} evt evento mousedown
 * @param {type} appearanceId id dell'appearance selezionata
 * @returns {undefined}
 */
function pdf_select(evt, appearanceId) {
    if (pdf_selectedAppearance !== appearanceId) {
        $controller$.appearanceSelected(appearanceId);
    }
}

function set_selected_appearance(appearanceId) {
    pdf_selectedAppearance = appearanceId;
}

/**
 * Stop event propagation
 * 
 * @param {Event} evt the event to interrupt the propagation
 * @returns {undefined}
 */
function pdf_stopEvent(evt) {
    evt.stopPropagation();
}

function pdf_onDeleteAppearanceEvent(evt, elementId) {
    $controller$.onDeleteAppearanceEvent(elementId);
    evt.stopPropagation();
}

function pdf_imageLoaded(loadingAreaId, imageId) {
    remove(loadingAreaId);
    pdf_completeLoading(imageId);
}

function pdf_completeLoading(imageId) {
    $controller$.completeLoading(imageId);
}

function pdf_reset() {
    pdf_mainPageDimension = {width: 0, height: 0};
    pdf_previewPageDimension = {width: 0, height: 0};

    pdf_signCount = 0;
    pdf_startX = 0;
    pdf_startY = 0;
    pdf_currentSignature = null;
    pdf_signing = false;
    pdf_signatureArea = {top: 0, left: 0, width: 0, height: 0};

    pdf_signLayerList = [];

    pdf_signParent = null;

    pdf_dragPointId = null;
    pdf_pageId = null;
    pdf_signatureId = null;
    pdf_signArea = null;

    pdf_originalHeight = 0;
    pdf_originalWidth = 0;

    pdf_originalMouseX = 0;
    pdf_originalMouseY = 0;

    pdf_minimumSize = 20;

    pdf_original_x = 0;
    pdf_original_y = 0;

    pdf_dragPointNord = null;
    pdf_dragPointSud = null;
    pdf_dragPointOvest = null;
    pdf_dragPointEst = null;

    pdf_initialRect = null;

    pdf_originalImageX = 0;
    pdf_originalImageY = 0;

    pdf_dragOriginalMouseX = 0;
    pdf_dragOriginalMouseY = 0;

    pdf_appearance = null;
    pdf_dragPage = 0;

    pdf_selectedAppearance = null;
}