function showCGTooltipIfOverflow(elementId, tooltipId) {
    try {
        showCGTooltipIfOverflowUnsafe(elementId, tooltipId);
    } catch (exception) {
        error("showCGTooltipIfOverflow(" + elementId + ", " + tooltipId + ")");
        error(exception.stack);
        try {
            showCGTooltipIfOverflowUnsafe(elementId + "_0", tooltipId);
        } catch (exception) {
            error("showCGTooltipIfOverflow(" + elementId + "_0, " + tooltipId + ")");
            error(exception.stack);
        }
    }
}

function showCGTooltipIfOverflowUnsafe(elementId, tooltipId) {
    var element = document.getElementById(elementId);
    if (element.offsetWidth < element.scrollWidth) {
        showCGTooltip(elementId, tooltipId);
    }
}

function showCGTooltipIfOverflowMultiple(elementId, tooltipId, controlId, count) {
    try {
        for (let i = 0; i < count; i++) {
            var element = document.getElementById(controlId + "_" + i);
            if (element.offsetWidth < element.scrollWidth) {
                showCGTooltip(elementId, tooltipId);
                return;
            }
        }
    } catch (exception) {
        error("showCGTooltipIfOverflowMultiple(" + elementId + ", " + tooltipId + ", " + controlId + ", " + count + ")");
        error(exception.stack);
    }
}

function showCGTooltip(elementId, tooltipId) {
    var element = document.getElementById(elementId);
    var tooltip = document.getElementById(tooltipId);
    tooltip.style.top = 'auto';
    tooltip.style.left = 'auto';
    tooltip.style.right = 'auto';
    removeClass(tooltipId, 'cg-topTooltip-hide');
    var elementRect = element.getBoundingClientRect();
    var elementHalfWidth = (elementRect.right - elementRect.left) / 2;
    var tooltipRect = tooltip.getBoundingClientRect();
    var tooltipHeight = tooltipRect.bottom - tooltipRect.top;
    if (tooltipRect.top < 0) {
        tooltipHeight = 0;
    }
    var tooltipWidth = tooltipRect.right - tooltipRect.left;
    if (tooltipHeight + 15 < elementRect.top) {
        // Il tooltip ha abbastanza spazio in alto
        // info("Il tooltip ha abbastanza spazio in alto");
        tooltip.style.top = (elementRect.top - tooltipHeight - 15) + 'px';
        setTooltipHorizontalPosition(tooltip, elementRect, tooltipWidth, elementHalfWidth);
        tooltipRect = tooltip.getBoundingClientRect();
        var tooltipAnchor = document.getElementById(tooltipId + "_i");
        tooltipAnchor.style.left = (elementRect.left + elementHalfWidth) + 'px';
        tooltipAnchor.style.top = (tooltipRect.bottom) + 'px';
        removeClass(tooltipId + "_i", 'cg-topTooltip_anchor_top');
        addClass(tooltipId + "_i", 'cg-topTooltip_anchor_bottom');
    } else {
        // Il tooltip non ha abbastanza spazio in alto
        // info("Il tooltip non ha abbastanza spazio in alto");
        tooltip.style.top = (elementRect.bottom + 15) + 'px';
        setTooltipHorizontalPosition(tooltip, elementRect, tooltipWidth, elementHalfWidth);
        tooltipRect = tooltip.getBoundingClientRect();
        var tooltipAnchor = document.getElementById(tooltipId + "_i");
        tooltipAnchor.style.left = (elementRect.left + elementHalfWidth) + 'px';
        tooltipAnchor.style.top = (tooltipRect.top - 12) + 'px';
        removeClass(tooltipId + "_i", 'cg-topTooltip_anchor_bottom');
        addClass(tooltipId + "_i", 'cg-topTooltip_anchor_top');
    }
}

function setTooltipHorizontalPosition(tooltip, elementRect, tooltipWidth, elementHalfWidth) {
    var tooltipHalfWidth = tooltipWidth / 2;
    if (tooltipHalfWidth < elementRect.left + elementHalfWidth) {
        // il tooltip ha abbastanza spazio a sinistra
        // info("il tooltip ha abbastanza spazio a sinistra");
        var desiredTooltipLeft = elementRect.left + elementHalfWidth - tooltipHalfWidth;
        if (desiredTooltipLeft + tooltipWidth + 15 < window.innerWidth) {
            // il tooltip ha abbastanza spazio a destra
            // info("il tooltip ha abbastanza spazio a destra");
            tooltip.style.left = (desiredTooltipLeft - 15) + 'px';
//            tooltip.style.right = (window.innerWidth - desiredTooltipLeft - tooltipWidth) + 'px';
        } else {
            // il tooltip non ha abbastanza spazio a destra
            // info("il tooltip non ha abbastanza spazio a destra");
            tooltip.style.right = 15 + 'px';
//            tooltip.style.left = (window.innerWidth - 15 - tooltipWidth) + 'px';
        }
    } else {
        // il tooltip non ha abbastanza spazio a sinistra
        // info("il tooltip non ha abbastanza spazio a sinistra");
        if (tooltipWidth + 15 < window.innerWidth) {
            // il tooltip ha abbastanza spazio a destra
            // info("il tooltip ha abbastanza spazio a destra");
            tooltip.style.left = 15 + 'px';
//            tooltip.style.right = (window.innerWidth - desiredTooltipLeft - tooltipWidth) + 'px';
        } else {
            // il tooltip non ha abbastanza spazio a destra
            // caso in cui il tooltip è più largo della finestra
            // info("Not set tooltip left ");
        }
    }
}

function hideCGTooltip(tooltipId) {
    addClass(tooltipId, 'cg-topTooltip-hide');
}
