/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.armpclient.utils;

import it.arubapec.armpclient.exception.CertVerificationException;
import it.arubapec.armpclient.utils.CRLClient$OCSPClient;
import it.arubapec.armpclient.utils.OCSPClient$CRLClient;
import it.arubapec.armpclient.utils.OCSPClient$OCSPClient;
import it.arubapec.armpclient.utils.auchrzch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;

public class CRLClient {
    private static final Logger logger = CRLClient.VZ("nf3mni", CRLClient.class);

    public static boolean checkRevocation(X509Certificate cert) throws CertVerificationException {
        return CRLClient.checkRevocation(null, cert);
    }

    public static boolean checkRevocation(X509Certificate issuerCert, X509Certificate cert) throws CertVerificationException {
        char[] cArray = "\ud15d\uaa9b\ua6df\u90e1\uaee0\udcd0\u8f8d\uc565\u430f\u2e37\ue2d4\u55fb\u5735\uf46b\u46c0\ud083\u2923".toCharArray();
        cArray[12] = (char)(cArray[12] ^ 0x2390);
        logger.debug(OCSPClient$CRLClient.Z(cArray, (short)8030, false, true));
        try {
            List<String> crlDistPoints = CRLClient.getCrlDistributionPoints(cert);
            if (crlDistPoints.isEmpty()) {
                char[] cArray2 = "\u6cae\u08ab\uccf9\u3ae3\u48c1\ueab1\ue87e\u8ee8\u2f81\u7764\u08d9\u5823\uae30\ud1c5\ue945\u4a37\ub8d1\u4e42\uaa78 \u3e4e\u2952\u3a4b".toCharArray();
                cArray2[12] = (char)(cArray2[12] ^ 0xBF9);
                logger.error(OCSPClient$CRLClient.Z(cArray2, (short)29477, true, false));
                char[] cArray3 = "\u36a5\ue2f1\u1f85\uda8e\uc6ea\uaec1\u76e0\u4ce8\ubc21\u6ed2\uee5b\ub1c7\ua9ba\u6f73\ub1ee\u75b2\uf90f\u4f50\u915d\u6d00\uee78\u4e47\u6076".toCharArray();
                cArray3[12] = (char)(cArray3[12] ^ 0x3E67);
                throw new CertVerificationException(OCSPClient$CRLClient.Z(cArray3, (short)31330, true, true));
            }
            for (String crlDP : crlDistPoints) {
                X509CRL crl = CRLClient.downloadCRL(crlDP);
                if (issuerCert != null) {
                    char[] cArray4 = "\u08a9\u3086\u41ee\ua549\u53b4\ua62c\u4efe\ue4af\uc33e\u3927\u4780\u020a\u934e\ub5d3\u030d\u7a42\u6f3f\u5f79\u1aa8\u4a0c\uc0d6\u116f\u5b32\u557d\uadfd\ud64b\udea1\u7e32\u7ce5\u1fba\ub4cd\u0539\ueb26\u8f9a\u51cb\u1093\ua019\u1f84".toCharArray();
                    cArray4[3] = (char)(cArray4[3] ^ 0x5F52);
                    logger.debug(OCSPClient$CRLClient.Z(cArray4, (short)22778, true, false));
                    try {
                        CRLClient.VZ("-l4g98c", crl, CRLClient.VZ("-1ii098k", issuerCert));
                    }
                    catch (Exception e) {
                        char[] cArray5 = "\u7cf2\u7298\u3dab\u4cd9\u00c0\uecd2\u62d8\ucb53\ubd14\u8813\u1115\u3f7e\ua0b4\uc71f\u8a96\u5fe8\u2a14\u9f05\u4d7a\ucc7e\uc6a4\u4086".toCharArray();
                        cArray5[17] = (char)(cArray5[17] ^ 0x7E29);
                        throw new CertVerificationException(OCSPClient$CRLClient.Z(cArray5, (short)5645, false, false), e);
                    }
                }
                if (CRLClient.VZ("-1bju98b", crl, cert) == false) continue;
                char[] cArray6 = "\u4d7b\u0f98\u28ee\ud7d6\ue2f1\u6554\u7976\udf3f\u0693\ued3a\uba05\u31de\u6fa1\u1804\u36a6\u4206\ubbb8\ua733\u6401\u49b8".toCharArray();
                cArray6[0] = (char)(cArray6[0] ^ 0x7D9A);
                logger.error(OCSPClient$CRLClient.Z(cArray6, (short)17737, false, false));
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((String)CRLClient.VZ("1k2pmmt", ex), (Throwable)ex);
            if (ex instanceof CertVerificationException) {
                throw (CertVerificationException)ex;
            }
            char[] cArray7 = "\u0b48\u5b6c\u4d62\u3771\u685b\u8004\u4647\uf1cd\u3eba\u3e24\u9f8f\u980d\ud7a6\uf042\ue9d2\u590d\u53ec\ua5aa\u234f\u5a6f\u2ec0\ubb9c\ucff4\u56e9\u7739\u6bad\uca3b\ud7a6\u3ee8\u7704\ue1ad\ud7d7\u361f\uf3a9\ub84c\u52b9\u0cde".toCharArray();
            cArray7[31] = (char)(cArray7[31] ^ 0x33B7);
            throw new CertVerificationException((String)CRLClient.VZ("hapme6", CRLClient.VZ("-jkg980", CRLClient.VZ("fn9me5", new StringBuilder(), OCSPClient$CRLClient.Z(cArray7, (short)19200, true, false)), CRLClient.VZ("5hpmnm", cert))));
        }
        char[] cArray8 = "\ub615\u2e0a\u7f9c\u8a08\ucee3\u6894\ucf9c\u08bf\u360e\u42b5\u9e78\u3cae\ua0bd\uf845\uadb5\u0fc8\uf7ec\u3636\u1016\u0a92\ud9a8\u737c".toCharArray();
        cArray8[8] = (char)(cArray8[8] ^ 0x5177);
        logger.debug(OCSPClient$CRLClient.Z(cArray8, (short)5160, true, true));
        return true;
    }

    private static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, CertVerificationException, NamingException {
        block5: {
            block4: {
                char[] cArray = "\u5710\u5130\ub86c\u7d52\ueefa\uf00c\u8564\u8109\u091e\ud1bc\u7ee8\u9681\u6587".toCharArray();
                cArray[9] = (char)(cArray[9] ^ 0x6BA5);
                logger.debug(OCSPClient$OCSPClient.q(cArray, (short)29890, (short)0, (short)1));
                char[] cArray2 = "\u324a\udb30\ud6ae\u2fca\u4a9e\u8cd6\u8079\u3164".toCharArray();
                cArray2[6] = (char)(cArray2[6] ^ 0x33E6);
                if (CRLClient.VZ("1mfjmnn", crlURL, OCSPClient$OCSPClient.q(cArray2, (short)3214, (short)4, (short)1)) != false) break block4;
                char[] cArray3 = "\u9875\u66d8\u4caf\u1a25\u8617\u4707\uaf72\ub11a\u69fd".toCharArray();
                cArray3[1] = (char)(cArray3[1] ^ 0x1C4D);
                if (CRLClient.VZ("1mfjmnn", crlURL, OCSPClient$OCSPClient.q(cArray3, (short)30707, (short)2, (short)5)) != false) break block4;
                char[] cArray4 = "\u3e7b\ucd56\u5802\ub58e\u1201\u3f78\u686e".toCharArray();
                cArray4[3] = (char)(cArray4[3] ^ 0x5D64);
                if (CRLClient.VZ("1mfjmnn", crlURL, OCSPClient$OCSPClient.q(cArray4, (short)29084, (short)4, (short)3)) == false) break block5;
            }
            return CRLClient.downloadCRLFromWeb(crlURL);
        }
        char[] cArray = "\u3d35\u7e64\ud02a\u3a19\u5ecf\uc94a\ufcb4\u0127".toCharArray();
        cArray[6] = (char)(cArray[6] ^ 0x528C);
        if (CRLClient.VZ("1mfjmnn", crlURL, OCSPClient$OCSPClient.q(cArray, (short)178, (short)5, (short)2)) != false) {
            return CRLClient.downloadCRLFromLDAP(crlURL);
        }
        char[] cArray5 = "\uf1b7\ua80a\u1c03\u6796\u20d8\uc824\u38e6\u4507\u9c3c\udf4c\uf907\udc31\ufd09\ub78d\u4299\udf61\uc2c6\u0474\uebcb\ue4d2\u07c8\u8435\u27a9\uc13c\u63e6\u0ee2\u0c53\u0d75\u9b64\ub7d2\u2498\u4ec4\udd3f\u800a\u3c25\u287a\u1ec9\ua186\ufab4\u455a\u8a46\u2882\u1087\u7084\ud0f7\u3282\u636c\u0735\ufaf9\u74b0\u6621\u27f5\ua16d\ucfd6\u98c8\uf70f\udc22\u6a6c\u78a6".toCharArray();
        cArray5[53] = (char)(cArray5[53] ^ 0x7523);
        throw new CertVerificationException((String)CRLClient.VZ("hapme6", CRLClient.VZ("fn9me5", CRLClient.VZ("fn9me5", new StringBuilder(), OCSPClient$OCSPClient.q(cArray5, (short)4344, (short)3, (short)5)), crlURL)));
    }

    private static X509CRL downloadCRLFromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, CertVerificationException {
        char[] cArray = "\u83eb\u3479\ue160\u36dc\u99d3\u0688\u28fc\uf019\u8978\ue0ee\u12bd\uc08b\u335e\u1466\uebd7\ub3ab\uac0d\u554c\u1319\u28ee\ue912\u3f8c".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x371);
        logger.debug(OCSPClient$CRLClient.Z(cArray, (short)1999, false, true));
        Hashtable<String, String> env = new Hashtable<String, String>();
        char[] cArray2 = "\u5f6e\u2598\ufb30\u3bc1\u66b0\uf6e0\u5814\ud6a4\ua03e\u2424\u8095\uf94b\u0506\u4152\u447d\ub754\u8dfa\ud9ec\u8f02\u67dc\uc885\u7c69\uc9b7\ud268\u0340\ub43f\u55ef\u0b53".toCharArray();
        cArray2[15] = (char)(cArray2[15] ^ 0x35C3);
        char[] cArray3 = "\u8948\ue59a\u81f3\uf206\u201d\u6d71\ud774\uc47d\u38aa\ub0ef\u03a3\u7e28\u8af6\udd01\ufe85\u4834\u62d1\u7753\u882d\u7edb\u2431\u63df\ua04c\u4003\u1c41\u72d3\ucf81\u7a88\u3fce\uf109\u9edb\uccf1\u7919".toCharArray();
        cArray3[5] = (char)(cArray3[5] ^ 0xDA8);
        env.put(OCSPClient$CRLClient.Z(cArray2, (short)16697, false, false), OCSPClient$CRLClient.Z(cArray3, (short)1723, true, false));
        char[] cArray4 = "\u9aff\u072b\u9245\u0692\udfc5\u4d22\u77a8\u7b84\u65d0\ua636\ue0e6\u12f4\uc322\u1a9e\u6d76\uea03\ufbd8\ua38f\u2adf\u4db8\u8f90\uc437\u28bc\ua73c\u3109".toCharArray();
        cArray4[7] = (char)(cArray4[7] ^ 0x4568);
        env.put(OCSPClient$CRLClient.Z(cArray4, (short)10168, true, false), ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes avals = ctx.getAttributes("");
        char[] cArray5 = "\ub319\u957b\u61b6\uc270\u7128\u1712\u4322\ue5bb\u3a60\ue87a\ue9dc\u1263\u94b6\u74aa\u7d32\ub53e\u46b7\ucf61\u7857\u2ca3\u045f\u03e0\ubc63\u7f1e\u427f\uc349\ua919\ue025\u72ee\u0004\u71f1\u54cb\u4797".toCharArray();
        cArray5[1] = (char)(cArray5[1] ^ 0x735C);
        Attribute aval = avals.get(OCSPClient$CRLClient.Z(cArray5, (short)9780, true, true));
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            char[] cArray6 = "\uf79b\u6d6f\u14b5\ubd4a\ub40d\udb48\u1929\ub55d\ueb80\ue8d8\uce15\ufb14\u4260\u8d15\uc8a7\u86fa\u4c7a\u8a07\ud2c3\u8f2f\uc9bf\u53c6\u157e\ube83\u5d31\u0643\u9dab\u3e0b".toCharArray();
            cArray6[16] = (char)(cArray6[16] ^ 0x571B);
            throw new CertVerificationException((String)CRLClient.VZ("hapme6", CRLClient.VZ("fn9me5", CRLClient.VZ("fn9me5", new StringBuilder(), OCSPClient$CRLClient.Z(cArray6, (short)3196, false, true)), ldapURL)));
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        char[] cArray7 = "\u58b1\udd7b\uf6b5\uc18f\u0311\u477c".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x7B0E);
        Object cf = CRLClient.VZ("-5oa99a", OCSPClient$CRLClient.Z(cArray7, (short)7746, false, false));
        return (X509CRL)CRLClient.VZ("6r3mno", cf, inStream);
    }

    private static X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        char[] cArray = "\u1e4c\ua211\u313f\u8574\uc3aa\ua9b1\u7da8\u47f5\u61c5\u25e4\u8d00\uccb7\u0388\ub77a\ua509\u8c70\uc7c9\u38a9\u980a\ued79\u5b34".toCharArray();
        cArray[10] = (char)(cArray[10] ^ 0x4192);
        logger.debug(CRLClient$OCSPClient.i(cArray, (short)6968, true, false));
        URL url = new URL(crlURL);
        Object crlStream = CRLClient.VZ("-1aim98v", url);
        Throwable throwable = null;
        try {
            char[] cArray2 = "\uf164\udd1b\u4308\ub753\u4aa8\u7241".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x6AC1);
            Object cf = CRLClient.VZ("-5oa99a", CRLClient$OCSPClient.i(cArray2, (short)27723, false, false));
            X509CRL x509CRL = (X509CRL)CRLClient.VZ("6r3mno", cf, crlStream);
            return x509CRL;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (crlStream != null) {
                if (throwable != null) {
                    try {
                        CRLClient.VZ("-pak9ah", crlStream);
                    }
                    catch (Throwable throwable3) {
                        CRLClient.VZ("uuvmms", throwable, throwable3);
                    }
                } else {
                    CRLClient.VZ("-pak9ah", crlStream);
                }
            }
        }
    }

    private static List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateParsingException, IOException {
        char[] cArray = "\u9223\u2191\u67b4\uf790\uf24b\u008e\ud155\ue05a\uc817\u34c7\u4a46\u031f\uccb0\u3699\u0cf5\ucc4d\u0aa0\u7ae6\u47a3\u8f4d\ubf93\ubb42\u3289\u3a5b\uaa03\ud22b\u43ff\u6e86\uee60\u83db\u2bf8".toCharArray();
        cArray[24] = (char)(cArray[24] ^ 0x6EF2);
        logger.debug(CRLClient$OCSPClient.i(cArray, (short)30291, true, true));
        byte[] crldpExt = (byte[])CRLClient.VZ("-1ldq97m", cert, CRLClient.VZ("-tas987", Extension.cRLDistributionPoints));
        if (crldpExt == null) {
            return new ArrayList<String>();
        }
        ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
        Object derObjCrlDP = CRLClient.VZ("1d6vmob", oAsnInStream);
        DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
        byte[] crldpExtOctets = (byte[])CRLClient.VZ("3g1moc", dosCrlDP);
        ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
        Object derObj2 = CRLClient.VZ("1d6vmob", oAsnInStream2);
        Object distPoint = CRLClient.VZ("-1pbe97j", derObj2);
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (DistributionPoint dp : (DistributionPoint[])CRLClient.VZ("18ufmme", distPoint)) {
            GeneralName[] genNames;
            Object dpn = CRLClient.VZ("-1f9c99h", dp);
            if (dpn == null || CRLClient.VZ("-fpa99g", dpn) != false) continue;
            for (GeneralName genName : genNames = (GeneralName[])CRLClient.VZ("-8c97t", CRLClient.VZ("b47mo2", CRLClient.VZ("-a5299f", dpn)))) {
                if (CRLClient.VZ("-174697s", genName) != 6) continue;
                Object url = CRLClient.VZ("-133s97p", CRLClient.VZ("1ls9mo6", CRLClient.VZ("-1d0o97r", genName)));
                crlUrls.add((String)url);
            }
        }
        char[] cArray2 = "\ucffd\ud26a\u772b\u32e3\u1f90\u99f8\u7f0a\uf4f5\u98a4\ua116\ubb97\u725c\ud4b4\ua2aa\ua3ac\u4f01\u2654\u92e7\u6334\u6071\ufd74\u03ac\uf177\u134d\ua6b3\u019a\u18dc\u7e68\uf0bd\u520f".toCharArray();
        cArray2[6] = (char)(cArray2[6] ^ 0x17B2);
        logger.info(CRLClient$OCSPClient.i(cArray2, (short)13290, false, false));
        return crlUrls;
    }

    private static Object VZ(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(auchrzch.h(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

