/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Video
extends DOMElement {
    private List<Source> sources = new ArrayList<Source>();
    private static int vid_id = 0;

    public Video(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("video", id, parentId);
    }

    public Video(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("video", id, parent.getId());
    }

    private Video(String id, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
    }

    public void load() {
        this.view.execute(new StringBuilder(this.id.length() + 38).append("document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\").load();").toString());
    }

    public void setSource(String src, String type) {
        for (Source s : this.sources) {
            s.remove();
        }
        this.sources.clear();
        Source source = new Source("src_" + vid_id++ + "_" + this.hashCode(), this, this.view);
        source.setSource(src);
        source.setType(type);
        this.sources.add(source);
    }

    public void setSources(Map<String, String> sources) {
        for (Source source : this.sources) {
            source.remove();
        }
        this.sources.clear();
        for (Map.Entry entry : sources.entrySet()) {
            Source source = new Source("src_" + vid_id++ + "_" + this.hashCode(), this, this.view);
            source.setSource((String)entry.getKey());
            source.setType((String)entry.getValue());
            this.sources.add(source);
        }
    }

    public void clearSources() {
        for (Source s : this.sources) {
            s.remove();
        }
        this.sources.clear();
    }

    public void addSource(String src, String type) {
        Source source = new Source("src_" + vid_id++ + "_" + this.hashCode(), this, this.view);
        source.setSource(src);
        source.setType(type);
        this.sources.add(source);
    }

    public void removeSource(String src) {
        boolean found = false;
        int i = -1;
        while (!found && i < this.sources.size()) {
            if (!this.sources.get(++i).getSource().equals(src)) continue;
            found = true;
            this.sources.get(i).remove();
        }
        if (found) {
            this.sources.remove(i);
        }
    }

    public static Video retrieveVideo(String id, View currentView) {
        return Video.getElementById(id, currentView);
    }

    public static Video getElementById(String id, View currentView) {
        if (Video.exist(id, currentView)) {
            return new Video(id, currentView);
        }
        return null;
    }

    private class Source
    extends DOMElement {
        public Source(String id, String parentId, View view) {
            super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
            this.createElementWithIDAndAppendIt("source", id, parentId);
        }

        public Source(String id, DOMElement parent, View view) {
            super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
            this.createElementWithIDAndAppendIt("source", id, parent.getId());
        }

        public void setSource(String src) {
            this.setAttribute("src", src);
        }

        public void setType(String type) {
            this.setAttribute("type", type);
        }

        public String getSource() {
            return this.getAttribute("src");
        }

        public String getType() {
            return this.getAttribute("type");
        }
    }
}

