/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.Constants;
import esecurity.desktop.View;
import esecurity.desktop.swt.Shell;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class FileDialog {
    private final View view;
    private final String title;
    private final String[] filters;
    private String initialFileName;
    private String initialDirectory;

    public FileDialog(View view, String title, String[] filters) {
        this.view = view;
        this.title = title;
        this.filters = filters;
    }

    public List<String> showOpenDialog(boolean multipleSelection) {
        if (!Constants.DEVELOP) {
            esecurity.desktop.swt.FileDialog dialog = multipleSelection ? new esecurity.desktop.swt.FileDialog((Shell)this.view.getWindow(), 2) : new esecurity.desktop.swt.FileDialog((Shell)this.view.getWindow(), 4);
            dialog.setText(this.title);
            dialog.setFilterExtensions(this.filters);
            String filePath = dialog.open();
            if (filePath != null) {
                String[] filePaths = new String[dialog.getFileNames().length];
                int index = 0;
                for (String fileName : dialog.getFileNames()) {
                    System.out.println("FilterPath: " + dialog.getFilterPath() + " FileName: " + fileName);
                    filePaths[index] = dialog.getFilterPath() + File.separator + fileName;
                    ++index;
                }
                if (filePaths.length == 0) {
                    return new ArrayList<String>();
                }
                return Arrays.asList(filePaths);
            }
            return new ArrayList<String>();
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        f.pack();
        f.setVisible(false);
        f.setAlwaysOnTop(true);
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(f);
        f.dispose();
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(file.getAbsolutePath());
            return ret;
        }
        return new ArrayList<String>();
    }

    public File showSaveDialog() {
        if (!Constants.DEVELOP) {
            String filePath;
            esecurity.desktop.swt.FileDialog dialog = new esecurity.desktop.swt.FileDialog((Shell)this.view.getWindow(), 8192);
            dialog.setText(this.title);
            dialog.setFilterExtensions(this.filters);
            if (this.initialFileName != null) {
                dialog.setFileName(this.initialFileName);
            }
            if (this.initialDirectory != null) {
                dialog.setFilterPath(this.initialDirectory);
            }
            if ((filePath = dialog.open()) != null) {
                return new File(filePath);
            }
            return null;
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        f.pack();
        f.setVisible(false);
        f.setAlwaysOnTop(true);
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(f);
        f.dispose();
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public void setInitialFileName(String initialFileName) {
        this.initialFileName = initialFileName;
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectory = initialDirectory;
    }
}

