/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.model;

import esecurity.desktop.Closable;
import esecurity.desktop.Listener;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.ArrayList;
import java.util.List;

public abstract class ListHandler<T> {
    private final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected List OBJECTS = new ArrayList();
    protected List<Listener<List<T>>> LISTENERS = new ArrayList<Listener<List<T>>>();

    public void addListener(Listener<List<T>> listener) {
        this.LISTENERS.add(listener);
    }

    public void removeListener(Listener<List<T>> listener) {
        this.LISTENERS.remove(listener);
    }

    public void removeAllListeners() {
        this.LISTENERS.clear();
    }

    public <T> void replace(T t, T t2) {
        if (this.OBJECTS.remove(t)) {
            this.OBJECTS.add(0, t2);
            this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
        }
    }

    public <T> void replaceAll(List<T> list, List<T> list2) {
        list.forEach(object -> this.OBJECTS.remove(object));
        list2.forEach(object -> this.OBJECTS.add(object));
        this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
    }

    public <T> void add(T t) {
        if (!this.OBJECTS.contains(t)) {
            this.OBJECTS.add(0, t);
            this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
        }
    }

    public <T> void addAll(List<T> list) {
        ArrayList arrayList = new ArrayList();
        list.stream().filter(object -> !this.OBJECTS.contains(object)).forEach(object -> arrayList.add(object));
        if (arrayList.size() > 0) {
            this.OBJECTS.addAll(0, arrayList);
            this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
        }
    }

    public <T> void remove(T t) {
        if (t instanceof Closable) {
            try {
                ((Closable)t).close();
            }
            catch (Exception exception) {
                this.a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        if (this.OBJECTS.remove(t)) {
            this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
        }
    }

    public <T> void removeAll(List<T> list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        try {
            if (list.get(0) instanceof Closable) {
                for (T t : list) {
                    ((Closable)t).close();
                }
            }
        }
        catch (Exception exception) {
            this.a.error(exception.getMessage(), (Throwable)exception);
        }
        if (this.OBJECTS.removeAll(list)) {
            this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
        }
    }

    protected <T> List<T> getList(Class<T> clazz) {
        return new ArrayList(this.OBJECTS);
    }

    public void clear() {
        if (this.OBJECTS.size() <= 0) {
            return;
        }
        try {
            if (this.OBJECTS.get(0) instanceof Closable) {
                for (Object e2 : this.OBJECTS) {
                    ((Closable)e2).close();
                }
            }
        }
        catch (Exception exception) {
            this.a.error(exception.getMessage(), (Throwable)exception);
        }
        this.OBJECTS.clear();
        this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
    }

    protected <T> void resetInt(List<T> list) {
        this.OBJECTS.clear();
        this.OBJECTS.addAll(list);
        this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
    }

    public boolean contains(T t) {
        if (this.OBJECTS == null) {
            return false;
        }
        return this.OBJECTS.contains(t);
    }
}

