/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.utils.GUIUtils;
import esecurity.crypto.gui.utils.rootupdater.CertDBLoader;
import esecurity.validator.ValidationDate;
import esecurity.validator.Validator;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class ValidationFacade {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final Object b = new Object();
    private static final ExecutorService c = Executors.newSingleThreadExecutor();
    private static Future<Validator> d;
    private static ValidatorConfig e;
    private static CertDBLoader f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadValidator() {
        Object object = b;
        synchronized (object) {
            if (d != null) {
                return;
            }
            d = c.submit(() -> {
                try {
                    Validator validator;
                    block4: {
                        e = GUIUtils.getValidatorConfig();
                        e.setProxyAuthenticator(ClientProperties.getInstance().getNetworkConfig().getProxyauthenticator());
                        e.setNetConfiguration(ClientProperties.getInstance().getNetworkConfig());
                        validator = null;
                        try {
                            validator = new Validator(e, (Logger)a);
                        }
                        catch (CapiException capiException) {
                            if (f == null || capiException.getCause() == null || !(capiException.getCause() instanceof CertDBException)) break block4;
                            f.reloadOnCorrupted();
                            validator = new Validator(e, (Logger)a);
                        }
                    }
                    return validator;
                }
                catch (Throwable throwable) {
                    a.error(throwable.getMessage(), throwable);
                    return null;
                }
            });
            c.shutdown();
            return;
        }
    }

    public static void setCertDBLoader(CertDBLoader certDBLoader) {
        f = certDBLoader;
    }

    public static ValidatorConfig getValidatorConfig() throws InterruptedException, ExecutionException {
        ValidationFacade.a();
        return e;
    }

    public static ValidatedCertificate verifyCertificate(Certificate certificate, ValidationProfile validationProfile, ValidationDate validationDate) throws InterruptedException, ExecutionException {
        Validator validator = ValidationFacade.a();
        if (validator == null) {
            throw new ExecutionException("can not retrieve validator, see log for more details", null);
        }
        return validator.validate(certificate, validationProfile, validationDate);
    }

    public static ValidatedDocument verifyDocument(InputHandler inputHandler, ValidationProfile validationProfile, ValidationDate validationDate, EventHandlerSelector eventHandlerSelector) throws InterruptedException, ExecutionException {
        Validator validator = ValidationFacade.a();
        if (validator == null) {
            throw new ExecutionException("can not retrieve validator, see log for more details", null);
        }
        return validator.validate(inputHandler, validationProfile, validationDate, eventHandlerSelector);
    }

    public static ValidatedDocument verifyTransientDocument(TransientDocument transientDocument, ValidationProfile validationProfile, ValidationDate validationDate) throws InterruptedException, ExecutionException {
        Validator validator = ValidationFacade.a();
        if (validator == null) {
            throw new ExecutionException("can not retrieve validator, see log for more details", null);
        }
        return validator.validate(transientDocument, validationProfile, validationDate);
    }

    public static void updateValidationDate(ValidatedDocument validatedDocument, ValidationProfile validationProfile, ValidationDate validationDate) throws InterruptedException, ExecutionException {
        Validator validator = ValidationFacade.a();
        if (validator == null) {
            throw new ExecutionException("can not retrieve validator, see log for more details", null);
        }
        validator.updateValidationDate(validatedDocument, validationProfile, validationDate);
    }

    private static Validator a() throws ExecutionException, InterruptedException {
        if (d == null) {
            ValidationFacade.loadValidator();
        }
        while (!d.isDone()) {
            Thread.sleep(300L);
        }
        return d.get();
    }
}

