/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import esecurity.dsd.client.cmd.Command;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.http.DomainHTTPProvider;
import java.util.List;
import java.util.Optional;

@Parameters(separators="=: ", commandDescription="Get data from a domain")
public class CommandGet
implements Command {
    @Parameter(description="Property key to lookup")
    private List<String> propertyKeys;
    @Parameter(names={"domain"}, description="Domain from wich lookup")
    private String domainName;
    @Parameter(names={"domains"}, description="Domain names ")
    private boolean domains;

    @Override
    public void execute(LocalConfigurationProvider lcp) {
        if (this.domains) {
            try {
                DomainHTTPProvider domainHTTPProvider = new DomainHTTPProvider(lcp);
                if (domainHTTPProvider.availableDomains().isEmpty()) {
                    System.out.println("No domain avaliables.");
                }
                for (String domain : domainHTTPProvider.availableDomains()) {
                    System.out.println(domain);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Get data from domain " + this.domainName);
            try {
                PropertyContainer values = new DomainHTTPProvider(lcp).getDomainProperties(this.domainName);
                values.keySet().forEach(k -> {
                    Object v = Optional.ofNullable(values.getValue(k)).orElse(new Object(){

                        public String toString() {
                            return "";
                        }
                    });
                    String s = String.format(" %s : ", k);
                    System.out.println(String.format("%-35s %s", s, v));
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getCommand() {
        return "get";
    }
}

