/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.FileHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class TempFileInputHandler
extends InputHandler
implements FileHandler {
    private File a;
    protected boolean deleteOnClose = true;

    public TempFileInputHandler() throws FileNotFoundException, IOException {
        this.a = TmpFileUtils.createTempFile("handler", ".tmp");
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : this.a.getName(), this.a.length());
    }

    public TempFileInputHandler(String string, String string2) throws FileNotFoundException, IOException {
        this.a = TmpFileUtils.createTempFile("handler", ".tmp");
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : this.a.getName(), this.a.length());
    }

    public TempFileInputHandler(File file) throws FileNotFoundException {
        this.a = file;
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The specified file [" + file.getAbsolutePath() + "] doesn't exist!");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The specified file [" + file.getAbsolutePath() + "] is a directory!");
        }
        this.a = file;
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : file.getName(), file.length());
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.a));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return bufferedInputStream;
    }

    @Override
    public File getFile() {
        return this.a;
    }

    public void setDeleteOnClose(boolean bl) throws IOException {
        this.deleteOnClose = bl;
    }

    @Override
    public void close() {
        block4: {
            if (!this.closed) {
                try {
                    super.close();
                    if (!this.deleteOnClose) break block4;
                    this.a.delete();
                }
                catch (Throwable throwable) {
                    if (this.deleteOnClose) {
                        this.a.delete();
                    }
                    throw throwable;
                }
                return;
            }
        }
    }
}

