/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import org.slf4j.Logger;

public class DefaultOCSPCacheManager
implements OCSPCacheManager {
    private Logger a;
    private final int b;
    private final int c;
    private final LRUMap<String, OCSPResponse> d;

    public DefaultOCSPCacheManager(ValidatorConfig validatorConfig, Logger logger) throws CapiException {
        this.c = validatorConfig.getIntElement("x509StatusService.cacheSize", 300);
        this.b = validatorConfig.getIntElement("x509StatusService.cacheRetentionTime", 60000);
        this.d = new LRUMap(this.c);
        this.a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (logger != null) {
            this.a = logger;
        }
        this.a.debug(String.format("OCSP cache manger created with size of %s and retention time %d", this.c, this.b));
    }

    @Override
    public OCSPResponse get(String string) {
        OCSPResponse oCSPResponse = (OCSPResponse)this.d.get(string);
        if (oCSPResponse != null && oCSPResponse.getProducedAt() != null && new Date().getTime() - oCSPResponse.getProducedAt().getTime() > (long)this.b) {
            this.d.remove(string);
            oCSPResponse = null;
            this.a.debug(String.format("OCSP response for %s is expired and it was removed from cache", string));
        }
        return oCSPResponse;
    }

    @Override
    public boolean isInCache(String string) {
        return this.get(string) != null;
    }

    @Override
    public void addToCache(String string, OCSPResponse oCSPResponse) throws CapiException {
        this.d.put(string, oCSPResponse);
    }

    @Override
    public void removeFromCache(String string) throws CapiException {
        this.d.remove(string);
    }
}

