/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;

public class StepX509ETSIDigestAlgorithmCompliance
extends SingleValidationSubStepImpl {
    public StepX509ETSIDigestAlgorithmCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && ((Date)(object = validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore())).after(Constants.DPCM_AGID_121_2019)) {
            object = DefaultCMSSignatureAlgorithmNameGenerator.INSTANCE.getDigestAlgName(new ASN1ObjectIdentifier(validationContextParameters.getSignerCertificate().getCert().getInternalCert().getSigAlgOID()));
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.valueFromJavaName((String)object);
            if (digestAlgorithm == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0025_DIGEST_ALGORITHM_NOT_SUPPORTED, object);
            }
            if (digestAlgorithm.isForbidden()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN, object);
            }
            if (!digestAlgorithm.isRecommended()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0021_ETSI_DIGEST_ALGORITHM_NOT_RECOMMENDED, object);
            }
        }
        return null;
    }
}

