/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;

@StepOrder(order=3)
@StepContext(formats={ValidationSignatureFormats.CADES})
public class StepSignatureIntegrityRelaxedCheck
extends MultipleValidationSubStepImpl {
    public StepSignatureIntegrityRelaxedCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters.getSignature() == null) {
            return null;
        }
        if (validationContextParameters.getSignature().getSignerInfoData() == null) {
            return null;
        }
        if (validationContextParameters.getSignature().getSignerInfoData().getSignerInfo() == null) {
            return null;
        }
        linkedList = new LinkedList();
        try {
            if (validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null && !this.isDERSignedAttributes(validationContextParameters.getSignature())) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0013_NO_RFC5652_SIGNEDATTRIBUTES, new Object[0]));
            }
        }
        catch (Throwable throwable) {
            this.logger.debug(throwable.getMessage());
        }
        try {
            if (!this.isValidSigningTime(validationContextParameters.getSignature(), validationContextParameters.getSignerCertificate())) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0014_NO_VALID_SIGNINGTIME, new Object[0]));
            }
        }
        catch (Throwable throwable) {
            this.logger.debug(throwable.getMessage());
        }
        return linkedList;
    }

    protected boolean isDERSignedAttributes(SignatureInformation object) {
        try {
            object = ((SignatureInformation)object).getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
            byte[] byArray = object.getEncoded("DER");
            object = object.getEncoded();
            boolean bl = Arrays.equals(byArray, (byte[])object);
            if (!bl) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean isValidSigningTime(SignatureInformation signatureInformation, ValidatedCertificate validatedCertificate) {
        SignerInfo signerInfo;
        try {
            validatedCertificate = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(validatedCertificate.getCert().getInternalCert());
        }
        catch (OperatorCreationException operatorCreationException) {
            return false;
        }
        try {
            signerInfo = signatureInformation.getSignerInfoData().getSignerInfo();
            signatureInformation = StepSignatureIntegrityRelaxedCheck.a(signerInfo);
        }
        catch (Exception exception) {
            return false;
        }
        return !validatedCertificate.hasAssociatedCertificate() || signatureInformation == null || (signerInfo = validatedCertificate.getAssociatedCertificate()).isValidOn(signatureInformation.getDate());
    }

    private static Time a(SignerInfo signerInfo) throws CMSException {
        ASN1Primitive aSN1Primitive;
        SignerInfo signerInfo2 = signerInfo;
        String string = "signing-time";
        signerInfo = CMSAttributes.signingTime;
        AttributeTable attributeTable = null;
        if (signerInfo2.getUnauthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getUnauthenticatedAttributes());
        }
        if (attributeTable != null && attributeTable.getAll((ASN1ObjectIdentifier)signerInfo).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        attributeTable = null;
        if (signerInfo2.getAuthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getAuthenticatedAttributes());
        }
        if (attributeTable == null) {
            aSN1Primitive = null;
        } else {
            signerInfo = attributeTable.getAll((ASN1ObjectIdentifier)signerInfo);
            switch (signerInfo.size()) {
                case 0: {
                    aSN1Primitive = null;
                    break;
                }
                case 1: {
                    signerInfo = (Attribute)signerInfo.get(0);
                    signerInfo = signerInfo.getAttrValues();
                    if (signerInfo.size() != 1) {
                        throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                    }
                    aSN1Primitive = signerInfo.getObjectAt(0).toASN1Primitive();
                    break;
                }
                default: {
                    throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
                }
            }
        }
        signerInfo = aSN1Primitive;
        if (aSN1Primitive == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)signerInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }
}

