/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import esecurity.crypto.gui.pdf.bean.PdfAnnotation;
import esecurity.crypto.gui.utils.OfficeDocumentConverter;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPagesLoader {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final Object b = new Object();
    private static ExecutorService c;
    private static Future<PdfPagesLoader> d;
    private static PDFRenderer e;
    private static PDDocument f;
    private static int g;
    private static Dimension[] h;
    private static boolean i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncInitialize(File file) {
        i = false;
        c = Executors.newSingleThreadExecutor();
        Object object = b;
        synchronized (object) {
            d = c.submit(() -> {
                try {
                    return new PdfPagesLoader(file);
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                    return null;
                }
            });
            return;
        }
    }

    private PdfPagesLoader(File file) throws IOException {
        File file2 = file;
        if (OfficeDocumentConverter.needConversion((File)file)) {
            file2 = OfficeDocumentConverter.convert((File)file);
        }
        file = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
        file2 = file.createBuffer(new FileInputStream(file2));
        file = new PDFParser((RandomAccessRead)file2, (ScratchFile)file);
        file.parse();
        f = file.getPDDocument();
        e = new PDFRenderer(f);
        g = f.getNumberOfPages();
        h = new Dimension[g];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadPage(int n, float f) throws IOException {
        if (i) {
            return null;
        }
        PdfPagesLoader.a();
        Object object = b;
        synchronized (object) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = e.renderImage(n, f, ImageType.RGB);
                if (h[n] == null) {
                    PdfPagesLoader.h[n] = new Dimension((int)((float)bufferedImage.getWidth() / f), (int)((float)bufferedImage.getHeight() / f));
                }
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
            return bufferedImage;
        }
    }

    public static int getPageCount() throws IOException {
        if (i) {
            return 0;
        }
        PdfPagesLoader.a();
        return g;
    }

    public static boolean isLoaded() {
        return d.isDone();
    }

    public static synchronized Dimension getPageDimension(int n, float f) throws IOException {
        if (i) {
            return new Dimension();
        }
        PdfPagesLoader.a();
        if (h[n] != null) {
            return h[n];
        }
        try {
            BufferedImage bufferedImage = e.renderImage(n, f, ImageType.RGB);
            PdfPagesLoader.h[n] = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            return h[n];
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            return new Dimension(0, 0);
        }
    }

    public static List<PdfAnnotation> getPageAnnotations(int n) throws IOException {
        ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
        PdfPagesLoader.a();
        try {
            Object object = f.getPage(n).getAnnotations();
            object = object.iterator();
            while (object.hasNext()) {
                COSName cOSName;
                Object object2 = (PDAnnotation)object.next();
                if ((object2 = object2.getCOSObject()).getCOSObject(COSName.V) != null || (cOSName = object2.getCOSName(COSName.FT)) == null || !"Sig".equals(cOSName.getName())) continue;
                cOSName = object2.getCOSArray(COSName.RECT);
                object2 = object2.getString(COSName.T);
                int n2 = cOSName.getInt(0);
                int n3 = cOSName.getInt(1);
                int n4 = cOSName.getInt(2);
                int n5 = cOSName.getInt(3);
                arrayList.add(new PdfAnnotation(new Rectangle(n2, n5, n4 - n2, n5 - n3), (String)object2));
            }
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        return arrayList;
    }

    public static PDDocument getPDDocument() throws IOException {
        PdfPagesLoader.a();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDocument() {
        Object object = b;
        synchronized (object) {
            i = true;
            try {
                f.close();
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
            return;
        }
    }

    public static void shutDown() {
        c.shutdownNow();
        if (!i) {
            PdfPagesLoader.closeDocument();
        }
    }

    private static PdfPagesLoader a() throws IOException {
        PdfPagesLoader pdfPagesLoader = null;
        try {
            pdfPagesLoader = d.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        if (pdfPagesLoader == null) {
            throw new IOException("PdfPagesLoader not loaded");
        }
        return pdfPagesLoader;
    }

    static {
        g = 0;
        i = false;
    }
}

