/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.validation.panels;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.Property;
import esecurity.crypto.gui.utils.guielements.CGTooltip;
import esecurity.crypto.gui.utils.swt.ImageHandler;
import esecurity.crypto.gui.validation.utils.DocumentUtils;
import esecurity.crypto.gui.validation.utils.SignerUtils;
import esecurity.desktop.DOMEvent;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.SpanContainer;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.FileInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.TempFileInputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class DocumentTreeElement {
    private static final I18N a = I18N.getInstance((String)"esecurity/crypto/gui/validation/i18n/i18n");
    private static final EllipsLogger b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final String c = ImageHandler.retrieveBase64Image((String)"trash.svg");
    private static final String d = ImageHandler.retrieveBase64Image((String)"trash_hover.svg");
    private final View e;
    private final int f;
    private final String g;
    private final ValidatedDocument h;
    private final List<DocumentTreeElement> i = new ArrayList<DocumentTreeElement>();
    private final DocumentTreeElement j;
    private final DivContainer k;
    private final DivContainer l;
    private final SpanContainer m;
    private final SpanContainer n;
    private final SpanContainer o;
    private final boolean p;
    private SpanContainer q;
    private Image r;
    private Button s;
    private Button t;
    private Runnable u = null;
    private Runnable v = null;
    private Runnable w = null;
    private Runnable x = null;
    private Runnable y = null;
    private Runnable z = null;
    private boolean A = false;
    private boolean B = false;
    private boolean C;
    private boolean D;
    private boolean E = false;
    private String F = "";
    private String G = "";
    private int H;

    public DocumentTreeElement(String string, DOMElement dOMElement, View view, DocumentTreeElement documentTreeElement, int n, int n2, ValidatedDocument validatedDocument, boolean bl, boolean bl2, boolean bl3) {
        this(string, dOMElement.getId(), view, documentTreeElement, n, n2, validatedDocument, bl, bl2, bl3);
    }

    public DocumentTreeElement(String string, String object, View view, DocumentTreeElement object2, int n, int n2, ValidatedDocument validatedDocument, boolean bl, boolean bl2, boolean bl3) {
        this.e = view;
        this.f = n;
        this.g = string;
        this.h = validatedDocument;
        this.j = object2;
        this.p = bl;
        this.B = bl3;
        this.D = bl2;
        this.k = new DivContainer(string, (String)object, view);
        this.k.addClass("documentTree_documentTreeElement");
        this.k.onClick(event -> {
            if (this.u != null) {
                try {
                    this.u.run();
                    return;
                }
                catch (Throwable throwable) {
                    b.error(throwable.getMessage(), throwable);
                }
            }
        });
        this.k.addJavaEventListener(DOMEvent.MOUSEENTER, event -> {
            if (!this.E) {
                this.k.addClass("documentTree_overItem");
            }
        }, true);
        this.k.addJavaEventListener(DOMEvent.MOUSELEAVE, event -> this.k.removeClass("documentTree_overItem"), true);
        if (n != 0 && bl3) {
            this.k.setVisible(false);
        }
        this.k.onDoubleClick(event -> {
            if (this.w != null) {
                try {
                    this.w.run();
                    return;
                }
                catch (Throwable throwable) {
                    b.error(throwable.getMessage(), throwable);
                }
            }
        });
        this.l = new DivContainer("documentTree_internalContainer" + this.g, (DOMElement)this.k, view);
        this.l.addClass("documentTree_internalContainer");
        this.l.setStyle("paddingLeft", n * 10 + "px");
        string = new DivContainer("documentTree_dummy_" + this.g, (DOMElement)this.l, view);
        string.addClass("dummy");
        this.m = new SpanContainer("arrow_" + this.g, (DOMElement)this.l, view);
        this.m.addClass("documentTree_arrowContainer");
        if (bl3) {
            this.m.addClass("documentTree_arrowClosed");
        } else {
            this.m.addClass("documentTree_arrowOpen");
        }
        this.m.onClick(event -> {
            if (this.v != null) {
                try {
                    this.v.run();
                    return;
                }
                catch (Throwable throwable) {
                    b.error(throwable.getMessage(), throwable);
                }
            }
        });
        boolean bl4 = n == 0 || "true".equals(ClientProperties.getInstance().get((Property)UserProperties.SHOW_COMPRESSED_INTERMEDIATE, "false"));
        boolean bl5 = this.A = bl4 && !validatedDocument.getSubResults().isEmpty();
        if (this.A) {
            this.m.setStyle("visibility", "visible");
        } else {
            this.m.setStyle("visibility", "hidden");
        }
        this.C = this.b();
        object = this;
        object2 = new DivContainer("iconsContainer_" + ((DocumentTreeElement)object).g, (DOMElement)((DocumentTreeElement)object).l, ((DocumentTreeElement)object).e);
        Image image = new Image("documentIcon_" + ((DocumentTreeElement)object).g + "_image", (DOMElement)object2, ((DocumentTreeElement)object).e);
        SpanContainer spanContainer = new SpanContainer("statusIcon_" + ((DocumentTreeElement)object).g + "_image", (DOMElement)object2, ((DocumentTreeElement)object).e);
        image.addClass("documentTree_documentIcon");
        spanContainer.addClass("documentTree_statusIconImage");
        object2.addClass("documentTree_leftIconsContainer");
        String string2 = "";
        try {
            object2 = ((DocumentTreeElement)object).h.getHandler();
            if (object2 instanceof FileInputHandler) {
                object2 = DataHandlerBuilder.get().setFile(((FileInputHandler)object2).getFile()).buildInput();
            } else if (object2 instanceof TempFileInputHandler) {
                object2 = DataHandlerBuilder.get().setFile(((TempFileInputHandler)object2).getFile()).buildInput();
            }
            ((DocumentTreeElement)object).G = ImageHandler.getFileExtension((String)((DocumentTreeElement)object).h.getShortName(), (InputHandler)object2);
            string2 = ImageHandler.retrieveSystemIconByExt(null, (String)((DocumentTreeElement)object).G);
        }
        catch (Exception exception) {
            b.error(exception.getMessage(), (Throwable)exception);
        }
        image.setSource(string2);
        object2 = ((DocumentTreeElement)object).C ? DocumentUtils.getStatusIconClass(DocumentUtils.getDocumentLevel(((DocumentTreeElement)object).h), ((DocumentTreeElement)object).p) : (((DocumentTreeElement)object).D ? DocumentUtils.getStatusIconClass(StatusLevel.WARNING, ((DocumentTreeElement)object).p) : DocumentUtils.getStatusIconClass(StatusLevel.ERROR, ((DocumentTreeElement)object).p));
        spanContainer.addClass((String)object2);
        this.H = this.a(validatedDocument);
        string2 = new SpanContainer("documentName_" + this.g, (DOMElement)this.l, view);
        string2.addClass("documentTree_leftText");
        this.n = new SpanContainer("signerName_" + this.g, (DOMElement)this.l, view);
        this.o = new SpanContainer("signerNameCollapsed_" + this.g, (DOMElement)this.l, view);
        this.o.addClass("documentTree_signerName");
        this.o.setVisible(false);
        this.q = new SpanContainer("rightIconsContainer_" + this.g, (DOMElement)this.l, view);
        this.q.addClass("documentTree_rightIconsContainer");
        object = new DivContainer("rightIconsDummy_" + this.g, (DOMElement)this.q, view);
        object.addClass("documentTree_rightIconsDummy");
        if (!this.C) {
            if (bl2) {
                this.t = new Button("documentTree_selectDocumentButton", (DOMElement)this.q, view, () -> a.get("validation_form__document_tree_select_document_button", new Object[0]));
                this.t.addClass("cg-button-secondary");
                this.t.addClass("documentTree_selectDocumentButton");
                this.t.onClick(event -> {
                    if (this.z != null) {
                        try {
                            this.z.run();
                            return;
                        }
                        catch (Throwable throwable) {
                            b.error(throwable.getMessage(), throwable);
                        }
                    }
                });
            } else {
                this.s = new Button("documentTree_changeDocumentButton", (DOMElement)this.q, view, () -> a.get("validation_form__document_tree_change_document_button", new Object[0]));
                this.s.addClass("cg-button-secondary");
                this.s.addClass("documentTree_changeDocumentButton");
                this.s.onClick(event -> {
                    if (this.y != null) {
                        try {
                            this.y.run();
                            return;
                        }
                        catch (Throwable throwable) {
                            b.error(throwable.getMessage(), throwable);
                        }
                    }
                });
            }
        }
        if (n == 0) {
            object = this;
            object2 = new Image("infoIcon_" + ((DocumentTreeElement)object).g, (DOMElement)((DocumentTreeElement)object).q, ((DocumentTreeElement)object).e);
            object2.setSource(ImageHandler.retrieveBase64Image((String)"info.svg"));
            object2.addClass("documentTree_infoIconImage");
            image = new SpanContainer("tooltipContainer_" + ((DocumentTreeElement)object).g, (DOMElement)((DocumentTreeElement)object).q, ((DocumentTreeElement)object).e);
            spanContainer = new CGTooltip(((DocumentTreeElement)object).g + "_filePath_tooltip", (DOMElement)image, ((DocumentTreeElement)object).e, () -> ((FileInputHandler)this.h.getHandler()).getFile().getParent());
            spanContainer.addClass("documentTree_tooltip");
            object2.addJavascriptEventListener("mouseover", "function() {showCGTooltip(\"" + object2.getId() + "\", \"" + spanContainer.getId() + "\");}");
            object2.addJavascriptEventListener("mouseleave", "function() {hideCGTooltip(\"" + spanContainer.getId() + "\");}");
            ((DocumentTreeElement)object).r = new Image("trashIcon_" + ((DocumentTreeElement)object).g, (DOMElement)((DocumentTreeElement)object).q, ((DocumentTreeElement)object).e);
            ((DocumentTreeElement)object).r.setSource(c);
            ((DocumentTreeElement)object).r.addClass("documentTree_trashIconImage");
            ((DocumentTreeElement)object).r.addJavaEventListener(DOMEvent.MOUSEENTER, event -> this.r.setSource(d), true);
            ((DocumentTreeElement)object).r.addJavaEventListener(DOMEvent.MOUSELEAVE, event -> this.r.setSource(c), true);
            ((DocumentTreeElement)object).r.onClick(event -> {
                if (this.x != null) {
                    try {
                        this.x.run();
                        return;
                    }
                    catch (Throwable throwable) {
                        b.error(throwable.getMessage(), throwable);
                    }
                }
            });
            object = StringEscapeUtils.escapeHtml4((String)DocumentUtils.getDocumentDescription(validatedDocument));
            if (bl2 && ((String)object).endsWith(" - " + a.get("validation_form__validated_document_model_file_not_signed", new Object[0]))) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf("-"));
            }
            string2.addClass("documentTree_documentName");
        } else {
            object2 = this.a();
            if (object2 == null) {
                string2.addClass("documentTree_levelName");
                object = a.get("validation_form__document_tree_level", new Object[0]) + " " + n;
            } else if (object2.getContainerFormat().equals((Object)ContainerFormat.ASIC) || object2.getFormat().equals((Object)SignatureFormat.XADES) || object2.getFormat().equals((Object)SignatureFormat.PADES)) {
                object = StringEscapeUtils.escapeHtml4((String)DocumentUtils.getDocumentDescription(validatedDocument));
                if (((String)object).endsWith(" - " + a.get("validation_form__validated_document_model_file_not_signed", new Object[0]))) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("-"));
                }
            } else {
                string2.addClass("documentTree_levelName");
                object = a.get("validation_form__document_tree_level", new Object[0]) + " " + n;
            }
        }
        if (!this.C) {
            this.F = bl2 ? " - " + a.get("validation_form__document_tree_signer_description_unassociated", new Object[0]) : " - " + a.get("validation_form__document_tree_signer_description_mismatch", new Object[0]);
        } else if (validatedDocument.getSigners().size() > 1 || !validatedDocument.getSigners().isEmpty() && !((ValidatedSigner)validatedDocument.getSigners().getFirst()).getCounterSigners().isEmpty()) {
            this.n.addClass("documentTree_signers");
            object2 = this.c();
            StringBuilder stringBuilder = this.a((List<ValidatedSigner>)object2);
            this.F = " - " + object2.size() + " " + a.get("validation_form__document_tree_signer_description_signers", new Object[0]);
            view = new CGTooltip(this.g + "_signers_Tooltip", (DOMElement)this.n, view, stringBuilder::toString, true);
            view.addClass("documentTree_tooltip");
            view.addClass("documentTree_signers_tooltip");
            this.n.addJavascriptEventListener("mouseover", "function() {showCGTooltip(\"" + this.n.getId() + "\", \"" + view.getId() + "\");}");
            this.n.addJavascriptEventListener("mouseleave", "function() {hideCGTooltip(\"" + view.getId() + "\");}");
        } else if (!validatedDocument.getSigners().isEmpty()) {
            this.n.addClass("documentTree_signerName");
            this.F = " - " + ((ValidatedSigner)validatedDocument.getSigners().getFirst()).getSignerName();
        }
        int n3 = 80;
        if (!this.C) {
            n3 = 68;
        }
        if (((String)object).length() + this.F.length() > n3) {
            if (((String)object).length() > n3 / 2) {
                object = ((String)object).substring(0, n3 / 2 - 3) + "...";
            }
            if (((String)object).length() + this.F.length() > n3) {
                this.F = this.F.substring(0, n3 / 2 - 3) + "...";
            }
        }
        string2.setInnerHTML((String)object);
        this.n.appendInnerHTML(this.F);
        this.o.appendInnerHTML(" - " + this.H + " " + a.get("validation_form__document_tree_signer_description_signatures_count", new Object[0]));
    }

    private SignatureInformation a() {
        Object object = this.h.getParent().getInternalDocument().getSignerInfo();
        if (object.isEmpty()) {
            return null;
        }
        String string = this.h.getId();
        object = object.iterator();
        while (object.hasNext()) {
            SignatureInformation signatureInformation = (SignatureInformation)object.next();
            for (ReferenceDoc referenceDoc : signatureInformation.getRefDocs()) {
                if (!string.equals(referenceDoc.getId())) continue;
                return signatureInformation;
            }
        }
        return null;
    }

    private boolean b() {
        for (Object object : this.h.getSigners()) {
            if (this.a((ValidatedSigner)object)) {
                return false;
            }
            object = object.getCounterSigners().iterator();
            while (object.hasNext()) {
                boolean bl;
                block6: {
                    Object object2 = this;
                    object2 = (ValidatedSigner)object.next();
                    Object object3 = object2;
                    if (((DocumentTreeElement)object2).a((ValidatedSigner)object3)) {
                        bl = false;
                    } else {
                        for (ValidatedSigner validatedSigner : object3.getCounterSigners()) {
                            if (!super.a(validatedSigner)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    private boolean a(ValidatedSigner object) {
        for (Object object2 : object.getMessages()) {
            if (object2.getMessageCode().equals(ValidatorMessageEnum.ES0025_NOTIMESTAMPRELATED.getCode())) {
                return true;
            }
            object2 = object2.getNotes().iterator();
            while (object2.hasNext()) {
                ValidatorMessage validatorMessage = (ValidatorMessage)object2.next();
                if (!DocumentTreeElement.a(validatorMessage)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean a(ValidatorMessage object) {
        if (object.getMessageCode().equals(ValidatorMessageEnum.ES0025_NOTIMESTAMPRELATED.getCode())) {
            return true;
        }
        for (ValidatorMessage validatorMessage : object.getNotes()) {
            if (!validatorMessage.getMessageCode().equals(ValidatorMessageEnum.ES0025_NOTIMESTAMPRELATED.getCode())) continue;
            return true;
        }
        return false;
    }

    private int a(ValidatedDocument validatedDocument) {
        int n = validatedDocument.getSigners().size();
        for (ValidatedSigner validatedSigner : validatedDocument.getSigners()) {
            n += this.b(validatedSigner);
        }
        for (ValidatedSigner validatedSigner : validatedDocument.getSubResults()) {
            n += this.a((ValidatedDocument)validatedSigner);
        }
        return n;
    }

    private int b(ValidatedSigner validatedSigner) {
        int n = validatedSigner.getCounterSigners().size();
        for (ValidatedSigner validatedSigner2 : validatedSigner.getCounterSigners()) {
            n += this.b(validatedSigner2);
        }
        for (ValidatedSigner validatedSigner2 : validatedSigner.getTimeStamps()) {
            n += this.b(validatedSigner2);
        }
        return n;
    }

    private StringBuilder a(List<ValidatedSigner> object) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            ValidatedSigner validatedSigner = (ValidatedSigner)object.next();
            String string = DocumentUtils.getStatusIconClass(SignerUtils.getSignerLevel(validatedSigner), this.p);
            stringBuilder.append("<div class=\"documentTree_tooltipContainer\"><span class=\"documentTree_tooltipImage ").append(string).append("\" ></span><span class=\"documentTree_tooltipText\">").append(validatedSigner.getSignerName()).append("</span></div>");
            if (++n <= 12) continue;
            stringBuilder.append("<div class=\"documentTree_tooltipContainer\"><span class=\"documentTree_tooltipText\">...</span></div>");
            break;
        }
        return stringBuilder;
    }

    private List<ValidatedSigner> c() {
        ArrayList<ValidatedSigner> arrayList = new ArrayList<ValidatedSigner>();
        for (ValidatedSigner validatedSigner : this.h.getSigners()) {
            this.a(validatedSigner, arrayList);
        }
        return arrayList;
    }

    private List<ValidatedSigner> a(ValidatedSigner object, List<ValidatedSigner> list) {
        list.add((ValidatedSigner)object);
        for (ValidatedSigner validatedSigner : object.getCounterSigners()) {
            this.a(validatedSigner, list);
        }
        return list;
    }

    public void setAreaWidth(int n) {
        this.l.setStyle("width", n + "px");
    }

    public DOMElement getInternalContainer() {
        return this.l;
    }

    public DocumentTreeElement getParent() {
        return this.j;
    }

    public DocumentTreeElement getRoot() {
        DocumentTreeElement documentTreeElement = this;
        while (!documentTreeElement.isRoot()) {
            documentTreeElement = documentTreeElement.getParent();
        }
        return documentTreeElement;
    }

    public String getId() {
        return this.g;
    }

    public boolean isRoot() {
        return this.f == 0;
    }

    public ValidatedDocument getDocument() {
        return this.h;
    }

    public List<DocumentTreeElement> getChildren() {
        return this.i;
    }

    public void addChild(DocumentTreeElement documentTreeElement) {
        this.i.add(documentTreeElement);
    }

    public void setCollapsable(boolean bl) {
        if (this.i.isEmpty()) {
            return;
        }
        for (DocumentTreeElement documentTreeElement : this.i) {
            documentTreeElement.setCollapsable(bl);
        }
        if (this.f != 0) {
            this.A = bl;
            if (bl) {
                this.m.setStyle("visibility", "visible");
                return;
            }
            this.m.setStyle("visibility", "hidden");
        }
    }

    public void toggleExpansion() {
        if (this.B) {
            this.expand();
            return;
        }
        this.collapse();
    }

    public void collapse() {
        this.B = true;
        this.m.removeClass("documentTree_arrowOpen");
        this.m.addClass("documentTree_arrowClosed");
        this.i.forEach(documentTreeElement -> documentTreeElement.setVisible(false));
        if (this.f == 0) {
            this.n.setVisible(false);
            this.o.setVisible(true);
        }
    }

    public void expand() {
        this.B = false;
        this.m.removeClass("documentTree_arrowClosed");
        this.m.addClass("documentTree_arrowOpen");
        this.setVisible(true);
        this.i.forEach(documentTreeElement -> documentTreeElement.expand());
        if (this.f == 0) {
            this.o.setVisible(false);
            this.n.setVisible(true);
        }
    }

    public boolean isCollapsed() {
        return this.B;
    }

    public boolean isCollapsable() {
        return this.A;
    }

    public void setVisible(boolean bl) {
        if (!bl || !this.B) {
            this.i.forEach(documentTreeElement -> documentTreeElement.setVisible(bl));
        }
        this.k.setVisible(bl);
    }

    public void remove() {
        this.i.forEach(documentTreeElement -> documentTreeElement.remove());
        this.i.clear();
        this.k.remove();
    }

    public void onSelect(Runnable runnable) {
        this.u = runnable;
    }

    public void onArrowClick(Runnable runnable) {
        this.v = runnable;
    }

    public void onDoubleClick(Runnable runnable) {
        this.w = runnable;
    }

    public void onTrashSelected(Runnable runnable) {
        this.x = runnable;
    }

    public void onChangeDocument(Runnable runnable) {
        this.y = runnable;
    }

    public void onSelectDocument(Runnable runnable) {
        this.z = runnable;
    }

    public void select() {
        this.k.addClass("documentTree_slectedItem");
        this.E = true;
    }

    public void deselect() {
        this.k.removeClass("documentTree_slectedItem");
        this.E = false;
    }

    public boolean isParentOf(DocumentTreeElement documentTreeElement) {
        if (documentTreeElement == null) {
            return false;
        }
        if (this.g.equals(documentTreeElement.getId())) {
            return false;
        }
        for (DocumentTreeElement documentTreeElement2 : this.i) {
            if (documentTreeElement2.equals(documentTreeElement)) {
                return true;
            }
            if (!documentTreeElement2.isParentOf(documentTreeElement)) continue;
            return true;
        }
        return false;
    }

    public boolean getDetachedMatch() {
        return this.C;
    }

    public boolean getDetachedAbsent() {
        return this.D;
    }

    public String getDocumentExtension() {
        return this.G;
    }

    public int getLevel() {
        return this.f;
    }
}

