/*
 * Decompiled with CFR 0.152.
 */
package esecurity.oss.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import esecurity.oss.bean.BeginSessionRequest;
import esecurity.oss.bean.FeaTransactionResult;
import esecurity.oss.bean.LcmRequest;
import esecurity.oss.bean.ListFeaCertificateRequest;
import esecurity.oss.bean.ListFeaCertificateResponse;
import esecurity.oss.bean.RetrieveTransactionExtraInfoRequest;
import esecurity.oss.bean.RetrieveTransactionExtraInfoResponse;
import esecurity.oss.bean.RetrieveUsersRequest;
import esecurity.oss.bean.RetrieveUsersResponse;
import esecurity.oss.bean.ReturnValues;
import esecurity.oss.bean.SignDocRequest;
import esecurity.oss.bean.SignDocResult;
import esecurity.oss.bean.TransactionRequest;
import esecurity.oss.bean.ValidateSessionRequest;
import esecurity.oss.bean.ValidateSessionResponse;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClient;
import java.io.IOException;
import java.security.KeyStore;
import org.slf4j.Logger;

public class OSSFERestProxy {
    private static Logger logger = null;
    private UrlClient client;
    private RestClient rsclient = null;
    private URLCredentials cred;
    ObjectMapper mapper = new ObjectMapper();
    ObjectWriter writer_transaction_request = null;
    ObjectWriter writer_signdoc_request = null;
    ObjectWriter writer_listcert_request = null;
    ObjectWriter writer_beginsession_request = null;
    ObjectWriter writer_validatesession_request = null;
    ObjectWriter writer_fealcm_request = null;
    ObjectWriter writer_retrieveusers_request = null;
    ObjectReader reader_featransaction_result = null;
    ObjectReader reader_signdoc_result = null;
    ObjectReader reader_listcert_result = null;
    ObjectReader reader_beginsession_result = null;
    ObjectReader reader_validatesession_result = null;
    ObjectReader reader_fealcm_result = null;
    ObjectReader reader_retrieveusers_result = null;
    ObjectWriter writer_retrievetransactionextrainfo_request = null;
    ObjectReader reader_retrievetransactionextrainfo_result = null;

    public OSSFERestProxy(Logger logger, UrlClient client, URLCredentials cred, KeyStore ks, boolean ignorecert) {
        OSSFERestProxy.logger = logger;
        this.client = client;
        this.cred = cred;
        this.rsclient = new RestClient(client, ks, ignorecert);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.writer_transaction_request = this.mapper.writerFor(TransactionRequest.class);
        this.writer_signdoc_request = this.mapper.writerFor(SignDocRequest.class);
        this.writer_listcert_request = this.mapper.writerFor(ListFeaCertificateRequest.class);
        this.writer_beginsession_request = this.mapper.writerFor(BeginSessionRequest.class);
        this.writer_validatesession_request = this.mapper.writerFor(ValidateSessionRequest.class);
        this.writer_fealcm_request = this.mapper.writerFor(LcmRequest.class);
        this.writer_retrieveusers_request = this.mapper.writerFor(RetrieveUsersRequest.class);
        this.reader_featransaction_result = this.mapper.readerFor(FeaTransactionResult.class);
        this.reader_signdoc_result = this.mapper.readerFor(SignDocResult.class);
        this.reader_listcert_result = this.mapper.readerFor(ListFeaCertificateResponse.class);
        this.reader_beginsession_result = this.mapper.readerFor(ReturnValues.class);
        this.reader_validatesession_result = this.mapper.readerFor(ValidateSessionResponse.class);
        this.reader_fealcm_result = this.mapper.readerFor(ReturnValues.class);
        this.reader_retrieveusers_result = this.mapper.readerFor(RetrieveUsersResponse.class);
        this.reader_retrievetransactionextrainfo_result = this.mapper.readerFor(RetrieveTransactionExtraInfoResponse.class);
        this.writer_retrievetransactionextrainfo_request = this.mapper.writerFor(RetrieveTransactionExtraInfoRequest.class);
    }

    public FeaTransactionResult createFEATransaction(String baseurl, TransactionRequest request) throws IOException {
        FeaTransactionResult result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/createFEATransaction");
            byte[] objectreq = this.writer_transaction_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/createFEATransaction", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (FeaTransactionResult)this.reader_featransaction_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public SignDocResult signDoc(String baseurl, SignDocRequest request) throws IOException {
        SignDocResult result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/signDoc");
            byte[] objectreq = this.writer_signdoc_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/signDoc", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (SignDocResult)this.reader_signdoc_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public ListFeaCertificateResponse listCerts(String baseurl, ListFeaCertificateRequest request) throws IOException {
        ListFeaCertificateResponse result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/listCerts");
            byte[] objectreq = this.writer_listcert_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/listCerts", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (ListFeaCertificateResponse)this.reader_listcert_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public ReturnValues beginSession(String baseurl, BeginSessionRequest request) throws IOException {
        ReturnValues result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/beginSession");
            byte[] objectreq = this.writer_beginsession_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/beginSession", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (ReturnValues)this.reader_beginsession_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public ValidateSessionResponse validateSession(String baseurl, ValidateSessionRequest request) throws IOException {
        ValidateSessionResponse result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/validateSession");
            byte[] objectreq = this.writer_validatesession_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/validateSession", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (ValidateSessionResponse)this.reader_validatesession_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public ReturnValues FeaLcm(String baseurl, LcmRequest request) throws IOException {
        ReturnValues result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/feaLcm");
            byte[] objectreq = this.writer_fealcm_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/feaLcm", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (ReturnValues)this.reader_fealcm_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public RetrieveUsersResponse retrieveUsers(String baseurl, RetrieveUsersRequest request) throws IOException {
        RetrieveUsersResponse result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/retrieveUsers");
            byte[] objectreq = this.writer_retrieveusers_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/retrieveUsers", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (RetrieveUsersResponse)this.reader_retrieveusers_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    public RetrieveTransactionExtraInfoResponse retrieveTransactionExtraInfo(String baseurl, RetrieveTransactionExtraInfoRequest request) throws IOException {
        RetrieveTransactionExtraInfoResponse result = null;
        try {
            logger.debug("endpoint richiesta " + baseurl + "/retrieveTransactionExtraInfo");
            byte[] objectreq = this.writer_retrievetransactionextrainfo_request.writeValueAsBytes((Object)request);
            logger.debug("richiesta {}", (Object)this.offuscatePassword(new String(objectreq)));
            byte[] objectres = this.rsclient.sendJsonByte(baseurl + "/retrieveTransactionExtraInfo", objectreq, this.cred);
            logger.debug("risposta " + new String(objectres));
            if (objectres != null) {
                result = (RetrieveTransactionExtraInfoResponse)this.reader_retrievetransactionextrainfo_result.readValue(objectres);
            } else {
                logger.error("Risposta del server nulla");
            }
        }
        catch (Exception ex) {
            throw new IOException("Impossibile Interrogare il server", ex);
        }
        return result;
    }

    private String offuscatePassword(String objectreq) {
        String strReturn = objectreq;
        try {
            int i = 0;
            i = strReturn.indexOf("clientpwd");
            if (i != -1) {
                strReturn = this.repalceToken(i, 12, strReturn);
            }
            if ((i = strReturn.indexOf("otp")) != -1) {
                strReturn = this.repalceToken(i, 6, strReturn);
            }
        }
        catch (Exception ex) {
            return "";
        }
        return strReturn;
    }

    private String repalceToken(int index, int tokenSize, String strReturn) {
        String toEnd = "\",";
        if (strReturn.substring(index + tokenSize).indexOf("\",") == -1) {
            toEnd = "\"}";
        }
        String password = strReturn.substring(index + tokenSize, index + tokenSize + strReturn.substring(index + tokenSize).indexOf(toEnd));
        return strReturn.replace("\"" + password + "\"", "\"*****\"");
    }
}

