/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import it.actalis.ellips.capi.core.Util;
import it.arubapec.ca.pkcs11.card.Atr;
import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CardStore {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private List<CardLibrary> cardLibraries;
    private List<CardFamily> cardFamilies;
    private List<Atr> atrs;
    private final transient List<Atr> completeAtr = new ArrayList<Atr>();
    private final transient List<Atr> regexAtr = new ArrayList<Atr>();
    private transient List<Atr> historicalAtr = new ArrayList<Atr>();

    private CardStore() {
        this.atrs = new ArrayList<Atr>();
        this.cardFamilies = new ArrayList<CardFamily>();
        this.cardLibraries = new ArrayList<CardLibrary>();
    }

    public List<CardLibrary> getCardLibraries() {
        return this.cardLibraries;
    }

    public void setCardLibraries(List<CardLibrary> list) {
        this.cardLibraries = list;
    }

    public List<CardFamily> getCardFamilies() {
        return this.cardFamilies;
    }

    public void setCardFamilies(List<CardFamily> list) {
        this.cardFamilies = list;
    }

    public void addAtr(Atr atr) throws IOException {
        atr.rebuild(this);
        if (!this.atrs.contains(atr)) {
            this.atrs.add(atr);
        }
        if (atr.getType() == AtrType.COMPLETE) {
            this.completeAtr.add(atr);
            return;
        }
        if (atr.getType() == AtrType.REGEX) {
            this.regexAtr.add(atr);
            return;
        }
        if (atr.getType() == AtrType.HISTORICAL) {
            this.historicalAtr.add(atr);
        }
    }

    public void setAtrs(List<Atr> list) {
        this.atrs = list;
    }

    public void save(OutputStream outputStream) throws IOException {
        outputStream = gson.newJsonWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));
        gson.toJson((Object)this, CardStore.class, (JsonWriter)outputStream);
        outputStream.close();
    }

    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.save(fileOutputStream);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fileOutputStream);
            throw throwable;
        }
        Util.closeQuietly((Closeable)fileOutputStream);
    }

    private void rebuild() throws IOException {
        for (Atr object : this.atrs) {
            this.addAtr(object);
        }
        for (CardFamily cardFamily : this.getCardFamilies()) {
            cardFamily.rebuild(this);
        }
    }

    public static CardStore getInstance() throws IOException {
        InputStream inputStream = CardStore.class.getResourceAsStream("/esecurity/card/store.json");
        return CardStore.getInstance(inputStream);
    }

    public static CardStore getInstance(File object) throws IOException {
        block3: {
            FileInputStream fileInputStream = null;
            try {
                if (object == null || !((File)object).exists()) break block3;
                fileInputStream = new FileInputStream((File)object);
                object = CardStore.getInstance(fileInputStream);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(fileInputStream);
                throw throwable;
            }
            Util.closeQuietly((Closeable)fileInputStream);
            return object;
        }
        object = CardStore.getInstance();
        Util.closeQuietly(null);
        return object;
    }

    public static CardStore getInstance(InputStream object) throws IOException {
        JsonReader jsonReader = gson.newJsonReader((Reader)new InputStreamReader((InputStream)object, "UTF-8"));
        object = (CardStore)gson.fromJson(jsonReader, CardStore.class);
        jsonReader.close();
        super.rebuild();
        return object;
    }

    public List<Atr> getCompleteAtr() {
        return this.completeAtr;
    }

    public List<Atr> getRegexAtr() {
        return this.regexAtr;
    }

    public List<Atr> getHistoricalAtr() {
        return this.historicalAtr;
    }

    public boolean equals(CardStore cardStore) {
        boolean bl;
        for (CardLibrary object : cardStore.getCardLibraries()) {
            bl = false;
            for (CardLibrary cardLibrary : this.getCardLibraries()) {
                if (!cardLibrary.equals(object)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (CardFamily cardFamily : cardStore.getCardFamilies()) {
            bl = false;
            for (CardFamily cardFamily2 : this.getCardFamilies()) {
                if (!cardFamily2.equals(cardFamily)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (Atr atr : cardStore.getCompleteAtr()) {
            bl = false;
            for (Atr atr2 : this.getCompleteAtr()) {
                if (!atr2.equals(atr)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (Atr atr : cardStore.getRegexAtr()) {
            bl = false;
            for (Atr atr3 : this.getRegexAtr()) {
                if (!atr3.equals(atr)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (Atr atr : cardStore.getHistoricalAtr()) {
            bl = false;
            for (Atr atr4 : this.getHistoricalAtr()) {
                if (!atr4.equals(atr)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

