/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11.nat;

import com.sun.jna.NativeLibrary;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Info;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.ExtraFunctionPointer;
import it.actalis.pkcs11.nat.NativePKCS11Info;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import sun.security.pkcs11.wrapper.CK_INFO;

public class NativePKCS11
extends PKCS11 {
    private String a;
    private sun.security.pkcs11.wrapper.PKCS11 b;
    private static final Logger c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final Map<String, NativePKCS11> d = new HashMap<String, NativePKCS11>();
    private int e;
    private boolean f;
    private ExtraFunctionPointer g;
    private boolean h;

    public static void addNativeLibraryPaths(Map<String, String> object) {
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            NativeLibrary.addSearchPath((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativePKCS11 getInstance(String string, boolean bl) throws CapiPKCS11Exception, IOException {
        Object object;
        NativeLibrary nativeLibrary;
        block11: {
            System.runFinalization();
            nativeLibrary = null;
            try {
                nativeLibrary = NativePKCS11.loadPKCS11Library(string);
            }
            catch (Throwable throwable) {
                c.debug("Unable to load " + string);
                object = System.getProperty("driver.folder", "");
                if (((String)object).isEmpty()) {
                    c.debug("driver.folder is empty, try with embedded");
                    object = new File(new File(string).getAbsolutePath());
                } else {
                    c.debug("Found driver.folder " + (String)object + " , try with embedded");
                    object = new File((String)object + File.separator + string);
                }
                if (!((File)object).exists()) break block11;
                c.debug("Embedded lib " + ((File)object).getAbsolutePath());
                nativeLibrary = NativePKCS11.loadPKCS11Library(((File)object).getAbsolutePath());
            }
        }
        if (nativeLibrary == null) {
            throw new UnsatisfiedLinkError(string);
        }
        string = nativeLibrary.getName();
        if (!d.containsKey(string)) {
            object = d;
            synchronized (object) {
                if (!d.containsKey(string)) {
                    d.put(string, new NativePKCS11(nativeLibrary.getFile().getPath(), bl));
                    return d.get(string);
                }
            }
        }
        object = d.get(string);
        if (bl) {
            ((NativePKCS11)object).libInitializePublic();
        }
        return object;
    }

    private NativePKCS11(String object, boolean bl) throws CapiPKCS11Exception, IOException {
        block4: {
            this.e = 0;
            this.f = false;
            this.a = object;
            if (((String)object).toLowerCase().contains("asepkcs")) {
                this.h = true;
            }
            if (bl) {
                try {
                    this.libInitializePublic();
                    return;
                }
                catch (CapiPKCS11Exception capiPKCS11Exception) {
                    object = capiPKCS11Exception;
                    if (capiPKCS11Exception.getErrorCode() == 401L || "CKR_CRYPTOKI_ALREADY_INITIALIZED".equals(((Throwable)object).getMessage())) break block4;
                    throw object;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void libInitializePublic() throws CapiPKCS11Exception, IOException {
        NativePKCS11 nativePKCS11 = this;
        synchronized (nativePKCS11) {
            long l = System.currentTimeMillis();
            if (this.e == 0) {
                if (!this.isInitialized()) {
                    c.debug("Call native libInitialize [START]");
                    try {
                        this.b = sun.security.pkcs11.wrapper.PKCS11.getInstance(this.a, "C_GetFunctionList", null, false);
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        if (exception instanceof IOException) {
                            throw (IOException)exception2;
                        }
                        throw new CapiPKCS11Exception(exception2.getMessage(), exception2);
                    }
                    this.g = new ExtraFunctionPointer(this.a);
                    c.debug("Call native libInitialize [END in {} ms]", (Object)(System.currentTimeMillis() - l));
                    this.f = true;
                    if (!this.isInitialized()) {
                        c.info("Non inizializzata reinizializzo");
                        this.g.a(null);
                    }
                } else {
                    c.debug("Pkcs11 Already Intialized by Other Modules [END in {} ms]", (Object)(System.currentTimeMillis() - l));
                }
            } else {
                c.debug("Library already initialized");
            }
            ++this.e;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void libFinalizePublic() {
        NativePKCS11 nativePKCS11 = this;
        synchronized (nativePKCS11) {
            long l = System.currentTimeMillis();
            if (this.e > 0) {
                if (this.e == 1) {
                    c.debug("Call native libFinalize [START]");
                    if (this.f) {
                        try {
                            this.b.C_Finalize(null);
                        }
                        catch (Exception exception) {
                            c.error("Errore in fase di Finalize ", (Throwable)exception);
                        }
                        this.b = null;
                        this.f = false;
                    }
                    c.debug("Call native libFinalize [END in {} ms]", (Object)(System.currentTimeMillis() - l));
                } else {
                    c.debug("Library used by other reference");
                }
                --this.e;
            }
            return;
        }
    }

    public void unloadLibrary() {
        try {
            this.libFinalizePublic();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getReferenceCount() {
        return this.e;
    }

    public static int nativeInstancesCount() {
        return d.size();
    }

    @Override
    public String getBridgeVersion() {
        return "7.0";
    }

    protected static NativeLibrary loadPKCS11Library(String string) {
        return NativeLibrary.getInstance((String)string);
    }

    public boolean isInitialized() {
        boolean bl = false;
        try {
            this.getSlotList(false);
            bl = true;
        }
        catch (Exception exception) {}
        return bl;
    }

    @Override
    public PKCS11Info getInfo() throws CapiPKCS11Exception {
        try {
            CK_INFO cK_INFO = this.b.C_GetInfo();
            return new NativePKCS11Info(cK_INFO);
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public PKCS11Slot[] getSlotList(boolean bl) throws CapiPKCS11Exception {
        try {
            long[] lArray = this.b.C_GetSlotList(bl);
            PKCS11Slot[] pKCS11SlotArray = new PKCS11Slot[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                pKCS11SlotArray[i] = new NativePKCS11Slot(this, lArray[i]);
            }
            return pKCS11SlotArray;
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public PKCS11Slot waitForSlotEvent(boolean bl) throws CapiPKCS11Exception {
        throw new UnsupportedOperationException();
    }

    final sun.security.pkcs11.wrapper.PKCS11 a() {
        return this.b;
    }

    public ExtraFunctionPointer getExtraFunctionPointer() {
        return this.g;
    }

    public void setExtraFunctionPointer(ExtraFunctionPointer extraFunctionPointer) {
        this.g = extraFunctionPointer;
    }

    public boolean isMiddlewareAthena() {
        return this.h;
    }

    public void setMiddlewareAthena(boolean bl) {
        this.h = bl;
    }
}

