/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.util.m7m.SimpleMimeReader;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class M7MParser
extends SignatureParser {
    private DateFormat a = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public M7MParser(SignatureParserBuilder signatureParserBuilder) {
        super(signatureParserBuilder);
        this.a.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone object, File file) throws ParsingException {
        ParsedTransientDocument parsedTransientDocument = new ParsedTransientDocument(inputHandler);
        if (object != null) {
            this.a.setTimeZone((TimeZone)object);
        }
        try {
            object = new MimeBodyPart(inputHandler.getInputAsNewStream());
            object = new MimePartDataSource((MimePart)object);
            object = new MimeMultipart((DataSource)object);
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < object.getCount(); ++i) {
                if (object.getBodyPart(i).getContentType().startsWith("time-stamp response")) {
                    n2 = i;
                    continue;
                }
                if (object.getBodyPart(i).getContentType().startsWith("application/timestamp")) {
                    n2 = i;
                    continue;
                }
                n = i;
            }
            byte[] byArray = null;
            InputHandler inputHandler2 = null;
            if (n2 == -1 && n != -1 || n == -1 && n2 != -1) {
                object = new SimpleMimeReader(inputHandler.getInputAsNewStream());
                while (((SimpleMimeReader)object).nextPart()) {
                    if (((SimpleMimeReader)object).getDescription() != null && ((SimpleMimeReader)object).getDescription().toLowerCase().contains("time-stamp response")) {
                        byArray = ((SimpleMimeReader)object).getPartDataAsBytes();
                    } else if (((SimpleMimeReader)object).getPartType() != null && ((SimpleMimeReader)object).getPartType().startsWith("application/timestamp")) {
                        byArray = ((SimpleMimeReader)object).getPartDataAsBytes();
                    } else {
                        if (((SimpleMimeReader)object).getPartType() != null) {
                            ((SimpleMimeReader)object).getPartType().startsWith("application/pkcs7-mime");
                        }
                        inputHandler2 = DataHandlerBuilder.get().setBytes(((SimpleMimeReader)object).getPartDataAsBytes()).setName("sub_content").buildInput();
                    }
                    if (byArray == null || inputHandler2 == null) continue;
                    break;
                }
            } else {
                byArray = Util.getBytesFromInputStream((InputStream)object.getBodyPart(n2).getInputStream());
                inputHandler2 = DataHandlerBuilder.get().setInputStream(object.getBodyPart(n).getInputStream()).setName("sub_content").buildInput();
            }
            if (byArray == null || inputHandler2 == null) {
                throw new ParsingException("La busta M7M e' corrotta o illeggibile", (Throwable)new Exception("Possibile Boundary non corretto"));
            }
            parsedTransientDocument.setSigned(true);
            object = ParserUtils.parseDoc((InputHandler)inputHandler2, (EventHandlerSelector)eventHandlerSelector, (NetworkConfig)networkConfig, (TimeZone)this.a.getTimeZone(), (File)file);
            parsedTransientDocument.addRefDoc((TransientDocument)object);
            eventHandlerSelector = TSTUtils.tstToVol((TransientDocument)parsedTransientDocument, (byte[])byArray, (InputHandler)inputHandler2, (String)object.getId(), (DateFormat)this.a);
            parsedTransientDocument.addSignerInfo((SignatureInformation)eventHandlerSelector);
        }
        catch (Exception exception) {
            throw new ParsingException("Unable to parse file", (Throwable)exception);
        }
        finally {
            inputHandler.close();
        }
        return parsedTransientDocument;
    }
}

