/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.a;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.TimeStampGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;

public class CadesUnSignedAttributeGenerator
implements CMSAttributeTableGenerator {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private final CadesSignatureOptions b;
    private final a c;
    private final LTResourceResolver d;
    private final X509Certificate e;
    private final boolean f;

    public CadesUnSignedAttributeGenerator(LTResourceResolver lTResourceResolver, CadesSignatureOptions cadesSignatureOptions, a a2, X509Certificate x509Certificate, boolean bl) {
        this.b = cadesSignatureOptions;
        this.d = lTResourceResolver;
        this.c = a2;
        this.e = x509Certificate;
        this.f = bl;
    }

    public AttributeTable getAttributes(Map object) throws CMSAttributeTableGenerationException {
        ASN1EncodableVector aSN1EncodableVector;
        block15: {
            aSN1EncodableVector = new ASN1EncodableVector();
            try {
                SignerInfo signerInfo;
                object = (byte[])object.get("encryptedDigest");
                if (this.f) {
                    try {
                        signerInfo = SignerInfo.getInstance((Object)((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])object)));
                        object = signerInfo.getEncryptedDigest().getOctets();
                    }
                    catch (Throwable throwable) {}
                }
                if (this.b.getSignatureLevel() == SignatureLevel.BES && !this.b.isResolveCertificateChainResources()) break block15;
                if (this.b.getTimeStampOptions() != null && this.b.getTimeStampOptions().getTSAClient() != null || this.b.isResolveCertificateChainResources()) {
                    signerInfo = null;
                    if (this.b.getTimeStampOptions() != null && this.b.getTimeStampOptions().getTSAClient() != null) {
                        a.debug("Signature TimeStampToken adding..");
                        signerInfo = CadesUnSignedAttributeGenerator.generateTimeStamp((byte[])object, this.b.getTimeStampOptions());
                        byte[] byArray = signerInfo.toByteArray(false, true);
                        object = byArray;
                        object = CadesUnSignedAttributeGenerator.getTSUnsignedAttribute(byArray);
                        aSN1EncodableVector.add((ASN1Encodable)object);
                        a.debug("Signature TimeStampToken adding OK");
                    }
                    if (this.b.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0 || this.b.isIncludeCertificateChain()) {
                        CadesUnSignedAttributeGenerator.a(this.c, this.e, this.d, (TimeStampToken)signerInfo);
                    }
                    this.b.getSignatureLevel();
                    break block15;
                }
                a.error("Unable to generate unsigned attribute Time Stamp options is required ");
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute Time Stamp options is required");
            }
            catch (ApiGeneralException apiGeneralException) {
                a.error("Unable to generate unsigned attribute: " + apiGeneralException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + apiGeneralException.getMessage());
            }
            catch (CapiException capiException) {
                a.error("Unable to generate unsigned attribute: " + capiException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + capiException.getMessage(), (Exception)((Object)capiException));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                a.error("Unable to generate unsigned attribute: " + certificateEncodingException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + certificateEncodingException.getMessage());
            }
            catch (IOException iOException) {
                a.error("Unable to generate unsigned attribute: " + iOException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + iOException.getMessage());
            }
            catch (CMSException cMSException) {
                a.error("Unable to generate unsigned attribute: " + cMSException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + cMSException.getMessage());
            }
            catch (CRLException cRLException) {
                a.error("Unable to generate unsigned attribute: " + cRLException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + cRLException.getMessage());
            }
            catch (CertificateException certificateException) {
                a.error("Unable to generate unsigned attribute: " + certificateException.getMessage());
                throw new CMSAttributeTableGenerationException("Unable to generate unsigned attribute: " + certificateException.getMessage());
            }
        }
        if (aSN1EncodableVector.size() == 0) {
            return null;
        }
        return new AttributeTable(aSN1EncodableVector);
    }

    public static TimeStampToken generateTimeStamp(byte[] byArray, TimeStampOptions timeStampOptions) throws CapiException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byArray = TimeStampGenerator.timestamp((TimeStampOptions)timeStampOptions, (InputStream)byteArrayInputStream);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(byteArrayInputStream);
            throw throwable;
        }
        Util.closeQuietly((Closeable)byteArrayInputStream);
        return new TimeStampToken(byArray);
    }

    static void a(a a2, X509Certificate x509Certificate, LTResourceResolver lTResourceResolver, TimeStampToken timeStampToken) throws CMSException, CRLException, CapiException, CertificateException, IOException {
        CadesUnSignedAttributeGenerator.a(a2, lTResourceResolver, x509Certificate, timeStampToken.getDate());
        CadesUnSignedAttributeGenerator.a(a2, lTResourceResolver, timeStampToken.getTSACert().getInternalCert(), timeStampToken.getDate());
    }

    private static void a(a a2, LTResourceResolver lTResourceResolver, X509Certificate iterator, Date date2) throws CMSException, CRLException, CapiException, CertificateException, IOException {
        lTResourceResolver = lTResourceResolver.resolve(new Certificate((X509Certificate)((Object)iterator)), date2);
        for (Date date2 : lTResourceResolver.getCerts()) {
            a2.b(date2.getInternalCert());
        }
        for (Date date2 : lTResourceResolver.getCrls()) {
            a2.b((CRL)date2);
        }
        for (Date date2 : lTResourceResolver.getOcsps()) {
            a2.b(date2.getBasicOcspResponse());
        }
    }

    public static Attribute getTSUnsignedAttribute(byte[] object) throws CapiException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            object = aSN1InputStream;
            object = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            Attribute attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)object));
            object = attribute;
            return attribute;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }
}

