/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.net;

import it.actalis.ellips.capi.http.bc.Base64;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP_URLConnection {
    private static final Logger logger = LoggerFactory.getLogger(HTTP_URLConnection.class);

    public byte[] doPost(String posturl, String content_type, byte[] req, String basic_username, String basic_password) throws Exception {
        int resCode;
        logger.debug("posting to URL " + posturl);
        URL url = new URL(posturl);
        logger.debug("opening connection to url " + url);
        URLConnection urlcon = url.openConnection();
        logger.debug("opened  connection ");
        urlcon.setDoOutput(true);
        logger.debug("after setDoOutput(true)");
        urlcon.setDoInput(true);
        logger.debug("after setDoInput(true)");
        urlcon.setUseCaches(false);
        logger.debug("after setUseCaches(false)");
        if (basic_username != null && basic_password != null) {
            String tmp = basic_username + ":" + basic_password;
            String encoded = new String(Base64.encode(tmp.getBytes()));
            urlcon.setRequestProperty("Authorization", "Basic " + encoded);
        }
        if (content_type != null) {
            urlcon.setRequestProperty("content-type", content_type);
        }
        urlcon.setRequestProperty("Content-length", String.valueOf(req.length));
        DataOutputStream dos = new DataOutputStream(urlcon.getOutputStream());
        dos.write(req);
        dos.flush();
        dos.close();
        dos = null;
        logger.debug("closed dataOutputStream");
        logger.debug("getting inputstream from urlcon:" + urlcon);
        String statusLine = urlcon.getHeaderField(0);
        logger.debug("RESPONSE: " + statusLine);
        if (statusLine == null || !statusLine.startsWith("HTTP/1.")) {
            throw new IOException("No HTTP/1. in server response");
        }
        int codePos = statusLine.indexOf(32);
        if (codePos <= 0) {
            throw new IOException("No space separator in server response");
        }
        int phrasePos = statusLine.indexOf(32, codePos + 1);
        if (phrasePos < 0) {
            phrasePos = statusLine.length();
        }
        if ((resCode = Integer.parseInt(statusLine.substring(codePos + 1, phrasePos))) >= 200 && resCode < 300) {
            logger.debug("resCode: " + resCode);
        } else if (resCode >= 300 && resCode < 400) {
            logger.debug("resCode: " + resCode);
        } else {
            throw new IOException(resCode + " : unexpected status code in server response");
        }
        InputStream in = urlcon.getInputStream();
        try {
            int stream;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[6144];
            while ((stream = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, stream);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            logger.debug("Exception reading server response in a bytearray :" + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }
}

