/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.TSLNodes;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.TSPService;
import it.actalis.ellips.capi.tsl.TrustServiceProvider;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUtils;
import it.actalis.ellips.capi.xml.parser.TSLVerifier;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TSL {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private boolean b = false;
    private boolean c = false;
    private boolean d = false;
    private String e = "";
    private String f = null;
    private String g = null;
    private String h = null;
    private int i = 0;
    private Date j = null;
    private Date k = null;
    private Date l = null;
    private X509Certificate m = null;
    private String n = "";
    private LinkedList<TrustServiceProvider> o = new LinkedList();
    private LinkedList<TSLPointer> p = new LinkedList();
    private LinkedList<String> q = new LinkedList();
    public static TSLPointer URL_ListOfList = null;
    public static TSLPointer URL_DSList = null;

    private static CertDBItem a(CertDB object, byte[] object2) throws CapiException {
        object = ((CertDB)object).canImport(Base64.decode((byte[])object2));
        object2 = new Certificate((byte[])object2);
        ((CertDBItem)object).setTrust(2);
        ((CertDBItem)object).setName(((Certificate)object2).getName());
        ((CertDBItem)object).setSubjectAndIssuer((Certificate)object2);
        ((CertDBItem)object).setSource(0);
        ((CertDBItem)object).setStatus("http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted");
        ((CertDBItem)object).addEllipsUsage(CertDBItem.EllipsUsage.QUALIFIED_SIGNATURE);
        return object;
    }

    public TSL(TSLPointer tSLPointer, NetworkConfig networkConfig, LinkedList<String> linkedList, boolean bl) throws CapiException {
        this(tSLPointer, networkConfig, linkedList, bl, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSL(TSLPointer tSLPointer, NetworkConfig object, LinkedList<String> serializable, boolean bl, java.io.File file) throws CapiException {
        if (tSLPointer == null || tSLPointer.getUrl() == null || tSLPointer.getUrl().trim().length() == 0 || object == null) {
            throw new CapiException("Null URL", 1001);
        }
        if (tSLPointer.getUrl().equalsIgnoreCase(URL_DSList.getUrl())) {
            tSLPointer = URL_DSList;
            this.c = true;
        } else if (tSLPointer.getUrl().equalsIgnoreCase(URL_ListOfList.getUrl())) {
            tSLPointer = URL_ListOfList;
        }
        this.e = tSLPointer.getUrl();
        if (serializable != null && !((AbstractCollection)((Object)serializable)).isEmpty()) {
            this.q = serializable;
        } else {
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/CA/QC");
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST");
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC");
            if (this.c) {
                this.q.add("http://uri.etsi.org/TrstSvc/Svctype/IdV");
            }
        }
        serializable = null;
        try {
            serializable = file != null ? file : TmpFileUtils.createTempFile("TSL", ".tmp");
            a.debug("loadingDocument " + this.e);
            TSL tSL = this;
            object = tSL.downloadTSL(tSL.e, (NetworkConfig)object, (java.io.File)serializable);
            if (object == null) {
                throw new CapiException("Exception downloading TSL: " + this.e, 50040);
            }
            if (tSLPointer.isVerifyXMLSignature()) {
                TSLVerifier tSLVerifier = new TSLVerifier();
                tSLVerifier.verifySignedXMLDocument(tSLPointer, (java.io.File)serializable);
                this.m = tSLVerifier.getTslSignerCertificate();
                this.l = tSLVerifier.getSignDate();
            }
            this.a((Node)object, bl);
            this.d = true;
            if (file != null || serializable == null) return;
            ((java.io.File)serializable).delete();
            return;
        }
        catch (CapiException capiException) {
            try {
                a.error("CapiException: " + capiException.getMessage());
                throw new CapiException("Exception in TSL: " + capiException.getMessage(), 50040);
                catch (SAXException sAXException) {
                    a.error("SAXException: " + sAXException.getMessage());
                    throw new CapiException(sAXException.getMessage(), 50040);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    a.error("ParserConfigurationException: " + parserConfigurationException.getMessage());
                    throw new CapiException(parserConfigurationException.getMessage(), 50040);
                }
                catch (IOException iOException) {
                    a.error("IOException: " + iOException.getMessage());
                    throw new CapiException(iOException.getMessage(), 50040);
                }
                catch (Exception exception) {
                    a.error("Exception: " + exception.getMessage());
                    throw new CapiException(exception.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                if (file != null || serializable == null) throw throwable;
                ((java.io.File)serializable).delete();
                throw throwable;
            }
        }
    }

    public TSL(TSLPointer tSLPointer, LinkedList<String> object, boolean bl) throws CapiException {
        java.io.File file = tSLPointer.getArchivedFile();
        if (file == null) {
            throw new CapiException("undefined archived file", 1001);
        }
        if (tSLPointer.getUrl().equalsIgnoreCase(URL_DSList.getUrl())) {
            tSLPointer = URL_DSList;
            this.c = true;
        } else if (tSLPointer.getUrl().equalsIgnoreCase(URL_ListOfList.getUrl())) {
            tSLPointer = URL_ListOfList;
        }
        this.e = tSLPointer.getUrl();
        if (object != null && !((AbstractCollection)object).isEmpty()) {
            this.q = object;
        } else {
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/CA/QC");
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST");
            this.q.add("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC");
            if (this.c) {
                this.q.add("http://uri.etsi.org/TrstSvc/Svctype/IdV");
            }
        }
        try {
            object = this.loadDocument(file);
            if (tSLPointer.isVerifyXMLSignature()) {
                TSLVerifier tSLVerifier = new TSLVerifier();
                tSLVerifier.verifySignedXMLDocument(tSLPointer, file);
                this.m = tSLVerifier.getTslSignerCertificate();
                this.l = tSLVerifier.getSignDate();
            }
            this.a((Node)object, bl);
            this.d = true;
            return;
        }
        catch (CapiException capiException) {
            a.error("CapiException: " + capiException.getMessage());
            throw new CapiException("Exception in TSL: " + capiException.getMessage(), 50040);
        }
        catch (SAXException sAXException) {
            a.error("SAXException: " + sAXException.getMessage());
            throw new CapiException(sAXException.getMessage(), 50040);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            a.error("ParserConfigurationException: " + parserConfigurationException.getMessage());
            throw new CapiException(parserConfigurationException.getMessage(), 50040);
        }
        catch (IOException iOException) {
            a.error("IOException: " + iOException.getMessage());
            throw new CapiException(iOException.getMessage(), 50040);
        }
        catch (Exception exception) {
            a.error("Exception: " + exception.getMessage());
            throw new CapiException(exception.getMessage(), 50040);
        }
    }

    private void a(Node object, boolean bl) throws Exception {
        boolean bl2 = true;
        bl2 = true;
        Node node = object;
        TSL tSL = this;
        boolean bl3 = true;
        int n = 1;
        int n2 = 1;
        Node node2 = node;
        int n3 = 0;
        for (int i = 0; i < node2.getChildNodes().getLength(); ++i) {
            if (node2.getChildNodes().item(i).getNodeType() == 8) continue;
            ++n3;
        }
        if (!(n3 >= n2 && n3 <= n)) {
            throw new Exception("Invalid signature: TSL root children number");
        }
        node2 = null;
        for (n2 = 0; n2 < object.getChildNodes().getLength(); ++n2) {
            if (object.getChildNodes().item(n2).getNodeType() == 8) continue;
            node2 = object.getChildNodes().item(n2);
            break;
        }
        if (node2 == null) {
            throw new Exception("Invalid format: all root nodes are comments!");
        }
        a.debug("node.getNodeName(): " + node2 == null ? "n/a" : node2.getNodeName());
        a.debug("node.getNamespaceURI(): " + node2.getNamespaceURI());
        if (node2.getPrefix() != null && !node2.getPrefix().trim().equals("") && node2.getNamespaceURI().equalsIgnoreCase("http://uri.etsi.org/02231/v2#")) {
            this.n = node2.getPrefix() + ":";
            a.debug("Using prefix namespace: " + this.n);
        } else {
            a.debug("Not using prefix namespace");
        }
        if (!node2.getNodeName().equalsIgnoreCase(this.n + TSLNodes.TrustServiceStatusList.get())) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.TrustServiceStatusList.get() + " not found as root. " + node2.getNodeName() + " instead");
        }
        Node node3 = this.a(node2, TSLNodes.SchemeInformation.get());
        if (node3 == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.SchemeInformation.get() + " not found in " + this.n + TSLNodes.TrustServiceStatusList.get() + " children");
        }
        object = this.a(node3, TSLNodes.TSLType.get());
        if (object == null) {
            throw new Exception("Invalid signature: " + this.n + TSLNodes.TSLType.get() + " not Signed");
        }
        this.h = object.getFirstChild().getNodeValue();
        a.debug("TSL type is: " + this.h);
        if (this.h.equalsIgnoreCase("http://uri.etsi.org/TrstSvc/TrustedList/TSLType/EUlistofthelists")) {
            this.b = true;
        }
        if ((object = this.a(node3, TSLNodes.TSLSequenceNumber.get())) == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.TSLSequenceNumber.get() + " not found in " + this.n + TSLNodes.SchemeInformation.get() + " children");
        }
        a.debug("TSL Sequence number is: " + object.getFirstChild().getNodeValue());
        try {
            this.i = Integer.parseInt(object.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.TSLSequenceNumber.get() + " is not numeric");
        }
        object = this.a(node3, TSLNodes.SchemeOperatorName.get());
        if (object == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.SchemeOperatorName.get() + " not found in " + this.n + TSLNodes.SchemeInformation.get() + " children");
        }
        if ((object = this.a((Node)object, TSLNodes.Name.get())) == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.Name.get() + " not found in " + this.n + TSLNodes.SchemeOperatorName.get() + " children");
        }
        this.g = object.getFirstChild().getNodeValue();
        a.debug("TSL schemeOperName is: " + this.g);
        object = this.a(node3, TSLNodes.SchemeName.get());
        if (object == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.SchemeName.get() + " not found in " + this.n + TSLNodes.SchemeInformation.get() + " children");
        }
        if ((object = this.a((Node)object, TSLNodes.Name.get())) == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.Name.get() + " not found in " + this.n + TSLNodes.SchemeName.get() + " children");
        }
        this.f = object.getFirstChild().getNodeValue();
        a.debug("TSL schemeOperName is: " + this.f);
        object = this.a(node3, TSLNodes.ListIssueDateTime.get());
        if (object == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.ListIssueDateTime.get() + " not found in " + this.n + TSLNodes.SchemeInformation.get() + " children");
        }
        try {
            a.debug("TSL issue date is: " + object.getFirstChild().getNodeValue());
            this.j = this.parseXMLTime(object.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            a.error("Exception parsing TSL issued date: " + exception.getMessage());
        }
        object = this.a(node3, TSLNodes.NextUpdate.get());
        if (object == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.NextUpdate.get() + " not found in " + this.n + TSLNodes.SchemeInformation.get() + " children");
        }
        try {
            object = this.a((Node)object, TSLNodes.dateTime.get());
            this.k = this.parseXMLTime(object.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            a.error("Exception parsing TSL issued date: " + exception.getMessage());
        }
        if (this.b) {
            this.p = this.a(node3, !bl, null);
            return;
        }
        if (this.c) {
            object = new ArrayList();
            this.a(node3, !bl, (List<String>)object);
            CertDB certDB = URL_ListOfList.getCacerts();
            for (int i = 0; i < object.size(); ++i) {
                try {
                    CertDBItem certDBItem = TSL.a(certDB, ((String)object.get(i)).getBytes());
                    certDB.add(certDBItem);
                    continue;
                }
                catch (CertDBException certDBException) {}
            }
            URL_ListOfList.setCacerts(certDB);
        }
        if ((object = this.a(node2, TSLNodes.TrustServiceProviderList.get())) == null) {
            throw new Exception("TrustServiceProviderList not found");
        }
        LinkedList<Node> linkedList = this.c((Node)object, TSLNodes.TrustServiceProvider.get());
        if (linkedList == null || linkedList.isEmpty()) {
            throw new Exception("TrustServiceProvider not found");
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            try {
                this.a(linkedList.get(i));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    private LinkedList<TSLPointer> a(Node object, boolean bl, List<String> list) {
        LinkedList<TSLPointer> linkedList = new LinkedList<TSLPointer>();
        if ((object = this.a((Node)object, TSLNodes.PointersToOtherTSL.get())) == null) {
            a.error("No TSLLocations in TSL");
            return null;
        }
        if ((object = this.c((Node)object, TSLNodes.OtherTSLPointer.get())) == null || ((AbstractCollection)object).isEmpty()) {
            a.error("No TSLLocations in TSL");
            return null;
        }
        if (list != null) {
            list.clear();
        }
        a.debug("Found " + ((LinkedList)object).size() + " OtherTSLPointer items");
        block7: for (int i = 0; i < ((LinkedList)object).size(); ++i) {
            Object object2 = (Node)((LinkedList)object).get(i);
            Object object3 = this.a((Node)object2, TSLNodes.TSLLocation.get());
            if (object3 == null) continue;
            object3 = object3.getFirstChild().getNodeValue();
            if (bl && ((String)object3).startsWith("http://")) {
                object3 = ((String)object3).replace("http://", "https://");
            }
            a.debug("location is: " + (String)object3);
            object2 = this.a((Node)object2, TSLNodes.AdditionalInformation.get());
            if (object2 == null || (object2 = this.c((Node)object2, TSLNodes.OtherInformation.get())) == null || ((AbstractCollection)object2).isEmpty()) continue;
            for (int j = 0; j < ((LinkedList)object2).size(); ++j) {
                Object object4 = (Node)((LinkedList)object2).get(j);
                if ((object4 = TSL.b((Node)object4, "MimeType|.*:MimeType")) == null) continue;
                object4 = object4.getFirstChild().getNodeValue();
                a.debug("mymeType is: " + (String)object4);
                if (!((String)object4).equalsIgnoreCase("application/vnd.etsi.tsl+xml")) continue;
                object4 = this.a((Node)((LinkedList)object).get(i), TSLNodes.ServiceDigitalIdentities.get());
                object4 = this.c((Node)object4, TSLNodes.ServiceDigitalIdentity.get());
                TSLPointer tSLPointer = new TSLPointer((String)object3);
                File file = null;
                CertDB certDB = null;
                try {
                    file = TmpFileUtils.createTempFile("tmp", ".cdb");
                    ((java.io.File)file).delete();
                    object4 = ((AbstractSequentialList)object4).iterator();
                    while (object4.hasNext()) {
                        Object object5 = (Node)object4.next();
                        TSL tSL = this;
                        object5 = tSL.a(tSL.a((Node)object5, TSLNodes.DigitalId.get()), TSLNodes.X509Certificate.get());
                        try {
                            CertDBItem certDBItem;
                            if (certDB == null) {
                                certDB = CertDB.getInstance(file.getAbsolutePath(), "temporaneo", true, false);
                            }
                            if (list != null) {
                                list.add(object5.getTextContent());
                            }
                            if ((certDBItem = certDB.canImport(Base64.decode((String)object5.getTextContent()))).getType() == 1) {
                                tSLPointer.getNot_importable_ski().add(new String(Base64.encode((byte[])certDBItem.getCertificate().getSubjectKeyIdentifier())));
                                continue;
                            }
                            certDB.add(certDBItem);
                        }
                        catch (CapiException capiException) {
                            a.debug("Cannot Import cert url {}", object3);
                            object5 = new Certificate(Base64.decode((String)object5.getTextContent()));
                            tSLPointer.getNot_importable_ski().add(new String(Base64.encode((byte[])((Certificate)object5).getSubjectKeyIdentifier())));
                        }
                    }
                    ((java.io.File)file).delete();
                }
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                finally {
                    if (file != null) {
                        ((java.io.File)file).delete();
                    }
                }
                tSLPointer.setCacerts(certDB);
                linkedList.add(tSLPointer);
                a.debug("Valid TSL location: " + (String)object3);
                continue block7;
            }
        }
        return linkedList;
    }

    private void a(Node object) throws Exception {
        Object object2 = this.a((Node)object, TSLNodes.TSPServices.get());
        if (object2 == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.TSPServices.get() + " not found in " + this.n + TSLNodes.TrustServiceProvider.get() + " children");
        }
        if ((object2 = this.c((Node)object2, TSLNodes.TSPService.get())) == null || ((AbstractCollection)object2).isEmpty()) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.TSPService.get() + " not found in " + this.n + TSLNodes.TSPServices.get() + " children");
        }
        if ((object = this.a((Node)object, TSLNodes.TSPInformation.get())) == null) {
            throw new Exception("Incomplete TrustServiceProvider TSPInformation data");
        }
        Node node = this.a((Node)object, TSLNodes.TSPName.get());
        if (object == null) {
            throw new Exception("Incomplete TrustServiceProvider TSPName");
        }
        node = this.a(node, TSLNodes.Name.get());
        if (object == null) {
            throw new Exception("Incomplete TrustServiceProvider name");
        }
        a.debug(node.getFirstChild().getNodeValue() + " has " + ((LinkedList)object2).size() + " " + this.n + TSLNodes.TSPService.get() + " items");
        object = new LinkedList();
        for (int i = 0; i < ((LinkedList)object2).size(); ++i) {
            Node node2 = (Node)((LinkedList)object2).get(i);
            try {
                ((LinkedList)object).add(this.b(node2));
                continue;
            }
            catch (Exception exception) {}
        }
        TrustServiceProvider trustServiceProvider = new TrustServiceProvider();
        trustServiceProvider.setName(node.getFirstChild().getNodeValue());
        trustServiceProvider.setTSPService((LinkedList<TSPService>)object);
        this.o.add(trustServiceProvider);
    }

    private TSPService b(Node object) throws Exception {
        if ((object = this.a((Node)object, TSLNodes.ServiceInformation.get())) == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.ServiceInformation.get() + " not found in " + this.n + TSLNodes.TSPService.get() + " children");
        }
        Object object2 = this.a((Node)object, TSLNodes.ServiceTypeIdentifier.get());
        if (object2 == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.ServiceTypeIdentifier.get() + " not found in " + this.n + TSLNodes.ServiceInformation.get() + " children");
        }
        if ((object2 = object2.getFirstChild().getNodeValue()) == null) {
            throw new Exception("Invalid format: children not found in " + this.n + TSLNodes.ServiceTypeIdentifier.get());
        }
        if (!this.q.contains(object2)) {
            throw new Exception("Service type not supported: " + (String)object2);
        }
        Node node = this.a((Node)object, TSLNodes.ServiceName.get());
        if (node == null) {
            throw new Exception("incomplete service data");
        }
        node = this.a(node, TSLNodes.Name.get());
        Object object3 = this.a((Node)object, TSLNodes.ServiceStatus.get());
        if (node == null || object3 == null) {
            throw new Exception("incomplete service data");
        }
        object3 = object3.getFirstChild().getNodeValue();
        boolean bl = false;
        for (int i = 0; i < TSLStatus.serviceStatusList.length; ++i) {
            if (!((String)object3).equalsIgnoreCase(TSLStatus.serviceStatusList[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new Exception("unsupported service status");
        }
        LinkedList<X509Certificate> linkedList = this.c((Node)object);
        if (linkedList.isEmpty()) {
            throw new Exception("Service without certificates to import");
        }
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if ((object = this.a((Node)object, TSLNodes.ServiceInformationExtensions.get())) != null) {
            object = this.c((Node)object, TSLNodes.Extension.get());
            block13: for (int i = 0; i < ((LinkedList)object).size(); ++i) {
                Object object4 = this.a((Node)((LinkedList)object).get(i), TSLNodes.AdditionalServiceInformation.get());
                if (object4 == null) continue;
                switch (object4.getTextContent().trim()) {
                    case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures": {
                        linkedList2.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures");
                        continue block13;
                    }
                    case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals": {
                        linkedList2.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals");
                        continue block13;
                    }
                    case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication": {
                        linkedList2.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication");
                        continue block13;
                    }
                    case "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/RootCA-QC": {
                        linkedList2.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/RootCA-QC");
                    }
                }
            }
        }
        object = new TSPService(node.getFirstChild().getNodeValue());
        ((TSPService)object).setCertificates(linkedList);
        ((TSPService)object).setStatus((String)object3);
        ((TSPService)object).setType((String)object2);
        ((TSPService)object).setAdditionalServiceInfo(linkedList2);
        ((TSPService)object).setTslId(TSLUtils.getNationalityFromUrl(this.e));
        return object;
    }

    private LinkedList<X509Certificate> c(Node object) throws Exception {
        if ((object = this.a((Node)object, TSLNodes.ServiceDigitalIdentity.get())) == null) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.ServiceDigitalIdentity.get() + " not found in " + this.n + TSLNodes.ServiceInformation.get() + " children");
        }
        if ((object = this.c((Node)object, TSLNodes.DigitalId.get())) == null || ((AbstractCollection)object).isEmpty()) {
            throw new Exception("Invalid format: " + this.n + TSLNodes.DigitalId.get() + " not found in " + this.n + TSLNodes.ServiceDigitalIdentity.get() + " children");
        }
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        for (int i = 0; i < ((LinkedList)object).size(); ++i) {
            Object object2 = (Node)((LinkedList)object).get(i);
            if ((object2 = this.a((Node)object2, TSLNodes.X509Certificate.get())) == null) continue;
            object2 = object2.getFirstChild().getNodeValue();
            try {
                object2 = new Certificate(Util.getBytes((String)object2));
                object2 = ((Certificate)object2).getInternalCert();
                linkedList.add((X509Certificate)object2);
                continue;
            }
            catch (CapiException capiException) {
                a.debug("Exception parsing certificate: " + capiException.getMessage() + ";" + capiException.getErrorCode());
            }
        }
        return linkedList;
    }

    private Node a(Node object, String string) {
        String string2 = this.n + string;
        int n = (object = object.getChildNodes()).getLength();
        if (n <= 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            if (!node.getNodeName().equalsIgnoreCase(string2) && !node.getNodeName().equalsIgnoreCase(string)) continue;
            return node;
        }
        return null;
    }

    private static Node b(Node object, String string) {
        int n = (object = object.getChildNodes()).getLength();
        if (n <= 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            Object object2 = Pattern.compile(string, 2);
            if (!((Matcher)(object2 = ((Pattern)object2).matcher(node.getNodeName()))).matches()) continue;
            return node;
        }
        return null;
    }

    private LinkedList<Node> c(Node object, String string) {
        String string2 = this.n + string;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        int n = (object = object.getChildNodes()).getLength();
        if (n <= 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            if (!node.getNodeName().equalsIgnoreCase(string2) && !node.getNodeName().equalsIgnoreCase(string)) continue;
            linkedList.add(node);
        }
        return linkedList;
    }

    public List<TSLPointer> getTSLLocations() {
        return this.p;
    }

    protected Document loadDocument(java.io.File object) throws SAXException, IOException, ParserConfigurationException {
        Object object2 = DocumentBuilderFactory.newInstance();
        object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        object = ((DocumentBuilder)object2).parse((java.io.File)object);
        return object;
    }

    protected Date parseXMLTime(String string) throws Exception {
        try {
            Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
            cloneable = cloneable.parse(string);
            return cloneable;
        }
        catch (Exception exception) {
            try {
                Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                cloneable = cloneable.parse(string);
                return cloneable;
            }
            catch (Exception exception2) {
                try {
                    Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    cloneable = cloneable.parse(string.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2"));
                    return cloneable;
                }
                catch (Exception exception3) {
                    a.debug("Exception parsing TSL issue date: " + exception3.getMessage());
                    return null;
                }
            }
        }
    }

    public X509Certificate getTslSignerCertificate() throws CapiException {
        if (!this.d) {
            a.debug("TSL not Parsed");
            throw new CapiException("TSL not Parsed", 50022);
        }
        return this.m;
    }

    protected boolean verifySignerCertificateDigest(String object, String string) throws CapiException {
        if (!this.d) {
            a.debug("TSL not Parsed");
            throw new CapiException("TSL not Parsed", 50022);
        }
        if (this.m == null) {
            throw new CapiException("No signer certificate", 30005);
        }
        try {
            object = object == "SHA-1" ? (Object)Util.digestStreams(Constants.SHA1, new ByteArrayInputStream(this.m.getEncoded())) : (Object)Util.digestStreams(Constants.SHA256, new ByteArrayInputStream(this.m.getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Wrong signer certificate format", 30005);
        }
        object = new String(Hex.encode((byte[])object));
        if (string.equalsIgnoreCase((String)object)) {
            a.debug("AUTHENTICATED TSL signer: " + this.m.getSubjectDN().getName());
            return true;
        }
        a.debug("NOT AUTHENTICATED EUROPEAN TSL signer: " + this.m.getSubjectDN().getName());
        return false;
    }

    protected Document loadDocument(String object) throws ParserConfigurationException, SAXException, IOException {
        Object object2 = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object2).setNamespaceAware(true);
        object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        object = ((DocumentBuilder)object2).parse((String)object);
        return object;
    }

    protected Document downloadTSL(String string, NetworkConfig object, java.io.File file) throws CapiException, ParserConfigurationException, SAXException, IOException {
        if (string == null || string.length() == 0 || object == null) {
            return null;
        }
        Document document = null;
        FileOutputStream fileOutputStream = null;
        try {
            a.debug("Temporary saving TSL in: " + file.getAbsolutePath());
            UrlClient urlClient = new UrlClient(object, a);
            object = new URLCredentials(object.getUserProxy(), object.getPasswordProxy(), null, null);
            RequestData requestData = new RequestData();
            object = urlClient.downloadUrl(string, requestData, (URLCredentials)object);
            if (!object.getStatus().equals("OK")) {
                Util.closeQuietly(null);
                return null;
            }
            object = object.getData();
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write((byte[])object);
            document = this.loadDocument(file.getAbsolutePath());
            if (document == null) {
                throw new CapiException("Null tslDocument", 50040);
            }
            Util.closeQuietly(fileOutputStream);
        }
        catch (Exception exception) {
            a.error("Error downloading TSL: " + string);
            a.error(exception.getMessage());
            object = document;
            return object;
        }
        finally {
            Util.closeQuietly(fileOutputStream);
        }
        return document;
    }

    public String getSchemeName() {
        return this.f;
    }

    public String getSchemeOperatorName() {
        return this.g;
    }

    public String getTSLType() {
        return this.h;
    }

    public int getSequenceNumber() {
        return this.i;
    }

    public Date getIssueDate() {
        return this.j;
    }

    public Date getNextIssueDate() {
        return this.k;
    }

    public Date getSignTime() {
        return this.l;
    }

    public List<TrustServiceProvider> getTrustServiceProvider() {
        return this.o;
    }

    static {
        java.io.File file = null;
        try {
            CertDBItem certDBItem;
            URL_ListOfList = new TSLPointer("https://ec.europa.eu/tools/lotl/eu-lotl.xml");
            URL_DSList = new TSLPointer("https://eidas.agid.gov.it/TL/TSL-IT.xml");
            file = TmpFileUtils.createTempFile("tmp", ".cdb");
            file.delete();
            CertDB certDB = CertDB.getInstance(file.getAbsolutePath(), "temporaneo", true, false);
            try {
                certDBItem = TSL.a(certDB, "MIIF0DCCBLigAwIBAgIEOrZQizANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJCTTEZMBcGA1UEChMQUXVvVmFkaXMgTGltaXRlZDElMCMGA1UECxMcUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEuMCwGA1UEAxMlUXVvVmFkaXMgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMTAzMTkxODMzMzNaFw0yMTAzMTcxODMzMzNaMH8xCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBMaW1pdGVkMSUwIwYDVQQLExxSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MS4wLAYDVQQDEyVRdW9WYWRpcyBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAv2G1lVO6V/z68mcLOhrfEYBklbTRvM16z/Ypli4kVEAkOPcahdxYTMukJ0KX0J+DisPkBgNbAKVRHnAEdOLB1Dqr1607BxgFjv2DrOpm2RgbaIr1VxqYuvXtdj182d6UajtLF8HVj71lODqV0D1VNk7feVcxKh7YWWVJWCCYfqtffp/p1k3sg3Spx2zY7ilKhSoGFPlU5tPaZQeLYzcS19Dsw3sgQUSj7cugF+FxZc4dZjH3dgEZyH0DWLaVSR2mEiboxgx24ONmy+pdpibu5cxfvWenAScOospUxbF6lR1xHkopigPcakXBpBlebzbNw6Kwt/5cOOJSvPhEQ+aQuwIDAQABo4ICUjCCAk4wPQYIKwYBBQUHAQEEMTAvMC0GCCsGAQUFBzABhiFodHRwczovL29jc3AucXVvdmFkaXNvZmZzaG9yZS5jb20wDwYDVR0TAQH/BAUwAwEB/zCCARoGA1UdIASCAREwggENMIIBCQYJKwYBBAG+WAABMIH7MIHUBggrBgEFBQcCAjCBxxqBxFJlbGlhbmNlIG9uIHRoZSBRdW9WYWRpcyBSb290IENlcnRpZmljYXRlIGJ5IGFueSBwYXJ0eSBhc3N1bWVzIGFjY2VwdGFuY2Ugb2YgdGhlIHRoZW4gYXBwbGljYWJsZSBzdGFuZGFyZCB0ZXJtcyBhbmQgY29uZGl0aW9ucyBvZiB1c2UsIGNlcnRpZmljYXRpb24gcHJhY3RpY2VzLCBhbmQgdGhlIFF1b1ZhZGlzIENlcnRpZmljYXRlIFBvbGljeS4wIgYIKwYBBQUHAgEWFmh0dHA6Ly93d3cucXVvdmFkaXMuYm0wHQYDVR0OBBYEFItLbe3TKbkGGew5Oanwl4Rqy+/fMIGuBgNVHSMEgaYwgaOAFItLbe3TKbkGGew5Oanwl4Rqy+/foYGEpIGBMH8xCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBMaW1pdGVkMSUwIwYDVQQLExxSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MS4wLAYDVQQDEyVRdW9WYWRpcyBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggQ6tlCLMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAitQUtf70mpKnGdSkfnIYj9lofFIk3WdvOXrEql494liwTXCYhGHoG+NpGA7O+0dQoE7/8CQfvbLO9Sf87C9TqnN7Az10buYWnuulLsS/VidQK2K6vkscPFVcQR0kvoIgR13VRH56FmjffU1RcHhXHTMe/QKZnAzNCgVPx7uOpHX6Sm2xgI4JVrmcGmD+XcHXetwReNDWXcG31a0ymQM6isxUJTkxgXsTIlG6Rmyhu576BGxJJnSP0nPrzDCi5upZIof4l/UO/erMkqQWxFIY6iHOsfHmhIHluqmGKPJDWl0Snawe2ajlCmqnf6CHKc/yiU3U7MXi5nrQNiOKSnQ2+Q==".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIFjjCCBHagAwIBAgIUIBhwLg4/l5vcFjA30Du20n1cSyIwDQYJKoZIhvcNAQEFBQAwfzELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxJTAjBgNVBAsTHFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxLjAsBgNVBAMTJVF1b1ZhZGlzIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTIwNDE2MTMxOTE4WhcNMjEwMzE3MTgzMzMzWjCBkjELMAkGA1UEBhMCTkwxIDAeBgNVBAoTF1F1b1ZhZGlzIFRydXN0bGluayBCLlYuMSgwJgYDVQQLEx9Jc3N1aW5nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MTcwNQYDVQQDEy5RdW9WYWRpcyBFVSBJc3N1aW5nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAptA1axMi6cc+oSTu9htnLRqQxnJl9FyGTCt3vG5A83hHNX4RhrAfY49DMADBLgRwOwqbHrl6GRwTCcbfBOK28gqOQXWOecqwfk1ELFSGTkiNJp6pqdzBRYZISEPgbfvPv1myotKSn9JLHM1mqhDlVhrM89wVmLFn/wMCRPkcPqbdko0lMQCZEa9UV0XL3axA6hw/vi84QuCAW6+2grv+BKQ5Hcg+ASTPyAxbkFmBu6ftyzbCdVdbggnRTI0Tqz6QP7NNC0W3fWTPva60+jnSuq4eHTZke4oFIa5/d5teBVdrKs97k5JuvQnx7vDDJwLVKh/cA3s/RLx+gzS/kR8fy4LnL2INOvjAEhopEq/AIozyDaNblku4ozv9U64B+kggxznGZRy/F37qWTOoVmWLGbMGBAV0EuMy+zf19qVg6Pmlha6IvkCoLIH1Rn1CCchRIZssi9EitsitionsemIPG0iYrplb2eY9AMuFNn2XhPbDGGLQeWzc2O7YAMnqnWPLrYfAlbwA581D4lgtPMUYTY4ejgJ3dbTq23PqMsR1RRTv3Z8e4OLXx8YY9zwnCG+iN+hoGBvwaDMy53PRP8BL2II6t03wQOWVkNaS2hi7UZKu2ubIczZkvjHVJHIWOsmvYkxM5slZk6XS61t3e3A5sniJOU0N7i10zQhC8qFSwtMCAwEAAaOB7TCB6jAPBgNVHRMBAf8EBTADAQH/MDoGCCsGAQUFBwEBBC4wLDAqBggrBgEFBQcwAYYeaHR0cDovL29jc3AucXVvdmFkaXNnbG9iYWwuY29tMBEGA1UdIAQKMAgwBgYEVR0gADAOBgNVHQ8BAf8EBAMCAQYwHwYDVR0jBBgwFoAUi0tt7dMpuQYZ7Dk5qfCXhGrL798wOAYDVR0fBDEwLzAtoCugKYYnaHR0cDovL2NybC5xdW92YWRpc2dsb2JhbC5jb20vcXZyY2EuY3JsMB0GA1UdDgQWBBTg+A751LXyf0kjtsN5x6M1H4Z6iDANBgkqhkiG9w0BAQUFAAOCAQEABTk3BgNBPt3jxfN1r7VHu4wGfE0Jhm/DTnwKtdKeaclcmLIoP36l+kkMlKdk7ER2bm6qIvPdwRIPPh+05LM0zEV6h4xsJen/2f0xccvp1Xbrz9IdOoA2wFylV6KivxJn5nsUmYZVUdE00wM+0g+MhD/EtpuSMI24WWhKufOAAljnUz3/0CN8vMrDh4KOYQh60JjCJRVWPQVSNqaGB0nJLHXD9t5tpw4GExQPQtZVYX2A5iuYyXnKemPySad+ZPk6gXUS5yVCcuve9ZzwGXWLuV3IyE6S7T7bZjQCIqrRoAIzhtNIR7DtlIkI81udhxatzv6dpQb81imXrUIMdxhKDA==".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIHSDCCBTCgAwIBAgIQHaaUHzn5vENUk+T/aHIefTANBgkqhkiG9w0BAQsFADAxMQswCQYDVQQGEwJFUzERMA8GA1UECgwIRk5NVC1SQ00xDzANBgNVBAMMBklTQSBDQTAeFw0xNDEyMTkwODQyMzlaFw0xODEyMTkwODQyMzlaMEwxCzAJBgNVBAYTAkJFMRwwGgYDVQQKDBNFVVJPUEVBTiBDT01NSVNTSU9OMR8wHQYDVQQDDBYoU0lHTikgQUdOSUVTWktBIEJBSk5PMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAog6nQQcoPlHOrwXYDD+wj38lwn1zbalTTJL7yW3N7OgO9/eSCIY5nGgfnslapC36vSO9RbSxW3cV4CJCf2nGZdsZHxNJpf4IG4CEsByui30UGFANtBPlFj/r5avf0OrDGKTI2H/6sN2swgs43grcRFQ5yt/ZPhOIgjXjzK4s36IFMBG1GGRQUSDJo+uv3cbuBcNjdFro3Zmm9TypDv194f1NwXRbFOon1WtaIsJNKzw4+MKCAyD9BBVATQxGLYeCT2tZt3DFbSSXZbBfSnfwGe7eMc99S12Hr/MwAPJhUwZZpienadVNlMNWxwutxcDO5HrmOdtxv8Vh9MKlAwvN4QIDAQABo4IDPzCCAzswWwYDVR0RBFQwUoEcQUdOSUVTWktBLkJBSk5PQEVDLkVVUk9QQS5FVaQyMDAxFDASBgkrBgEEAaxmAQIMBUJBSk5PMRgwFgYJKwYBBAGsZgEBDAlBR05JRVNaS0EwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCBkAwHQYDVR0OBBYEFIe8EqP5sxbiNrSKwgNC00FsSfkjMB8GA1UdIwQYMBaAFEft+GPwma9e/n4OXFjL/uI1N6a9MIHgBgNVHSAEgdgwgdUwgcgGCisGAQQBrGYDBAEwgbkwKQYIKwYBBQUHAgEWHWh0dHA6Ly93d3cuY2VydC5mbm10LmVzL2RwY3MvMIGLBggrBgEFBQcCAjB/DH1RdWFsaWZpZWQgY2VydGlmaWNhdGUuIFVuZGVyIHRoZSB1c2FnZSBjb25kaXRpb25zIGFzc2VydGVkIGluIHRoZSBGTk1ULVJDTSBDUFMgKDEwNiwgSm9yZ2UgSnVhbiBzdHJlZXQsMjgwMDksIE1hZHJpZCwgU3BhaW4pLjAIBgYEAIswAQEwgYYGCCsGAQUFBwEBBHoweDBBBggrBgEFBQcwAYY1aHR0cDovL29jc3BJU0FjYS5jZXJ0LmZubXQuZXMvb2NzcElTQWNhL09jc3BSZXNwb25kZXIwMwYIKwYBBQUHMAKGJ2h0dHA6Ly93d3cuY2VydC5mbm10LmVzL2NlcnRzL0lTQUNBLmNydDBGBggrBgEFBQcBAwQ6MDgwCAYGBACORgEBMAsGBgQAjkYBAwIBDzAVBgYEAI5GAQIwCxMDRVVSAgECAgECMAgGBgQAjkYBBDCBzAYDVR0fBIHEMIHBMIG+oIG7oIG4hoGIbGRhcDovL2xkYXBJU0FjYS5jZXJ0LmZubXQuZXMvQ049Q1JMMSxjbj1JU0ElMjBDQSxvPUZOTVQtUkNNLEM9RVM/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdDtiaW5hcnk/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludIYraHR0cDovL3d3dy5jZXJ0LmZubXQuZXMvY3Jsc19JU0FjYS9DUkwxLmNybDANBgkqhkiG9w0BAQsFAAOCAgEAd2CyyRljkbR+hxMwnjwzNE9q6nw29uLWx4c/kWfWGNxyjO/mbE2KhgXfUm7e441Ih87PX1p8jpTeOhtfvL8CxmsqyDg56GBNq5NprbagpmKHiNCP77baZiLMFfEvc915ktLlYQEH+wIe5i0gMPmRWjA2urB/M+fXwLgqQdOEe4e0NSLr7YJqHeL1sWQsS4r1zK8ZGv1uJ0v+vAmYXwFtaYYht/c9X+QtVxYaflDcBVnPBxj3xUG7vQHe7g5/RPX4vvzAZNV9d5IBk+sCX05dRfRqsym4qw1sw4j0W2nxAfQwk3bfW6NP5SgOHfC9sh2LrC3F/wlvePY8piTXFUkRzlsEb8zWM2vfz3QRNgGbxCz3DY3kFavdEL/gnNHOg5Q4tn2TVV7YfXLEgu7zN+IqBOdlAtbJXEu60FiF9Cs35IGqwWlbeOK8QvogFYDxlgIPrs3ijEA1WHyY+GH1mofSA7u30wEvooCzohFf4DBv06I4q9aCNBnTo4yki1yFhBm71r60hlAas6aK6TZ+NUoFWwPypMP617SlHdy8QlFx1s3V+rIt2hxUUGddid/FXDKtuUCRqKqx6x8J8bI7DecZsCS7ijPCApjJ84HB8UASRzdGtEwc97hvnAqXjpCS/tHAVcVvmP3isNDu4WtV2LQfL/TIY8zMxUebv/E5JyB3KAw=".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "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".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "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".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "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".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIID/TCCAuWgAwIBAgIQEAAAAAAAWcxEUPr16SDrtzANBgkqhkiG9w0BAQUFADAzMQswCQYDVQQGEwJCRTETMBEGA1UEAxMKQ2l0aXplbiBDQTEPMA0GA1UEBRMGMjAxMzExMB4XDTEzMDcyNDAxNDUzMVoXDTE4MDcxODIzNTk1OVowbzELMAkGA1UEBhMCQkUxIjAgBgNVBAMTGU1hYXJ0ZW4gT3R0b3kgKFNpZ25hdHVyZSkxDjAMBgNVBAQTBU90dG95MRYwFAYDVQQqEw1NYWFydGVuIEpvcmlzMRQwEgYDVQQFEws4MzEyMTQyNDEwMjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAjbr1T8USYkuh4X+Yi+coykq7mbF8PjgyjWQ28uODqRCkynuqJz468tCIYxsM/+/QdqEFq4Z5Z1YDbBYb5KsxfBmkzr9D+Gt49iWVt9Ig+FhngbOexwCW108t6Q/+NAo6gwl6IKkzv2wpEJIwtc51VFzvM+WkE1mNmclphYRTL5UCAwEAAaOCAVMwggFPMB8GA1UdIwQYMBaAFLws1Y0dT3YXfAzva5To9R51FmNhMG4GCCsGAQUFBwEBBGIwYDA2BggrBgEFBQcwAoYqaHR0cDovL2NlcnRzLmVpZC5iZWxnaXVtLmJlL2JlbGdpdW1yczIuY3J0MCYGCCsGAQUFBzABhhpodHRwOi8vb2NzcC5laWQuYmVsZ2l1bS5iZTBEBgNVHSAEPTA7MDkGB2A4CQEBAgEwLjAsBggrBgEFBQcCARYgaHR0cDovL3JlcG9zaXRvcnkuZWlkLmJlbGdpdW0uYmUwOQYDVR0fBDIwMDAuoCygKoYoaHR0cDovL2NybC5laWQuYmVsZ2l1bS5iZS9laWRjMjAxMzExLmNybDAOBgNVHQ8BAf8EBAMCBkAwEQYJYIZIAYb4QgEBBAQDAgUgMBgGCCsGAQUFBwEDBAwwCjAIBgYEAI5GAQEwDQYJKoZIhvcNAQEFBQADggEBAHNRipzOD4aXB7Oo4FgfBbWgPkmUGTqkz2jK9U2tEWUbyQrhirgqhxK6YMAHBvzL+7BHouMEAuxycZG3ozAfEDRZiznFWyqS8QlnHUe0ThaAvs8v5wYOUO7lJ6vnaNLLvQj7W3L5kCnEva5h0Jh9wMytlNp89dd02l7MD4BsidXoMN21AE8su39tBmNayLF6YrFLe3Zob4fQCuIEbx/pj3kYIVC4WM7uuDx+QpEJdNBtB41o2q2JJFqusRP7W0phkxX7sPtYkot6RXLdgaZNoB4YIRwGozIvcegydRVqpcYrvFSoppNHQqd8ZNzswjGzqBhlWYPsxdjjsxJiUyk7T1c=".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "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".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "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".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            URL_ListOfList.setCacerts(certDB);
            file = TmpFileUtils.createTempFile("tmp", ".cdb");
            file.delete();
            certDB = CertDB.getInstance(file.getAbsolutePath(), "temporaneo", true, false);
            try {
                certDBItem = TSL.a(certDB, "MIIFKjCCBBKgAwIBAgIQVkqok9BKNUimK+WoejQSZDANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCSVQxJjAkBgNVBAoMHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMRowGAYDVQQFDBFWQVRJVC05NzczNTAyMDU4NDENMAsGA1UEAwwEQWdJRDEhMB8GCSqGSIb3DQEJARYSaXRfdHNsQGFnaWQuZ292Lml0MB4XDTE2MDQyNjA4MTQyM1oXDTI2MTIzMTA4MTQyM1owgYMxCzAJBgNVBAYTAklUMSYwJAYDVQQKDB1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTEaMBgGA1UEBQwRVkFUSVQtOTc3MzUwMjA1ODQxDTALBgNVBAMMBEFnSUQxITAfBgkqhkiG9w0BCQEWEml0X3RzbEBhZ2lkLmdvdi5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALlwpg71q4cV9X1cE+2ydlVhTrFWkzUjYbkiwugPPhknt6CDYwATS1Er20ttwEqlnQ+4YYuzVa7SWpijue6XNNKGQm7OEm1Hoyv64vqOPOD0rZD4cmaTmikHlYWsZJRta++A6r3LFvasD+g6fIzfi4QiX/Rt5lZLn5z25B4qJ2bVIqbH5lPHBb1YsdmMHl7IpZXNltAX1mHAoGDTNG4WiBJiEcus/0VPTC7BgIZMmcmGqpFywCwVR8l2Kd4pUQSFGJIf5pxCClIVIvMHBQ8X3kFAjlsR1aZknvhgvlQ+m26SR659qPPNfvYcgHXm9a/OlpsxCQBWiN9bPBzHhI8xtjUCAwEAAaOCAZYwggGSMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBQQblejCQGUNLDtGclWwzjkDxJiQzA5BgNVHR8EMjAwMC6gLKAqhihodHRwczovL2VpZGFzLmFnaWQuZ292Lml0L2NybC9JVF9DUkwuY3JsMIHZBgNVHSAEgdEwgc4wCgYIKwYBBQUHAgEwgb8GAytMEDCBtzA5BggrBgEFBQcCARYtaHR0cHM6Ly9laWRhcy5hZ2lkLmdvdi5pdC9jcHMvSVRfQ1BTX0FHSUQucGRmMHoGCCsGAQUFBwICMG4wJBYdQWdlbnppYSBwZXIgbCdJdGFsaWEgRGlnaXRhbGUwAwIBARpGQ0EgdXNlZCBpbiBJdGFseSBieSB0aGUgZ292ZXJubWVudCBib2R5IEFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlLjAfBgNVHSMEGDAWgBQQblejCQGUNLDtGclWwzjkDxJiQzAYBggrBgEFBQcBAwQMMAowCAYGBACORgEEMA0GCSqGSIb3DQEBCwUAA4IBAQAnV0ZVkfIDHNpJgzGp0uG/eVfNTeb1TRfjgF5yCgJCFfYMQ2NOQWw36wKgWvnjaq6+eNjgv/Ww1CE6A2Ygo8Dw/6l0amH+YoXiLMLOc5R9ZXg4FhmZX8qhZo7Nx15HpCTo219OL6twVqWOwii/6ABE+lh1YUcADk/+NZDvzByD471WD4LhdQvnTKdn4PItofxAcu97/tUUHuMDKwOdM//VVHmxiezClPd4yDDZv3Xh16n2muQx4O3SqeFPbab3U4GrqPzpiEmk0dUPeyMqrH+vThjVYnA/hWjQ2Xj1o5PR01RgUzoUHynpJt0yfi53kCcWRgATtSuBsuMCqYfIHxqJ".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIFUjCCBDqgAwIBAgIQEK7utqGYkEyYnrNc0XlTLzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCSVQxJjAkBgNVBAoMHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMRowGAYDVQQFDBFWQVRJVC05NzczNTAyMDU4NDENMAsGA1UEAwwEQWdJRDEhMB8GCSqGSIb3DQEJARYSaXRfdHNsQGFnaWQuZ292Lml0MB4XDTE2MDQyNzA4NTM0MloXDTIxMDExMjA4NTM0MlowgbQxCzAJBgNVBAYTAklUMSYwJAYDVQQKDB1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTEvMC0GA1UECwwmSXRhbGlhbiBUcnVzdGVkIExpc3QgTWFuYWdlbWVudCBPZmZpY2UxGjAYBgNVBAUMEVZBVElULTk3NzM1MDIwNTg0MQ0wCwYDVQQDDARBZ0lEMSEwHwYJKoZIhvcNAQkBFhJpdF90c2xAYWdpZC5nb3YuaXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDQf3nLh9d4BwwuuF4Z0m9APKF+SqYc+nySjnyqNDevHc4989STgw4StRaI+QWr7eYvV+qLv9KKR57zfcOib37zKVGmdaXx33S3iy3cxLms2xtjvz2/YYOqdAaWdPP90VnnoSXndaGDb1RUgeisHiHfC1LZEdReYE9j4jVCwg0C8QHafKnBCXU5oKGl0BHLvc/1hhvglz3JqpF1TvJjcucHLRUoX4psJabWVhsBmb2+cFAO5PQIUDz1FbLY6hPcnRhp6CDkyTCztITfg4R4SegaXc9MXGGl0z+xHoDhd0LQoxXFLC0ZaOgZGxz4wQRYmboILy/rbU82wTf/AXIYJ5BrAgMBAAGjggGNMIIBiTAJBgNVHRMEAjAAMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUunUq6QVK5Y31PcP5ihoQKOU7jqgwEQYDVR0lBAowCAYGBACRNwMAMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHBzOi8vZWlkYXMuYWdpZC5nb3YuaXQvY3JsL0lUX0NSTC5jcmwwgcYGA1UdIASBvjCBuzAKBggrBgEFBQcCATCBrAYDK0wQMIGkMDkGCCsGAQUFBwIBFi1odHRwczovL2VpZGFzLmFnaWQuZ292Lml0L2Nwcy9JVF9DUFNfQUdJRC5wZGYwZwYIKwYBBQUHAgIwWzAkFh1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTADAgEBGjNDZXJ0aWZpY2F0ZSB1c2FibGUgdG8gdmFsaWRhdGUgSXRhbGlhbiBUcnVzdGVkIExpc3QwHwYDVR0jBBgwFoAUEG5XowkBlDSw7RnJVsM45A8SYkMwGAYIKwYBBQUHAQMEDDAKMAgGBgQAjkYBBDANBgkqhkiG9w0BAQsFAAOCAQEAnsiB+TUDBkVMsqjT2RLMZgOEi/IJsJqK7YBvl1+1Piu5sKyuyeSJsTMPYJsraen284m1ZVC9qsog47QxAXL1K621R9kU5HMUSKiimbDvSOiHNnWWWLbabk+gzSxMPhxzFlLnGZ4hxKVrnfuIZJH0JibMNXq1S1WAEInq4iGUdYvegYLz8i946riCbSYUtB0GDbKn6KQlux/GR7nwaImetqZM4cHLmCxShn6wS1s1NaQjBsgwUtxq14PbFlaH0whmytWmL7sW52mAcyzhAbkxA80dPj+er7zz/GskJe5Rle3lzFKAKznhD3QYms84iy3UjnXeSuKSXQw10sKtbNVeSw==".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                TSL.a(certDB, "MIIFUjCCBDqgAwIBAgIQN05etZHKmECSK/TenCUl0DANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCSVQxJjAkBgNVBAoMHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMRowGAYDVQQFDBFWQVRJVC05NzczNTAyMDU4NDENMAsGA1UEAwwEQWdJRDEhMB8GCSqGSIb3DQEJARYSaXRfdHNsQGFnaWQuZ292Lml0MB4XDTE2MDQyNzA5MjA0NloXDTIxMDUxMjA5MjA0NlowgbQxCzAJBgNVBAYTAklUMSYwJAYDVQQKDB1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTEvMC0GA1UECwwmSXRhbGlhbiBUcnVzdGVkIExpc3QgTWFuYWdlbWVudCBPZmZpY2UxGjAYBgNVBAUMEVZBVElULTk3NzM1MDIwNTg0MQ0wCwYDVQQDDARBZ0lEMSEwHwYJKoZIhvcNAQkBFhJpdF90c2xAYWdpZC5nb3YuaXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDJtzPKirZAlfG2RjE+cA83AYSxJC4pgFZFhr750Z56bEZ9UjMTajcTBKg6VhZxRU+R2z6sbj2o3OV4s8eDhgK6MI66xC78CoTwQk0ths+oiobvSvPIGuF91NkbLR7leEurWnaYid8nWYDHX6ok5+p3wK/LTjnYIQok10DYl0f0BIGCPrMmRnZr1BKijh+XhmJLpPxiYSwMfxM6itJ2mSUquhN2BxxerB8nptD5o8UVrLKmepCMYycFAZ5qSf/GqMKUrh8Yy3GvDGJfxJm7vPqKcj+g/oCBIm0YOA24RieahqlZDLdmio57XqEFyV4E5ye6rjFPoKu2v9HxAgvn9MFxAgMBAAGjggGNMIIBiTAJBgNVHRMEAjAAMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUAt+oGvjGL3RLbqTgdl6KPs3z/zQwEQYDVR0lBAowCAYGBACRNwMAMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHBzOi8vZWlkYXMuYWdpZC5nb3YuaXQvY3JsL0lUX0NSTC5jcmwwgcYGA1UdIASBvjCBuzAKBggrBgEFBQcCATCBrAYDK0wQMIGkMDkGCCsGAQUFBwIBFi1odHRwczovL2VpZGFzLmFnaWQuZ292Lml0L2Nwcy9JVF9DUFNfQUdJRC5wZGYwZwYIKwYBBQUHAgIwWzAkFh1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTADAgEBGjNDZXJ0aWZpY2F0ZSB1c2FibGUgdG8gdmFsaWRhdGUgSXRhbGlhbiBUcnVzdGVkIExpc3QwHwYDVR0jBBgwFoAUEG5XowkBlDSw7RnJVsM45A8SYkMwGAYIKwYBBQUHAQMEDDAKMAgGBgQAjkYBBDANBgkqhkiG9w0BAQsFAAOCAQEBQnxvuiuL507lhU/KdytchoLNdPS23IUT8OGBnJHzDYzGEVsHuEEo7TVuqRNhKpTe/MmKVGLAL7LzaigcHYSngux0F+20fZCW3o8NOc9OQNz8K8XhrOLIuzmiPvHRgjluMWaVU6QZkHEJu0ncQuErr+cGCV41SniCSff4DeoFYZt4wqiFra2Lh9geUkFmGyw39vdGcub8k24xRQUZ3CBWylS9GxGCicr/gAGnlvFbt6byWd9xpytVG0pnwiIkG08dVwly/zW/Zka++C+xsbrcFBzivu8zQmyKGs4ykU5WoaSIL/U6jv1yxrR4pPhq73KfBCwojqAX2gJjxtlQX/q0Mg==".getBytes());
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIExjCCA66gAwIBAgIQNdl1lNG2dU22NkLLterPzzANBgkqhkiG9w0BAQsFADA7MQswCQYDVQQGEwJJVDEQMA4GA1UEChMHRGlnaXRQQTEaMBgGA1UEAxMRVWZmaWNpbyBTaWN1cmV6emEwHhcNMTAwNTIwMDgzOTQ2WhcNMjAwNTE3MDgzOTQ2WjBbMQswCQYDVQQGEwJJVDEQMA4GA1UEChMHRGlnaXRQQTEQMA4GA1UEKhMHVWZmaWNpbzESMBAGA1UEBBMJU2ljdXJlenphMRQwEgYDVQQFEws5NzEwMzQyMDU4MDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAI6sLMeL0AXS/zG30Nvh+mmtimUFvIVLeFZLaqg47bi5d7E1/IpkQnAwTyTT4yJGfrYrIrPnAK13wLcB4Za0WhYlBueW69uNHXhpkueIiGO9Wfeasx9T5tYcnrOUsoQTigTx3zcwY36DETwNqECu0uVH7K0al51s53SE5eVbQKMgJKa/uvP6hLxcvDdilsv9kyR4oNWOxlFeCSxl2aMVzs4zpSyNnmHwt2mQAgbzREnVvcjwOKAgRH9Kg6z5WiWsM2rNGRIeEkUIzHIxoc5WxkdNrBHppa79cmUCEIuBIE2ZtaNjOIVXvzYwkLq5TpgD5rSauUQZO3nduZxiPHVWmrMCAwEAAaOCAaQwggGgMAwGA1UdEwEB/wQCMAAwDgYDVR0PAQH/BAQDAgZAMCgGA1UdCQQhMB8wHQYIKwYBBQUHCQExERgPMjAxMDA1MTMyMjAwMDBaMEEGA1UdHwQ6MDgwNqA0oDKGMGh0dHBzOi8vYXBwbGljYXppb25pLmNuaXBhLmdvdi5pdC9UU0wvSVRfVFNMLmNybDCBsAYDVR0gBIGoMIGlMIGiBgMrTBAwgZowJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuZGlnaXRwYS5nb3YuaXQvMHAGCCsGAQUFBwICMGQwDhYHRGlnaXRQQTADAgEBGlJLZXlzIHVzZWQgdG8gZ2VuZXJhdGUgY2VydGlmaWNhdGVzIHRvIHN1YnNjcmliZSBuYXRpb25hbCBUcnVzdCBTZXJ2aWNlIHN0YXR1cyBMaXN0MB0GA1UdDgQWBBRIk1ErMuBTlDGOEariH5O7InkS7TAfBgNVHSMEGDAWgBS5A9dz6beQZDceQKN59MYviqnwqjAgBgNVHREEGTAXgRVJVF9UU0xAZGlnaXRwYS5nb3YuaXQwDQYJKoZIhvcNAQELBQADggEBACsvm2YLT0bB2Rgk5W1iG9mMYZCWE7rA+1h6Y9DmxS5zwdzFlwCr7EQ7DbWElQD0glq0hYO5COP6Z0YRhQsn2LypxLrzpWN/qhDBvA8Tol4/MPUqYznU1yBttt3aopqn0GR5iGlTCCYhDF3G8qj4sgOUsG6kJ/TGVbFiV9YRyUBUv7+3FN9ed95mtV2Cy0NVuG1JDSGot60qZfekHn1ZCg1KdaGnoYzk7Dzh2yio0/fEBPP9+r8sVCJCuujQYx+M5qQB/NHyAGXMUS//F3/4qhZAElz5/D/kN6Q3eYTtw04XIShGt89pbGsP7lXmvSLHSKPz98xBFQLqEwJn1QcWDLE=".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIEdzCCA1+gAwIBAgIQBSTQoxxf8UaYEMZNtexORDANBgkqhkiG9w0BAQsFADA7MQswCQYDVQQGEwJJVDEQMA4GA1UEChMHRGlnaXRQQTEaMBgGA1UEAxMRVWZmaWNpbyBTaWN1cmV6emEwHhcNMTQwMjEwMTE0MjM5WhcNMjAxMjMxMTE0MjM5WjBbMQswCQYDVQQGEwJJVDEQMA4GA1UEChMHRGlnaXRQQTESMBAGA1UEBBMJU2ljdXJlenphMRAwDgYDVQQqEwdVZmZpY2lvMRQwEgYDVQQFEws5NzEwMzQyMDU4MDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIPOYhltsTauooCfL6ggktmvRogcxVMRHPh7R9PifTJQBSR67L23u7bp4lY+Vd9w9h60z0rzp+vNvNgc12zXcgHcoue2VdFEJTlptElj3t3OICulC4QA4vFEUuFp2fKxEIr0KdzvLlHfcHYBhC4flx9k0hdpbfkjn+hwC/WOusj7JBMXgl3P1PSjKWpXNhVOnvrr+m6AbmERazIk7aBCSy6joz+QrRgCLiXRuqJxV3FirlQnmLB8np4Mebd+JwwwTgcT6hhx+f8s31cv7HFQDeIUd1i2aTCg04OrpuawZVmZjgGNHj+79YGouuQfCys7jW6t0Lety6LsonaSxHpAQgECAwEAAaOCAVUwggFRMAwGA1UdEwEB/wQCMAAwDgYDVR0PAQH/BAQDAgZAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHBzOi8vYXBwbGljYXppb25pLmNuaXBhLmdvdi5pdC9UU0wvdGVzdC5jcmwwga4GA1UdIASBpjCBozCBoAYDK0wQMIGYMCYGCCsGAQUFBwIBFhpodHRwOi8vd3d3LmRpZ2l0cGEuZ292Lml0LzBuBggrBgEFBQcCAjBiMA4WB0RpZ2l0UEEwAwIBARpQQ0EgdXNlZCB0byBnZW5lcmF0ZSBjZXJ0aWZpY2F0ZXMgdG8gc3Vic2NyaWJlIG5hdGlvbmFsIFRydXN0IFNlcnZpY2Ugc3RhdHVzIExpc3QwHQYDVR0OBBYEFIZ211SuCQDJ//4sjSI7DacHi7EaMCAGA1UdEQQZMBeBFUlUX1RTTEBkaWdpdHBhLmdvdi5pdDANBgkqhkiG9w0BAQsFAAOCAQEBNSU/P4X7Dllqg4tXIrxsAjlQrSS0Znt6et8+zW21GI8QmYSq0R8qHjFQs+dfl5B/qmftebhVpVe6vSzyJndKWycMtdMX0gkC2o66Wpl6fMZ55voYCF8ZTqBDcqMMvCt8o9TzlIPdcaWUZmlj3QfH+nGiC2/3cY4ZK9IWtWrYlZYk7tQGA1RCvQFLz3Uy9kbK5XcpF5prPCwQ/f5VjZBfWut2TuqO3NUbQ0RUK5JPDHiInV7VwN9sMj5nbRfhOiMH5AENLU8/x9Mk7V9YsXXEXq/Qms8I/yk7HejSn0Rd/DurIUUP8UbBM3GCv5cAYoea1R3sG52tMZUxke88uOCLkg==".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIFUTCCBDmgAwIBAgIQZTsBHXHnMEWLMsMhC1buxjANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCSVQxJjAkBgNVBAoMHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMRowGAYDVQQFDBFWQVRJVC05NzczNTAyMDU4NDENMAsGA1UEAwwEQWdJRDEhMB8GCSqGSIb3DQEJARYSaXRfdHNsQGFnaWQuZ292Lml0MB4XDTIwMTIwMTA5MzQ0MVoXDTI2MDExNDA5MzQ0MVowgbMxCzAJBgNVBAYTAklUMSYwJAYDVQQKDB1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTEvMC0GA1UECwwmSXRhbGlhbiBUcnVzdGVkIExpc3QgTWFuYWdlbWVudCBPZmZpY2UxGTAXBgNVBAUMEFZBVElULTk3NzM1MDIwNTgxDTALBgNVBAMMBEFnSUQxITAfBgkqhkiG9w0BCQEWEml0X3RzbEBhZ2lkLmdvdi5pdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKxsC/kmEJJO7/hcupCbonzR0UBxgO2Qud6/M4kvAE1NyRdd6soE6wLFSUcIoZCw6by31ddfaNTJbFkevNDUS31u2ycsOqMobPm/uTOTNpDhMLrsncY5O8aSGNYYMVn9Og2AtDhYDdkqnWR4jigzgTSJ/Fk5PFJarFZ/tk+kl3jLvrI9qOP861yQ+QCc/I+C04ugcpDONwkoWukZJtHayVrOoUZwgQGHBVFeD4nFbdZFH33le9YHN9vg7lczdTbLsYhEJp0WUwMsewC/NuPJ/grpr7hj6UcM4h4qEC/eS5d63pZHnwXqvgMW1AN6P38sSbXdd+45hDDcxVBhQ/JH5M8CAwEAAaOCAY0wggGJMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgbAMB0GA1UdDgQWBBSGmjb0h4WtXP3TDc0Njk9qZcpSNDARBgNVHSUECjAIBgYEAJE3AwAwOQYDVR0fBDIwMDAuoCygKoYoaHR0cHM6Ly9laWRhcy5hZ2lkLmdvdi5pdC9jcmwvSVRfQ1JMLmNybDCBxgYDVR0gBIG+MIG7MAoGCCsGAQUFBwIBMIGsBgMrTBAwgaQwOQYIKwYBBQUHAgEWLWh0dHBzOi8vZWlkYXMuYWdpZC5nb3YuaXQvY3BzL0lUX0NQU19BR0lELnBkZjBnBggrBgEFBQcCAjBbMCQWHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMAMCAQEaM0NlcnRpZmljYXRlIHVzYWJsZSB0byB2YWxpZGF0ZSBJdGFsaWFuIFRydXN0ZWQgTGlzdDAfBgNVHSMEGDAWgBQQblejCQGUNLDtGclWwzjkDxJiQzAYBggrBgEFBQcBAwQMMAowCAYGBACORgEEMA0GCSqGSIb3DQEBCwUAA4IBAQFLLVVR81eBCxGXEDtvpltOERl7r/WbolQ62qYd2YfRCf7Xj9Qb65ZayvVtb9XQLO3h6sGFpKZ5tyXiA9HVbt+om9J+ezxaYMhWomNntJ2oi8g2rk3DV9jhkBxTwLrkFjU9yQokHzFBE4jy9OBciktmGZ22EOL03CAQD0OVc7ukr9zI8ICw5DL5t/v8o86Stu3y1DuvyZ519xRNJ6CZTTYiaD9iFOHma+VDbUy4yzZ642Z2FnUxxLxZZAnjJe1iKND6OGApxnB512So63VFLtPTcC26js10j6MFR+A7evqbWsVZTx1mlA0uQIro7c/NbZodboJ27jqJwwnLcsBqyPZG".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            try {
                certDBItem = TSL.a(certDB, "MIIFUjCCBDqgAwIBAgIQdoEx8tMJRESZrx3ITwK2dzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCSVQxJjAkBgNVBAoMHUFnZW56aWEgcGVyIGwnSXRhbGlhIERpZ2l0YWxlMRowGAYDVQQFDBFWQVRJVC05NzczNTAyMDU4NDENMAsGA1UEAwwEQWdJRDEhMB8GCSqGSIb3DQEJARYSaXRfdHNsQGFnaWQuZ292Lml0MB4XDTIwMTIwMTA5NDA1MVoXDTI2MDUxNDA5NDA1MVowgbQxCzAJBgNVBAYTAklUMSYwJAYDVQQKDB1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTEvMC0GA1UECwwmSXRhbGlhbiBUcnVzdGVkIExpc3QgTWFuYWdlbWVudCBPZmZpY2UxGjAYBgNVBAUMEVZBVElULTk3NzM1MDIwNTg0MQ0wCwYDVQQDDARBZ0lEMSEwHwYJKoZIhvcNAQkBFhJpdF90c2xAYWdpZC5nb3YuaXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDQN3R97HGAIkPLE0SZVMnIgQrG2gmfUvvbfDbvTpx2Ng1qHFV+gSo4cKwR5uP3qycCA2kAkR8HoSqE9t/UGz3XEbaFaBCvRXXGNhREYHnUTW3TcfS2lv+QhY5fug84wkeetEOBBGE81zio+sZVRzRT7hHak8sGv26VOzLW6Jgt6q4M+r+4Q6dGKde9bjQxnlL9CpWSadImrKXUog3ar7Diy7CLTtQoBI6FnYili2oBGJIh9rM3uHyWZ+2/ctQtl9GB2M/vCBixyoySG52j/HLzsxEAtwnnuOzKx3d3JoegGGotvoqg/+Lj/sB/EBpYU1o/jToLFyVa/V7Q+uuQwGYBAgMBAAGjggGNMIIBiTAJBgNVHRMEAjAAMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUAAiTuMDCn+3Th5/SnfZ9MbLpCM4wEQYDVR0lBAowCAYGBACRNwMAMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHBzOi8vZWlkYXMuYWdpZC5nb3YuaXQvY3JsL0lUX0NSTC5jcmwwgcYGA1UdIASBvjCBuzAKBggrBgEFBQcCATCBrAYDK0wQMIGkMDkGCCsGAQUFBwIBFi1odHRwczovL2VpZGFzLmFnaWQuZ292Lml0L2Nwcy9JVF9DUFNfQUdJRC5wZGYwZwYIKwYBBQUHAgIwWzAkFh1BZ2VuemlhIHBlciBsJ0l0YWxpYSBEaWdpdGFsZTADAgEBGjNDZXJ0aWZpY2F0ZSB1c2FibGUgdG8gdmFsaWRhdGUgSXRhbGlhbiBUcnVzdGVkIExpc3QwHwYDVR0jBBgwFoAUEG5XowkBlDSw7RnJVsM45A8SYkMwGAYIKwYBBQUHAQMEDDAKMAgGBgQAjkYBBDANBgkqhkiG9w0BAQsFAAOCAQEBbM/KmjgWRWE05eorBsjURkwxrrpYiZTLTmTxHOPyKVEYp9qLs95ffAWBnCNnDVx/ZM5N2VLeUDnWL+eJMx6ohaS1Rfk0/+jnxJnThHU9LWdu6NdZIjh8cDG2NKwKMhGJmr2qKXn6vpmV4GSTAJT0Y3C6utpGVxyuJz7oyNayqiXilLWghIq4LBAgrt9iIvykSTvGkvqtRP6yhq5h41lzRhbpbdryZcdDirqlrakPHqMpbeZYybWhu9yfTrPJ5ws99cRDLOOoNNVqjbmxfc240B/aCf+U4zLPjP0IAb2EY4e45YBURdho+xhLX6bUL7GgZsynnTx2089HJPqKmLqeqg==".getBytes());
                certDB.add(certDBItem);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
            URL_DSList.setCacerts(certDB);
        }
        catch (CertDBException certDBException) {
            a.error(certDBException.getMessage(), (Throwable)certDBException);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

