/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rsa;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.vol.utils.Constants;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public abstract class DigestRSASignature
extends Signature {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Cipher c;
    protected String b;
    protected Digest hash;

    protected DigestRSASignature(String string, String string2, Digest digest) throws NoSuchAlgorithmException {
        super(string);
        this.b = string2;
        this.hash = digest;
    }

    @Override
    protected boolean engineVerify(byte[] object) throws SignatureException {
        a.debug("engineVerify called...");
        byte[] byArray = new byte[this.hash.getDigestSize()];
        this.hash.doFinal(byArray, 0);
        try {
            object = this.c.doFinal((byte[])object, 0, ((byte[])object).length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        try {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])object);
            object = aSN1Primitive;
            MessageImprint messageImprint = MessageImprint.getInstance((Object)((ASN1Sequence)aSN1Primitive));
            object = messageImprint;
            AlgorithmIdentifier algorithmIdentifier = messageImprint.getHashAlgorithm();
            object = object.getHashedMessage();
            a.debug("engineVerify comparing two digest ..");
            if (this.b.compareTo(algorithmIdentifier.getAlgorithm().getId()) != 0) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
            return Arrays.areEqual((byte[])byArray, (byte[])object);
        }
        catch (SignatureException signatureException) {
            object = signatureException;
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Signature ASN.1 format error: " + exception.toString());
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.hash.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(byte by) {
        this.hash.update(by);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        a.debug("engineSign: Sha256RSASignature");
        Object object = new byte[this.hash.getDigestSize()];
        this.hash.doFinal(object, 0);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(this.b);
        aSN1ObjectIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)DERNull.INSTANCE);
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[2];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray[0] = aSN1ObjectIdentifier;
        aSN1EncodableArray2[1] = new DEROctetString(object);
        object = new DERSequence(aSN1EncodableArray2);
        try {
            a.debug("engineSign: dofinal ?");
            object = object.getEncoded();
            object = this.c.doFinal((byte[])object, 0, ((byte[])object).length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
        return object;
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    @Override
    protected void engineInitVerify(PublicKey serializable) throws InvalidKeyException {
        try {
            a.debug("engineInitVerify called...");
            this.c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            this.c.init(2, (Key)serializable);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            serializable = invalidKeyException;
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitVerify error: " + exception.toString());
        }
    }

    @Override
    protected void engineInitSign(PrivateKey serializable) throws InvalidKeyException {
        try {
            a.debug("engineInitSign ?");
            this.c = Cipher.getInstance("RSA/ECB/PKCS1Padding", ActalisSingleton.getActalisProvider());
            a.debug("engineInitSign: RSA/ECB/PKCS1Padding");
            this.c.init(1, (Key)serializable);
            a.debug("engineInitSign: ok");
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            serializable = invalidKeyException;
            throw invalidKeyException;
        }
        catch (Exception exception) {
            a.error("Init sign error: " + exception.getMessage(), (Throwable)exception);
            throw new InvalidKeyException("InitSign error: " + exception.toString());
        }
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }
}

