/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509DPCM45Issuer
extends SingleValidationSubStepImpl {
    public StepX509DPCM45Issuer() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore().after(Constants.DPCM_CNIPA_45_2009) && validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore().before(Constants.DPCM_AGID_189_2017_STARTDATE)) {
            if (validationContextParameters.getSignerCertificate().getIssuer() == null) {
                return null;
            }
            boolean bl = false;
            try {
                String[] stringArray = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] stringArray2 = validationContextParameters.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                if (stringArray != null && stringArray.length == 1 && stringArray2 != null && stringArray2.length == 1) {
                    bl = true;
                }
            }
            catch (CapiException capiException) {
                bl = false;
            }
            if (!bl) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0016_INVALID_ISSUER_DPCM45, new Object[0]);
            }
        }
        return null;
    }
}

