/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.memory;

import esecurity.tsl.AtrDbItem;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbItemFilter;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MemoryCdb
extends CertDb {
    private final HashMap<String, ArrayList<ServiceDbItem>> items = new HashMap();
    private List<AtrDbItem> blackList = new ArrayList<AtrDbItem>();
    private List<AtrDbItem> whiteList = new ArrayList<AtrDbItem>();

    public MemoryCdb(NetworkConfig networkConfig) {
        super(networkConfig);
    }

    @Override
    protected List<ServiceDbItem> getServiceItems(String string) {
        this.throwExceptionIfClosed();
        if (this.items.get(string) == null) {
            return null;
        }
        return this.items.get(string);
    }

    @Override
    public void importService(ServiceDbItem serviceDbItem) throws CapiException {
        this.throwExceptionIfClosed();
        String string = this.calculateServiceIdFromSubject(serviceDbItem.getCert(), serviceDbItem.getCert().getSubjectDN());
        if (this.items.get(string) == null) {
            this.items.put(string, new ArrayList());
        }
        serviceDbItem.setValidSignature(false);
        this.items.get(string).add(serviceDbItem);
    }

    @Override
    public int getServiceCount() {
        int n = 0;
        for (String string : this.items.keySet()) {
            n += this.items.get(string).size();
        }
        return n;
    }

    @Override
    public List<ServiceDbItem> queryServiceItems(CertDbItemFilter certDbItemFilter) {
        LinkedList<ServiceDbItem> linkedList = new LinkedList<ServiceDbItem>();
        if (certDbItemFilter != null && certDbItemFilter.serviceId != null) {
            MemoryCdb memoryCdb = this;
            return memoryCdb.filterList((List<ServiceDbItem>)memoryCdb.items.get(certDbItemFilter.serviceId), certDbItemFilter);
        }
        for (String string : this.items.keySet()) {
            MemoryCdb memoryCdb = this;
            linkedList.addAll(memoryCdb.filterList((List<ServiceDbItem>)memoryCdb.items.get(string), certDbItemFilter));
        }
        return linkedList;
    }

    @Override
    public List<ServiceDbItem> queryServiceItems(Certificate object) {
        Certificate certificate = object;
        object = this.calculateServiceIdFromSubject(certificate, certificate.getSubjectDN());
        return this.getServiceItems((String)object);
    }

    @Override
    public List<AtrDbItem> getAtrWhiteList() {
        if (this.whiteList == null) {
            return new ArrayList<AtrDbItem>();
        }
        return this.whiteList;
    }

    @Override
    public void removeServiceItem(Certificate object) throws CapiException {
        this.throwExceptionIfClosed();
        Certificate certificate = object;
        object = this.calculateServiceIdFromSubject(certificate, certificate.getSubjectDN());
        this.items.remove(object);
    }

    @Override
    public boolean isAtrInWhitelist(String string) {
        for (AtrDbItem atrDbItem : this.whiteList) {
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceAtrWhitelist(List<String> list) {
        this.whiteList = this.replaceAtrList(list);
    }

    @Override
    public List<AtrDbItem> getAtrBlackList() {
        if (this.blackList == null) {
            return new ArrayList<AtrDbItem>();
        }
        return this.blackList;
    }

    @Override
    public void addAtrToWhiteList(String string) {
        MemoryCdb memoryCdb = this;
        memoryCdb.addAtrToList(memoryCdb.whiteList, string);
    }

    @Override
    public void removeAtrWhitelist(String object) {
        object = this.getWhiteListAtrItem((String)object);
        MemoryCdb memoryCdb = this;
        memoryCdb.removeAtr(memoryCdb.whiteList, (AtrDbItem)object);
    }

    @Override
    public boolean isAtrInBlacklist(String string) {
        for (AtrDbItem atrDbItem : this.blackList) {
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AtrDbItem getWhiteListAtrItem(String string) {
        for (AtrDbItem atrDbItem : this.whiteList) {
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return atrDbItem;
        }
        return null;
    }

    @Override
    public AtrDbItem getBlackListAtrItem(String string) {
        for (AtrDbItem atrDbItem : this.blackList) {
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return atrDbItem;
        }
        return null;
    }

    @Override
    public void replaceAtrBlacklist(List<String> list) {
        this.blackList = this.replaceAtrList(list);
    }

    private List<AtrDbItem> replaceAtrList(List<String> object) {
        ArrayList<AtrDbItem> arrayList = new ArrayList<AtrDbItem>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            AtrDbItem atrDbItem = new AtrDbItem();
            atrDbItem.setAtr(string);
            arrayList.add(atrDbItem);
        }
        return arrayList;
    }

    @Override
    public void addAtrToBlackList(String string) {
        MemoryCdb memoryCdb = this;
        memoryCdb.addAtrToList(memoryCdb.blackList, string);
    }

    private void addAtrToList(List<AtrDbItem> list, String string) {
        for (AtrDbItem atrDbItem : list) {
            if (!atrDbItem.getAtr().equalsIgnoreCase(string)) continue;
            return;
        }
        AtrDbItem atrDbItem = new AtrDbItem();
        atrDbItem.setAtr(string);
        list.add(atrDbItem);
    }

    @Override
    public void removeAtrBlacklist(String object) {
        object = this.getBlackListAtrItem((String)object);
        MemoryCdb memoryCdb = this;
        memoryCdb.removeAtr(memoryCdb.blackList, (AtrDbItem)object);
    }

    private void removeAtr(List<AtrDbItem> list, AtrDbItem atrDbItem) {
        if (atrDbItem != null) {
            list.remove(atrDbItem);
        }
    }

    private List<ServiceDbItem> filterList(List<ServiceDbItem> object, CertDbItemFilter certDbItemFilter) {
        LinkedList<ServiceDbItem> linkedList = new LinkedList<ServiceDbItem>();
        if (object == null) {
            return linkedList;
        }
        if (certDbItemFilter == null) {
            return object;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)object.next();
            if (certDbItemFilter.validSignature && !serviceDbItem.isValidSignature() || certDbItemFilter.certType != null && serviceDbItem.getCert().getCertificateType() != certDbItemFilter.certType || certDbItemFilter.uriType != null && serviceDbItem.getServiceType() != TSLServiceTypeIdentifiers.fromUri(certDbItemFilter.uriType) || certDbItemFilter.commonName != null && !certDbItemFilter.commonName.toLowerCase().contains(certDbItemFilter.commonName.toLowerCase())) continue;
            linkedList.add(serviceDbItem);
        }
        return linkedList;
    }

    @Override
    public void close() {
        this.items.clear();
        this.close = true;
    }
}

