/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.cms.ASN1SequenceGenerator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TimeStampAndCRL;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.slf4j.Logger;

public class TimeStampedData {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ASN1Integer b = null;
    private ASN1Sequence c = null;
    private DERIA5String d = null;
    private DERIA5String e = null;
    private DERUTF8String f = null;
    private Hashtable g = null;
    private ASN1Boolean h = null;
    private ASN1OctetStringParser i = null;
    private File j = null;
    private File k = null;
    private InputStream l = null;
    private static String m = "TSDenv";
    private static String n = "TSDcontent";
    private int o = -1;
    private TimeStampAndCRL[] p = null;
    public static final String TIME_STAMPED_DATA_OID = "1.2.840.113549.1.9.16.1.31";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private int q = -1;
    private boolean r = false;

    public TimeStampedData(boolean bl) {
        this.b = new ASN1Integer(1L);
        this.q = 0;
        this.r = bl;
    }

    public TimeStampedData() {
        this(false);
    }

    public TimeStampedData(InputStream inputStream) throws CapiException {
        try {
            new ASN1InputStream(inputStream);
            inputStream = new ASN1StreamParser(inputStream);
            inputStream = (ASN1SequenceParser)inputStream.readObject();
        }
        catch (Exception exception) {
            throw new CapiException("Exception reading TimeStampedData", 50040);
        }
        this.a((ASN1SequenceParser)inputStream);
        this.q = 1;
    }

    public TimeStampedData(byte[] object) throws CapiException {
        try {
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(object);
            object = aSN1StreamParser;
            object = (ASN1SequenceParser)aSN1StreamParser.readObject();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception reading TimeStampedData", 50040);
        }
        this.a((ASN1SequenceParser)object);
        this.q = 1;
    }

    private static int a(Object object, Class[] classArray) {
        int n;
        for (n = 0; n < classArray.length; ++n) {
            Class<?> clazz = object.getClass();
            a.debug("[checkObj] obj class is:  " + clazz.getName());
            if (!clazz.equals(classArray[n])) continue;
            a.debug("[checkObj] found  " + classArray[n].getName());
            return n;
        }
        a.debug("[checkObj] obj does not belog to the requested Classes: ");
        for (n = 0; n < classArray.length; ++n) {
            a.debug("[checkObj] " + classArray[n].getName());
        }
        return -1;
    }

    private void a(ASN1SequenceParser aSN1SequenceParser) throws CapiException {
        try {
            int n;
            Object object;
            Object object2 = aSN1SequenceParser.readObject();
            if (object2 == null || !(object2 instanceof ASN1ObjectIdentifier)) {
                throw new CapiException("Invalid ContentInfo", 50040);
            }
            if ((object2 = (ASN1ObjectIdentifier)object2).getId().compareToIgnoreCase(TIME_STAMPED_DATA_OID) != 0) {
                throw new CapiException("Invalid Content Type. Supported OID: 1.2.840.113549.1.9.16.1.31", 50040);
            }
            a.debug("[parse] Found Content Type.");
            object2 = aSN1SequenceParser.readObject();
            if (object2 == null) {
                throw new CapiException("Missing content: TimeStampedData", 50040);
            }
            aSN1SequenceParser = (BERTaggedObjectParser)object2;
            aSN1SequenceParser = (ASN1SequenceParser)aSN1SequenceParser.getObjectParser(0, true);
            a.debug("[parse] parsing TimeStampedData ...");
            object2 = aSN1SequenceParser.readObject();
            if (object2 == null || !(object2 instanceof ASN1Integer)) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Version not found", 50040);
            }
            this.b = (ASN1Integer)object2;
            a.debug("[parse] version = " + this.b.getValue().intValue());
            if (this.b.getValue().intValue() != 1) {
                throw new CapiException("TimeStampedData Version: " + this.b.getValue().intValue() + ". V1 is supported.", 50040);
            }
            object2 = aSN1SequenceParser.readObject();
            if (object2 == null) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
            }
            this.c = null;
            Class[] classArray = new Class[]{DERIA5String.class, BERSequenceParser.class, BEROctetStringParser.class, DERSequenceParser.class, DEROctetStringParser.class};
            int n2 = TimeStampedData.a(object2, classArray);
            block3 : switch (n2) {
                case 0: {
                    int n3;
                    this.d = (DERIA5String)object2;
                    object2 = aSN1SequenceParser.readObject();
                    if (object2 == null) {
                        throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                    }
                    Class[] classArray2 = new Class[]{BERSequenceParser.class, BEROctetStringParser.class, DERSequenceParser.class, DEROctetStringParser.class};
                    int n4 = TimeStampedData.a(object2, classArray2);
                    switch (n4) {
                        case 0: 
                        case 2: {
                            object = (ASN1SequenceParser)object2;
                            this.c = (ASN1Sequence)object.toASN1Primitive();
                            object2 = aSN1SequenceParser.readObject();
                            if (object2 == null) {
                                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                            }
                            classArray2 = new Class[]{BEROctetStringParser.class, DEROctetStringParser.class};
                            n3 = TimeStampedData.a(object2, classArray2);
                            if (n3 != 0 && n3 != 1) break block3;
                            this.i = (ASN1OctetStringParser)object2;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.i = (ASN1OctetStringParser)object2;
                            break;
                        }
                    }
                    break;
                }
                case 1: 
                case 3: {
                    object = (ASN1SequenceParser)object2;
                    this.c = (ASN1Sequence)object.toASN1Primitive();
                    object2 = aSN1SequenceParser.readObject();
                    if (object2 == null) {
                        throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
                    }
                    Class[] classArray3 = new Class[]{BEROctetStringParser.class, DEROctetStringParser.class};
                    int n3 = TimeStampedData.a(object2, classArray3);
                    if (n3 == 0 || n3 == 1) {
                        this.i = (ASN1OctetStringParser)object2;
                        break;
                    }
                    throw new CapiException("Invalid TimeStampedData SEQUENCE. Missing both dataUri and content.", 50040);
                }
                case 2: 
                case 4: {
                    this.i = (ASN1OctetStringParser)object2;
                    break;
                }
                default: {
                    throw new CapiException("Invalid TimeStampedData SEQUENCE. Missing dataUri, metaData and content.", 50040);
                }
            }
            ASN1Set aSN1Set = null;
            if (this.c != null) {
                object = this.c.getObjects();
                if (!object.hasMoreElements()) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                Object e = object.nextElement();
                if (e == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                Class[] classArray4 = new Class[]{ASN1Boolean.class};
                int n5 = TimeStampedData.a(e, classArray4);
                if (n5 != 0 && n5 != 1) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Missing hashProtected.", 50040);
                }
                this.h = (ASN1Boolean)e;
                if (!object.hasMoreElements()) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                e = object.nextElement();
                if (e == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Not enough data.", 50040);
                }
                Class[] classArray5 = new Class[]{DERUTF8String.class, DERIA5String.class, ASN1Set.class};
                n = TimeStampedData.a(e, classArray5);
                block12 : switch (n) {
                    case 0: {
                        this.f = (DERUTF8String)e;
                        a.debug("[parse] filename = " + this.f.getString());
                        if (!object.hasMoreElements() || (e = object.nextElement()) == null) break;
                        classArray5 = new Class[]{DERIA5String.class, ASN1Set.class};
                        n = TimeStampedData.a(e, classArray5);
                        switch (n) {
                            case 0: {
                                this.e = (DERIA5String)e;
                                a.debug("[parse] mediaType = " + this.e.getString());
                                if (!object.hasMoreElements() || (e = object.nextElement()) == null) break block12;
                                classArray5 = new Class[]{ASN1Set.class};
                                if (TimeStampedData.a(e, classArray5) == 0) {
                                    aSN1Set = (ASN1Set)e;
                                    break block12;
                                }
                                throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after mediaType.", 50040);
                            }
                            case 1: {
                                aSN1Set = (ASN1Set)e;
                                break block12;
                            }
                            default: {
                                throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after fileName", 50040);
                            }
                        }
                    }
                    case 1: {
                        this.e = (DERIA5String)e;
                        a.debug("[parse] mediaType = " + this.e.getString());
                        if (!object.hasMoreElements() || (e = object.nextElement()) == null) break;
                        classArray5 = new Class[]{ASN1Set.class};
                        if (TimeStampedData.a(e, classArray5) == 0) {
                            aSN1Set = (ASN1Set)e;
                            break;
                        }
                        throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after mediaType.", 50040);
                    }
                    default: {
                        throw new CapiException("Invalid MetaData SEQUENCE. Found an invalid element after HashProtected", 50040);
                    }
                }
                if (this.f == null && this.e == null && aSN1Set == null) {
                    throw new CapiException("Invalid MetaData SEQUENCE. Missing fileName, mediaType and otherMetaData", 50040);
                }
            }
            if (aSN1Set != null) {
                if (aSN1Set.size() == 0) {
                    throw new CapiException("Invalid othetMetaData. No Attribute found", 50040);
                }
                object = new AttributeTable(aSN1Set);
                this.g = object.toHashtable();
            }
            if (this.i != null) {
                object = null;
                InputStream inputStream = null;
                try {
                    inputStream = this.i.getOctetStream();
                    a.debug("reading content octect stream...");
                    String string = null;
                    if (this.f != null && this.f.getString() != null && (n = this.f.getString().lastIndexOf(".")) >= 0) {
                        string = this.f.getString().substring(n);
                    }
                    this.j = TimeStampedData.a(this.j, TimeStampedData.n, string);
                    object = new FileOutputStream(this.j);
                    object2 = new byte[8192];
                    while ((n = inputStream.read((byte[])object2)) != -1) {
                        ((OutputStream)object).write((byte[])object2, 0, n);
                    }
                    this.l = new FileInputStream(this.j);
                    object2 = aSN1SequenceParser.readObject();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    throw exception;
                }
                finally {
                    Util.closeQuietly((Closeable)object);
                    Util.closeQuietly((Closeable)inputStream);
                }
            }
            if (object2 == null) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Not enough data.", 50040);
            }
            if (!(object2 instanceof BERTaggedObjectParser)) {
                throw new CapiException("Invalid TimeStampedData SEQUENCE. Evidence not found", 50040);
            }
            object = ((BERTaggedObjectParser)object2).toASN1Primitive();
            switch (((ASN1TaggedObject)object).getTagNo()) {
                case 0: {
                    ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)object), (boolean)false);
                    int n6 = aSN1Sequence.size();
                    if (n6 <= 0) {
                        throw new CapiException("No TimeStampAndCRL found in TimeStampTokenEvidence", 50040);
                    }
                    a.debug("[parse] Found " + n6 + " TimeStampAndCRL.");
                    this.p = new TimeStampAndCRL[n6];
                    for (n = 0; n < n6; ++n) {
                        object2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n).toASN1Primitive();
                        if (object2.size() <= 0) {
                            throw new CapiException("Empty TimeStampAndCRL SEQUENCE.", 50040);
                        }
                        if (object2.size() == 1) {
                            a.debug("[parse] TimeStampAndCRL contains only TimeStampToken.");
                            this.p[n] = new TimeStampAndCRL();
                            this.p[n].setTimeStampToken(object2.getObjectAt(0).toASN1Primitive().getEncoded("DER"));
                            continue;
                        }
                        if (object2.size() == 2) {
                            a.debug("[parse] TimeStampAndCRL contains both TimeStampToken and CRL");
                            this.p[n] = new TimeStampAndCRL();
                            this.p[n].setTimeStampToken(object2.getObjectAt(0).toASN1Primitive().getEncoded("DER"));
                            this.p[n].setCRL(object2.getObjectAt(1).toASN1Primitive().getEncoded("DER"));
                            continue;
                        }
                        this.p = null;
                        throw new CapiException("Invalid TimeStampAndCRL SEQUENCE. Too many fields in the SEQUENCE", 50040);
                    }
                    this.o = 0;
                    break;
                }
                case 1: {
                    a.debug("[parse] EvidenceRecord is not supported. Only TimeStampTokenEvidence is supported");
                    this.o = 1;
                    break;
                }
                case 2: {
                    a.debug("[parse] OtherEvidence is not supported. Only TimeStampTokenEvidence is supported");
                    this.o = 2;
                    break;
                }
                default: {
                    throw new CapiException("Invalid Tag for Evidence. Tag = " + ((ASN1TaggedObject)object).getTagNo() + ". Allowed values are 0, 1 and 2.", 50040);
                }
            }
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("TimeStampedData parsing exception: " + exception.getMessage(), 50040);
        }
    }

    public int getVersion() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return this.b.getValue().intValue();
    }

    public String getFileName() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.f != null) {
            return this.f.getString();
        }
        return null;
    }

    public void setFileName(String string) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (string == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.f = new DERUTF8String(string);
    }

    public String getMediaType() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.e != null) {
            return this.e.getString();
        }
        return null;
    }

    public Map getOtherMetaData() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return new Hashtable(this.g);
    }

    public TimeStampAndCRL[] getTstEvidence() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.o != 0) {
            throw new CapiException("Temporal Evidence is not a TimeStampTokenEvidence.", 50000);
        }
        if (this.p != null && this.p.length > 0) {
            ArrayList arrayList = new ArrayList(this.p.length);
            Collections.addAll(arrayList, this.p);
            return arrayList.toArray(new TimeStampAndCRL[0]);
        }
        return null;
    }

    public void setTstEvidence(TimeStampAndCRL[] timeStampAndCRLArray) throws CapiException {
        if (timeStampAndCRLArray == null || timeStampAndCRLArray.length <= 0) {
            throw new CapiException("Null parameter", 1001);
        }
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, timeStampAndCRLArray);
        this.p = arrayList.toArray(new TimeStampAndCRL[0]);
        this.o = 0;
        if (this.q == 1) {
            this.q = 2;
        }
    }

    public void setOtherMetaData(Map map) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (map == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.g = new Hashtable(map.size());
        for (Object k : map.keySet()) {
            this.g.put(k, map.get(k));
        }
    }

    public int getTemporalEvidenceType() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        return this.o;
    }

    public void setMediaType(String string) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (string == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.e = new DERIA5String(string, true);
            return;
        }
        catch (Exception exception) {
            throw new CapiException("Invalid parameter", 1002);
        }
    }

    public InputStream getContent() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.l != null) {
            return this.l;
        }
        throw new CapiException("FileNotFoundException", 50000);
    }

    public String getDataURI() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.d != null) {
            return this.d.getString();
        }
        return null;
    }

    public void setDataURI(String string) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (string == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.d = new DERIA5String(string, true);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CapiException("Invalid parameter", 1002);
        }
    }

    public void setContent(byte[] byArray) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (byArray == null) {
            throw new CapiException("Null parameter", 1001);
        }
        this.l = new ByteArrayInputStream(byArray);
    }

    public void setContent(InputStream inputStream) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        if (inputStream == null) {
            throw new CapiException("Null parameter", 1001);
        }
        try {
            this.l = inputStream;
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception", 50040);
        }
    }

    public void setHashProtected(boolean bl) throws CapiException {
        if (this.q > 0) {
            throw new CapiException("TimeStampedData parsed. Cannot set this field.", 50000);
        }
        this.h = ASN1Boolean.getInstance((boolean)bl);
    }

    public boolean getHashProtected() throws CapiException {
        if (this.q <= 0) {
            throw new CapiException("TimeStampedData not parsed", 50000);
        }
        if (this.c == null || this.h == null) {
            throw new CapiException("No MetaData found", 50000);
        }
        return this.h.isTrue();
    }

    private DERSequence a() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined hashProtected field", 50000);
        }
        if (this.f == null && this.e == null && this.g == null) {
            throw new CapiException("At least one of fileName, mediaType and otherMetaData has to be defined", 50000);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.h);
        if (this.f != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.f);
        }
        if (this.e != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.e);
        }
        if (this.g != null) {
            AttributeTable attributeTable = new AttributeTable(this.g);
            aSN1EncodableVector.add((ASN1Encodable)new DERSet(attributeTable.toASN1EncodableVector()));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(OutputStream outputStream) throws CapiException {
        if (this.q == 1) {
            throw new CapiException("TimeStampedData parsed and not changed", 50000);
        }
        if (this.d == null && this.l == null) {
            if (this.j == null) throw new CapiException("Undefined both dataUri and content", 50000);
            if (!this.j.exists()) {
                throw new CapiException("Undefined both dataUri and content", 50000);
            }
        }
        if (this.p == null) throw new CapiException("No Temporal Evidencehas has been defined", 50000);
        if (this.p.length <= 0) {
            throw new CapiException("No Temporal Evidencehas has been defined", 50000);
        }
        ASN1SequenceGenerator aSN1SequenceGenerator = null;
        ASN1SequenceGenerator aSN1SequenceGenerator2 = null;
        OutputStream outputStream2 = null;
        try {
            int n;
            Object object;
            Object object2;
            aSN1SequenceGenerator = new ASN1SequenceGenerator(outputStream, this.r);
            a.debug("new BERSequenceGenerator done");
            aSN1SequenceGenerator.addObject((ASN1Encodable)new ASN1ObjectIdentifier(TIME_STAMPED_DATA_OID));
            a.debug("ci.addObject done");
            aSN1SequenceGenerator2 = new ASN1SequenceGenerator(aSN1SequenceGenerator.getRawOutputStream(), 0, true, this.r);
            a.debug("new BERSequenceGenerator(ci.getRawOutputStream(), 0, true) done");
            if (this.b == null) {
                this.b = new ASN1Integer(1L);
            }
            aSN1SequenceGenerator2.addObject((ASN1Encodable)this.b);
            a.debug("envGen.addObject(version) done");
            if (this.d != null) {
                aSN1SequenceGenerator2.addObject((ASN1Encodable)this.d);
            }
            if (this.c != null) {
                aSN1SequenceGenerator2.addObject((ASN1Encodable)this.c);
            } else {
                this.c = this.a();
                aSN1SequenceGenerator2.addObject((ASN1Encodable)this.c);
            }
            if (this.l == null) {
                a.debug("this.contentInputStream is null");
            } else if (!this.r) {
                BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(aSN1SequenceGenerator2.getRawOutputStream());
                object2 = bEROctetStringGenerator;
                outputStream2 = bEROctetStringGenerator.getOctetOutputStream();
                object = new byte[8192];
                while ((n = this.l.read((byte[])object)) != -1) {
                    outputStream2.write((byte[])object, 0, n);
                    a.debug("contentInputStream.read(buffer) loop");
                }
                outputStream2.close();
            } else {
                object2 = IOUtils.toByteArray((InputStream)this.l);
                DEROctetString dEROctetString = new DEROctetString(object2);
                aSN1SequenceGenerator2.getRawOutputStream().write(dEROctetString.getEncoded());
            }
            object2 = new ASN1EncodableVector();
            for (n = 0; this.p != null && n < this.p.length; ++n) {
                try {
                    object = this.p[n].getDERSequence();
                    object2.add((ASN1Encodable)object);
                    continue;
                }
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Exception adding timeStampandCRL sequence", 50040);
                }
            }
            DERTaggedObject dERTaggedObject = new DERTaggedObject(false, 0, (ASN1Encodable)new DERSequence((ASN1EncodableVector)object2));
            a.debug("new DERTaggedObject(false, 0, new DERSequence(tstEvidence)) done");
            aSN1SequenceGenerator2.addObject((ASN1Encodable)dERTaggedObject);
            a.debug("envGen.addObject(evidence) done");
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("IOException generating envelope", 50040);
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Exception generating envelope", 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (aSN1SequenceGenerator2 != null) {
                        aSN1SequenceGenerator2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (aSN1SequenceGenerator != null) {
                        aSN1SequenceGenerator.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (outputStream2 == null) throw throwable;
                    outputStream2.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            aSN1SequenceGenerator2.close();
        }
        catch (Exception exception) {}
        try {
            aSN1SequenceGenerator.close();
        }
        catch (Exception exception) {}
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (outputStream2 == null) return;
            outputStream2.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public byte[] getMetaData() throws CapiException {
        if (this.h == null) {
            return null;
        }
        try {
            return this.a().getEncoded("DER");
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            throw new CapiException("Exception in MetaData " + exception.getMessage(), 50040);
        }
    }

    public void writeTo(OutputStream outputStream) throws CapiException {
        this.a(outputStream);
    }

    private static File a(File file, String string, String string2) throws CapiException {
        try {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {}
        try {
            if (string.length() < 3) {
                string = string + "___";
            }
            file = TmpFileUtils.createTempFile((String)string, (String)string2);
            a.debug("Created file: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new CapiException("IOException in createTempFile", 50040);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getEncoded() throws CapiException {
        FileInputStream fileInputStream;
        Object object = null;
        try {
            this.k = TimeStampedData.a(this.k, m, null);
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        try {
            object = new FileOutputStream(this.k);
            this.a((OutputStream)object);
            fileInputStream = new FileInputStream(this.k);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (object != null) throw new CapiException("FileNotFoundException opening TimeStampedData", 50040);
                throw new CapiException("FileNotFoundException opening FileOutputStream", 50040);
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((OutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
                throw throwable;
            }
        }
        try {
            ((OutputStream)object).close();
            return fileInputStream;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            return fileInputStream;
        }
    }

    public void free() {
        if (this.l != null) {
            try {
                this.l.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }
}

