/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.cmdLine;

import esecurity.crypto.gui.cmdline.CmdLine;
import esecurity.crypto.gui.cmdline.CmdLineParser;
import esecurity.crypto.gui.cmdline.Option;
import esecurity.crypto.gui.cmdline.Options;
import esecurity.crypto.gui.functionality.SignatureFacade;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.NetworkProperties;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.utils.Constants;
import esecurity.crypto.gui.utils.Property;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.arubapec.arubasign.utils.ConfigurationTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class ArubaSignCmdLineParser {
    private static final Options OPTIONS = new Options();
    private static final Properties DEFAULTS;

    public static CmdLine parse(String[] args) {
        CmdLine cmdLine = new CmdLine();
        if (args != null) {
            try {
                cmdLine = new CmdLineParser().parse(OPTIONS, args);
            }
            catch (CapiException ex) {
                System.err.println("Error: " + ex.getMessage());
                OPTIONS.printHelp("Every arguments passed without a key is interpreted as file.");
                System.exit(1);
            }
        }
        return cmdLine;
    }

    public static void apply(CmdLine cmdLine, boolean verbose) throws CapiException {
        String defaultTimeZone;
        String cdbPassword;
        File cdbFile;
        File tslLogFile;
        File logFile;
        File logFolder;
        File CRLFolder;
        File TSLFolder;
        File configFile;
        Properties custom;
        File workFolder;
        File baseFolder;
        String timeZone;
        String noProxyHosts;
        String proxyUsername;
        String proxyAddressAndPort;
        LanguagesCode languageCode;
        LoggerLevel logLevel;
        String proxyPassword;
        boolean noProxy;
        block91: {
            String logFileName;
            String logFolderName;
            String CRLFolderName;
            String TSLFolderName;
            String configFileName;
            block90: {
                String baseFolderPath;
                if (cmdLine == null) {
                    return;
                }
                noProxy = false;
                proxyPassword = "";
                logLevel = LoggerLevel.NONE;
                languageCode = LanguagesCode.EN;
                if (cmdLine.hasOption("help")) {
                    OPTIONS.printHelp("Every arguments passed without a key is interpreted as file.");
                    System.exit(0);
                }
                if (cmdLine.hasOption("noproxy")) {
                    noProxy = cmdLine.getOptionValue("noproxy").equals("true");
                }
                proxyAddressAndPort = cmdLine.getOptionValue("proxyaddress");
                proxyUsername = cmdLine.getOptionValue("proxyusername");
                noProxyHosts = cmdLine.getOptionValue("noproxyhosts");
                if (cmdLine.hasOption("proxypassword")) {
                    proxyPassword = cmdLine.getOptionValue("proxypassword");
                }
                timeZone = null;
                if (cmdLine.hasOption("timezone")) {
                    timeZone = cmdLine.getOptionValue("timezone");
                }
                if (cmdLine.hasOption("loglevel")) {
                    String lev;
                    switch (lev = cmdLine.getOptionValue("loglevel").toLowerCase()) {
                        case "trace": {
                            logLevel = LoggerLevel.TRACE;
                            break;
                        }
                        case "debug": {
                            logLevel = LoggerLevel.DEBUG;
                            break;
                        }
                        case "info": {
                            logLevel = LoggerLevel.INFO;
                            break;
                        }
                        case "warn": {
                            logLevel = LoggerLevel.WARN;
                            break;
                        }
                        case "error": {
                            logLevel = LoggerLevel.ERROR;
                            break;
                        }
                        case "none": {
                            logLevel = LoggerLevel.NONE;
                            break;
                        }
                        default: {
                            if (!verbose) break;
                            System.err.println("unrecognized logger level: " + lev);
                        }
                    }
                }
                if ((baseFolderPath = cmdLine.getOptionValue("basedir")) == null) {
                    String customDir = System.getProperty("it.arubapec.asbasedir");
                    baseFolderPath = "appdata".equals(customDir) ? System.getenv("APPDATA") : System.getProperty("user.dir");
                    if (verbose) {
                        System.out.println("use default root folder: " + baseFolderPath);
                    }
                }
                baseFolder = new File(baseFolderPath);
                String workFolderName = cmdLine.getOptionValue("workdir");
                if (workFolderName == null) {
                    workFolderName = ".ArubaSign";
                    if (verbose) {
                        System.out.println("use default base folder: " + workFolderName);
                    }
                }
                if (!(workFolder = new File(System.getProperty("user.home") + File.separator + workFolderName)).exists()) {
                    workFolder.mkdir();
                }
                if ((configFileName = cmdLine.getOptionValue("config")) == null) {
                    configFileName = "ArubaSign.properties";
                    if (verbose) {
                        System.out.println("use default config file name: " + configFileName);
                    }
                }
                custom = new Properties();
                File customOptions = new File(baseFolder + File.separator + "gui.properties");
                if (customOptions.exists()) {
                    try (FileInputStream is = new FileInputStream(customOptions);){
                        custom.load(is);
                    }
                    catch (IOException ex) {
                        if (!verbose) break block90;
                        System.out.println("Error loading " + customOptions);
                        ex.printStackTrace();
                    }
                }
            }
            if (!(configFile = new File(workFolder + File.separator + configFileName)).exists() && !ConfigurationTranslator.translate("ArubaSign", configFile, DEFAULTS, custom)) {
                try {
                    configFile.createNewFile();
                }
                catch (IOException ex) {
                    System.out.println("Errore creazione file di properties: " + ex.getMessage());
                }
            }
            if ((TSLFolderName = cmdLine.getOptionValue("tsldir")) == null) {
                TSLFolderName = "TSL";
                if (verbose) {
                    System.out.println("use default TSL folder: " + TSLFolderName);
                }
            }
            if (!(TSLFolder = new File(workFolder + File.separator + TSLFolderName)).exists()) {
                TSLFolder.mkdir();
            }
            if ((CRLFolderName = cmdLine.getOptionValue("crl")) == null || CRLFolderName.isEmpty()) {
                CRLFolderName = "crl";
                if (verbose) {
                    System.out.println("use default crl folder name: " + CRLFolderName);
                }
            }
            if (!(CRLFolder = new File(workFolder + File.separator + CRLFolderName)).exists()) {
                CRLFolder.mkdir();
            }
            if ((logFolderName = cmdLine.getOptionValue("logdir")) == null) {
                logFolderName = "log";
                if (verbose) {
                    System.out.println("use default log folder name: " + logFolderName);
                }
            }
            if (!(logFolder = new File(workFolder + File.separator + logFolderName)).exists()) {
                logFolder.mkdir();
            }
            if ((logFileName = cmdLine.getOptionValue("logfile")) == null) {
                logFileName = "ArubaSign.log";
                if (verbose) {
                    System.out.println("use default log file name: " + logFileName);
                }
            }
            logFile = new File(logFolder.getAbsolutePath() + File.separator + logFileName);
            String tslUpdaterFileName = cmdLine.getOptionValue("tsllog");
            if (tslUpdaterFileName == null) {
                tslUpdaterFileName = "root_updater.log";
                if (verbose) {
                    System.out.println("use default TSL updater log file name: " + tslUpdaterFileName);
                }
            }
            tslLogFile = new File(TSLFolder.getAbsolutePath() + File.separator + tslUpdaterFileName);
            String cdbFileName = cmdLine.getOptionValue("cdb");
            if (cdbFileName == null) {
                cdbFileName = "cert.cdb";
                if (verbose) {
                    System.out.println("use default cdb file name: " + cdbFileName);
                }
            }
            cdbFile = new File(TSLFolder.getAbsolutePath() + File.separator + cdbFileName);
            cdbPassword = cmdLine.getOptionValue("cdb");
            if (cdbPassword == null) {
                cdbPassword = "1234567890AAbbCCdd";
                if (verbose) {
                    System.out.println("use default cdb password");
                }
            }
            defaultTimeZone = "UTC";
            try {
                int currentTimezoneValue = TimeZone.getDefault().getRawOffset() / 3600000;
                for (int i = 0; i < Constants.TIME_ZONES.length; ++i) {
                    if ((double)currentTimezoneValue != Constants.TIME_ZONES[i]) continue;
                    defaultTimeZone = Constants.TIME_ZONE_IDS[i];
                    break;
                }
            }
            catch (Throwable t) {
                if (!verbose) break block91;
                System.out.println("Error retrieving default timezone, use UTC");
            }
        }
        if (Locale.getDefault().equals(Locale.ITALY) || Locale.getDefault().equals(Locale.ITALIAN)) {
            DEFAULTS.setProperty(UserProperties.LANGUAGE.getValue(), LanguagesCode.IT.name());
        } else {
            DEFAULTS.setProperty(UserProperties.LANGUAGE.getValue(), LanguagesCode.EN.name());
        }
        DEFAULTS.setProperty(UserProperties.TIME_ZONE.getValue(), defaultTimeZone);
        String language = cmdLine.getOptionValue("lang");
        if (null != language) {
            switch (language) {
                case "en_US": 
                case "en_GB": {
                    languageCode = LanguagesCode.EN;
                    Locale.setDefault(new Locale("en", "GB"));
                    break;
                }
                case "it_IT": {
                    languageCode = LanguagesCode.IT;
                    Locale.setDefault(new Locale("it", "IT"));
                    break;
                }
                case "de_DE": {
                    languageCode = LanguagesCode.DE;
                    Locale.setDefault(new Locale("de", "DE"));
                }
            }
        }
        ClientProperties clientProps = ClientProperties.getInstance((Properties)DEFAULTS, (File)configFile);
        clientProps.setAll(custom, ClientProperties.Priority.CUSTOM);
        String defDomain = DEFAULTS.getProperty(ServerProperties.REMOTE_SIGNATURE_DOMAIN.getValue(), "firma");
        String cusDomain = custom.getProperty(ServerProperties.REMOTE_SIGNATURE_DOMAIN.getValue(), defDomain);
        String domain = clientProps.get((Property)ServerProperties.REMOTE_SIGNATURE_DOMAIN, "firma");
        if (!domain.isEmpty() && !domain.equals(cusDomain)) {
            clientProps.set((Property)ServerProperties.REMOTE_SIGNATURE_CUSTOM_DOMAIN_ENABLED, "true", ClientProperties.Priority.FILE);
        }
        clientProps.set((Property)AppProperties.BASE_FOLDER, baseFolder.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.WORK_FOLDER, workFolder.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.TSL_FOLDER, TSLFolder.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.CRL_FOLDER, CRLFolder.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.LOG_FOLDER, logFolder.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.LOG_FILE, logFile.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.TSL_LOG_FILE, tslLogFile.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.CDB_DEFAULT_FILE, baseFolder.getAbsolutePath() + File.separator + "cert.cdb", ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.CDB_FILE, cdbFile.getAbsolutePath(), ClientProperties.Priority.CMD_LINE);
        clientProps.set((Property)AppProperties.CDB_PSW, cdbPassword, ClientProperties.Priority.CMD_LINE);
        if (noProxy) {
            clientProps.set((Property)NetworkProperties.PROXY_GENERIC_MODE, "noProxy", ClientProperties.Priority.CMD_LINE);
            clientProps.set((Property)NetworkProperties.PROXY_LDAP_MODE, "noProxy", ClientProperties.Priority.CMD_LINE);
        }
        if (proxyUsername != null) {
            clientProps.set((Property)NetworkProperties.PROXY_GENERIC_USER, proxyUsername, ClientProperties.Priority.CMD_LINE);
        }
        if (proxyPassword != null && !proxyPassword.isEmpty()) {
            clientProps.set((Property)NetworkProperties.PROXY_GENERIC_PSW, proxyPassword, ClientProperties.Priority.CMD_LINE);
        }
        if (proxyAddressAndPort != null) {
            String[] proxyHostAndPort = ArubaSignCmdLineParser.parseProxyHost(proxyAddressAndPort.trim());
            clientProps.set((Property)NetworkProperties.PROXY_GENERIC_HOST, proxyHostAndPort[0], ClientProperties.Priority.CMD_LINE);
            clientProps.set((Property)NetworkProperties.PROXY_GENERIC_PORT, proxyHostAndPort[1], ClientProperties.Priority.CMD_LINE);
        }
        if (noProxyHosts != null) {
            clientProps.set((Property)NetworkProperties.NO_PROXY_HOSTS, noProxyHosts, ClientProperties.Priority.CMD_LINE);
        }
        if (cmdLine.hasOption("loglevel")) {
            clientProps.set((Property)UserProperties.LOG_LEVEL, logLevel.toString(), ClientProperties.Priority.CMD_LINE);
        }
        if (cmdLine.hasOption("timezone")) {
            clientProps.set((Property)UserProperties.TIME_ZONE, timeZone, ClientProperties.Priority.CMD_LINE);
        }
        if (cmdLine.hasOption("lang")) {
            clientProps.set((Property)UserProperties.LANGUAGE, languageCode.name(), ClientProperties.Priority.CMD_LINE);
        }
    }

    private static String[] parseProxyHost(String hostNameString) {
        String[] hostNameParsed = new String[2];
        int twoPointsCounter = hostNameString.length() - hostNameString.replace(":", "").length();
        if (twoPointsCounter > 2) {
            hostNameParsed[0] = "";
            hostNameParsed[1] = "";
            return hostNameParsed;
        }
        boolean hasProtocol = false;
        if (hostNameString.startsWith("http://") || hostNameString.startsWith("https://") || hostNameString.startsWith("socks://")) {
            hasProtocol = true;
        }
        if (hasProtocol) {
            hostNameParsed[0] = hostNameString.split(":")[0] + ":" + hostNameString.split(":")[1];
            hostNameParsed[1] = twoPointsCounter == 2 ? hostNameString.split(":")[2] : "";
        } else if (twoPointsCounter == 1) {
            hostNameParsed[0] = hostNameString.split(":")[0];
            hostNameParsed[1] = hostNameString.split(":")[1];
        } else {
            hostNameParsed[0] = hostNameString;
            hostNameParsed[1] = "";
        }
        return hostNameParsed;
    }

    static {
        OPTIONS.addOption(new Option("bd", "basedir", "Folder containing application executable"));
        OPTIONS.addOption(new Option("wd", "workdir", "Folder where the application save his config file"));
        OPTIONS.addOption(new Option("c", "config", "Configuration file name"));
        OPTIONS.addOption(new Option("td", "tsldir", "TSL folder name inside workdir"));
        OPTIONS.addOption(new Option("tl", "tsllog", "TSL updater log file name"));
        OPTIONS.addOption(new Option("db", "cdb", "cdb file name inside tsldir"));
        OPTIONS.addOption(new Option("dp", "cdbpwd", "cdb file password"));
        OPTIONS.addOption(new Option("ld", "logdir", "logger folder name inside workdir"));
        OPTIONS.addOption(new Option("lf", "logfile", "logger file name inside logdir"));
        OPTIONS.addOption(new Option("l", "lang", "Application language, supported value: en_US, en_GB, it_IT, de_DE"));
        OPTIONS.addOption(new Option("np", "noproxy", "If present ignore proxy configuration"));
        OPTIONS.addOption(new Option("pa", "proxyaddress", "Proxy endpoint in the format host:port"));
        OPTIONS.addOption(new Option("pu", "proxyusername", "User name for proxy access"));
        OPTIONS.addOption(new Option("pp", "proxypassword", "User password for proxy access"));
        OPTIONS.addOption(new Option("nh", "noproxyhosts", "List of URL(s) that ignore proxy, separated by ';'"));
        OPTIONS.addOption(new Option("ll", "loglevel", "Logger level, supported value: [none|trace|debug|info|warn|error]"));
        OPTIONS.addOption(new Option("tz", "timezone", "timezone in use"));
        OPTIONS.addOption(new Option("s", "sign", "List of File(s) to sign, separated by ';'"));
        OPTIONS.addOption(new Option("v", "verify", "List of File(s) to verify, separated by ';'"));
        OPTIONS.addOption(new Option("e", "encrypt", "List of File(s) to encrypt, separated by ';'"));
        OPTIONS.addOption(new Option("d", "decrypt", "List of File(s) to decrypt, separated by ';'"));
        OPTIONS.addOption(new Option("t", "timestamp", "List of File(s) to timestamp, separated by ';'"));
        OPTIONS.addOption(new Option("h", "help", "Show this help"));
        DEFAULTS = new Properties();
        DEFAULTS.setProperty(AppProperties.CACHE_CRL.getValue(), "S");
        DEFAULTS.setProperty(AppProperties.SHOW_ONBOARDING.getValue(), "true");
        DEFAULTS.setProperty(UserProperties.WORD_STATUS.getValue(), "1");
        DEFAULTS.setProperty(UserProperties.EXCEL_STATUS.getValue(), "1");
        DEFAULTS.setProperty(UserProperties.POWERPOINT_STATUS.getValue(), "1");
        DEFAULTS.setProperty(UserProperties.SHOW_ADMIN_START_WARNING.getValue(), "true");
        DEFAULTS.setProperty(UserProperties.SHOW_FEA.getValue(), "false");
        DEFAULTS.setProperty(UserProperties.CERT_EXPIRATION_REMINDER_TIME.getValue(), "60");
        DEFAULTS.setProperty(UserProperties.DEFAULT_PDF_FORMAT.getValue(), SignatureFacade.SignatureType.PADES.getName());
        DEFAULTS.setProperty(UserProperties.DEFAULT_XML_FORMAT.getValue(), SignatureFacade.SignatureType.XADES.getName());
        DEFAULTS.setProperty(ServerProperties.DSD_SERVER_1.getValue(), "https://dsd.aruba.it");
        DEFAULTS.setProperty(ServerProperties.DSD_SERVER_2.getValue(), "https://dsd.aruba.it");
        DEFAULTS.setProperty(ServerProperties.DSD_USER.getValue(), "asuser");
        DEFAULTS.setProperty(ServerProperties.USE_DSD.getValue(), "true");
        DEFAULTS.setProperty(ServerProperties.REMOTE_SIGNATURE_DOMAIN.getValue(), "firma");
        DEFAULTS.setProperty(ServerProperties.REMOTE_SIGNATURE_SERVER_1.getValue(), "https://app1.firma-remota.it/ArubaSignerService/webresources/signerservice");
        DEFAULTS.setProperty(ServerProperties.REMOTE_SIGNATURE_SERVER_2.getValue(), "https://app2.firma-remota.it/ArubaSignerService/webresources/signerservice");
        DEFAULTS.setProperty(NetworkProperties.PROXY_GENERIC_MODE.getValue(), "noProxy");
        DEFAULTS.setProperty(NetworkProperties.PROXY_GENERIC_TYPE.getValue(), "direct");
        DEFAULTS.setProperty(NetworkProperties.PROXY_LDAP_MODE.getValue(), "noProxy");
        DEFAULTS.setProperty(NetworkProperties.PROXY_LDAP_TYPE.getValue(), "direct");
        DEFAULTS.setProperty(ServerProperties.TSA_SERVER_ADDRESS.getValue(), "https://servizi.arubapec.it/tsa/ngrequest.php");
    }
}

