/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign;

import com.sun.jna.Platform;
import esecurity.crypto.gui.cmdline.CmdLine;
import esecurity.crypto.gui.events.FixedEvent;
import esecurity.crypto.gui.form.proxy.CryptoGuiProxyAuthenticator;
import esecurity.crypto.gui.functionality.ValidationFacade;
import esecurity.crypto.gui.ldap.LdapEndPointLoader;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.NetworkProperties;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.service.theme.ThemeURLStreamHandlerFactory;
import esecurity.crypto.gui.updater.AlertViewer;
import esecurity.crypto.gui.updater.ProgressIndicator;
import esecurity.crypto.gui.updater.Updater;
import esecurity.crypto.gui.updater.UpdaterUtils;
import esecurity.crypto.gui.utils.CardMonitor;
import esecurity.crypto.gui.utils.GUIUtils;
import esecurity.crypto.gui.utils.Property;
import esecurity.crypto.gui.utils.armp.ARMPThread;
import esecurity.crypto.gui.utils.lock.IPCFileThread;
import esecurity.crypto.gui.utils.lock.LockableFile;
import esecurity.crypto.gui.utils.rootupdater.CertDBUpdater;
import esecurity.crypto.gui.utils.swt.ImageHandler;
import esecurity.desktop.BaseController;
import esecurity.desktop.Event;
import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import esecurity.desktop.ResUtils;
import esecurity.desktop.View;
import esecurity.desktop.ViewBuilder;
import esecurity.desktop.swt.OsCheck;
import esecurity.desktop.swt.SWTView;
import esecurity.dsd.client.DSDFactory;
import esecurity.dsd.client.DomainConfigProvider;
import esecurity.dsd.client.config.RemoteConfigProvider;
import esecurity.dsd.core.Log;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.tsl.sqllite.ArubaCdbManifestValidator;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateMode;
import it.actalis.ellips.capi.tsl.rootupdater.config.RootUpdaterConfigFile;
import it.arubapec.arubasign.cmdLine.ArubaSignCmdLineParser;
import it.arubapec.arubasign.cmdLine.CmdLineController;
import it.arubapec.arubasign.dsd.DSDObserver;
import it.arubapec.arubasign.gui.ArubaSignController;
import it.arubapec.arubasign.gui.Version;
import it.arubapec.arubasign.utils.OfficeToolExternalThread;
import it.arubapec.ca.update.conf.UpdateConf;
import it.arubapec.ca.utils.ApplicationUtils;
import it.arubapec.ca.utils.ConfigParameter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Observer;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import secretstoreutils.SecretStore;

public class ArubaSignApp {
    private static final int DEFAULT_LOG_MAXSIZE_MB = 100;
    private static EllipsLogger logger;
    private static final I18N i18n;
    private static final String UPDATE_FILE_NAME = "update.conf";
    private Process ndvaProcess = null;
    private ArubaSignController arubaSignController;
    private final int viewXPos = 100;
    private final int viewYPos = 100;
    private int viewWidth = 1005;
    private int viewHeight = 690;
    private final int viewWidthMin = 820;
    private final int viewHeightMin = 466;
    public static long startTime;
    private static CmdLine cmdLine;
    private static SplashScreen splashScreen;
    private static String lockFilePath;
    private static boolean applyUpdateExist;
    private static ArubaSignApp APP_INSTANCE;
    private boolean isClosing = false;
    private static final Object CLOSING;
    private View arubaSignView = null;

    public static void main(String[] args) {
        LoggerLevel logLevel;
        startTime = System.currentTimeMillis();
        long vmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        System.out.println("JVM startup time: " + (startTime - vmStartTime) + "ms");
        if (args == null) {
            args = new String[]{};
        }
        LoggerConfig config = new LoggerConfig();
        try {
            cmdLine = ArubaSignCmdLineParser.parse(args);
            ArubaSignCmdLineParser.apply(cmdLine, true);
        }
        catch (Exception ex) {
            config.setFileAppender(new File(System.getProperty("user.dir") + File.separator + "ArubaSign.error"));
            config.setConsoleAppender(true);
            logger = EllipsLoggerFactory.createLogger((String)"ArubaSign", (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)LoggerLevel.DEBUG, (LoggerConfig)config);
            logger.error("Error parsing input raw parameters: " + ex.getMessage() + " param size: " + args.length, (Throwable)ex);
            System.exit(-1);
        }
        ClientProperties properties = ClientProperties.getInstance();
        config.setFileAppender(new File(properties.get((Property)AppProperties.LOG_FILE, "")));
        config.setSpaceRolling(100L);
        String logLevelName = properties.get((Property)UserProperties.LOG_LEVEL, LoggerLevel.NONE.name());
        try {
            logLevel = LoggerLevel.valueOf((String)logLevelName);
        }
        catch (Throwable t) {
            logLevel = LoggerLevel.NONE;
        }
        logger = EllipsLoggerFactory.createLogger((String)"ArubaSign", (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)logLevel, (LoggerConfig)config);
        try {
            EllipsLoggerFactory.setMasterLogger((String)logger.getName());
        }
        catch (InterruptedException ex) {
            System.err.println("unable to set master logger");
            ex.printStackTrace();
        }
        logger.info("\n-------------------------\nSign - open logger\n-------------------------");
        switch (properties.get((Property)UserProperties.LANGUAGE, LanguagesCode.IT.name()).toUpperCase()) {
            case "IT": {
                I18N.setLocale((Locale)Locale.ITALY);
                break;
            }
            case "EN": {
                I18N.setLocale((Locale)Locale.US);
                break;
            }
            default: {
                I18N.setLocale((Locale)Locale.getDefault());
            }
        }
        boolean launchGUI = true;
        if (Platform.isLinux()) {
            ArubaSignApp.findLibpcsclite();
        }
        if (Platform.isMac()) {
            ArubaSignApp.workaroundBigSur();
        }
        OsCheck.OSInfo info = OsCheck.getOperatingSistemInfo();
        logger.info("=================");
        logger.info("ARUBASIGN STARTUP");
        logger.info("=================");
        logger.info("Input arguments: " + Arrays.deepToString(args));
        logger.info("---- configuration setup ----");
        logger.info("Language: " + properties.get((Property)UserProperties.LANGUAGE, "auto"));
        logger.info("TimeZone: " + properties.get((Property)UserProperties.TIME_ZONE, "UTC"));
        logger.info("Software version: " + Version.getVersion());
        logger.info("Configuration folder: " + properties.get((Property)AppProperties.WORK_FOLDER, ""));
        logger.info("Application folder: " + properties.get((Property)AppProperties.BASE_FOLDER, ""));
        logger.info("OS name: " + System.getProperty("os.name"));
        logger.info("OS Version: " + System.getProperty("os.version"));
        logger.info("OS Version_2: " + info.getVersion());
        logger.info("OS Platform: " + info.getPlatformName());
        logger.info("OS architecture: " + System.getProperty("os.arch"));
        logger.info("Java home: " + System.getProperty("java.home"));
        logger.info("Java version: " + System.getProperty("java.version"));
        Runtime runtimeEnv = Runtime.getRuntime();
        logger.info(String.format("JVM free memory: %d", runtimeEnv.freeMemory()));
        logger.info(String.format("JVM total memory: %d", runtimeEnv.totalMemory()));
        logger.info(String.format("JVM max usable memory: %d", runtimeEnv.maxMemory()));
        properties.getNetworkConfig().setProxyauthenticator((ProxyAutenticator)new CryptoGuiProxyAuthenticator());
        if (launchGUI) {
            SwingUtilities.invokeLater(() -> ArubaSignApp.drawVersionOnSplashScreen());
            File applyUpdate = new File(ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator + ".." + File.separator + "update" + File.separator + "applyUpdate");
            applyUpdateExist = applyUpdate.exists();
            if (!applyUpdateExist) {
                String customDownloadFolder = System.getProperty("updater.customDownloadFolder");
                if (customDownloadFolder != null && !customDownloadFolder.isEmpty() && customDownloadFolder.length() > 3) {
                    applyUpdate = new File(customDownloadFolder + File.separator + "update" + File.separator + "applyUpdate");
                    applyUpdateExist = applyUpdate.exists();
                } else {
                    customDownloadFolder = System.getProperty("user.home");
                    applyUpdate = new File(customDownloadFolder + File.separator + "update" + File.separator + "applyUpdate");
                    applyUpdateExist = applyUpdate.exists();
                    if (applyUpdateExist) {
                        System.setProperty("updater.customDownloadFolder", customDownloadFolder);
                    }
                }
            }
            if (applyUpdateExist) {
                File installerFile;
                logger.info("File " + applyUpdate.getAbsolutePath() + " trovato");
                UpdaterUtils.setApplyUpdateFile((File)applyUpdate);
                String installerName = UpdaterUtils.getInstallerName();
                if (installerName != null && !(installerFile = new File(applyUpdate.getParent() + File.separator + installerName)).exists()) {
                    logger.info("Installer file " + installerFile.getAbsolutePath() + " non trovato");
                    applyUpdateExist = false;
                    applyUpdate.delete();
                    ArubaSignApp.launchGUI(args);
                    return;
                }
                if ("true".equals(ClientProperties.getInstance().get((Property)UserProperties.AUTOMATIC_UPDATE, "true")) && ArubaSignApp.createUpdater().applyUpdate(null)) {
                    applyUpdate.delete();
                    System.exit(0);
                }
            }
            ArubaSignApp.launchGUI(args);
        } else {
            new CmdLineController();
        }
    }

    private static void launchGUI(String[] args) {
        File ipcFile;
        String workFolder = ClientProperties.getInstance().get((Property)AppProperties.WORK_FOLDER, "");
        lockFilePath = workFolder + File.separator + "ArubaSign_use.lck";
        File lockFile = new File(lockFilePath);
        IPCFileThread th = IPCFileThread.tryLock((File)lockFile, (File)(ipcFile = new File(workFolder + File.separator + "ArubaSignIpc")), (String[])args);
        if (th != null) {
            logger.info("Unlocked");
            System.out.println("Start UI thread: " + (System.currentTimeMillis() - startTime) + "ms");
            SWTView.startUIThread(() -> {
                APP_INSTANCE = new ArubaSignApp();
                APP_INSTANCE.start(th);
            });
            if (APP_INSTANCE != null) {
                APP_INSTANCE.exit();
            }
        }
    }

    private static void workaroundBigSur() {
        if (ArubaSignApp.isOldMacOsVersion()) {
            return;
        }
        logger.info("Big Sur System detected, ready to execute a workaround to enable smarcard reading");
        String finalDir = ArubaSignApp.getPCSCDirectory();
        if (finalDir != null) {
            logger.info("Directory Current found");
            logger.info("adding to runtime properties: " + finalDir);
            System.setProperty("sun.security.smartcardio.library", finalDir);
        }
    }

    private static boolean isOldMacOsVersion() {
        String osVersion = System.getProperty("os.version", "");
        if (!osVersion.startsWith("10") || !osVersion.contains(".")) {
            return false;
        }
        String[] splitVersion = osVersion.split("\\.");
        String minor = splitVersion[1];
        try {
            if (Integer.parseInt(minor) < 16) {
                return true;
            }
        }
        catch (Throwable t) {
            logger.info(t.getMessage());
        }
        return false;
    }

    private static String getPCSCDirectory() {
        File dir = new File(File.separator + "System" + File.separator + "Library" + File.separator + "Frameworks" + File.separator + "PCSC.framework" + File.separator + "Versions");
        if (!dir.exists()) {
            logger.info(dir + " not found");
            return null;
        }
        logger.info(dir + " found, checking for subdirectories");
        String[] directories = dir.list((current, name) -> new File(current, name).isDirectory());
        if (directories == null) {
            return null;
        }
        for (String subdir : directories) {
            if (subdir.equals("Current")) {
                return dir.getAbsolutePath() + File.separator + "Current" + File.separator + "PCSC";
            }
            if (subdir.equals("A")) {
                return dir.getAbsolutePath() + File.separator + "A" + File.separator + "PCSC";
            }
            if (subdir.equals("B")) {
                return dir.getAbsolutePath() + File.separator + "B" + File.separator + "PCSC";
            }
            if (!subdir.equals("C")) continue;
            return dir.getAbsolutePath() + File.separator + "C" + File.separator + "PCSC";
        }
        return null;
    }

    public void start(IPCFileThread th) {
        logger.info(" ");
        logger.info("Begin Main Form startup");
        logger.info(" ");
        this.startAccessibilityTools();
        this.initCertDB();
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new ThemeURLStreamHandlerFactory());
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("max-height", "680px");
        variables.put("max-width", "970px");
        variables.put("min-height", "681px");
        variables.put("min-width", "971px");
        ResUtils.setCssVariables(variables);
        ArrayList<String> javascript = new ArrayList<String>();
        javascript.add("/it/arubapec/arubasign/gui/form/ArubaSign.js");
        javascript.add("/esecurity/crypto/gui/form/common/cg-base.js");
        javascript.add("/esecurity/crypto/gui/utils/jquery/jquery-ui.js");
        javascript.add("/esecurity/crypto/gui/form/settings/settings.js");
        javascript.add("/esecurity/crypto/gui/form/ldap/ldap.js");
        javascript.add("/esecurity/crypto/gui/utils/introjs/intromin.js");
        this.arubaSignController = new ArubaSignController(javascript, cmdLine);
        ValidationFacade.setCertDBLoader(() -> {
            ValidatorConfig validatorConfig = GUIUtils.getValidatorConfig();
            validatorConfig.setProxyAuthenticator(ClientProperties.getInstance().getNetworkConfig().getProxyauthenticator());
            validatorConfig.setNetConfiguration(ClientProperties.getInstance().getNetworkConfig());
            try {
                this.arubaSignController.tryLock();
                this.arubaSignController.reloadCorruptedCdb(validatorConfig);
            }
            finally {
                this.arubaSignController.tryRelease();
            }
        });
        th.setBehaviour(args -> {
            CmdLine ipcCmdLine = ArubaSignCmdLineParser.parse(args.toArray(new String[args.size()]));
            this.arubaSignController.addFilesToManage(ipcCmdLine);
        });
        String title = "ArubaSign";
        if (ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false").equals("true")) {
            title = "ArubaSign Beta";
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            ViewBuilder asBuilder = new ViewBuilder((BaseController)this.arubaSignController).setDecorated(true).setTitle(title).setViewArea(new Region(100, 100, 820, 466));
            if ("true".equals(ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false"))) {
                asBuilder.setImage(ImageHandler.retrieveByteArrayImage((String)"icon_beta.png"));
            } else {
                asBuilder.setImage(ImageHandler.retrieveByteArrayImage((String)"icon.png"));
            }
            double screenWidth = screenSize.getWidth();
            double screenHeight = screenSize.getHeight();
            this.arubaSignView = asBuilder.build();
            String appUserResolution = ClientProperties.getInstance().get((Property)AppProperties.APP_USER_RESOLUTION);
            if (appUserResolution != null && !appUserResolution.isEmpty()) {
                this.setUserPropertiesDimension(appUserResolution, screenWidth, screenHeight);
            } else {
                this.setStandardDimension(screenWidth, screenHeight);
            }
            this.arubaSignView.onShow(evt -> {
                if (splashScreen != null) {
                    try {
                        splashScreen.close();
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            });
            this.arubaSignView.centerOnScreen();
            this.arubaSignView.show();
            this.arubaSignView.forceActive();
            this.arubaSignView.onClose(evt -> this.exit());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        new Thread(() -> this.backgroundInitialization()).start();
    }

    private void startAccessibilityTools() {
        boolean bAccessibilityEnabled;
        String accessibility = System.getProperty("ArubaSign.accessibility.enabled");
        boolean bl = bAccessibilityEnabled = accessibility != null && accessibility.equals("true");
        if (Platform.isWindows() && bAccessibilityEnabled) {
            logger.info("Accessibility pack enabled");
            String ndvaPath = ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator + "NVDAPortable" + File.separator + "nvda.exe";
            logger.info("Search for NDVA portable: " + ndvaPath);
            File ndvaFile = new File(ndvaPath);
            if (ndvaFile.exists()) {
                try {
                    logger.info("Starting NDVA portable: ");
                    this.ndvaProcess = new ProcessBuilder(ndvaPath).start();
                }
                catch (IOException ex) {
                    logger.error("Unable to start NDVA: " + ex.getMessage());
                }
            } else {
                logger.error("Unable to find NDVA!");
            }
        }
    }

    private void initCertDB() {
        ClientProperties properties = ClientProperties.getInstance();
        File cdb = new File(properties.get((Property)AppProperties.WORK_FOLDER, "") + File.separator + "TSL" + File.separator + "cert.cdb");
        File atslLastUpdate = new File(properties.get((Property)AppProperties.WORK_FOLDER, "") + File.separator + "TSL" + File.separator + "atslLastUpd.txt");
        if (!cdb.exists()) {
            try {
                this.initProvider(new File(properties.get((Property)AppProperties.BASE_FOLDER, "") + File.separator + "cert.cdb"), cdb);
                CertDBUpdater.setNeedUpdate((boolean)true);
                return;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            BufferedReader brTest = new BufferedReader(new FileReader(cdb));
            String firstLine = brTest.readLine();
            if (firstLine.startsWith("#Ellips CertDB")) {
                CertDBUpdater.setNeedUpdate((boolean)true);
                CertDBUpdater.setFromOldVersion((boolean)true);
                return;
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            CertDBUpdater.setNeedUpdate((boolean)true);
            return;
        }
        if (atslLastUpdate.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(atslLastUpdate));){
                String line = br.readLine();
                Date lastUpdate = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz").parse(line);
                if (TimeUnit.DAYS.convert(new Date().getTime() - lastUpdate.getTime(), TimeUnit.MILLISECONDS) > 30L) {
                    CertDBUpdater.setNeedUpdate((boolean)true);
                }
                return;
            }
            catch (IOException | ParseException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        CertDBUpdater.setNeedUpdate((boolean)true);
    }

    private void backgroundInitialization() {
        ArubaSignApp.checkOfficeUtils();
        new Thread(() -> this.setupDSD()).start();
        new Thread(() -> LdapEndPointLoader.load()).start();
        if (CertDBUpdater.needUpdate()) {
            CertDBUpdater.waitUpdate();
        } else {
            this.startRootUpdater();
        }
        ValidationFacade.loadValidator();
        CardMonitor.start();
        String voucher = "3FE7-66D7-F4A4-40A1";
        if ("true".equals(ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false"))) {
            voucher = "3FCA-D8F6-B3EA-A834";
        }
        ARMPThread.start((String)ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, ""), (String)"arubasign", (String)voucher, (Logger)logger);
        try {
            LockableFile lockableFile = new LockableFile(new File(ClientProperties.getInstance().get((Property)AppProperties.WORK_FOLDER) + File.separator + "installer_downloading"));
            if (lockableFile.lock()) {
                lockableFile.release();
                this.performUpdate();
            }
        }
        catch (HeadlessException | IOException | URISyntaxException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void checkOfficeUtils() {
        if (Platform.isWindows()) {
            OfficeToolExternalThread otThread = new OfficeToolExternalThread();
            otThread.setCallback((wordStatus, excelStatus, powerPointStatus) -> {
                ClientProperties.getInstance().set((Property)UserProperties.WORD_STATUS, Integer.toString(wordStatus.ordinal()), ClientProperties.Priority.USER);
                ClientProperties.getInstance().set((Property)UserProperties.EXCEL_STATUS, Integer.toString(excelStatus.ordinal()), ClientProperties.Priority.USER);
                ClientProperties.getInstance().set((Property)UserProperties.POWERPOINT_STATUS, Integer.toString(powerPointStatus.ordinal()), ClientProperties.Priority.USER);
                try {
                    ClientProperties.getInstance().save();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            });
            otThread.setLogger(logger);
            Thread t = new Thread(otThread);
            t.start();
        }
    }

    private void performUpdate() throws HeadlessException, IOException, URISyntaxException {
        Updater updater;
        String arubaPecLink;
        Throwable throwable;
        File updateFile = new File(ClientProperties.getInstance().get((Property)AppProperties.WORK_FOLDER, "") + File.separator + "updateCount");
        if (!updateFile.exists()) {
            logger.info("Create updateCount file");
            updateFile.createNewFile();
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(updateFile));){
                bw.write("loop:0");
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
        int loop = 0;
        try {
            throwable = null;
            try (BufferedReader br = new BufferedReader(new FileReader(updateFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("loop")) continue;
                    loop = Integer.parseInt(line.split(":")[1]);
                    logger.info("Restart update #" + String.valueOf(loop));
                }
            }
            catch (Throwable line) {
                throwable = line;
                throw line;
            }
        }
        catch (Exception e3) {
            logger.error(e3.getMessage(), (Throwable)e3);
        }
        if (loop >= 3 && !applyUpdateExist) {
            logger.info("More than 3 restart, exit updater");
            updateFile.delete();
            return;
        }
        try {
            throwable = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(updateFile));){
                bw.write("loop:" + ++loop);
            }
            catch (Throwable line) {
                throwable = line;
                throw line;
            }
        }
        catch (Exception e4) {
            logger.error(e4.getMessage(), (Throwable)e4);
        }
        String currentVersion = Version.getVersion();
        if (currentVersion.contains("-")) {
            currentVersion = currentVersion.split("-")[0];
        }
        if ((arubaPecLink = (updater = ArubaSignApp.createUpdater()).getStableVersion()) != null && "true".equals(ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false"))) {
            this.arubaSignController.showLinkToArubaPec(arubaPecLink);
            return;
        }
        Updater updaterFinal = updater;
        Listener onApply = t -> new Thread(() -> {
            updaterFinal.applyUpdate((AlertViewer)this.arubaSignController);
            if (applyUpdateExist) {
                UpdaterUtils.getApplyUpdateFile().delete();
            }
            updateFile.delete();
            File applyUpdate = new File(ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator + ".." + File.separator + "update" + File.separator + "applyUpdate");
            if (applyUpdate.exists()) {
                applyUpdate.delete();
            }
            if ((applyUpdate = new File(System.getProperty("user.home") + File.separator + "update" + File.separator + "applyUpdate")).exists()) {
                applyUpdate.delete();
            }
            System.exit(0);
        }).start();
        if (applyUpdateExist) {
            this.arubaSignController.requestApplyUpdate(Updater.Update.STANDARD, (Listener<Event>)onApply);
            return;
        }
        Updater.Update u = updater.haveNewVersion(currentVersion);
        if (Updater.Update.NO.equals((Object)u)) {
            logger.info("No update needed delete updateCount file");
            updateFile.delete();
            return;
        }
        if (!updaterFinal.canUpdate()) {
            return;
        }
        switch (u) {
            case STANDARD: {
                this.update(updater, Updater.Update.STANDARD, (Listener<Event>)onApply);
                break;
            }
            case CRITICAL: {
                this.update(updater, Updater.Update.CRITICAL, (Listener<Event>)onApply);
                break;
            }
            case FORCED: {
                this.arubaSignController.requestDownloadUpdate(Updater.Update.FORCED, (Listener<Event>)((Listener)t -> new Thread(() -> {
                    try {
                        if (!updaterFinal.downloadUpdate((ProgressIndicator)this.arubaSignController.getTotalDownloadProgress(), (ProgressIndicator)this.arubaSignController.getCurrentDownloadProgress(), (AlertViewer)this.arubaSignController)) {
                            this.arubaSignController.stopDownloadListener();
                            return;
                        }
                        File applyUpdate = new File(ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator + ".." + File.separator + "update" + File.separator + "applyUpdate");
                        if (!applyUpdate.exists() && !(applyUpdate = new File(System.getProperty("user.home") + File.separator + "update" + File.separator + "applyUpdate")).exists()) {
                            return;
                        }
                        updaterFinal.applyUpdate((AlertViewer)this.arubaSignController);
                        applyUpdate.delete();
                        System.exit(0);
                    }
                    catch (HeadlessException | IOException | URISyntaxException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                        this.arubaSignController.stopDownloadListener();
                    }
                }).start()));
            }
        }
    }

    private void update(Updater updater, Updater.Update type, Listener<Event> onApply) throws HeadlessException, IOException, URISyntaxException {
        if ("true".equals(ClientProperties.getInstance().get((Property)UserProperties.AUTOMATIC_DOWNLOAD, "true"))) {
            if (!updater.downloadUpdate(null, null, null)) {
                return;
            }
            if (!"true".equals(ClientProperties.getInstance().get((Property)UserProperties.AUTOMATIC_UPDATE, "true"))) {
                this.arubaSignController.requestApplyUpdate(type, onApply);
            }
            return;
        }
        this.arubaSignController.requestDownloadUpdate(type, (Listener<Event>)((Listener)t -> new Thread(() -> {
            try {
                if (!updater.downloadUpdate((ProgressIndicator)this.arubaSignController.getTotalDownloadProgress(), (ProgressIndicator)this.arubaSignController.getCurrentDownloadProgress(), (AlertViewer)this.arubaSignController)) {
                    this.arubaSignController.stopDownloadListener();
                    return;
                }
                if (!"true".equals(ClientProperties.getInstance().get((Property)UserProperties.AUTOMATIC_UPDATE, "true"))) {
                    this.arubaSignController.requestApplyUpdate(type, onApply);
                }
            }
            catch (HeadlessException | IOException | URISyntaxException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.arubaSignController.stopDownloadListener();
            }
        }).start()));
    }

    private static Updater createUpdater() {
        String updaterUpdateFolder;
        String appsUpdateFolder;
        block6: {
            logger.info("Read local update urls");
            String updateConfPath = ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator + UPDATE_FILE_NAME;
            appsUpdateFolder = "";
            updaterUpdateFolder = "";
            try {
                FileInputStream objUpdateConf = new FileInputStream(updateConfPath);
                BufferedReader br = new BufferedReader(new InputStreamReader(objUpdateConf));
                appsUpdateFolder = br.readLine();
                updaterUpdateFolder = br.readLine();
                logger.info("File {} found", (Object)updateConfPath);
                logger.info("Remote Url apps .....: {}", (Object)appsUpdateFolder);
                logger.info("Remote Url updater ..: {}", (Object)updaterUpdateFolder);
            }
            catch (Exception ex) {
                logger.warn("File {} not found", (Object)updateConfPath);
                String customUpdateConfPath = System.getProperty("customUpdateConfPath");
                if (customUpdateConfPath == null) break block6;
                logger.info("custom update.conf is " + customUpdateConfPath);
                updateConfPath = customUpdateConfPath;
                try {
                    FileInputStream objUpdateConf = new FileInputStream(updateConfPath);
                    BufferedReader br = new BufferedReader(new InputStreamReader(objUpdateConf));
                    appsUpdateFolder = br.readLine();
                    updaterUpdateFolder = br.readLine();
                    logger.info("File {} found", (Object)updateConfPath);
                    logger.info("Remote Url apps .....: {}", (Object)appsUpdateFolder);
                    logger.info("Remote Url updater ..: {}", (Object)updaterUpdateFolder);
                }
                catch (Exception ex2) {
                    logger.error("invalid custom update.conf " + ex2.getMessage());
                }
            }
        }
        String prevBitVersion = "64";
        String archModel = System.getProperty("sun.arch.data.model");
        if (archModel != null && archModel.equals("32")) {
            prevBitVersion = "32";
        }
        UpdateConf.setUpdateCallerName((String)"ArubaSign");
        if ("true".equals(System.getProperty("updater.log.enableCustomInit"))) {
            UpdateConf.setLogDirPath((String)(System.getProperty("user.home") + File.separator + ".ArubaSign" + File.separator + "log"));
            UpdateConf.setLogNamePrefix((String)"ArubaSign");
        }
        return new Updater(prevBitVersion, appsUpdateFolder, updaterUpdateFolder, ClientProperties.getInstance().get((Property)AppProperties.BASE_FOLDER, "") + File.separator, lockFilePath);
    }

    private void setupDSD() {
        try {
            String defaultDomain;
            String domains;
            RemoteConfigProvider.Builder builder;
            ClientProperties properties = ClientProperties.getInstance();
            String url1 = properties.get((Property)ServerProperties.DSD_SERVER_1, "");
            String url2 = properties.get((Property)ServerProperties.DSD_SERVER_2, "");
            String username = properties.get((Property)ServerProperties.DSD_USER, "asuser");
            String password = null;
            password = Platform.isWindows() ? "1R7/LamW5zmLOJH7xJdVhTokeD1w3yWBogUbDXIR+JQ=" : "HD7unC/oWP2RTHSwEKh4TADrRvKSzzoIs8lSpOoYVrQ=";
            password = SecretStore.DecryptByPassword((String)username, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)password);
            if (password == null) {
                logger.error("dsd client pass not found!");
            }
            RemoteConfigProvider remoteConfProvider1 = null;
            RemoteConfigProvider remoteConfProvider2 = null;
            Log.setLogger((Logger)logger);
            String proxy = properties.get((Property)NetworkProperties.PROXY_GENERIC_HOST, "");
            String proxyPort = properties.get((Property)NetworkProperties.PROXY_GENERIC_PORT, "");
            String proxyUser = properties.get((Property)NetworkProperties.PROXY_GENERIC_USER, "");
            String proxyPsw = properties.get((Property)NetworkProperties.PROXY_GENERIC_PSW, "");
            if (url1 != null && !url1.isEmpty()) {
                URI uri1 = new URI(url1);
                builder = RemoteConfigProvider.create((String)"DSN1");
                if (!proxy.isEmpty() && !proxyPort.isEmpty()) {
                    builder.proxyAddress(proxy).proxyPort(Integer.valueOf(Integer.parseInt(proxyPort))).proxyAuthentication(proxyUser, proxyPsw);
                }
                remoteConfProvider1 = builder.host(uri1.getHost()).port(uri1.getPort()).useSSL(uri1.getScheme() != null && uri1.getScheme().equalsIgnoreCase("https")).username(username).password(password).build();
            }
            if (url2 != null && !url2.isEmpty()) {
                URI uri2 = new URI(url2);
                builder = RemoteConfigProvider.create((String)"DSN2");
                if (!proxy.isEmpty() && !proxyPort.isEmpty()) {
                    builder.proxyAddress(proxy).proxyPort(Integer.valueOf(Integer.parseInt(proxyPort))).proxyAuthentication(proxyUser, proxyPsw);
                }
                remoteConfProvider2 = builder.host(uri2.getHost()).port(uri2.getPort()).useSSL(uri2.getScheme() != null && uri2.getScheme().equalsIgnoreCase("https")).username(username).password(password).build();
            }
            ArrayList<String> defaultASDomains = new ArrayList<String>(1);
            if (!ClientProperties.getInstance().get((Property)ServerProperties.REMOTE_SIGNATURE_MULTIPLE_DOMAIN_LIST, "").isEmpty() && (domains = ClientProperties.getInstance().get((Property)ServerProperties.REMOTE_SIGNATURE_MULTIPLE_DOMAIN_LIST, "")).contains(";")) {
                String[] splittedDomains;
                for (String domain : splittedDomains = domains.split(";")) {
                    defaultASDomains.add(domain);
                }
            }
            if (!defaultASDomains.contains(defaultDomain = ClientProperties.getInstance().get((Property)ServerProperties.REMOTE_SIGNATURE_DOMAIN, "firma"))) {
                defaultASDomains.add(defaultDomain);
            }
            if ("false".equals(ClientProperties.getInstance().get((Property)ServerProperties.USE_DSD, "false"))) {
                logger.debug("DSD not enabled");
            }
            DSDFactory.bootstrap((String)"ArubaSign", (RemoteConfigProvider)remoteConfProvider1, (RemoteConfigProvider)remoteConfProvider2, defaultASDomains, (Observer)new DSDObserver(), (DomainConfigProvider[])new DomainConfigProvider[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.closeDSD()));
            FixedEvent.addSaveConfigurationEvent(() -> {
                try {
                    if ("true".equals(ClientProperties.getInstance().get((Property)ServerProperties.USE_DSD, "true"))) {
                        String domain = ClientProperties.getInstance().get((Property)ServerProperties.REMOTE_SIGNATURE_DOMAIN, "firma");
                        if (DSDFactory.getProvider((String)"ArubaSign") != null && DSDFactory.getProvider((String)"ArubaSign").availableDomains() != null && DSDFactory.getProvider((String)"ArubaSign").availableDomains().contains(domain)) {
                            String appUrl1 = (String)DSDFactory.get((String)"ArubaSign", (String)domain, (String)"app1");
                            String appUrl2 = (String)DSDFactory.get((String)"ArubaSign", (String)domain, (String)"app2");
                            if (appUrl1 != null && !appUrl1.isEmpty() || appUrl2 != null && !appUrl2.isEmpty()) {
                                ClientProperties.getInstance().set((Property)ServerProperties.REMOTE_SIGNATURE_SERVER_1, appUrl1, ClientProperties.Priority.USER);
                                ClientProperties.getInstance().set((Property)ServerProperties.REMOTE_SIGNATURE_SERVER_2, appUrl2, ClientProperties.Priority.USER);
                                ClientProperties.getInstance().save();
                                logger.debug("DSD remote signature endpoints applied");
                            }
                        }
                    } else {
                        logger.debug("DSD is disabled. Using manual remote signature endpoints");
                    }
                }
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                }
            });
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void closeDSD() {
        DSDFactory.close((String)"ArubaSign");
    }

    public void initProvider(File installerCDB, File cdb) throws Exception {
        String profile = ClientProperties.getInstance().get((Property)AppProperties.PROFILE, "");
        this.loadExtraRoot(profile, installerCDB);
        try {
            Files.copy(installerCDB.toPath(), cdb.toPath(), new CopyOption[0]);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void startRootUpdater() {
        ClientProperties properties = ClientProperties.getInstance();
        File configDir = new File(properties.get((Property)AppProperties.WORK_FOLDER, ""));
        File configFile = new File(configDir + File.separator + "rootUpdater.properties");
        File configFolder = new File(configFile.getParent());
        try {
            Path tslFolder = configFolder.toPath().relativize(configDir.toPath().resolve("TSL"));
            Path cdbFile = configFolder.toPath().relativize(configDir.toPath().resolve("TSL").resolve("cert.cdb"));
            Path logAppender = configFolder.toPath().relativize(configDir.toPath().resolve("log").resolve("rootUpdater.log"));
            RootUpdaterConfigFile.createConfigFile().withHomeFolder(tslFolder.toString()).withCertDBFile(cdbFile.toString()).withCertDBPassword(SecretStore.CryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)"1234567890AAbbCCdd")).setNetworkConfig(properties.getNetworkConfig()).setUpdateMode(UpdateMode.ATSL).setLoggerFileAppender(logAppender.toFile()).setLoggerLevel(logger.getLevel()).save(configFile);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        String rootUpdaterFile = "RootUpdater";
        if (Platform.isWindows()) {
            rootUpdaterFile = rootUpdaterFile + ".exe";
        }
        File rootUpdaterExe = new File(properties.get((Property)AppProperties.BASE_FOLDER, "") + File.separator + rootUpdaterFile);
        logger.info("RootUpdater path: " + rootUpdaterExe.getAbsolutePath());
        ArrayList<String> parameters = new ArrayList<String>(6);
        parameters.add("-cdbConfig");
        parameters.add("\"" + configFile.getAbsolutePath() + "\"");
        parameters.add("-updaterModel");
        parameters.add("esecurity.crypto.gui.model.RootUpdaterModel");
        parameters.add("-guiApp");
        parameters.add("esecurity.crypto.gui.RootUpdaterApp");
        if (rootUpdaterExe.exists()) {
            try {
                ApplicationUtils.launch((String)rootUpdaterExe.getAbsolutePath(), parameters, (boolean)false);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.error(rootUpdaterExe + " not found");
        }
    }

    private static void findLibpcsclite() {
        if (new File("/usr/lib/x86_64-linux-gnu/libpcsclite.so.1").exists()) {
            System.setProperty("sun.security.smartcardio.library", "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
            logger.debug("Load /usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
        } else if (new File("/usr/lib/libpcsclite.so.1").exists()) {
            System.setProperty("sun.security.smartcardio.library", "/usr/lib/libpcsclite.so.1");
            logger.debug("Load /usr/lib/libpcsclite.so.1");
        } else if (new File("/lib/libpcsclite.so.1").exists()) {
            System.setProperty("sun.security.smartcardio.library", "/lib/libpcsclite.so.1");
            logger.debug("Load /lib/libpcsclite.so.1");
        } else if (new File("/lib/x86_64-linux-gnu/libpcsclite.so.1").exists()) {
            System.setProperty("sun.security.smartcardio.library", "/lib/x86_64-linux-gnu/libpcsclite.so.1");
            logger.debug("Load /lib/x86_64-linux-gnu/libpcsclite.so.1");
        } else if (new File("/lib/i386-linux-gnu/libpcsclite.so.1").exists()) {
            System.getProperties().put("sun.security.smartcardio.library", "/lib/i386-linux-gnu/libpcsclite.so.1");
            logger.debug("Load /lib/i386-linux-gnu/libpcsclite.so.1");
        } else {
            logger.error("libpcsclite.so.1 not found");
        }
    }

    private void loadExtraRoot(String profile, File installerCDB) throws CapiException, IOException {
        if (profile.contains("icbpi") || profile.contains("nexi")) {
            String nexiRoot;
            Certificate certNexi;
            CertDb certificates = CertDbBuilder.get().setFile(installerCDB).setNetworkConfig(ClientProperties.getInstance().getNetworkConfig()).setType(CertDbType.SQLLITE).setManifestValidator((ManifestValidator)new ArubaCdbManifestValidator()).build();
            logger.info("loading icbpi extra roots");
            String epcRoot = "-----BEGIN CERTIFICATE-----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\njeZ3V4W6Yr0VgK4mbSufTZpFuLaUDlsGptzJj51arIX5THztFug=\n-----END CERTIFICATE-----";
            Certificate certEpcRoot = new Certificate(epcRoot.getBytes());
            if (!certificates.containsCertificate(certEpcRoot)) {
                X509ServiceDbItem epcRootX509ServiceDbItem = new X509ServiceDbItem(certEpcRoot, TSLServiceTypeIdentifiers.User);
                certificates.importService((ServiceDbItem)epcRootX509ServiceDbItem);
            }
            if (!certificates.containsCertificate(certNexi = new Certificate((nexiRoot = "-----BEGIN CERTIFICATE-----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\noGpgGjtxxn/sgvHi+tuZNJImCey8ANHOCJo6k724v2c24b8=\n-----END CERTIFICATE-----").getBytes()))) {
                X509ServiceDbItem nexiX509ServiceDbItem = new X509ServiceDbItem(certNexi, TSLServiceTypeIdentifiers.User);
                certificates.importService((ServiceDbItem)nexiX509ServiceDbItem);
            }
        }
    }

    private static void drawVersionOnSplashScreen() {
        splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen == null || !splashScreen.isVisible()) {
            return;
        }
        Font splashFont = new Font("Arial", 2, 21);
        Graphics2D splashGraphics = splashScreen.createGraphics();
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        splashGraphics.addRenderingHints(hints);
        splashGraphics.setFont(splashFont);
        splashGraphics.setPaint(Color.BLACK);
        splashGraphics.drawString(i18n.get("splashScreen_version", new Object[0]) + " " + Version.getVersion(), 105, 580);
        splashScreen.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        if (!this.isClosing) {
            Object object = CLOSING;
            synchronized (object) {
                if (!this.isClosing) {
                    this.isClosing = true;
                    logger.info("ArubaSignApp.exit");
                    if (this.arubaSignView != null) {
                        ClientProperties.getInstance().set((Property)AppProperties.APP_USER_RESOLUTION, this.arubaSignView.getShellWidth() + ";" + this.arubaSignView.getShellHeight(), ClientProperties.Priority.FILE);
                        try {
                            ClientProperties.getInstance().save();
                        }
                        catch (IOException ex) {
                            logger.error(ex.getMessage());
                        }
                    }
                    if (this.ndvaProcess != null && this.ndvaProcess.isAlive()) {
                        this.ndvaProcess.destroy();
                    }
                    new Thread(() -> {
                        logger.info("ArubaSignApp.exit.thread.exit");
                        System.exit(0);
                    }).start();
                }
            }
        }
    }

    private void setStandardDimension(double screenWidth, double screenHeight) {
        if (screenWidth >= 1600.0 && screenHeight >= 800.0) {
            this.arubaSignView.setDimension(this.viewWidth, this.viewHeight);
        }
    }

    private void setUserPropertiesDimension(String appUserResolution, double screenWidth, double screenHeight) {
        String[] appUserResolutionArray = appUserResolution.split(";");
        int appUserWidth = Integer.parseInt(appUserResolutionArray[0]);
        int appUserHeight = Integer.parseInt(appUserResolutionArray[1]);
        if ((double)appUserWidth < screenWidth && (double)appUserHeight < screenHeight) {
            this.arubaSignView.setDimension(appUserWidth, appUserHeight);
        } else {
            this.setStandardDimension(screenWidth, screenHeight);
        }
    }

    static {
        i18n = I18N.getInstance((String)"it/arubapec/arubasign/gui/resource/lang/ArubaSign");
        cmdLine = null;
        splashScreen = null;
        applyUpdateExist = false;
        APP_INSTANCE = null;
        CLOSING = new Object();
    }
}

