/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

public class Argon2BytesGenerator {
    private static final int ARGON2_BLOCK_SIZE = 1024;
    private static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    private static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 0x1000000;
    private static final int MIN_OUTLEN = 4;
    private static final int MIN_ITERATIONS = 1;
    private Block[] memory;
    private int segmentLength;
    private int laneLength;
    private Argon2Parameters parameters;
    private byte[] result;

    public void init(Argon2Parameters parameters) {
        this.parameters = parameters;
        if (parameters.getLanes() < 1) {
            throw new IllegalStateException("lanes must be greater than 1");
        }
        if (parameters.getLanes() > 0x1000000) {
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        if (parameters.getMemory() < 2 * parameters.getLanes()) {
            throw new IllegalStateException("memory is less than: " + 2 * parameters.getLanes() + " expected " + 2 * parameters.getLanes());
        }
        if (parameters.getIterations() < 1) {
            throw new IllegalStateException("iterations is less than: 1");
        }
        this.doInit(parameters);
    }

    public int generateBytes(char[] password, byte[] out) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(password), out);
    }

    public int generateBytes(char[] password, byte[] out, int outOff, int outLen) {
        return this.generateBytes(this.parameters.getCharToByteConverter().convert(password), out, outOff, outLen);
    }

    public int generateBytes(byte[] password, byte[] out) {
        return this.generateBytes(password, out, 0, out.length);
    }

    public int generateBytes(byte[] password, byte[] out, int outOff, int outLen) {
        if (outLen < 4) {
            throw new IllegalStateException("output length less than 4");
        }
        this.initialize(password, outLen);
        this.fillMemoryBlocks();
        this.digest(outLen);
        System.arraycopy(this.result, 0, out, outOff, outLen);
        this.reset();
        return outLen;
    }

    private void reset() {
        for (int i = 0; i < this.memory.length; ++i) {
            Block b = this.memory[i];
            b.clear();
        }
        this.memory = null;
        Arrays.fill(this.result, (byte)0);
    }

    private void doInit(Argon2Parameters parameters) {
        int memoryBlocks = parameters.getMemory();
        if (memoryBlocks < 8 * parameters.getLanes()) {
            memoryBlocks = 8 * parameters.getLanes();
        }
        this.segmentLength = memoryBlocks / (parameters.getLanes() * 4);
        this.laneLength = this.segmentLength * 4;
        memoryBlocks = this.segmentLength * (parameters.getLanes() * 4);
        this.initMemory(memoryBlocks);
    }

    private void initMemory(int memoryBlocks) {
        this.memory = new Block[memoryBlocks];
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = new Block();
        }
    }

    private void fillMemoryBlocks() {
        FillBlock filler = new FillBlock();
        Position position = new Position();
        for (int i = 0; i < this.parameters.getIterations(); ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < this.parameters.getLanes(); ++k) {
                    position.update(i, k, j, 0);
                    this.fillSegment(filler, position);
                }
            }
        }
    }

    private void fillSegment(FillBlock filler, Position position) {
        Block addressBlock = null;
        Block inputBlock = null;
        Block zeroBlock = null;
        boolean dataIndependentAddressing = this.isDataIndependentAddressing(position);
        int startingIndex = Argon2BytesGenerator.getStartingIndex(position);
        int currentOffset = position.lane * this.laneLength + position.slice * this.segmentLength + startingIndex;
        int prevOffset = this.getPrevOffset(currentOffset);
        if (dataIndependentAddressing) {
            addressBlock = filler.addressBlock.clear();
            zeroBlock = filler.zeroBlock.clear();
            inputBlock = filler.inputBlock.clear();
            this.initAddressBlocks(filler, position, zeroBlock, inputBlock, addressBlock);
        }
        position.index = startingIndex;
        while (position.index < this.segmentLength) {
            long pseudoRandom;
            int refLane = this.getRefLane(position, pseudoRandom = this.getPseudoRandom(filler, position, addressBlock, inputBlock, zeroBlock, prevOffset = this.rotatePrevOffset(currentOffset, prevOffset), dataIndependentAddressing));
            int refColumn = this.getRefColumn(position, pseudoRandom, refLane == position.lane);
            Block prevBlock = this.memory[prevOffset];
            Block refBlock = this.memory[this.laneLength * refLane + refColumn];
            Block currentBlock = this.memory[currentOffset];
            if (this.isWithXor(position)) {
                filler.fillBlockWithXor(prevBlock, refBlock, currentBlock);
            } else {
                filler.fillBlock(prevBlock, refBlock, currentBlock);
            }
            ++position.index;
            ++currentOffset;
            ++prevOffset;
        }
    }

    private boolean isDataIndependentAddressing(Position position) {
        return this.parameters.getType() == 1 || this.parameters.getType() == 2 && position.pass == 0 && position.slice < 2;
    }

    private void initAddressBlocks(FillBlock filler, Position position, Block zeroBlock, Block inputBlock, Block addressBlock) {
        ((Block)inputBlock).v[0] = this.intToLong(position.pass);
        ((Block)inputBlock).v[1] = this.intToLong(position.lane);
        ((Block)inputBlock).v[2] = this.intToLong(position.slice);
        ((Block)inputBlock).v[3] = this.intToLong(this.memory.length);
        ((Block)inputBlock).v[4] = this.intToLong(this.parameters.getIterations());
        ((Block)inputBlock).v[5] = this.intToLong(this.parameters.getType());
        if (position.pass == 0 && position.slice == 0) {
            this.nextAddresses(filler, zeroBlock, inputBlock, addressBlock);
        }
    }

    private boolean isWithXor(Position position) {
        return position.pass != 0 && this.parameters.getVersion() != 16;
    }

    private int getPrevOffset(int currentOffset) {
        if (currentOffset % this.laneLength == 0) {
            return currentOffset + this.laneLength - 1;
        }
        return currentOffset - 1;
    }

    private int rotatePrevOffset(int currentOffset, int prevOffset) {
        if (currentOffset % this.laneLength == 1) {
            prevOffset = currentOffset - 1;
        }
        return prevOffset;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private void nextAddresses(FillBlock filler, Block zeroBlock, Block inputBlock, Block addressBlock) {
        long[] lArray = inputBlock.v;
        lArray[6] = lArray[6] + 1L;
        filler.fillBlock(zeroBlock, inputBlock, addressBlock);
        filler.fillBlock(zeroBlock, addressBlock, addressBlock);
    }

    private long getPseudoRandom(FillBlock filler, Position position, Block addressBlock, Block inputBlock, Block zeroBlock, int prevOffset, boolean dataIndependentAddressing) {
        if (dataIndependentAddressing) {
            if (position.index % 128 == 0) {
                this.nextAddresses(filler, zeroBlock, inputBlock, addressBlock);
            }
            return addressBlock.v[position.index % 128];
        }
        return this.memory[prevOffset].v[0];
    }

    private int getRefLane(Position position, long pseudoRandom) {
        int refLane = (int)((pseudoRandom >>> 32) % (long)this.parameters.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            refLane = position.lane;
        }
        return refLane;
    }

    private int getRefColumn(Position position, long pseudoRandom, boolean sameLane) {
        int referenceAreaSize;
        int startPosition;
        if (position.pass == 0) {
            startPosition = 0;
            referenceAreaSize = sameLane ? position.slice * this.segmentLength + position.index - 1 : position.slice * this.segmentLength + (position.index == 0 ? -1 : 0);
        } else {
            startPosition = (position.slice + 1) * this.segmentLength % this.laneLength;
            referenceAreaSize = sameLane ? this.laneLength - this.segmentLength + position.index - 1 : this.laneLength - this.segmentLength + (position.index == 0 ? -1 : 0);
        }
        long relativePosition = pseudoRandom & 0xFFFFFFFFL;
        relativePosition = relativePosition * relativePosition >>> 32;
        relativePosition = (long)(referenceAreaSize - 1) - ((long)referenceAreaSize * relativePosition >>> 32);
        return (int)((long)startPosition + relativePosition) % this.laneLength;
    }

    private void digest(int outputLength) {
        Block finalBlock = this.memory[this.laneLength - 1];
        for (int i = 1; i < this.parameters.getLanes(); ++i) {
            int lastBlockInLane = i * this.laneLength + (this.laneLength - 1);
            finalBlock.xorWith(this.memory[lastBlockInLane]);
        }
        byte[] finalBlockBytes = finalBlock.toBytes();
        this.result = this.hash(finalBlockBytes, outputLength);
    }

    private byte[] initialHash(Argon2Parameters parameters, int outputLength, byte[] password) {
        Blake2bDigest blake = new Blake2bDigest(512);
        Argon2BytesGenerator.addIntToLittleEndian(blake, parameters.getLanes());
        Argon2BytesGenerator.addIntToLittleEndian(blake, outputLength);
        Argon2BytesGenerator.addIntToLittleEndian(blake, parameters.getMemory());
        Argon2BytesGenerator.addIntToLittleEndian(blake, parameters.getIterations());
        Argon2BytesGenerator.addIntToLittleEndian(blake, parameters.getVersion());
        Argon2BytesGenerator.addIntToLittleEndian(blake, parameters.getType());
        Argon2BytesGenerator.addByteString(blake, password);
        Argon2BytesGenerator.addByteString(blake, parameters.getSalt());
        Argon2BytesGenerator.addByteString(blake, parameters.getSecret());
        Argon2BytesGenerator.addByteString(blake, parameters.getAdditional());
        byte[] blake2hash = new byte[blake.getDigestSize()];
        blake.doFinal(blake2hash, 0);
        return blake2hash;
    }

    private byte[] hash(byte[] input, int outputLength) {
        byte[] result = new byte[outputLength];
        byte[] outlenBytes = Pack.intToLittleEndian(outputLength);
        int blake2bLength = 64;
        if (outputLength <= blake2bLength) {
            Blake2bDigest blake = new Blake2bDigest(outputLength * 8);
            blake.update(outlenBytes, 0, outlenBytes.length);
            blake.update(input, 0, input.length);
            blake.doFinal(result, 0);
        } else {
            Blake2bDigest digest = new Blake2bDigest(blake2bLength * 8);
            byte[] outBuffer = new byte[blake2bLength];
            digest.update(outlenBytes, 0, outlenBytes.length);
            digest.update(input, 0, input.length);
            digest.doFinal(outBuffer, 0);
            System.arraycopy(outBuffer, 0, result, 0, blake2bLength / 2);
            int r = (outputLength + 31) / 32 - 2;
            int position = blake2bLength / 2;
            int i = 2;
            while (i <= r) {
                digest.update(outBuffer, 0, outBuffer.length);
                digest.doFinal(outBuffer, 0);
                System.arraycopy(outBuffer, 0, result, position, blake2bLength / 2);
                ++i;
                position += blake2bLength / 2;
            }
            int lastLength = outputLength - 32 * r;
            digest = new Blake2bDigest(lastLength * 8);
            digest.update(outBuffer, 0, outBuffer.length);
            digest.doFinal(result, position);
        }
        return result;
    }

    private static void roundFunction(Block block, int v0, int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8, int v9, int v10, int v11, int v12, int v13, int v14, int v15) {
        Argon2BytesGenerator.F(block, v0, v4, v8, v12);
        Argon2BytesGenerator.F(block, v1, v5, v9, v13);
        Argon2BytesGenerator.F(block, v2, v6, v10, v14);
        Argon2BytesGenerator.F(block, v3, v7, v11, v15);
        Argon2BytesGenerator.F(block, v0, v5, v10, v15);
        Argon2BytesGenerator.F(block, v1, v6, v11, v12);
        Argon2BytesGenerator.F(block, v2, v7, v8, v13);
        Argon2BytesGenerator.F(block, v3, v4, v9, v14);
    }

    private static void F(Block block, int a, int b, int c, int d) {
        Argon2BytesGenerator.fBlaMka(block, a, b);
        Argon2BytesGenerator.rotr64(block, d, a, 32L);
        Argon2BytesGenerator.fBlaMka(block, c, d);
        Argon2BytesGenerator.rotr64(block, b, c, 24L);
        Argon2BytesGenerator.fBlaMka(block, a, b);
        Argon2BytesGenerator.rotr64(block, d, a, 16L);
        Argon2BytesGenerator.fBlaMka(block, c, d);
        Argon2BytesGenerator.rotr64(block, b, c, 63L);
    }

    private static void fBlaMka(Block block, int x, int y) {
        long m = 0xFFFFFFFFL;
        long xy = (block.v[x] & 0xFFFFFFFFL) * (block.v[y] & 0xFFFFFFFFL);
        ((Block)block).v[x] = block.v[x] + block.v[y] + 2L * xy;
    }

    private static void rotr64(Block block, int v, int w, long c) {
        long temp = block.v[v] ^ block.v[w];
        ((Block)block).v[v] = temp >>> (int)c | temp << (int)(64L - c);
    }

    private void initialize(byte[] password, int outputLength) {
        byte[] initialHash = this.initialHash(this.parameters, outputLength, password);
        this.fillFirstBlocks(initialHash);
    }

    private static void addIntToLittleEndian(Digest digest, int n) {
        digest.update((byte)n);
        digest.update((byte)(n >>> 8));
        digest.update((byte)(n >>> 16));
        digest.update((byte)(n >>> 24));
    }

    private static void addByteString(Digest digest, byte[] octets) {
        if (octets != null) {
            Argon2BytesGenerator.addIntToLittleEndian(digest, octets.length);
            digest.update(octets, 0, octets.length);
        } else {
            Argon2BytesGenerator.addIntToLittleEndian(digest, 0);
        }
    }

    private void fillFirstBlocks(byte[] initialHash) {
        byte[] zeroBytes = new byte[]{0, 0, 0, 0};
        byte[] oneBytes = new byte[]{1, 0, 0, 0};
        byte[] initialHashWithZeros = this.getInitialHashLong(initialHash, zeroBytes);
        byte[] initialHashWithOnes = this.getInitialHashLong(initialHash, oneBytes);
        for (int i = 0; i < this.parameters.getLanes(); ++i) {
            Pack.intToLittleEndian(i, initialHashWithZeros, 68);
            Pack.intToLittleEndian(i, initialHashWithOnes, 68);
            byte[] blockhashBytes = this.hash(initialHashWithZeros, 1024);
            this.memory[i * this.laneLength + 0].fromBytes(blockhashBytes);
            blockhashBytes = this.hash(initialHashWithOnes, 1024);
            this.memory[i * this.laneLength + 1].fromBytes(blockhashBytes);
        }
    }

    private byte[] getInitialHashLong(byte[] initialHash, byte[] appendix) {
        byte[] initialHashLong = new byte[72];
        System.arraycopy(initialHash, 0, initialHashLong, 0, 64);
        System.arraycopy(appendix, 0, initialHashLong, 64, 4);
        return initialHashLong;
    }

    private long intToLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    private static class Position {
        int pass;
        int lane;
        int slice;
        int index;

        Position() {
        }

        void update(int pass, int lane, int slice, int index) {
            this.pass = pass;
            this.lane = lane;
            this.slice = slice;
            this.index = index;
        }
    }

    private static class Block {
        private static final int SIZE = 128;
        private final long[] v = new long[128];

        private Block() {
        }

        void fromBytes(byte[] input) {
            if (input.length != 1024) {
                throw new IllegalArgumentException("input shorter than blocksize");
            }
            for (int i = 0; i < 128; ++i) {
                this.v[i] = Pack.littleEndianToLong(input, i * 8);
            }
        }

        byte[] toBytes() {
            byte[] result = new byte[1024];
            for (int i = 0; i < 128; ++i) {
                Pack.longToLittleEndian(this.v[i], result, i * 8);
            }
            return result;
        }

        private void copyBlock(Block other) {
            System.arraycopy(other.v, 0, this.v, 0, 128);
        }

        private void xor(Block b1, Block b2) {
            for (int i = 0; i < 128; ++i) {
                this.v[i] = b1.v[i] ^ b2.v[i];
            }
        }

        public void xor(Block b1, Block b2, Block b3) {
            for (int i = 0; i < 128; ++i) {
                this.v[i] = b1.v[i] ^ b2.v[i] ^ b3.v[i];
            }
        }

        private void xorWith(Block other) {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i] = this.v[i] ^ other.v[i];
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 128; ++i) {
                result.append(Hex.toHexString(Pack.longToLittleEndian(this.v[i])));
            }
            return result.toString();
        }

        public Block clear() {
            Arrays.fill(this.v, 0L);
            return this;
        }
    }

    private static class FillBlock {
        Block R = new Block();
        Block Z = new Block();
        Block addressBlock = new Block();
        Block zeroBlock = new Block();
        Block inputBlock = new Block();

        private FillBlock() {
        }

        private void applyBlake() {
            int i;
            for (i = 0; i < 8; ++i) {
                int i16 = 16 * i;
                Argon2BytesGenerator.roundFunction(this.Z, i16, i16 + 1, i16 + 2, i16 + 3, i16 + 4, i16 + 5, i16 + 6, i16 + 7, i16 + 8, i16 + 9, i16 + 10, i16 + 11, i16 + 12, i16 + 13, i16 + 14, i16 + 15);
            }
            for (i = 0; i < 8; ++i) {
                int i2 = 2 * i;
                Argon2BytesGenerator.roundFunction(this.Z, i2, i2 + 1, i2 + 16, i2 + 17, i2 + 32, i2 + 33, i2 + 48, i2 + 49, i2 + 64, i2 + 65, i2 + 80, i2 + 81, i2 + 96, i2 + 97, i2 + 112, i2 + 113);
            }
        }

        private void fillBlock(Block X, Block Y, Block currentBlock) {
            if (X == this.zeroBlock) {
                this.R.copyBlock(Y);
            } else {
                this.R.xor(X, Y);
            }
            this.Z.copyBlock(this.R);
            this.applyBlake();
            currentBlock.xor(this.R, this.Z);
        }

        private void fillBlockWithXor(Block X, Block Y, Block currentBlock) {
            this.R.xor(X, Y);
            this.Z.copyBlock(this.R);
            this.applyBlake();
            currentBlock.xor(this.R, this.Z, currentBlock);
        }
    }
}

