/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Decorations;
import esecurity.desktop.swt.Display;
import esecurity.desktop.swt.Event;
import esecurity.desktop.swt.Listener;
import esecurity.desktop.swt.Rectangle;
import esecurity.desktop.swt.Region;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell
extends Decorations {
    private static final Logger logger = LoggerFactory.getLogger(Shell.class);

    public Shell(Display display, int style) {
        try {
            this.innerObject = SWTClass.Shell.getRef();
            this.innerObject.init(display.innerObject.getObj(), style);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Shell(Shell shell, int style) {
        try {
            this.innerObject = SWTClass.Shell.getRef();
            this.innerObject.init(shell.innerObject.getObj(), style);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public void addListener(int eventType, Listener listener) {
        try {
            Object p = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.Listener.getClss()}, (proxy, method, args) -> {
                listener.handleEvent(new Event(args[0]));
                return null;
            });
            this.innerObject.callMethod("addListener", eventType, p);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setMinimumSize(int width, int height) {
        try {
            this.innerObject.callMethod("setMinimumSize", width, height);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void open() {
        try {
            this.innerObject.callMethod("open", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void close() {
        try {
            this.innerObject.callMethod("close", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void forceActive() {
        try {
            this.innerObject.callMethod("forceActive", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setActive() {
        try {
            this.innerObject.callMethod("setActive", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public boolean isVisible() {
        try {
            return this.innerObject.callMethodAsBoolean("isVisible", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public void setVisible(boolean visible) {
        try {
            this.innerObject.callMethod("setVisible", visible);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setMinimized(boolean minimized) {
        try {
            this.innerObject.callMethod("setMinimized", minimized);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setMaximized(boolean maximized) {
        try {
            this.innerObject.callMethod("setMaximized", maximized);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void setRegion(Region region) {
        try {
            this.innerObject.callMethod("setRegion", region.innerObject.getObj());
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Rectangle getClientArea() {
        try {
            Object obj = this.innerObject.callMethod("getClientArea", new Object[0]);
            if (obj != null) {
                return new Rectangle(obj);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    public Rectangle getBounds() {
        try {
            Object obj = this.innerObject.callMethod("getBounds", new Object[0]);
            if (obj != null) {
                return new Rectangle(obj);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }
}

