/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.observable;

import esecurity.desktop.observable.ObservableListener;
import java.util.ArrayList;
import java.util.List;

public class ObservableObject<T> {
    private T value;
    private final List<ObservableListener> callbacks = new ArrayList<ObservableListener>();

    public ObservableObject() {
        this.value = null;
    }

    public ObservableObject(T defaultValue) {
        this.value = defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.notifyAllListeners();
    }

    public void addListener(ObservableListener runnable) {
        if (!this.callbacks.contains(runnable)) {
            this.callbacks.add(runnable);
        }
    }

    public void removeListener(ObservableListener runnable) {
        this.callbacks.remove(runnable);
    }

    private void notifyAllListeners() {
        if (this.callbacks != null) {
            this.callbacks.forEach(r -> r.notify(this.value));
        }
    }

    public void removeAllListeners() {
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }
}

