/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class Tree
extends DOMElement {
    private final List<TreeNode> children = Collections.synchronizedList(new ArrayList());

    public Tree(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            Tree.createElementWithID("ul", id, view);
        }
    }

    public Tree(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("ul", id, parentId);
    }

    public Tree(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("ul", id, parent.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TreeNode child) {
        List<TreeNode> list = this.children;
        synchronized (list) {
            this.children.add(child);
        }
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        List<TreeNode> list = this.children;
        synchronized (list) {
            for (TreeNode node : this.children) {
                node.delete();
            }
            this.children.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<? super TreeNode> action) {
        List<TreeNode> list = this.children;
        synchronized (list) {
            this.children.forEach(action);
        }
    }
}

