/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import esecurity.crypto.gui.pdf.loader.PdfPagesLoader;
import esecurity.crypto.gui.pdf.loader.PdfPagesLoaderController;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PdfLoaderServlet
extends HttpServlet {
    private final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    protected void doGet(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = null;
        try {
            object = object.getParameterMap();
            String[] stringArray = (String[])object.get("pageId");
            string = stringArray[0];
            stringArray = (String[])object.get("page");
            int n = Integer.parseInt(stringArray[0]);
            float f = 1.0f;
            try {
                object = (String[])object.get("zoom");
                f = Float.parseFloat(object[0]);
            }
            catch (Exception exception) {
                this.a.error(exception.getMessage(), (Throwable)exception);
            }
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET");
            httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
            httpServletResponse.setContentType("image/bmp");
            httpServletResponse.setStatus(200);
            object = PdfPagesLoader.loadPage(n, f);
            if (object == null) {
                this.a.error("Unable to load page " + string);
                return;
            }
            PdfPagesLoaderController.startLoading(string);
            ImageIO.write((RenderedImage)object, "png", (OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.getOutputStream().flush();
            return;
        }
        catch (Throwable throwable) {
            if (string != null) {
                this.a.error(throwable.getMessage() + " page " + string, throwable);
                return;
            }
            this.a.error(throwable.getMessage(), throwable);
            return;
        }
    }
}

