/*
 * Decompiled with CFR 0.152.
 */
package esecurity.enroll;

import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;

public class CSRUtils {
    public CSRUtils() {
        EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    }

    public static PKCS10CertificationRequest generateCertificateRequest(Provider provider, KeyPair keyPair, CertificateFields certificateFields, GeneralNames[] generalNames) throws IOException, NoSuchAlgorithmException, OperatorCreationException, CapiException {
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        if ((generalNames = CSRUtils.a((GeneralNames[])generalNames)) != null) {
            extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)generalNames);
        }
        generalNames = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded()));
        generalNames = new PKCS10CertificationRequestBuilder(certificateFields.getX500Name(), (SubjectPublicKeyInfo)generalNames);
        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(64));
        generalNames.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
        if (certificateFields.getChallengePassword() != null) {
            certificateFields = new DERPrintableString(certificateFields.getChallengePassword());
            generalNames.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERSet((ASN1Encodable)certificateFields));
        }
        certificateFields = keyPair.getPublic().getAlgorithm().equals("RSA") ? new JcaContentSignerBuilder("SHA256withRSA") : new JcaContentSignerBuilder("SHA256withECDSA");
        certificateFields.setProvider(provider);
        provider = generalNames.build(certificateFields.build(keyPair.getPrivate()));
        return provider;
    }

    private static org.bouncycastle.asn1.x509.GeneralNames a(GeneralNames[] generalNamesArray) throws CapiException {
        Object object = null;
        if (generalNamesArray != null && generalNamesArray.length > 0) {
            object = new ArrayList();
            for (GeneralNames generalNames : generalNamesArray) {
                GeneralName generalName = null;
                try {
                    if (generalNames.getName().equals("otherName") || generalNames.getName().equals("0")) {
                        generalName = new GeneralName(0, generalNames.getValue());
                    } else if (generalNames.getName().equals("rfc822Name") || generalNames.getName().equals("1")) {
                        generalName = new GeneralName(1, generalNames.getValue());
                    } else if (generalNames.getName().equals("dNSName") || generalNames.getName().equals("2")) {
                        generalName = new GeneralName(2, generalNames.getValue());
                    } else if (generalNames.getName().equals("x400Address") || generalNames.getName().equals("3")) {
                        generalName = new GeneralName(3, generalNames.getValue());
                    } else if (generalNames.getName().equals("directoryName") || generalNames.getName().equals("4")) {
                        generalName = new GeneralName(4, generalNames.getValue());
                    } else if (generalNames.getName().equals("ediPartyName") || generalNames.getName().equals("5")) {
                        generalName = new GeneralName(5, generalNames.getValue());
                    } else if (generalNames.getName().equals("uniformResourceIdentifier") || generalNames.getName().equals("6")) {
                        generalName = new GeneralName(6, generalNames.getValue());
                    } else if (generalNames.getName().equals("iPAddress") || generalNames.getName().equals("7")) {
                        generalName = new GeneralName(7, generalNames.getValue());
                    } else if (generalNames.getName().equals("registeredID") || generalNames.getName().equals("8")) {
                        generalName = new GeneralName(8, generalNames.getValue());
                    }
                    if (generalName == null) {
                        throw new CapiException("Unsupported subject name: " + generalNames.getName(), 1003);
                    }
                }
                catch (Exception exception) {
                    object = String.format("Unable to generate GeneralName from (%s, %s)", generalNames.getName(), generalNames.getValue());
                    throw new CapiException((String)object, 1003, exception);
                }
                object.add(generalName);
            }
            org.bouncycastle.asn1.x509.GeneralNames generalNames = object;
            object = new org.bouncycastle.asn1.x509.GeneralNames(generalNames.toArray(new GeneralName[generalNames.size()]));
        }
        return object;
    }
}

