/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pcsc;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.ATR;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.Hex;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import org.slf4j.Logger;

public class SCardUtils {
    private static int a;
    private static int b;
    private static final Logger c;

    public static List<ATR> retrieveATR() {
        c.info("SCardUtils16.retrieveATR() start");
        List<ATR> list = new LinkedList<ATR>();
        try {
            Object object = a >= 17 ? TerminalFactory.getInstance("PC/SC", null, "JNA2PCSC") : TerminalFactory.getDefault();
            object = ((TerminalFactory)object).terminals().list();
            c.info("Numero di terminali trovati: {}", (Object)object.size());
            object = object.iterator();
            while (object.hasNext()) {
                CardTerminal cardTerminal = (CardTerminal)object.next();
                c.info("  Terminal [{}]:", (Object)cardTerminal.getName());
                Card card = null;
                try {
                    card = cardTerminal.connect("*");
                    c.info("    connected", (Object)cardTerminal.getName());
                    String string = Hex.getHex((byte[])card.getATR().getBytes());
                    c.info("    returns ATR = {}", (Object)string);
                    list.add(new ATR(cardTerminal.getName(), string.toLowerCase()));
                }
                catch (CardNotPresentException cardNotPresentException) {
                    c.error("    no card is present");
                }
                catch (CardException cardException) {
                    c.error("    not connected", (Throwable)cardException);
                }
                catch (Exception exception) {
                    c.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException cardException) {
            c.error(cardException.getMessage(), (Throwable)cardException);
            try {
                if (a < 17) {
                    SCardUtils.clearTerminalsList();
                    if (b-- >= 0) {
                        list = SCardUtils.retrieveATR();
                    }
                }
            }
            catch (Exception exception) {
                c.error(cardException.getMessage(), (Throwable)cardException);
            }
            finally {
                b = 1;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            c.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            c.error(noSuchProviderException.getMessage(), (Throwable)noSuchProviderException);
        }
        c.info("SCardUtils16.retrieveATR() end");
        return list;
    }

    public static void clearTerminalsList() throws Exception {
        c.debug("clear the terminals in cache");
        c.info("clearTerminalsList() start");
        AnnotatedElement annotatedElement = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Object object = ((Class)annotatedElement).getDeclaredField("contextId");
        ((Field)object).setAccessible(true);
        if (((Field)object).getLong(annotatedElement) != 0L) {
            GenericDeclaration genericDeclaration = Class.forName("sun.security.smartcardio.PCSC");
            Method method = genericDeclaration.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
            method.setAccessible(true);
            Field field = genericDeclaration.getDeclaredField("SCARD_SCOPE_USER");
            field.setAccessible(true);
            long l = (Long)method.invoke(genericDeclaration, field.getInt(genericDeclaration));
            ((Field)object).setLong(annotatedElement, l);
            object = TerminalFactory.getDefault();
            object = ((TerminalFactory)object).terminals();
            annotatedElement = ((Class)annotatedElement).getDeclaredField("terminals");
            ((Field)annotatedElement).setAccessible(true);
            genericDeclaration = Class.forName("java.util.Map");
            genericDeclaration = genericDeclaration.getDeclaredMethod("clear", new Class[0]);
            ((Method)genericDeclaration).invoke(((Field)annotatedElement).get(object), new Object[0]);
        }
        c.info("clearTerminalsList() end");
    }

    public static ATR retrieveATR(String string) {
        ATR aTR = new ATR("", "");
        try {
            Iterator iterator = TerminalFactory.getDefault();
            iterator = ((TerminalFactory)((Object)iterator)).terminals().list();
            c.info("Numero di terminali trovati: {}", (Object)iterator.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = (CardTerminal)iterator.next();
                c.info("Lettura terminale [{}]", (Object)cardTerminal.getName());
                Card card = null;
                try {
                    if (!cardTerminal.getName().toUpperCase().contains(string.trim().toUpperCase())) continue;
                    card = cardTerminal.connect("*");
                    c.info("Terminale [{}] connesso", (Object)cardTerminal.getName());
                    String string2 = Hex.getHex((byte[])card.getATR().getBytes());
                    c.info("Trovato ATR = {}", (Object)string2);
                    aTR = new ATR(cardTerminal.getName(), string2.toLowerCase());
                }
                catch (CardNotPresentException cardNotPresentException) {
                    c.error("Nessuna carta presente");
                }
                catch (CardException cardException) {
                    c.error("Terminale [" + cardTerminal.getName() + "] non connesso", (Throwable)cardException);
                }
                catch (Exception exception) {
                    c.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException cardException) {
            c.error(cardException.getMessage(), (Throwable)cardException);
        }
        return aTR;
    }

    static {
        String string = System.getProperty("java.specification.version");
        a = string.contains(".") ? 8 : Integer.parseInt(string);
        if (a >= 17) {
            Security.addProvider(new Smartcardio());
        }
        b = 1;
        c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    }
}

