/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.ValidationFacade;
import esecurity.crypto.gui.functionality.a;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.SignatureRequest;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.OfficeDocumentConverter;
import esecurity.crypto.gui.utils.files.FileSystemUtils;
import esecurity.dts.util.IllegalParamException;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.generator.ASiCGenerator;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.container.ContainerGeneratorOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesSignatureGenerator;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOperation;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.signature.TimeStampClient;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.ArubaDTSClient;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSDUtils;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SignatureFacade {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final I18N b = I18N.getInstance("esecurity/crypto/gui/theme/i18n/i18n");
    private static Status c = null;

    public static OperationResult sign(SignatureRequest signatureRequest) {
        try {
            Object object2 = signatureRequest;
            if (((SignatureRequest)object2).getSignatureType() == null) {
                throw new CapiException("SignatureType is required", 1001);
            }
            if (((SignatureRequest)object2).getKeyStore() == null) {
                throw new CapiException("KeyStore is required", 1001);
            }
            if (((SignatureRequest)object2).getAlias() == null) {
                throw new CapiException("Alias is required", 1001);
            }
            if (((SignatureRequest)object2).getKeyStorePassword() == null) {
                throw new CapiException("KeyStorePassword is required", 1001);
            }
            if (((SignatureRequest)object2).getFileToSigns().isEmpty()) {
                throw new CapiException("FileToSigns is required", 1001);
            }
            if (((SignatureRequest)object2).getAsiceFileToSign() == null && SignatureType.ASICE.equals((Object)((SignatureRequest)object2).getSignatureType())) {
                throw new CapiException("AsicEFileToSigns is required if SignatureType is ASICE", 1001);
            }
            if (signatureRequest.getSignatureLevel().equals((Object)SignatureLevel.LT) && signatureRequest.getCertDb() == null) {
                object2 = new OperationResult<FileToSign>(new Status(StatusLevel.ERROR, "CertDB is required with SignatureLevel LT"), signatureRequest.getFileToSigns(), signatureRequest.getDestinationFolder());
                return object2;
            }
            c = null;
            boolean bl = false;
            block4 : switch (signatureRequest.getSignatureType()) {
                case CADES: 
                case XADES: 
                case TSD: {
                    SignatureOptions signatureOptions = SignatureFacade.c(signatureRequest);
                    object2 = SignatureFacade.a(signatureRequest);
                    for (FileToSign object3 : signatureRequest.getFileToSigns()) {
                        bl |= SignatureFacade.b(object3, signatureRequest, signatureOptions, (SignatureGenerator)object2);
                        if (c != null && StatusLevel.ERROR.equals((Object)c.getLevel())) break block4;
                    }
                    break;
                }
                case PADES: {
                    SignatureOptions signatureOptions = SignatureFacade.c(signatureRequest);
                    object2 = SignatureFacade.a(signatureRequest);
                    for (FileToSign fileToSign : signatureRequest.getFileToSigns()) {
                        bl |= SignatureFacade.a(fileToSign, signatureRequest, signatureOptions, (SignatureGenerator)object2);
                        if (c != null && StatusLevel.ERROR.equals((Object)c.getLevel())) break block4;
                    }
                    break;
                }
                case ASICS: {
                    ASiCGenerator aSiCGenerator = new ASiCGenerator();
                    MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
                    object2 = new ASiCGeneratorOptions();
                    SignatureOptions signatureOptions = SignatureFacade.b(signatureRequest);
                    for (FileToSign fileToSign : signatureRequest.getFileToSigns()) {
                        bl |= SignatureFacade.a(fileToSign, signatureRequest, (TimeStampOptions)signatureOptions, (ASiCGeneratorOptions)object2, mutableASiCOptions, aSiCGenerator);
                        if (c != null && StatusLevel.ERROR.equals((Object)c.getLevel())) break block4;
                    }
                    break;
                }
                case ASICE: {
                    bl = false | SignatureFacade.d(signatureRequest);
                    break;
                }
                default: {
                    OperationResult<FileToSign> operationResult = new OperationResult<FileToSign>(new Status(StatusLevel.ERROR, "SignatureType not recognize"), signatureRequest.getFileToSigns(), signatureRequest.getDestinationFolder());
                    return operationResult;
                }
            }
            if (bl && c == null) {
                boolean bl2 = true;
                Iterator<FileToSign> iterator = signatureRequest.getFileToSigns().iterator();
                while (iterator.hasNext() && bl2) {
                    bl2 = !StatusLevel.SUCCESS.equals((Object)iterator.next().getSignResult().getLevel());
                }
                c = bl2 ? new Status(StatusLevel.ERROR, "") : new Status(StatusLevel.WARNING, "");
            } else if (c == null) {
                c = new Status(StatusLevel.SUCCESS, "");
            }
        }
        catch (Throwable throwable) {
            a.error(throwable.getMessage(), throwable);
            c = new Status(StatusLevel.ERROR, throwable);
        }
        finally {
            OfficeDocumentConverter.clearCache();
        }
        return new OperationResult<FileToSign>(c, signatureRequest.getFileToSigns(), signatureRequest.getDestinationFolder());
    }

    private static SignatureGenerator a(SignatureRequest signatureRequest) {
        switch (signatureRequest.getSignatureType()) {
            case CADES: 
            case TSD: {
                return new CadesSignatureGenerator();
            }
            case PADES: {
                return new PadesSignatureGenerator();
            }
            case XADES: {
                return new XadesSignatureGenerator();
            }
        }
        return null;
    }

    private static TimeStampOptions b(SignatureRequest signatureRequest) throws IllegalParamException {
        if (signatureRequest.getSignatureLevel().equals((Object)SignatureLevel.BES)) {
            return null;
        }
        TimeStampOptions timeStampOptions = new TimeStampOptions();
        timeStampOptions.setTSACertReq(true);
        timeStampOptions.setTSAClient((TimeStampClient)new ArubaDTSClient(signatureRequest.getTsaData(), ClientProperties.getInstance().getNetworkConfig()));
        timeStampOptions.setTSADigestAlgorithm(DigestAlgorithm.SHA256);
        timeStampOptions.setTSAPolicy("");
        return timeStampOptions;
    }

    private static SignatureOptions c(SignatureRequest signatureRequest) throws IllegalParamException {
        CadesSignatureOptions cadesSignatureOptions = null;
        switch (signatureRequest.getSignatureType()) {
            case CADES: 
            case TSD: {
                cadesSignatureOptions = new CadesSignatureOptions();
                cadesSignatureOptions.setSignatureMode(signatureRequest.getSignatureMode());
                break;
            }
            case PADES: {
                cadesSignatureOptions = new PadesSignatureOptions();
                cadesSignatureOptions.setProfile(signatureRequest.getPdfProfile());
                break;
            }
            case XADES: {
                cadesSignatureOptions = new XadesSignatureOptions();
                cadesSignatureOptions.setSignatureMode(signatureRequest.getSignatureMode());
            }
        }
        if (!signatureRequest.getSignatureLevel().equals((Object)SignatureLevel.BES)) {
            TimeStampOptions timeStampOptions = new TimeStampOptions();
            timeStampOptions.setTSACertReq(true);
            timeStampOptions.setTSAClient((TimeStampClient)new ArubaDTSClient(signatureRequest.getTsaData(), ClientProperties.getInstance().getNetworkConfig()));
            timeStampOptions.setTSADigestAlgorithm(DigestAlgorithm.SHA256);
            timeStampOptions.setTSAPolicy("");
            cadesSignatureOptions.setTimeStampOptions(timeStampOptions);
            cadesSignatureOptions.setSignatureLevel(signatureRequest.getSignatureLevel());
            if (signatureRequest.getSignatureLevel().equals((Object)SignatureLevel.LT)) {
                cadesSignatureOptions.setCertdb(signatureRequest.getCertDb());
            }
        }
        cadesSignatureOptions.setNetworkConfig(ClientProperties.getInstance().getNetworkConfig());
        cadesSignatureOptions.setKeyStore(signatureRequest.getKeyStore());
        cadesSignatureOptions.setAlias(signatureRequest.getAlias());
        cadesSignatureOptions.setKeyStorePassword(signatureRequest.getKeyStorePassword());
        return cadesSignatureOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(FileToSign fileToSign, SignatureRequest signatureRequest, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        Object object;
        Object object2;
        Serializable serializable;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = fileToSign.getPdfAppereances() != null && !fileToSign.getPdfAppereances().isEmpty();
        if (bl2) {
            n = fileToSign.getPdfAppereances().size();
        }
        File file = SignatureFacade.a(fileToSign, signatureRequest);
        Object object3 = fileToSign;
        if (OfficeDocumentConverter.needConversion(fileToSign)) {
            serializable = OfficeDocumentConverter.convert(fileToSign);
            object3 = new FileToSign((File)serializable);
            ((FileToSign)object3).setFileExtension(fileToSign.getFileExtension());
            ((FileToSign)object3).setDestinationFileName(fileToSign.getDestinationFileName());
            ((FileToSign)object3).setDestinationFileExtension(fileToSign.getDestinationFileExtension());
        }
        serializable = new ArrayDeque();
        String string = ((File)object3).getName();
        do {
            block34: {
                if (bl2) {
                    object2 = fileToSign.getPdfAppereances().get(n2);
                    object = (PadesSignatureOptions)signatureOptions;
                    if (object2 != null) {
                        object.setApparence((CapiPDFApparence)object2);
                        object.setLocation(object2.getLocation());
                        object.setReason(object2.getReason());
                        object.setFieldName(object2.getFieldName());
                        object.setPreservePdfA(object2.isPDFASignature());
                    }
                }
                object = Files.createTempFile(string, ((FileToSign)object3).getDestinationFileExtension(), new FileAttribute[0]).toFile();
                ((ArrayDeque)serializable).addFirst(object);
                try {
                    Throwable throwable;
                    object2 = DataHandlerBuilder.get().setFile((File)object3).buildInput();
                    Throwable throwable2 = null;
                    try {
                        block33: {
                            throwable = DataHandlerBuilder.get().setFile((File)object).setReplace(true).buildOutput();
                            Throwable throwable3 = null;
                            try {
                                block32: {
                                    signatureOptions.setInput((InputHandler)object2);
                                    signatureOptions.setOutput((OutputHandler)throwable);
                                    ((FileToSign)object3).setDestinationFileName(file.getName().substring(0, file.getName().lastIndexOf(".")));
                                    try {
                                        if (signatureRequest.getSignatureOperation() == SignatureOperation.NEW_SIGN) {
                                            signatureGenerator.sign(signatureOptions);
                                            if (signatureRequest.getSignatureType().equals((Object)SignatureType.TSD)) {
                                                signatureOptions.getOutput().close();
                                                TSDUtils.createTsd((InputHandler)DataHandlerBuilder.get().setFile((File)object).buildInput(), (OutputHandler)DataHandlerBuilder.get().setFile((File)object).setReplace(true).buildOutput(), (TSAData)signatureRequest.getTsaData(), (String)fileToSign.getName(), (String)"application/pkcs7-mime", (ValidatorConfig)ValidationFacade.getValidatorConfig(), (boolean)false);
                                            }
                                            break block32;
                                        }
                                        if (signatureRequest.getSignatureOperation() == SignatureOperation.COUNTER_SIGN) {
                                            signatureOptions.setSignaturePath(signatureRequest.getSignerPath());
                                        }
                                        signatureGenerator.addSign(signatureOptions);
                                    }
                                    catch (XadesModeException xadesModeException) {
                                        object3 = xadesModeException;
                                        if (xadesModeException.getPermit_mode() == null) {
                                            throw object3;
                                        }
                                        signatureOptions.setSignatureMode(object3.getPermit_mode());
                                        if (signatureRequest.getSignatureOperation() == SignatureOperation.NEW_SIGN) {
                                            signatureGenerator.sign(signatureOptions);
                                        }
                                        signatureGenerator.addSign(signatureOptions);
                                    }
                                }
                                if (throwable == null) break block33;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    object3 = throwable4;
                                    throwable3 = throwable4;
                                    throw object3;
                                }
                                catch (Throwable throwable5) {
                                    if (throwable == null) throw throwable5;
                                    if (throwable3 == null) {
                                        throwable.close();
                                        throw throwable5;
                                    }
                                    try {
                                        throwable.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable3.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                            }
                            throwable.close();
                        }
                        if (object2 == null) break block34;
                    }
                    catch (Throwable throwable7) {
                        try {
                            throwable = throwable7;
                            throwable2 = throwable7;
                            throw throwable;
                        }
                        catch (Throwable throwable8) {
                            if (object2 == null) throw throwable8;
                            if (throwable2 == null) {
                                object2.close();
                                throw throwable8;
                            }
                            try {
                                object2.close();
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                                throw throwable8;
                            }
                        }
                    }
                    object2.close();
                }
                catch (Throwable throwable) {
                    bl = true;
                    a.error(throwable.getMessage(), throwable);
                    if (SignatureFacade.a(throwable)) {
                        c = new Status(StatusLevel.ERROR, throwable);
                    }
                    fileToSign.setSignResult(new Status(StatusLevel.ERROR, throwable));
                }
            }
            if (fileToSign.getSignResult() == null) {
                fileToSign.setSignResult(new Status(StatusLevel.SUCCESS, "OK"));
            }
            object3 = new FileToSign((File)object);
            ((FileToSign)object3).setFileExtension(fileToSign.getFileExtension());
            ((FileToSign)object3).setDestinationFileExtension(fileToSign.getDestinationFileExtension());
            ++n2;
            if (((ArrayDeque)serializable).size() <= 2 || (object2 = (File)((ArrayDeque)serializable).pollLast()) == null) continue;
            Files.deleteIfExists(((File)object2).toPath());
        } while (n2 < n && !bl);
        if (!bl) {
            Files.move(((File)object3).toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        object = ((ArrayDeque)serializable).iterator();
        while (object.hasNext()) {
            object2 = (File)object.next();
            Files.deleteIfExists(((File)object2).toPath());
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean b(FileToSign var0, SignatureRequest var1_2, SignatureOptions var2_5, SignatureGenerator var3_8) throws IOException {
        var4_9 = false;
        var5_10 = false;
        var6_11 = SignatureFacade.a(var0, var1_2);
        var7_12 = Files.createTempFile(var0.getName(), var0.getDestinationFileExtension(), new FileAttribute[0]).toFile();
        var8_13 = null;
        var9_14 /* !! */  = var1_2.isApplyTsd() != false ? (var8_13 = Files.createTempFile(var0.getName(), var0.getDestinationFileExtension(), new FileAttribute[0]).toFile()) : var7_12;
        try {
            var10_15 = DataHandlerBuilder.get().setFile((File)var0).buildInput();
            var11_17 = null;
            try {
                var9_14 /* !! */  = DataHandlerBuilder.get().setFile(var9_14 /* !! */ ).setReplace(true).buildOutput();
                var12_18 = null;
                try {
                    var2_5.setInput(var10_15);
                    var2_5.setOutput((OutputHandler)var9_14 /* !! */ );
                    var0.setDestinationFileName(var6_11.getName().substring(0, var6_11.getName().lastIndexOf(".")));
                    try {
                        switch (esecurity.crypto.gui.functionality.a.b[var1_2.getSignatureOperation().ordinal()]) {
                            case 1: {
                                var3_8.sign(var2_5);
                                if (var1_2.isApplyTsd()) {
                                    var16_19 = var0.getName();
                                    var15_20 /* !! */  = var7_12;
                                    var14_22 = var8_13;
                                    var13_24 /* !! */  = var2_5;
                                    var17_29 = new TSAData();
                                    var18_30 = ClientProperties.getInstance();
                                    var17_29.setTSAUser(var18_30.get(ServerProperties.TSA_ACCOUNT, ""));
                                    var17_29.setTSAUrl(var18_30.get(ServerProperties.TSA_SERVER_ADDRESS, ""));
                                    var17_29.setTSAPolicy(var18_30.get(ServerProperties.TSA_POLICY, ""));
                                    var17_29.setTSAPassword(var18_30.get(ServerProperties.TSA_PASSWORD, ""));
                                    var14_22 = DataHandlerBuilder.get().setFile(var14_22).buildInput();
                                    var18_30 = null;
                                    try {
                                        var15_20 /* !! */  = DataHandlerBuilder.get().setFile(var15_20 /* !! */ ).setReplace(true).buildOutput();
                                        var19_31 = null;
                                        try {
                                            var13_24 /* !! */ .getOutput().close();
                                            TSDUtils.createTsd((InputHandler)var14_22, (OutputHandler)var15_20 /* !! */ , (TSAData)var17_29, (String)var16_19, (String)"application/pkcs7-mime", (ValidatorConfig)ValidationFacade.getValidatorConfig(), (boolean)false);
                                            ** if (var15_20 /* !! */  == null) goto lbl-1000
                                        }
                                        catch (Throwable v0) {
                                            try {
                                                var13_24 /* !! */  = v0;
                                                var19_31 = v0;
                                                throw var13_24 /* !! */ ;
                                            }
                                            catch (Throwable var13_25) {
                                                if (var15_20 /* !! */  != null) {
                                                    if (var19_31 != null) {
                                                        try {
                                                            var15_20 /* !! */ .close();
                                                        }
                                                        catch (Throwable var15_21) {
                                                            var19_31.addSuppressed(var15_21);
                                                        }
                                                    } else {
                                                        var15_20 /* !! */ .close();
                                                    }
                                                }
                                                throw var13_25;
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            var15_20 /* !! */ .close();
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                        ** if (var14_22 == null) goto lbl-1000
                                    }
                                    catch (Throwable v1) {
                                        try {
                                            var15_20 /* !! */  = v1;
                                            var18_30 = v1;
                                            throw var15_20 /* !! */ ;
                                        }
                                        catch (Throwable var13_26) {
                                            if (var14_22 != null) {
                                                if (var18_30 != null) {
                                                    try {
                                                        var14_22.close();
                                                    }
                                                    catch (Throwable var14_23) {
                                                        var18_30.addSuppressed(var14_23);
                                                    }
                                                } else {
                                                    var14_22.close();
                                                }
                                            }
                                            throw var13_26;
                                        }
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        var14_22.close();
                                        break;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                    }
                                }
                                break;
                            }
                            case 2: {
                                var2_5.setSignaturePath(var1_2.getSignerPath());
                            }
                            case 3: {
                                var3_8.addSign(var2_5);
                            }
                        }
                    }
                    catch (XadesModeException v2) {
                        var13_27 = v2;
                        if (v2.getPermit_mode() == null) {
                            throw var13_27;
                        }
                        var2_5.setSignatureMode(var13_27.getPermit_mode());
                        if (var1_2.getSignatureOperation() == SignatureOperation.NEW_SIGN) {
                            var3_8.sign(var2_5);
                        }
                        var3_8.addSign(var2_5);
                    }
                    ** if (var9_14 /* !! */  == null) goto lbl-1000
                }
                catch (Throwable v3) {
                    try {
                        var13_28 = v3;
                        var12_18 = v3;
                        throw var13_28;
                    }
                    catch (Throwable var1_3) {
                        if (var9_14 /* !! */  != null) {
                            if (var12_18 != null) {
                                try {
                                    var9_14 /* !! */ .close();
                                }
                                catch (Throwable var2_6) {
                                    var12_18.addSuppressed(var2_6);
                                }
                            } else {
                                var9_14 /* !! */ .close();
                            }
                        }
                        throw var1_3;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var9_14 /* !! */ .close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (var10_15 == null) goto lbl-1000
            }
            catch (Throwable v4) {
                try {
                    var9_14 /* !! */  = v4;
                    var11_17 = v4;
                    throw var9_14 /* !! */ ;
                }
                catch (Throwable var1_4) {
                    if (var10_15 != null) {
                        if (var11_17 != null) {
                            try {
                                var10_15.close();
                            }
                            catch (Throwable var2_7) {
                                var11_17.addSuppressed(var2_7);
                            }
                        } else {
                            var10_15.close();
                        }
                    }
                    throw var1_4;
                }
            }
lbl-1000:
            // 1 sources

            {
                var10_15.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var10_16) {
            block61: {
                try {
                    var5_10 = true;
                    var4_9 = true;
                    SignatureFacade.a.error(var10_16.getMessage(), var10_16);
                    if (SignatureFacade.a(var10_16)) {
                        SignatureFacade.c = new Status(StatusLevel.ERROR, var10_16);
                        break block61;
                    }
                    var0.setSignResult(new Status(StatusLevel.ERROR, var10_16));
                }
                catch (Throwable var0_1) {
                    if (!var4_9) {
                        Files.move(var7_12.toPath(), var6_11.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    Files.deleteIfExists(var7_12.toPath());
                    if (var8_13 != null) {
                        Files.deleteIfExists(var8_13.toPath());
                    }
                    throw var0_1;
                }
            }
            Files.deleteIfExists(var7_12.toPath());
            if (var8_13 != null) {
                Files.deleteIfExists(var8_13.toPath());
            } else {
                ** GOTO lbl167
            }
        }
        Files.move(var7_12.toPath(), var6_11.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        Files.deleteIfExists(var7_12.toPath());
        if (var8_13 != null) {
            Files.deleteIfExists(var8_13.toPath());
        }
        if (var0.getSignResult() == null) {
            var0.setSignResult(new Status(StatusLevel.SUCCESS, "OK"));
        }
        return var5_10;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean a(FileToSign var0, SignatureRequest var1_2, TimeStampOptions var2_5, ASiCGeneratorOptions var3_8, MutableASiCOptions var4_9, ASiCGenerator var5_10) throws IOException {
        var6_11 = false;
        var7_12 = false;
        var8_13 = SignatureFacade.a(var0, var1_2);
        var9_14 = Files.createTempFile(var0.getName(), var0.getDestinationFileExtension(), new FileAttribute[0]).toFile();
        try {
            var10_15 = DataHandlerBuilder.get().setFile((File)var0).buildInput();
            var11_17 = null;
            try {
                var12_18 = DataHandlerBuilder.get().setReplace(true).setFile(var9_14).buildOutput();
                var13_20 = null;
                try {
                    var14_21 = new SignatureOptions();
                    var14_21.setInput(var10_15);
                    var14_21.setDigestAlgorithm(DigestAlgorithm.SHA256);
                    var14_21.setSignatureMode(SignatureMode.DETACHED);
                    var14_21.setKeyStore(var1_2.getKeyStore());
                    var14_21.setKeyStorePassword(var1_2.getKeyStorePassword());
                    var14_21.setAlias(var1_2.getAlias());
                    var14_21.setNetworkConfig(ClientProperties.getInstance().getNetworkConfig());
                    if (!var1_2.getSignatureLevel().equals((Object)SignatureLevel.BES)) {
                        var14_21.setTimeStampOptions(var2_5 /* !! */ );
                        var14_21.setSignatureLevel(var1_2.getSignatureLevel());
                        if (var1_2.getSignatureLevel().equals((Object)SignatureLevel.LT)) {
                            var14_21.setCertdb(var1_2.getCertDb());
                        }
                    }
                    var2_5 /* !! */  = new ArrayList<SignatureOptions>();
                    var2_5 /* !! */ .add(var14_21);
                    var4_9.setFormat(ASiCFormat.SIMPLE);
                    var4_9.setSignatureType(var1_2.getASiCSignatureType());
                    var3_8.setAsicOpts(var4_9);
                    var3_8.setSignEntriesOptions((List)var2_5 /* !! */ );
                    var3_8.setOutDoc(var12_18);
                    var0.setDestinationFileName(var8_13.getName().substring(0, var8_13.getName().lastIndexOf(".")));
                    var5_10.pack((ContainerGeneratorOptions)var3_8);
                    ** if (var12_18 == null) goto lbl-1000
                }
                catch (Throwable v0) {
                    try {
                        var14_22 = v0;
                        var13_20 = v0;
                        throw var14_22;
                    }
                    catch (Throwable var1_3) {
                        if (var12_18 != null) {
                            if (var13_20 != null) {
                                try {
                                    var12_18.close();
                                }
                                catch (Throwable var2_6) {
                                    var13_20.addSuppressed(var2_6);
                                }
                            } else {
                                var12_18.close();
                            }
                        }
                        throw var1_3;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var12_18.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (var10_15 == null) goto lbl-1000
            }
            catch (Throwable v1) {
                try {
                    var12_19 = v1;
                    var11_17 = v1;
                    throw var12_19;
                }
                catch (Throwable var1_4) {
                    if (var10_15 != null) {
                        if (var11_17 != null) {
                            try {
                                var10_15.close();
                            }
                            catch (Throwable var2_7) {
                                var11_17.addSuppressed(var2_7);
                            }
                        } else {
                            var10_15.close();
                        }
                    }
                    throw var1_4;
                }
            }
lbl-1000:
            // 1 sources

            {
                var10_15.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var10_16) {
            block29: {
                try {
                    var7_12 = true;
                    var6_11 = true;
                    SignatureFacade.a.error(var10_16.getMessage());
                    if (SignatureFacade.a(var10_16)) {
                        SignatureFacade.c = new Status(StatusLevel.ERROR, var10_16);
                        break block29;
                    }
                    var0.setSignResult(new Status(StatusLevel.ERROR, var10_16));
                }
                catch (Throwable var0_1) {
                    if (!var6_11) {
                        Files.move(var9_14.toPath(), var8_13.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    Files.deleteIfExists(var9_14.toPath());
                    throw var0_1;
                }
            }
            Files.deleteIfExists(var9_14.toPath());
        }
        Files.move(var9_14.toPath(), var8_13.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        Files.deleteIfExists(var9_14.toPath());
        if (var0.getSignResult() == null) {
            var0.setSignResult(new Status(StatusLevel.SUCCESS, "OK"));
        }
        return var7_12;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean d(SignatureRequest var0) throws IOException, IllegalParamException {
        var1_3 = false;
        var2_4 = false;
        var3_7 = new ArrayList();
        var4_8 = SignatureFacade.a(var0.getAsiceFileToSign(), var0);
        var5_9 = Files.createTempFile(var4_8.getName(), ".asice", new FileAttribute[0]).toFile();
        var6_10 = new ASiCGenerator();
        var7_11 = new MutableASiCOptions();
        var8_12 = new ASiCGeneratorOptions();
        var9_13 = SignatureFacade.b(var0);
        try {
            var10_14 = DataHandlerBuilder.get().setFile(var5_9).setReplace(true).buildOutput();
            var11_17 = null;
            try {
                for (FileToSign var13_21 : var0.getFileToSigns()) {
                    var14_22 = new SignatureOptions();
                    var13_21 = DataHandlerBuilder.get().setFile((File)var13_21).buildInput();
                    var14_22.setInput((InputHandler)var13_21);
                    var14_22.setDigestAlgorithm(DigestAlgorithm.SHA256);
                    var14_22.setSignatureMode(SignatureMode.DETACHED);
                    var14_22.setKeyStore(var0.getKeyStore());
                    var14_22.setKeyStorePassword(var0.getKeyStorePassword());
                    var14_22.setAlias(var0.getAlias());
                    if (!var0.getSignatureLevel().equals((Object)SignatureLevel.BES)) {
                        var14_22.setTimeStampOptions(var9_13);
                        var14_22.setSignatureLevel(var0.getSignatureLevel());
                        if (var0.getSignatureLevel().equals((Object)SignatureLevel.LT)) {
                            var14_22.setCertdb(var0.getCertDb());
                        }
                    }
                    var3_7.add(var14_22);
                }
                var7_11.setFormat(ASiCFormat.EXTENDED);
                var7_11.setSignatureType(var0.getASiCSignatureType());
                var8_12.setAsicOpts(var7_11);
                var8_12.setSignEntriesOptions((List)var3_7);
                var8_12.setOutDoc(var10_14);
                var6_10.pack((ContainerGeneratorOptions)var8_12);
                ** if (var10_14 == null) goto lbl-1000
            }
            catch (Throwable v0) {
                try {
                    var12_20 = v0;
                    var11_17 = v0;
                    throw var12_20;
                }
                catch (Throwable var0_1) {
                    if (var10_14 != null) {
                        if (var11_17 != null) {
                            try {
                                var10_14.close();
                            }
                            catch (Throwable var2_5) {
                                var11_17.addSuppressed(var2_5);
                            }
                        } else {
                            var10_14.close();
                        }
                    }
                    throw var0_1;
                }
            }
lbl-1000:
            // 1 sources

            {
                var10_14.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var10_15) {
            try {
                var2_4 = true;
                var1_3 = true;
                SignatureFacade.a.error(var10_15.getMessage());
                SignatureFacade.c = new Status(StatusLevel.ERROR, var10_15);
            }
            catch (Throwable var0_2) {
                for (SignatureOptions var3_7 : var3_7) {
                    if (var3_7.getInput() == null) continue;
                    var3_7.getInput().close();
                }
                if (!var1_3) {
                    Files.move(var5_9.toPath(), var4_8.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                Files.deleteIfExists(var5_9.toPath());
                throw var0_2;
            }
            for (SignatureOptions var11_18 : var3_7) {
                if (var11_18.getInput() == null) continue;
                var11_18.getInput().close();
            }
            Files.deleteIfExists(var5_9.toPath());
        }
        for (Throwable var11_17 : var3_7) {
            if (var11_17.getInput() == null) continue;
            var11_17.getInput().close();
        }
        Files.move(var5_9.toPath(), var4_8.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        Files.deleteIfExists(var5_9.toPath());
        return var2_4;
    }

    private static File a(FileToSign fileToSign, SignatureRequest signatureRequest) throws IOException {
        File file = signatureRequest.getDestinationFolder();
        if (file == null) {
            file = fileToSign.getParentFile();
        }
        if (signatureRequest.getSignatureOperation() == SignatureOperation.NEW_SIGN) {
            return FileSystemUtils.renameFilesWithSameName(file, fileToSign.getDestinationFileName(), fileToSign.getDestinationFileExtension());
        }
        if (SignatureType.ASICE.equals((Object)signatureRequest.getSignatureType())) {
            return new File(file + File.separator + fileToSign.getDestinationFileName() + fileToSign.getDestinationFileExtension());
        }
        return new File(fileToSign.getParent() + File.separator + fileToSign.getDestinationFileName() + fileToSign.getDestinationFileExtension());
    }

    private static boolean a(Throwable throwable) {
        if (!(throwable instanceof CapiException)) {
            return false;
        }
        return (throwable = (CapiException)throwable).getErrorCode() == 2014 || throwable.getErrorCode() == 2001 || throwable.getErrorCode() == 10013;
    }

    public static enum SignatureFormat {
        T(SignatureLevel.T),
        LT(SignatureLevel.LT),
        TSD(SignatureLevel.BES);

        private final SignatureLevel a;

        private SignatureFormat(SignatureLevel signatureLevel) {
            this.a = signatureLevel;
        }

        public final SignatureLevel getSignatureLevel() {
            return this.a;
        }
    }

    public static enum SignatureType {
        CADES("CAdES", ".p7m", "crypto_gui__cades_signature_fullName", "crypto_gui__cades_signature_description"),
        PADES("PAdES", ".pdf", "crypto_gui__pades_signature_fullName", "crypto_gui__pades_signature_description"),
        XADES("XAdES", ".xml", "crypto_gui__xades_signature_fullName", "crypto_gui__xades_signature_description"),
        ASICS("ASiC-S", ".asics", "ASiC-S", "crypto_gui__asic_signature_description"),
        ASICE("ASiC-E", ".asice", "ASiC-E", "crypto_gui__asic_signature_description"),
        TSD("TSD", ".tsd", "TSD", "");

        private final String a;
        private final String b;
        private final String c;
        private final String d;

        private SignatureType(String string2, String string3, String string4, String string5) {
            this.b = string2;
            this.a = string3;
            this.c = string4;
            this.d = string5;
        }

        public final String getName() {
            return this.b;
        }

        public final String getExtension() {
            return this.a;
        }

        public final String getFullName() {
            String string = b.get(this.c, new Object[0]);
            if (string.equals("->" + this.c + "<-")) {
                return this.c;
            }
            return string;
        }

        public final String getDescription() {
            String string = b.get(this.d, new Object[0]);
            if (string.equals("->" + this.d + "<-")) {
                return this.d;
            }
            return string;
        }
    }
}

